----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

realSpeedLimit = {};
realSpeedLimit.modDirectory  = g_currentModDirectory;
local modDescFile = loadXMLFile("modDesc", realSpeedLimit.modDirectory .. "modDesc.xml");
realSpeedLimit.title = getXMLString(modDescFile, "modDesc.title.en");
realSpeedLimit.author = getXMLString(modDescFile, "modDesc.author");
realSpeedLimit.version = getXMLString(modDescFile, "modDesc.version");
delete(modDescFile);

function realSpeedLimit.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations)
		and SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realSpeedLimit.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLeaveVehicle", realSpeedLimit);
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", realSpeedLimit);
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", realSpeedLimit);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", realSpeedLimit);
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", realSpeedLimit);
end;

function realSpeedLimit.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "setRealSpeedLimitEventState",  realSpeedLimit.setRealSpeedLimitEventState);
end;

function realSpeedLimit.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getSpeedLimit", realSpeedLimit.getSpeedLimit);
end;

function realSpeedLimit:getSpeedLimit(superFunc, onlyIfWorking) --server side
    local limit = math.huge;
    local doCheckSpeedLimit = self:doCheckSpeedLimit();
    if onlyIfWorking == nil or (onlyIfWorking and doCheckSpeedLimit) then
		if self.spec_realSpeedLimit == nil or (self.spec_realSpeedLimit ~= nil and not self.spec_realSpeedLimit.active) then
			limit = self.speedLimit;
        end;
        local damage = self:getVehicleDamage();
        if damage > 0 then
            limit = limit * (1 - damage * Vehicle.DAMAGED_SPEEDLIMIT_REDUCTION);
        end;
    end;

	if self.spec_realSpeedLimit ~= nil and self.spec_realSpeedLimit.active then 
		local speedLimit = self.spec_realSpeedLimit.baseVehicleSpeedLimit;
		if speedLimit ~= nil and speedLimit > 999 then speedLimit = nil; end;
		self.spec_realSpeedLimit.suggestedLimit = speedLimit;
	end;

	local attachedImplements;
	if self.getAttachedImplements ~= nil then
		attachedImplements = self:getAttachedImplements();
	end;

	if attachedImplements ~= nil then
		for _, implement in pairs(attachedImplements) do
			if implement.object ~= nil then
				local speed, implementDoCheckSpeedLimit = implement.object:getSpeedLimit(onlyIfWorking);
				if onlyIfWorking == nil or (onlyIfWorking and implementDoCheckSpeedLimit) then
					if self.spec_realSpeedLimit == nil or (self.spec_realSpeedLimit ~= nil and not self.spec_realSpeedLimit.active) then
						limit = math.min(limit, speed);
					end;
				end;
				doCheckSpeedLimit = doCheckSpeedLimit or implementDoCheckSpeedLimit;
				if self.spec_realSpeedLimit ~= nil and self.spec_realSpeedLimit.active then
					local speedLimit = implement.object.speedLimit;
					if speedLimit ~= nil and speedLimit > 999 then speedLimit = nil; end;
					if self.spec_realSpeedLimit.suggestedLimit == nil and speedLimit ~= nil then
						self.spec_realSpeedLimit.suggestedLimit = speedLimit;
					elseif speedLimit ~= nil then 
						self.spec_realSpeedLimit.suggestedLimit = math.min(self.spec_realSpeedLimit.suggestedLimit, speedLimit);
					end;
				end;
			end;
		end;
	end;

    return limit, doCheckSpeedLimit;
end;

function realSpeedLimit:onLoad()
	self.spec_realSpeedLimit = {};
	self.spec_realSpeedLimit.active = false;
	self.spec_realSpeedLimit.events = {};
	self.spec_realSpeedLimit.eventIds = {};
	self.spec_realSpeedLimit.suggestedLimit = nil;
	self.spec_realSpeedLimit.baseVehicleSpeedLimit = getXMLFloat(self.xmlFile.handle,"vehicle.base.speedLimit#value");
end;

function realSpeedLimit:onUpdate()
	if not self.isServer then--client side only (not called by single player or the host in non-dedicated servers)
		if self.spec_realSpeedLimit ~= nil and self.spec_realSpeedLimit.active then
			local isControlled = self.getIsControlled ~= nil and self:getIsControlled();
			if isControlled or self:getIsActiveForInput(true, true) then
				local speedLimit = self.spec_realSpeedLimit.baseVehicleSpeedLimit;
				if speedLimit ~= nil and speedLimit > 999 then speedLimit = nil; end;
				self.spec_realSpeedLimit.suggestedLimit = speedLimit;
				local attachedImplements;
				if self.getAttachedImplements ~= nil then
					attachedImplements = self:getAttachedImplements();
				end;
				if attachedImplements ~= nil then
					for _, implement in pairs(attachedImplements) do
						if implement.object ~= nil then
							local speedLimit = implement.object.speedLimit;
							if speedLimit ~= nil and speedLimit > 999 then speedLimit = nil; end;
							if self.spec_realSpeedLimit.suggestedLimit == nil and speedLimit ~= nil then
								self.spec_realSpeedLimit.suggestedLimit = speedLimit;
							elseif speedLimit ~= nil then 
								self.spec_realSpeedLimit.suggestedLimit = math.min(self.spec_realSpeedLimit.suggestedLimit, speedLimit);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function realSpeedLimit:onLeaveVehicle()
	self.spec_realSpeedLimit.suggestedLimit = nil;
end;

 function realSpeedLimit:setRealSpeedLimitEventState(state, noEventSend)
    realSpeedLimitEvent.sendEvent(self, state, noEventSend);
	self.spec_realSpeedLimit.active = state;
	if not self.spec_realSpeedLimit.active then
		self.spec_realSpeedLimit.suggestedLimit = nil;
	end;
end;

function realSpeedLimit:toggleActive()
	self:setRealSpeedLimitEventState(not self.spec_realSpeedLimit.active);
end;

function realSpeedLimit:onDraw(dt)
	if self.spec_realSpeedLimit.active then
		if self.spec_realSpeedLimit.suggestedLimit ~= nil then
			local speed = tostring(math.floor(self.spec_realSpeedLimit.suggestedLimit));
			g_currentMission:addExtraPrintText("Suggested Working Speed: "..speed);
		end;
	end;
end;

function realSpeedLimit:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		self:clearActionEventsTable(self.spec_realSpeedLimit.events);
		self.spec_realSpeedLimit.eventIds = {};
        if self:getIsActiveForInput(true, true) then
			local _, actionEventId = self:addActionEvent(self.spec_realSpeedLimit.events, 'realSpeedLimit_toggleKey', self, realSpeedLimit.toggleActive, false, true, false, true, nil);
			g_inputBinding:setActionEventTextVisibility(actionEventId, true);
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH);
			table.insert(self.spec_realSpeedLimit.eventIds, actionEventId);
		end;
	end;
end;

--Vehicle.getSpeedLimit = Utils.overwrittenFunction(Vehicle.getSpeedLimit, realSpeedLimit.getSpeedLimit);

realSpeedLimitEvent = {};
realSpeedLimitEvent_mt = Class(realSpeedLimitEvent, Event);
InitEventClass(realSpeedLimitEvent,"realSpeedLimitEvent");

function realSpeedLimitEvent:emptyNew()
    local self = Event.new(realSpeedLimitEvent_mt);
    self.className = "realSpeedLimitEvent";
    return self;
end;
function realSpeedLimitEvent:new(vehicle,state)
	local self = realSpeedLimitEvent.emptyNew()
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;
function realSpeedLimitEvent:readStream(streamId,connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId);
    self.state = streamReadBool(streamId);
    self:run(connection);
end;
function realSpeedLimitEvent:writeStream(streamId,connection)
    NetworkUtil.writeNodeObject(streamId,self.vehicle);
    streamWriteBool(streamId,self.state);
end;
function realSpeedLimitEvent:run(connection)
    self.vehicle:setRealSpeedLimitEventState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(realSpeedLimitEvent:new(self.vehicle,self.state),nil,connection,self.vehicle);
    end;
end;
function realSpeedLimitEvent.sendEvent(vehicle,state,noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(realSpeedLimitEvent:new(vehicle,state),nil,nil,vehicle);
        else
            g_client:getServerConnection():sendEvent(realSpeedLimitEvent:new(vehicle,state));
        end;
    end;
end;