----------------------------------------------------------------------------
-- @Author: ViperGTS96---------------------------------------------
----------------------------------------------------------------------------
--------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

indoorCamPosition = {};

function indoorCamPosition.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Enterable, specializations)
		and SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function indoorCamPosition.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", indoorCamPosition);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", indoorCamPosition);
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", indoorCamPosition);
	SpecializationUtil.registerEventListener(vehicleType, "onLeaveVehicle", indoorCamPosition);
	SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", indoorCamPosition);
end;

function indoorCamPosition:saveToXMLFile(xmlFile, key)
	if self.spec_indoorCamPosition ~= nil then
		local spec = self.spec_indoorCamPosition;
		setXMLFloat(xmlFile.handle, key.."#x", spec.position.x);
		setXMLFloat(xmlFile.handle, key.."#y", spec.position.y);
		setXMLFloat(xmlFile.handle, key.."#z", spec.position.z);
	end;
end;

function indoorCamPosition:onLoad(savegame)
	self.spec_indoorCamPosition = {};
	self.spec_indoorCamPosition.position = {x=0, y=0, z=0};

	for _,camera in pairs(self.spec_enterable.cameras) do
		if camera.isInside and camera.cameraNode ~= nil then
			self.spec_indoorCamPosition.camera = camera;
			break;
		end;
	end;

	if savegame ~= nil then
		self.spec_indoorCamPosition.position.x = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. ".indoorCamPosition#x"),0);
		self.spec_indoorCamPosition.position.y = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. ".indoorCamPosition#y"),0);
		self.spec_indoorCamPosition.position.z = Utils.getNoNil(getXMLFloat(savegame.xmlFile.handle, savegame.key .. ".indoorCamPosition#z"),0);
	end;

end;

function indoorCamPosition:onUpdate(dt)
	local spec = self.spec_indoorCamPosition;
	if spec ~= nil and spec.camera ~= nil then
		local cam = self:getActiveCamera();
		if cam == spec.camera then
			if Input.isKeyPressed(Input.KEY_lshift) then  -- Z
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
					spec.position.z = spec.position.z+0.01;
					spec.position.z = math.clamp(spec.position.z,-0.25,0.5);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=nil,y=nil,z=true};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
					spec.position.z = spec.position.z-0.01;
					spec.position.z = math.clamp(spec.position.z,-0.25,0.5);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=nil,y=nil,z=true};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
					spec.position.z = 0;
					spec.position.drawUpdate = {time = 0, x=nil,y=nil,z=nil};
				end;
			elseif Input.isKeyPressed(Input.KEY_lctrl) then  -- X
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
					spec.position.x = spec.position.x+0.01;
					spec.position.x = math.clamp(spec.position.x,-0.25,0.25);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=true,y=nil,z=nil};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
					spec.position.x = spec.position.x-0.01;
					spec.position.x = math.clamp(spec.position.x,-0.25,0.25);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=true,y=nil,z=nil};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
					spec.position.x = 0;
					spec.position.drawUpdate = {time = 0, x=nil,y=nil,z=nil};
				end;
			else -- Y
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
					spec.position.y = spec.position.y+0.01;
					spec.position.y = math.clamp(spec.position.y,-0.25,0.25);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=nil,y=true,z=nil};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
					spec.position.y = spec.position.y-0.01;
					spec.position.y = math.clamp(spec.position.y,-0.25,0.25);
					spec.position.drawUpdate = {time = math.abs(g_time/1000)+2, x=nil,y=true,z=nil};
				elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
					spec.position.y = 0;
					spec.position.drawUpdate = {time = 0, x=nil,y=nil,z=nil};
				end;
			end;
		end;
	end;
	if spec.position.drawUpdate ~= nil then
		if spec.position.drawUpdate.time ~= nil then
			if math.abs(g_time/1000) > spec.position.drawUpdate.time then
				spec.position.drawUpdate = nil;
			end;
		end;
	end;
end;

function indoorCamPosition:onLeaveVehicle()
	local spec = self.spec_indoorCamPosition;
	if spec ~= nil and spec.position ~= nil then
		spec.position.drawUpdate = nil;
	end;
end;

function indoorCamPosition:onDraw()
	local spec = self.spec_indoorCamPosition;
	if spec.position ~= nil and spec.position.drawUpdate ~= nil then
		local uiScale = g_gameSettings:getValue("uiScale");
		local textSize = 0.03*uiScale;
		local oX = textSize * HUDTextDisplay.SHADOW_OFFSET_FACTOR;
		local text = "";
		local length = 4;
		
		if spec.position.drawUpdate.x ~= nil then
			if spec.position.x < 0 then length = 5; end;
			text = math.floor(spec.position.x*100)/100;
			text = string.sub(tostring(text),0,length);
		elseif spec.position.drawUpdate.y ~= nil then
			if spec.position.y < 0 then length = 5; end;
			text = math.floor(spec.position.y*100)/100;
			text = string.sub(tostring(text),0,length);
		elseif spec.position.drawUpdate.z ~= nil then
			if spec.position.z < 0 then length = 5; end;
			text = math.floor(spec.position.z*100)/100;
			text = string.sub(tostring(text),0,length);
		end;

		setTextBold(false);
		setTextColor(0,0,0,1);
		setTextAlignment(RenderText.ALIGN_CENTER);
		renderText(0.5+oX,0.1-oX,textSize,text);
		setTextColor(1,1,1,1);
		renderText(0.5,0.1,textSize,text);
	end;
end;