local modDir = g_currentModDirectory.. "speciale/SpeedControl/";
local modName = g_currentModName;

local specFile = Utils.getFilename("SpeedControl.lua", modDir);

function registerSpecialization(typeManager)

	if g_specializationManager:getSpecializationByName("SpeedControl") == nil then
		g_specializationManager:addSpecialization("SpeedControl", "SpeedControl", specFile, nil);
		print("Mod:  register spec SpeedControl 1.0.0.0".. " by HappyLooser");
	end;
	
    if typeManager.typeName == "vehicle" then
        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
            if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations)
			and SpecializationUtil.hasSpecialization(Motorized, typeEntry.specializations)
			and SpecializationUtil.hasSpecialization(Enterable, typeEntry.specializations) then
                g_vehicleTypeManager:addSpecialization(typeName, modName..".SpeedControl");
            end;
        end;
    end;
end;
TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, registerSpecialization);

SpeedControlMPEvent = {};
local SpeedControlMPEvent_mt = Class(SpeedControlMPEvent, Event);

InitEventClass(SpeedControlMPEvent, "SpeedControlMPEvent");

function SpeedControlMPEvent.emptyNew()
    local self = Event.new(SpeedControlMPEvent_mt);    
    return self;
end;

function SpeedControlMPEvent.new(object)
    local self = SpeedControlMPEvent.emptyNew()
    self.object = object;
    return self;
end;

function SpeedControlMPEvent:readStream(streamId, connection)	
    self.object = NetworkUtil.readNodeObject(streamId);	
	self.object.speedControl.currentKey = streamReadInt8(streamId);
	
	self.object:setSpeedControlKey(self.object.speedControl.currentKey);
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(SpeedControlMPEvent.new(self.object), nil, connection, self.object);
	end;

end;

function SpeedControlMPEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object);	
	
	streamWriteInt8(streamId, self.object.speedControl.currentKey);	
end;

function SpeedControlMPEvent.updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(SpeedControlMPEvent.new(runSelf), nil, nil, runSelf);
	else
		g_client:getServerConnection():sendEvent(SpeedControlMPEvent.new(runSelf));
	end;

end;


SpeedControlSpeedMPEvent = {};
local SpeedControlSpeedMPEvent_mt = Class(SpeedControlSpeedMPEvent, Event);

InitEventClass(SpeedControlSpeedMPEvent, "SpeedControlSpeedMPEvent");

function SpeedControlSpeedMPEvent.emptyNew()
    local self = Event.new(SpeedControlSpeedMPEvent_mt);    
    return self;
end;

function SpeedControlSpeedMPEvent.new(object)
    local self = SpeedControlSpeedMPEvent.emptyNew()
    self.object = object;
    return self;
end;

function SpeedControlSpeedMPEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId);	
	
	self.object.speedControl.keys[self.object.speedControl.currentKey].speed = streamReadInt8(streamId);
	
	self.object.spec_drivable.cruiseControl.speed = math.ceil(self.object.speedControl.keys[self.object.speedControl.currentKey].speed);
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(SpeedControlSpeedMPEvent.new(self.object), nil, connection, self.object);
	end;

end;

function SpeedControlSpeedMPEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);		
	
	streamWriteInt8(streamId, self.object.speedControl.keys[self.object.speedControl.currentKey].speed);
end;

function SpeedControlSpeedMPEvent.updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(SpeedControlSpeedMPEvent.new(runSelf), nil, nil, runSelf);
	else
		g_client:getServerConnection():sendEvent(SpeedControlSpeedMPEvent.new(runSelf));
	end;

end;

SpeedControlReverseSpeedMPEvent = {};
local SpeedControlReverseSpeedMPEvent_mt = Class(SpeedControlReverseSpeedMPEvent, Event);

InitEventClass(SpeedControlReverseSpeedMPEvent, "SpeedControlReverseSpeedMPEvent");

function SpeedControlReverseSpeedMPEvent.emptyNew()
    local self = Event.new(SpeedControlReverseSpeedMPEvent_mt);    
    return self;
end;

function SpeedControlReverseSpeedMPEvent.new(object)
    local self = SpeedControlReverseSpeedMPEvent.emptyNew()
    self.object = object;
    return self;
end;

function SpeedControlReverseSpeedMPEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId);	
	
	self.object.spec_drivable.cruiseControl.speedReverse = streamReadInt8(streamId);	
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(SpeedControlReverseSpeedMPEvent.new(self.object), nil, connection, self.object);
	end;

end;

function SpeedControlReverseSpeedMPEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);		
	
	streamWriteInt8(streamId, self.object.spec_drivable.cruiseControl.speedReverse);
end;

function SpeedControlReverseSpeedMPEvent.updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(SpeedControlReverseSpeedMPEvent.new(runSelf), nil, nil, runSelf);
	else
		g_client:getServerConnection():sendEvent(SpeedControlReverseSpeedMPEvent.new(runSelf));
	end;

end;

