VehicleInspector_Display_XmlBox = {};

function VehicleInspector_Display_XmlBox:defaultValues(box)	
	if box.name == "VehicleInspector_Display_Box" then
		box.ownTable = {extension=false, updateList=false, lastStateExtraLine=false, bgTransparent={0.75,0.20,0.95,0.05,0.75}, maxSettingTyp=1}; 
		box.ownTable.notViewFillData = {};
		box.ownTable.invertPercentFillData = {};
		box.ownTable.additiveFillData = {};
		local extraFillData = {SILAGE_ADDITIVE={true,true},GREASE={true,true},ENGINEOIL={true,true},DEF={true,true},BALE_WRAP={true,true},BALE_NET={true,true},BALE_TWINE={true,true}};
		for name, v in pairs (extraFillData) do
			local fillType = g_fillTypeManager:getFillTypeIndexByName(name)
			if fillType ~= nil then 
				box.ownTable.notViewFillData[fillType] = name;
				if v[1] ~= nil and v[1] then box.ownTable.invertPercentFillData[fillType] = name;end;
				if v[2] ~= nil and v[2] then box.ownTable.additiveFillData[fillType] = name;end;
			end;
		end;
		box.ownTable.camera = {
			zoom = {18,5,30};
			rotX = {85,30,90};
			--rotY = {0,0,0};
			--rotZ = {0,0,0}
		};
		box.ownTable.autoDimension = {
			isOpen = {false,4};
			width = {2,1,2}; --width view  automatic trailer extern ! 
			maxWidth = {1,1,6}; --by player, length attached (not active)
			height = {2,1,3};	--height on/automatic/manuell(maxHeight)
			maxHeight = {2,2,30}; --by player
		};
		box.ownTable.showBox = { --alignment
			isOpen = {false,2};		
			helpMenu = {4,1,4,true}; --off, F1 ON, F1 Off, F1 ON+OFF, F1 ON Right		
			ingameMap = {1,1,4,false}; --off, MINIMAP ON, MINIMAP OFF, MINIMAP ON+OFF, MINIMAP ON Right (Large MiniMap is blocked over Box System)
		};
		box.ownTable.sortBy = {
			[1] = "";
			[2] = {"vehicleName", "string"}; 
			[3] = {"viTypIcon", "string"};
			[4] = {"viIsMarked", "boolean"};
			[5] = {"vmViewGroup", "boolean"};
		};
		box.ownTable.showVehicles = { --state,min,max
			controlled = {3,1,5}; --1=all,2=jobEnd,3=controlled,4=marked,5=viewGroups		
		};
		box.ownTable.viewWarnings = { --state,min,max (1=off)
			isOpen = {false,5};
			isBlocking = {2,1,2};
			isFuelEmpty = {2,1,2};		
			isDamage = {2,1,2};	
			isWater = {2,1,2};
			isAdBlueEmpty = {2,1,2}; --Mod AdBlue
		};	
		box.ownTable.length = { --is,min,max,level
			isOpen = {false,6};
			damageProzent = {90,5,95,5};
			fuelProzent = {10,5,95,5};
			adBlueProzent = {5,5,95,5}; --Mod AdBlue
			----
			helperJobEndTimeBlinking = {60,10,120,5};			
			vehicleName = {4,2,10,1}; --iconWidth * this
			controlledName = {2,2,10,1}; --iconWidth * this			
			attached = {2,1,6,1};		
		};
		box.ownTable.view = { --state,min,max (1=off)(state/typ Text,Icon or or or)
			isOpen = {false,27};		
			emptyVehicleBox = {2,1,2}; --Show is List empty
			contractor = {1,1,3}; --off,own+contrator,contrator
			speed = {2,2,2};
			vehicleName = {2,1,5}; --off,ls name,ls fullname,typ name,AD/VM driver name
			vehicleIcon = {3,1,3}; --off,ls schema,ls real
			controlledName = {1,1,4}; --off,players,players/helper,helper
			controlledNameSide = {1,1,3};  --auto/left/right (auto default right)			
			field = {2,1,4};	--off,field,field+number(SP),field+number(SP/MP)	
			fillTypeName = {2,1,2}; 
			fillTypeIcon = {2,1,2};
			fillLimit = {1,1,2};
			fillData = {2,1,3}; --off,fillLevel+prozent,fillLevel		
			fillDataColor = {2,1,2}; --color Off (Full/Empty/Half etc. prozentual)
			jobTypeName = {1,1,3};		
			helperJobEndTimeBlinking = {2,1,2};
			leasing = {2,1,3};	--off,icon,text			
			overload = {1,1,2}; --pipe
			attachedIcon = {1,1,2,false,10}; --view Attached Icon is not viewFillData, +auto off timer
			attachedTotal = {1,1,2};
			frontloaderReady = {2,1,2};
			horse = {1,1,2};
			train = {2,1,2};
			group = {1,1,2}; --needs VehicleManager Mod
			gps = {1,1,3}; --needs GPS Mod
			parking = {1,1,2}; --needs Parking Mod
			cpRemaining = {1,1,2,false}; --needs Courseplay Mod, 1=Off, 2=Time On, +Waypoints On/Off 
			adRemaining = {1,1,2,false}; --needs AutoDrive Mod, 1=Off, 2=Time On, +Waypoints On/Off 
			remainingSide = {1,1,3}; --auto/left/right (auto default right)
		};
		box.ownTable.showColors = {		
			isOpen = {false,29};
			separator = "white";
			speed = "ls22";
			playerControlled = "ls15";
			otherControlled = "ls22";
			helperControlled = "darkGreen";
			unknownControlled = "darkYellow";
			field = "yellowDisabled";
			fieldNumber = "mangenta";
			water = "darkBlue";
			damage = "orange";
			blockingTyp1 = "red";
			blockingTyp2 = "yellow";
			fuelEmpty = "orangeRed";
			adBlueEmpty = "hover";
			leasing = "deepPink";
			missionsLeasing = "yellowGreen";		
			overload = "yellow"; --pipe
			fillLimit = "khaki";
			helperJobEndTimeBlinking = "gold";
			parking = "yellow";
			gps = "ls15";
			full = "red";
			empty = "red";
			viewGroup = "ls22";
			isGroup = "white";	
			marked = "mangenta";
			selected = "mangenta";
			adRemainingString = "ls22";
			cpRemainingString = "ls22";
			camera = "ls22";
			contractor = "yellowGreen";
		};
		box.ownTable.viewText = {		
			remainingTimeSeparator = ":";
			remainingWaypoints = "w";
			remainingWaypointsSeparator = "|";
		};
		g_currentMission.hlUtils.addSwitchTimer( {name="vi_switchTwo", delay=10, switch={[1]=10,[2]=3}} ); --two all 10/3 sec. ,for switch attachedTotal and fillTypeName
		g_currentMission.hlUtils.addSwitchTimer( {name="vi_switchWarnings", delay=10, switch={[1]=10,[2]=3,[3]=3}} ); --three, 10/3/3 sec. ,for switch warnings
	elseif box.name == "VehicleInspector_Display_AllInBox" then
		box.ownTable = {updateList=false, lastStateExtraLine=false, maxSettingTyp=1};
		box.ownTable.view = {
			isOpen = {false,8};
			contractor = {1,1,3};
			vehicleName = {2,2,5}; --not off
			vehicleIcon = {3,1,3};
			frontloaderReady = {2,2,2};
			leasing = {2,2,2};
			group = {2,2,2}; --needs VehicleManager Mod
			joinVehicles = {2,1,2};
			vorschauVehicles = {1,1,2};
			---
			extraIcons = {1,1,2};
			engineIcon = {1,1,2}; --over extraIcons
			statisticIcon = {2,1,2}; --over extraIcons
			damageIcon = {1,1,2}; --over extraIcons
			fuelIcon = {1,1,2}; --over extraIcons
		};
		box.ownTable.viewWarnings = { --state,min,max (1=off)
			isOpen = {false,5};			
			isFuelEmpty = {2,1,2}; --virtual fake, not xml or edit	
			isDamage = {2,1,2};	--virtual fake, not xml or edit			
		};
		box.ownTable.length = { --is,min,max,level
			isOpen = {false,1};				
			vehicleName = {4,2,20,1}; --iconWidth * this
			damageProzent = {90,5,95,5};
			fuelProzent = {10,5,95,5};
		};
		box.ownTable.showColors = {		
			isOpen = {false,9};			
			playerControlled = "ls15";
			otherControlled = "ls22";
			helperControlled = "darkGreen";
			unknownControlled = "darkYellow";			
			fuelEmpty = "orangeRed";
			damage = "orange";
			leasing = "deepPink";
			missionsLeasing = "yellowGreen";			
			viewGroup = "ls22";
			isGroup = "white";	
			marked = "mangenta";
			camera = "ls22";
			contractor = "yellowGreen";
		};
		box.ownTable.viewTyp = {
			isOpen = {false,19};
			tractor = {2,1,2,{}};
			tractor_other = {2,1,2,{}};			
			tractor_frontloader = {2,1,2,{}};
			harvester = {2,1,2,{}}; --last for Box
			harvester_other = {2,1,2,{}};			
			harvester_cotton = {2,1,2,{}};
			harvester_sugarcane = {2,1,2,{}};
			harvester_chaff = {2,1,2,{}};
			selfpropelledsprayer = {2,1,2,{}};
			selfpropelledmower = {2,1,2,{}};			
			truck = {2,1,2,{}};
			car = {2,1,2,{}};
			teleloader = {2,1,2,{}};
			wheelloader = {2,1,2,{}};			
			miscvehicles = {2,1,2,{}};
			stapler = {1,1,2,{}};
			skidsteer = {1,1,2,{}};
			implement_conveyorbelt = {1,1,2,{}};
			handtoolmower = {1,1,2,{}};			
		};
		for key, value in pairs (box.ownTable.viewTyp) do
			if key ~= "isOpen" then
				value[4] = {total=0,viewVehicles={},viewContractorVehicles={}};
			end;
		end;
		box.ownTable.typIcon = {};
		local linesSequence = {"tractor","tractor_other","tractor_frontloader","harvester","harvester_other","harvester_cotton","harvester_sugarcane","harvester_chaff","truck","miscvehicles","teleloader","wheelloader","stapler","skidsteer","selfpropelledmower","selfpropelledsprayer","car","implement_conveyorbelt","handtoolmower"};
		for k,v in pairs(linesSequence) do
			local typTable = {name=v,{}};
			table.insert(box.ownTable.typIcon, typTable);
		end;
		--box.ownTable.typIcon = {
		--	[1] = {name="tractor",view={}};
		--	[2] = {name="tractor_other",view={}};
		--	[3] = {name="tractor_frontloader",view={}};
		--	[4] = {name="harvester",view={}};
		--	[5] = {name="harvester_other",view={}};
		--	[6] = {name="harvester_cotton",view={}};
		--	[7] = {name="harvester_sugarcane",view={}};
		--	[8] = {name="harvester_chaff",view={}};
		--	[9] = {name="truck",view={}};
		--	[10] = {name="miscvehicles",view={}};
		--	[11] = {name="teleloader",view={}};
		--	[12] = {name="wheelloader",view={}};
		--	[13] = {name="stapler",view={}};
		--	[14] = {name="skidsteer",view={}};
		--	[15] = {name="selfpropelledmower",view={}};
		--	[16] = {name="selfpropelledsprayer",view={}};
		--	[17] = {name="car",view={}};
		--	[18] = {name="implement_conveyorbelt",view={}};
		--	[19] = {name="handtoolmower",view={}};
		--};		
		box.ownTable.bounds = {0,0,0,box.ownTable.viewTyp.isOpen[2]}; --for typIcon line	
	end;
end;

function VehicleInspector_Display_XmlBox:onLoadXml(box, Xml, xmlNameTag)
	if box.ownTable.lastStateExtraLine == nil then VehicleInspector_Display_XmlBox:defaultValues(box);end;	
	if Xml ~= nil and xmlNameTag ~= nil then		
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
		
		else
			return; --first config not found
		end;
		if box.name == "VehicleInspector_Display_Box" then
			local groupNameTag = (xmlNameTag.. ".extension(%d)"):format(0);
			if getXMLBool(Xml, groupNameTag.."#isOn") ~= nil then box.ownTable.extension = getXMLBool(Xml, groupNameTag.."#isOn");end;		
			if getXMLFloat(Xml, groupNameTag.."#bgTransparent") ~= nil then 
				local bgTransparent = getXMLFloat(Xml, groupNameTag.."#bgTransparent");
				if bgTransparent >= box.ownTable.bgTransparent[2] and bgTransparent <= box.ownTable.bgTransparent[3] then box.ownTable.bgTransparent[1] = bgTransparent;end;
				if box.ownTable.extension and box.ownTable.bgTransparent[1] ~= box.ownTable.bgTransparent[5] then
					--local bgColor = g_currentMission.hlUtils.getColor(box.overlays.color.background, true);
					local bgColor = g_currentMission.hlUtils.getColor("viBoxBgTransparent", true);				
					bgColor[4] = box.ownTable.bgTransparent[1];
					g_currentMission.hlUtils.setBackgroundColor(box.overlays.bg, bgColor);
				end;
			end;
			
			--view warnings/percent--
			groupNameTag = (xmlNameTag.. ".viewWarnings(%d)"):format(0);
			for key, value in pairs (box.ownTable.viewWarnings) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.viewWarnings[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;				
				end;
			end;		
			if getXMLInt(Xml, groupNameTag.."#fuelProzent") ~= nil then box.ownTable.length.fuelProzent[1] = getXMLInt(Xml, groupNameTag.."#fuelProzent");end;		
			if getXMLInt(Xml, groupNameTag.."#damageProzent") ~= nil then box.ownTable.length.damageProzent[1] = getXMLInt(Xml, groupNameTag.."#damageProzent");end;		
			if getXMLInt(Xml, groupNameTag.."#adBlueProzent") ~= nil then box.ownTable.length.adBlueProzent[1] = getXMLInt(Xml, groupNameTag.."#adBlueProzent");end;
			--view warnings/percent--
			--view vehicles and data and length--
			groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
			for key, value in pairs (box.ownTable.view) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;
					if key == "contractor" and not g_currentMission.missionDynamicInfo.isMultiplayer and box.ownTable.view[key][1] == 3 then box.ownTable.view[key][1] = 1;end;
				end;
			end;
			if getXMLInt(Xml, groupNameTag.."#vehicleNameLength") ~= nil then box.ownTable.length.vehicleName[1] = getXMLInt(Xml, groupNameTag.."#vehicleNameLength");end;
			if getXMLInt(Xml, groupNameTag.."#controlledNameLength") ~= nil then box.ownTable.length.controlledName[1] = getXMLInt(Xml, groupNameTag.."#controlledNameLength");end;
			if getXMLInt(Xml, groupNameTag.."#attachedLength") ~= nil then box.ownTable.length.attached[1] = getXMLInt(Xml, groupNameTag.."#attachedLength");end;
			if getXMLInt(Xml, groupNameTag.."#helperJobEndTimeBlinkingSec") ~= nil then box.ownTable.length.helperJobEndTimeBlinking[1] = getXMLInt(Xml, groupNameTag.."#helperJobEndTimeBlinkingSec");end;
			if getXMLBool(Xml, groupNameTag.."#attachedIconNotViewFillData") ~= nil then box.ownTable.view.attachedIcon[4] = getXMLBool(Xml, groupNameTag.."#attachedIconNotViewFillData");end;
			if getXMLBool(Xml, groupNameTag.."#adWaypoints") ~= nil then box.ownTable.view.adRemaining[4] = getXMLBool(Xml, groupNameTag.."#adWaypoints");end;
			if getXMLBool(Xml, groupNameTag.."#cpWaypoints") ~= nil then box.ownTable.view.cpRemaining[4] = getXMLBool(Xml, groupNameTag.."#cpWaypoints");end;
			--view vehicles and data and length--
			--show colors--
			--groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
			--for key, value in pairs (box.ownTable.showColors) do
			--	if key ~= "isOpen" then
			--		if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then 
			--			local color = getXMLString(Xml, groupNameTag.."#".. tostring(key));
			--			if g_currentMission.hlUtils.colorIntern[color] ~= nil then box.ownTable.showColors[key] = color;end;
			--		end;
			--	end;
			--end;
			--show colors--
			--view text--
			groupNameTag = (xmlNameTag.. ".viewText(%d)"):format(0);
			for key, value in pairs (box.ownTable.viewText) do			
				if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.viewText[key] = getXMLString(Xml, groupNameTag.."#".. tostring(key));end;			
			end;
			--view text--
			--show box align--
			groupNameTag = (xmlNameTag.. ".alignBox(%d)"):format(0);
			for key, value in pairs (box.ownTable.showBox) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.showBox[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;
					if getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "AlignRight") ~= nil then box.ownTable.showBox[key][4] = getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "AlignRight");end;
					--if getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "ViewBoxEmpty") ~= nil then box.ownTable.showBox[key][5] = getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "ViewBoxEmpty");end;
				end;
			end;
			--show box align--
			--auto dimension--
			groupNameTag = (xmlNameTag.. ".autoDimension(%d)"):format(0);
			for key, value in pairs (box.ownTable.autoDimension) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.autoDimension[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;
					if getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean") ~= nil then box.ownTable.autoDimension[key][4] = getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean");end;
				end;
			end;
			--auto dimension--
			--camera--
			groupNameTag = (xmlNameTag.. ".cameraBox(%d)"):format(0);
			for key, value in pairs (box.ownTable.camera) do
				if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.camera[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;		
			end;
			--camera--
		elseif box.name == "VehicleInspector_Display_AllInBox" then
			--view vehicles and data and length--
			local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
			for key, value in pairs (box.ownTable.view) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;				
				end;
			end;
			if getXMLInt(Xml, groupNameTag.."#vehicleNameLength") ~= nil then box.ownTable.length.vehicleName[1] = getXMLInt(Xml, groupNameTag.."#vehicleNameLength");end;			
			--view vehicles and data and length--
			--view vehicle typ--
			groupNameTag = (xmlNameTag.. ".viewTyp(%d)"):format(0);
			for key, value in pairs (box.ownTable.viewTyp) do
				if key ~= "isOpen" then
					if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.viewTyp[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;				
				end;
			end;
			--view vehicle typ--
			--show colors--
			--groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
			--for key, value in pairs (box.ownTable.showColors) do
			--	if key ~= "isOpen" then
			--		if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then 
			--			local color = getXMLString(Xml, groupNameTag.."#".. tostring(key));
			--			if g_currentMission.hlUtils.colorIntern[color] ~= nil then box.ownTable.showColors[key] = color;end;
			--		end;
			--	end;
			--end;
			--show colors--
		end;
	end;
end;

function VehicleInspector_Display_XmlBox.onSaveXml(box, Xml, xmlNameTag)	
	setXMLInt(Xml, xmlNameTag.."#version", VehicleInspector.metadata.xmlVersion);	
	setXMLString(Xml, xmlNameTag.."#WARNING", "NOT EDIT THIS XML OR VI CAN CRASH");
	
	if box.name == "VehicleInspector_Display_Box" then
		local groupNameTag = (xmlNameTag.. ".extension(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.."#isOn", box.ownTable.extension);
		setXMLFloat(Xml, groupNameTag.."#bgTransparent", box.ownTable.bgTransparent[1]);
		
		--view warnings/percent--
		groupNameTag = (xmlNameTag.. ".viewWarnings(%d)"):format(0);
		for key, value in pairs (box.ownTable.viewWarnings) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			end;
		end;	
		setXMLInt(Xml, groupNameTag.."#fuelProzent", box.ownTable.length.fuelProzent[1]);	
		setXMLInt(Xml, groupNameTag.."#damageProzent", box.ownTable.length.damageProzent[1]);	
		setXMLInt(Xml, groupNameTag.."#adBlueProzent", box.ownTable.length.adBlueProzent[1]);	
		--view warnings/percent--
		--view vehicles and data and length--
		groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (box.ownTable.view) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			end;
		end;
		setXMLInt(Xml, groupNameTag.."#vehicleNameLength", box.ownTable.length.vehicleName[1]);
		setXMLInt(Xml, groupNameTag.."#controlledNameLength", box.ownTable.length.controlledName[1]);
		setXMLInt(Xml, groupNameTag.."#attachedLength", box.ownTable.length.attached[1]);
		setXMLInt(Xml, groupNameTag.."#helperJobEndTimeBlinkingSec", box.ownTable.length.helperJobEndTimeBlinking[1]);
		setXMLBool(Xml, groupNameTag.."#attachedIconNotViewFillData", box.ownTable.view.attachedIcon[4]);
		setXMLBool(Xml, groupNameTag.."#adWaypoints", box.ownTable.view.adRemaining[4]);
		setXMLBool(Xml, groupNameTag.."#cpWaypoints", box.ownTable.view.cpRemaining[4]);	
		--view vehicles and data and length--
		--show colors--
		groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
		for key, value in pairs (box.ownTable.showColors) do
			if key ~= "isOpen" then
				setXMLString(Xml, groupNameTag.."#".. tostring(key), value);
			end;
		end;
		--show colors--
		--view text--
		groupNameTag = (xmlNameTag.. ".viewText(%d)"):format(0);
		for key, value in pairs (box.ownTable.viewText) do		
			setXMLString(Xml, groupNameTag.."#".. tostring(key), value);		
		end;
		--view text
		--show box align--
		groupNameTag = (xmlNameTag.. ".alignBox(%d)"):format(0);
		for key, value in pairs (box.ownTable.showBox) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
				setXMLBool(Xml, groupNameTag.."#".. tostring(key).. "AlignRight", value[4]);
				--setXMLBool(Xml, groupNameTag.."#".. tostring(key).. "ViewBoxEmpty", value[5]);
			end;
		end;
		--show box align--
		--auto dimension--
		groupNameTag = (xmlNameTag.. ".autoDimension(%d)"):format(0);
		for key, value in pairs (box.ownTable.autoDimension) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
				if value[4] ~= nil then setXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean", value[4]);end;
			end;
		end;
		--auto dimension--
		--camera--
		groupNameTag = (xmlNameTag.. ".cameraBox(%d)"):format(0);
		for key, value in pairs (box.ownTable.camera) do
			setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
		end;
		--camera--
		--own global xml--
		viSetGetSettingsXml:saveConfig();
		--own global xml--
	elseif box.name == "VehicleInspector_Display_AllInBox" then
		--view vehicles and data and length--
		local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (box.ownTable.view) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			end;
		end;
		setXMLInt(Xml, groupNameTag.."#vehicleNameLength", box.ownTable.length.vehicleName[1]);		
		--view vehicles and data and length--
		--view vehicle typ--
		groupNameTag = (xmlNameTag.. ".viewTyp(%d)"):format(0);
		for key, value in pairs (box.ownTable.viewTyp) do
			if key ~= "isOpen" then
				setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			end;
		end;
		--view vehicle typ--
		--show colors--
		groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
		for key, value in pairs (box.ownTable.showColors) do
			if key ~= "isOpen" then
				setXMLString(Xml, groupNameTag.."#".. tostring(key), value);
			end;
		end;
		--show colors--
	end;
end;

function VehicleInspector_Display_XmlBox:loadBox(name, show)
	if name == "VehicleInspector_Display_Box" then
		local box = g_currentMission.hlHudSystem.hlBox.generate( {name=name, width=250, height=150, info="VehicleInspector Mod\nVehicleInspector Box", displayName="VehicleInspectorDisplay Show Box", hiddenMod="VehicleInspector", autoZoomOutIn="text"} );
		VehicleInspector_DisplaySetGet:loadBoxIcons(box);		
		box.onDraw = VehicleInspector_Display_DrawBox.setBox;
		box.canDraw = VehicleInspector_Display_DrawBox.canDrawBox;
		box.onClick = VehicleInspector_Display_MouseKeyEventsBox.onClick;							
		box.screen.canBounds.on = true;
		box.resetBoundsByDragDrop = false;
		box.overlays.settingIcons.save.visible = false; --save over global icon
		box.overlays.settingIcons.up.visible = true; --for viewExtraLine
		box.overlays.settingIcons.down.visible = true; --for viewExtraLine
		box.isHelp = true;
		box.onSaveXml = VehicleInspector_Display_XmlBox.onSaveXml;						
		g_currentMission.hlUtils.colorIntern.ls15Inactive = { 0/255, 255/255, 255/255, 0.50 };
		g_currentMission.hlUtils.colorIntern.viBoxBgTransparent = { 0/255, 0/255, 0/255, 0.75 }; --for extension bgTransparent
		VehicleInspector_Display_XmlBox:onLoadXml(box, box:getXml()); --own box load over Xml (replace Data)
		box.displayName = "VehicleInspectorDisplay Box" --fix DisplayName;
		VehicleInspector_DisplaySetGet:setIconsColor(box);
		box:setMinWidth(box.screen.pixelW*180); --set min. width new (default ..pixelW*30) --replace save xml value
		box.autoZoomOutIn = "text"; --replace save xml value
		box.canAutoClose = false; --replace save xml value
		if show ~= nil and show and not box.show then box.show = true;end;
		box.ownTable.lastStateExtraLine = box.viewExtraLine;		
		--setting Gui--
		viGuiBoxSetGet:loadBox(box);
		--setting Gui--
	elseif name == "VehicleInspector_Display_AllInBox" then
		local box = g_currentMission.hlHudSystem.hlBox.generate( {name=name, width=250, height=150, info="VehicleInspector Mod\nVehicleInspector AllInBox", displayName="VehicleInspectorDisplay Show AllIn Box", hiddenMod="VehicleInspector", autoZoomOutIn="text"} );
		VehicleInspector_DisplaySetGet:loadBoxIcons(box);
		box.onDraw = VehicleInspector_Display_DrawAllInBox.setBox;
		box.onClick = VehicleInspector_Display_MouseKeyEventsBox.onClick;
		box.screen.canBounds.on = true;
		box.resetBoundsByDragDrop = false;
		box.overlays.settingIcons.save.visible = false; --save over global icon
		box.overlays.settingIcons.up.visible = true; --for viewExtraLine
		box.overlays.settingIcons.down.visible = true; --for viewExtraLine
		box.isHelp = true;
		box.onSaveXml = VehicleInspector_Display_XmlBox.onSaveXml;	
		VehicleInspector_Display_XmlBox:onLoadXml(box, box:getXml()); --own box load over Xml (replace Data)
		box:setMinWidth(box.screen.pixelW*180); --set min. width new (default ..pixelW*30) --replace save xml value
		box.autoZoomOutIn = "text"; --replace save xml value		
		if show ~= nil and show and not box.show then box.show = true;end;
		box.ownTable.lastStateExtraLine = box.viewExtraLine;
		--setting Gui--
		viGuiBoxSetGet:loadBox(box);
		--setting Gui--
	end;
end;
