viGuiBoxSetGet = {};

function viGuiBoxSetGet:loadBox(box)	
	if box ~= nil then
		local linesSequence = {};
		if box.name == "VehicleInspector_Display_Box" then
			linesSequence = {"vehicleTrailerHeadline_","maxAttached_","externTrailer_","fillLimit_","vehicleIcon_","vehicleName_","vehicleNameLength_","fillTypeIcon_","fillTypeName_","fillData_","colorPercent_","controlledName_","controlledNameLength_",
			"alignHeadline_","f1Menu_","ingameMap_","emptyVehicleBox_","autoHeight_",
			"optionalHeadline_","train_","horse_","contractor_","previewVehicles_","field_","leasing_","vmGroup_","attachedTotal_","infoWarningHeadline_","helperJobEndTimeBlinking_","isBlocking_","isWater_","isDamage_","isFuelEmpty_",
			"globalHeadline_","autoLight_","previewVehicleInfos_","previewUnloadSide_","previewWorkingWidth_","previewAttachedDamage_","previewLoadedFillTypes_"}; 
			box.guiMenu = g_currentMission.hlHudSystem.hlGuiBox.generate( {name="VehicleInspector_Display_GuiBox", title="VehicleInspector Box Settings", onOverGuiBoxHudSystem=true} );
		else
			linesSequence = {"vehicleHeadline_","vehicleIcon_","vehicleName_","vehicleNameLength_","vorschauVehicles_"};			
			box.guiMenu = g_currentMission.hlHudSystem.hlGuiBox.generate( {name="VehicleInspector_Display_GuiAllInBox", title="VehicleInspector AllIn-Box Settings", onOverGuiBoxHudSystem=true} );
		end;
		box.guiMenu.screen.canBounds.on = true;
		box.guiMenu.onClick = VehicleInspector_Display_MouseKeyEventsGuiBox.onClickArea;
		box.guiMenu.getLine = viGuiBoxSetGet.getLines;
		box.guiMenu.guiLines = {};
		for k,v in pairs(linesSequence) do
			table.insert(box.guiMenu.guiLines, v);
		end;		
		if box.ownTable.extension ~= nil and box.ownTable.extension then
			local extensionLinesSequence = {"extensionHeadline_","boxBgTransparents_"};
			for k,v in pairs(extensionLinesSequence) do
				table.insert(box.guiMenu.guiLines, v);
			end;
		end;
		viGuiBoxSetGet:addLines(box);
	end;
end;

function viGuiBoxSetGet:addLines(box)	
	if box ~= nil then		
		for l=1, #box.guiMenu.guiLines do
			box.guiMenu:addLine( {} );
		end;
		box.guiMenu:resetDimension();
	end;
end;

function viGuiBoxSetGet.getLines(args)	
	local box = args.box;
	local guiBox = args.guiBox;
	if guiBox == nil then return;end;
	if box == nil then 
		if guiBox.name == "VehicleInspector_Display_GuiBox" then
			box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_Box");
		else
			box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_AllInBox");
		end;
	end;
	local line = args.line or 1;
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local values = box.ownTable;
	local textL = "";
	local textR = "-";
	local textColor = "white";
	local textOffColor = box.overlays.color.notActive;
	local iconColor = box.overlays.color.notActive;	
	local helpText = "";
	local helpText2 = "";
	local alignWarning = g_i18n:getText("box_alignWarning");
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");
	local state = false;
	local stateColor = nil;
	local alignRightTxt = " (".. g_i18n:getText("info_tipSideRight").. ")";
	local moreTxt = "";
	local infoTxt = "";
	---trailer---
	if box.guiMenu.guiLines[line] == "vehicleHeadline_" then	
		textL = g_i18n:getText("box_vehicleHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;	
	if box.guiMenu.guiLines[line] == "vorschauVehicles_" then
		textL = g_i18n:getText("box_previewVehicles_title");
		state = false;
		if values.view["vorschauVehicles"][1] > 1 then state = true;iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewVehicles_help");		
		if values.view["vorschauVehicles"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewVehicles"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "vehicleTrailerHeadline_" then	
		textL = g_i18n:getText("box_vehicleTrailerHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "maxAttached_" then
		textL = g_i18n:getText("box_viewMaxAttached_title");
		helpText = string.format(g_i18n:getText("box_viewMaxAttached_help"), tostring(values.length.attached[1]));
		return {icon=overlayDefaultGroup[overlayDefaultByName["tractortrailer"]], iconColor=box.overlays.color.on, typ="number", helpText=helpText, text={[1]={text=textL}, [2]={state=true,text=tostring(values.length.attached[1])}} };
	end;
	if box.guiMenu.guiLines[line] == "externTrailer_" then		
		textL = g_i18n:getText("box_autoDimensionWidth_title");
		if values.autoDimension.width[1] > 1 then iconColor = box.overlays.color.on;end;		
		helpText = string.format(g_i18n:getText("box_autoDimensionWidth_help"), tostring(values.length.attached[1]));		
		if values.autoDimension.width[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["viewMaxAttached"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.autoDimension.width[1] > 1}} };		
	end;
	if box.guiMenu.guiLines[line] == "fillLimit_" then
		textL = g_i18n:getText("box_viewFillLimit_title");		
		state = false;
		if g_currentMission.missionInfo.trailerFillLimit and values.view["fillLimit"][1] > 1 then state = true;iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_viewFillLimit_help");		
		if values.view["fillLimit"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["fillLimit"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "vehicleIcon_" then
		textL = g_i18n:getText("box_viewVehicleIcons_title");
		infoTxt = stateOff;
		local icon = overlayDefaultGroup[overlayDefaultByName["tractor"]];
		if values.view["vehicleIcon"][1] > 1 then 
			iconColor = box.overlays.color.on;
			if values.view["vehicleIcon"][1] == 2 then infoTxt = "TypeDesc";elseif values.view["vehicleIcon"][1] == 3 then icon = overlayDefaultGroup[overlayDefaultByName["tractor_org"]];iconColor = {1,1,1,1};infoTxt = g_i18n:getText("input_TOGGLE_STORE");end;
			textL = textL.. " (".. infoTxt.. ")";
		end;
		helpText = string.format(g_i18n:getText("box_viewVehicleIcons_help"), infoTxt);
		if values.view["vehicleIcon"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=icon, iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleIcon"][1] > 1}} };	
	end;
	if box.guiMenu.guiLines[line] == "vehicleName_" then
		textL = g_i18n:getText("box_viewVehicleName_title");
		infoTxt = " (AutoDrive*/VehicleManager)";
		local driverText = "";
		if values.view["vehicleName"][1] > 1 then iconColor = box.overlays.color.on;end;
		if values.view["vehicleName"][1] == 5 then if VehicleInspector.otherMods.autoDrive then driverText = " (AutoDrive)";elseif g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil then driverText = " (VehicleManager)";end;end;
		if values.view["vehicleName"][1] == 1 then infoTxt = "\nView: ".. stateOff;elseif values.view["vehicleName"][1] == 2 then infoTxt = "\nView: VehicleName";elseif values.view["vehicleName"][1] == 3 then infoTxt = "\nView: FullName";elseif values.view["vehicleName"][1] == 4 then infoTxt = "\nView: TypName";elseif values.view["vehicleName"][1] == 5 then infoTxt = "\nView: DriverName".. driverText;end;
		helpText = string.format(g_i18n:getText("box_viewVehicleName_help"), driverText, driverText).. infoTxt;
		if values.view["vehicleName"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["tractor"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleName"][1] > 1}} };	
	end;
	if box.guiMenu.guiLines[line] == "vehicleNameLength_" then
		textL = g_i18n:getText("box_vehicleNameLength_title");
		if values.view["vehicleName"][1] == 1 then
			stateColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", text={[1]={text=textL,color=stateColor}} };
		else
			helpText = string.format(g_i18n:getText("box_vehicleNameLength_help"), tostring(values.length.vehicleName[1]));
			return {typ="number", helpText=helpText, text={[1]={text=textL}, [2]={text=tostring(values.length.vehicleName[1])}} };
		end;
	end;
	if box.guiMenu.guiLines[line] == "fillTypeIcon_" then
		textL = g_i18n:getText("box_viewFillTypeIcons_title");
		if values.view.fillTypeIcon[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_viewFillTypeIcons_help");
		if values.view.fillTypeIcon[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["wheat"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view.fillTypeIcon[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "fillTypeName_" then
		textL = g_i18n:getText("box_viewFillTypeName_title");
		if values.view.fillTypeName[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = string.format(g_i18n:getText("box_viewFillTypeName_help"), "10", "3");
		if values.view.fillTypeName[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["wheat"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view.fillTypeName[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "fillData_" then
		textL = g_i18n:getText("box_viewFillData_title");
		if values.view["fillData"][1] > 1 then iconColor = box.overlays.color.on;end;
		infoTxt = stateOff;
		if values.view["fillData"][1] == 2 then infoTxt = g_i18n:getText("info_fillLevel").. " + %";textL = textL.. " + %";elseif values.view["fillData"][1] == 3 then infoTxt = g_i18n:getText("info_fillLevel");end;
		helpText = string.format(g_i18n:getText("box_viewFillData_help"), infoTxt);
		if values.view.fillData[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["trailerfull"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view.fillData[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "colorPercent_" then
		textL = g_i18n:getText("box_viewFillDataColor_title");
		if values.view.fillDataColor[1] > 1 then iconColor = {1,1,1,1};end;
		helpText = g_i18n:getText("box_viewFillDataColor_help");
		if values.view.fillDataColor[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["colorPercent"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view.fillDataColor[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "controlledName_" then
		textL = g_i18n:getText("box_viewControlledName_title");
		infoTxt = "\nView: ".. stateOff;
		if values.view["controlledName"][1] > 1 then iconColor = textColor;else iconColor = textOffColor;end;
		if values.view["controlledName"][1] == 2 then infoTxt = "\nView: ".. g_i18n:getText("ui_playerName").. "(MP)";elseif values.view["controlledName"][1] == 3 then infoTxt = "\nView: ".. g_i18n:getText("ui_playerName").. "(MP)/".. g_i18n:getText("ui_helper").. " ".. g_i18n:getText("ui_name");elseif values.view["controlledName"][1] == 4 then infoTxt = "\nView: ".. g_i18n:getText("ui_helper").. " ".. g_i18n:getText("ui_name");end;
		helpText = g_i18n:getText("box_viewControlledName_help").. infoTxt;
		if values.view["controlledName"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["controlledName"][1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "controlledNameLength_" then
		textL = g_i18n:getText("box_controlledNameLength_title");
		if values.view["controlledName"][1] == 1 then
			stateColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", text={[1]={text=textL,color=stateColor}} };
		else
			helpText = string.format(g_i18n:getText("box_controlledNameLength_help"), tostring(values.length.controlledName[1]));
			return {typ="number", helpText=helpText, text={[1]={text=textL}, [2]={text=tostring(values.length.controlledName[1])}} };
		end;
	end;
	---trailer---
	---align---
	if box.guiMenu.guiLines[line] == "alignHeadline_" then	
		textL = g_i18n:getText("box_alignHeadline");	
		local formatTxt = stateOff;
		local status = "";
		if values.showBox.helpMenu[1] == 1 and values.showBox.ingameMap[1] == 1 then 
			
		else 
			formatTxt = stateOn;
			if values.showBox.helpMenu[1] > 1 then status = "-F1 MENU-";else status = "-INGAMEMAP-";end;			
		end;		
		helpText = string.format(g_i18n:getText("box_autoAlign_help"), formatTxt, status);
		return {typ="headline", helpText=helpText, text={[1]={text=textL, color="ls22"}} };
	end;	
	if box.guiMenu.guiLines[line] == "f1Menu_" then	
		textL = g_i18n:getText("box_alignHelpMenu_title");						
		if values.showBox.helpMenu[1] > 1 then			
			iconColor = box.overlays.color.on;
			if values.showBox.helpMenu[4] then textL = textL.. alignRightTxt;end;
			if values.showBox.helpMenu[1] == 4 then textR = stateOn.. "/".. stateOff;elseif values.showBox.helpMenu[1] == 2 then textR = stateOn;elseif values.showBox.helpMenu[1] == 3 then textR = stateOff;end;
		end;
		if values.showBox.helpMenu[1] > 1 then 
			helpText = string.format(g_i18n:getText("box_alignHelpMenu_help"), stateOn);
			helpText = helpText.. "\n".. g_i18n:getText("box_helpMenuState".. tostring(values.showBox.helpMenu[1]));
			if values.showBox.helpMenu[1] == 2 or values.showBox.helpMenu[1] == 4 then 
				if values.showBox.helpMenu[4] then helpText = helpText.. g_i18n:getText("box_alignHelpMenuRight");else helpText = helpText.. g_i18n:getText("box_alignHelpMenuTop");end;
			end;
			--if values.showBox.helpMenu[5] then moreTxt = string.format(g_i18n:getText("box_alignViewEmptyBox"), stateOn);else moreTxt = string.format(g_i18n:getText("box_alignViewEmptyBox"), stateOff);end;
			--helpText = helpText.. "\n".. moreTxt;
		else 
			helpText = string.format(g_i18n:getText("box_alignHelpMenu_help"), stateOff);
		end;
		if values.showBox.helpMenu[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["autoAlign"]], iconColor=iconColor, typ="string", setFrame=true, frameIcon=overlayDefaultGroup[overlayDefaultByName["view"]], frameIconColor=iconColor, acceptsMouse={"left","right"}, helpText=helpText.. "\n".. alignWarning, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,text=textR}} };	
	end;
	if box.guiMenu.guiLines[line] == "ingameMap_" then
		textL = g_i18n:getText("box_alignIngameMap_title");		
		if values.showBox.helpMenu[1] == 1 and values.showBox.ingameMap[1] > 1 then	
			iconColor = box.overlays.color.on;
			if values.showBox.ingameMap[4] then textL = textL.. alignRightTxt;end;
			if values.showBox.ingameMap[1] == 4 then textR = stateOn.. "/".. stateOff;elseif values.showBox.ingameMap[1] == 2 then textR = stateOn;elseif values.showBox.ingameMap[1] == 3 then textR = stateOff;end;
		elseif values.showBox.helpMenu[1] > 1 then 
			iconColor = box.overlays.color.off;
		end;		
		if values.showBox.ingameMap[1] > 1 and values.showBox.helpMenu[1] == 1 then 
			helpText = string.format(g_i18n:getText("box_alignIngameMap_help"), stateOn);
			helpText = helpText.. "\n".. g_i18n:getText("box_ingameMapState".. tostring(values.showBox.ingameMap[1]));
			if values.showBox.ingameMap[1] == 2 or values.showBox.ingameMap[1] == 4 then 
				if values.showBox.ingameMap[4] then helpText = helpText.. g_i18n:getText("box_alignIngameMapRight");else helpText = helpText.. g_i18n:getText("box_alignIngameMapTop");end;
			end;
			--if values.showBox.ingameMap[5] then moreTxt = string.format(g_i18n:getText("box_alignViewEmptyBox"), stateOn);else moreTxt = string.format(g_i18n:getText("box_alignViewEmptyBox"), stateOff);end;
			--helpText = helpText.. "\n".. moreTxt;
		else 
			helpText = string.format(g_i18n:getText("box_alignIngameMap_help"), stateOff);
		end;
		if (values.showBox.helpMenu[1] == 1 and values.showBox.ingameMap[1] == 1) or values.showBox.helpMenu[1] > 1 then stateColor = textOffColor;end;	
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["autoAlign"]], iconColor=iconColor, typ="string", setFrame=true, frameIcon=overlayDefaultGroup[overlayDefaultByName["view"]], frameIconColor=iconColor, acceptsMouse={"left","right"}, helpText=helpText.. "\n".. alignWarning, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,text=textR}} };
	end;
	if box.guiMenu.guiLines[line] == "emptyVehicleBox_" then
		textL = g_i18n:getText("box_viewEmptyVehicleBox_title");
		textR = stateOff;
		if values.view.emptyVehicleBox[1] > 1 then iconColor = box.overlays.color.on;textR = stateOn;end;
		helpText = g_i18n:getText("box_viewEmptyVehicleBox_help");
		if values.view.emptyVehicleBox[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, iconColor=iconColor, typ="string", setFrame=true, frameIcon=overlayDefaultGroup[overlayDefaultByName["view"]], frameIconColor=iconColor, helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,text=textR}} };
	end;
	if box.guiMenu.guiLines[line] == "autoHeight_" then
		alignWarning = g_i18n:getText("box_autoDimensionWarning");
		textL = g_i18n:getText("box_autoDimensionHeight_title");		
		textR = "-";
		if values.autoDimension.height[1] > 1 then
			iconColor = box.overlays.color.on;
			helpText = string.format(g_i18n:getText("box_autoDimensionHeight_help"), stateOn, "").. "\n".. alignWarning;		
		else
			helpText = string.format(g_i18n:getText("box_autoDimensionHeight_help"), stateOff, "").. "\n".. alignWarning;		
		end;
		if values.autoDimension.height[1] > 1 then
			if values.autoDimension.height[1] == 2 then
				iconColor = box.overlays.color.on;
				moreTxt = g_i18n:getText("ui_auto");
				helpText = string.format(g_i18n:getText("box_autoDimensionMaxHeight"), moreTxt).. "\n".. alignWarning;
				textL = textL.. " (".. moreTxt.. ")";
				return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["autoDimensionHeight"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL}, [2]={state=true}} };
			else
				iconColor = box.overlays.color.warning;
				moreTxt = g_i18n:getText("ui_directionChangeModeManual");
				helpText = string.format(g_i18n:getText("box_autoDimensionMaxHeight"), moreTxt).. "\n".. alignWarning;
				textL = textL.. " (".. moreTxt.. ")";
				textR = tostring(values.autoDimension.maxHeight[1]);
				helpText2 = g_i18n:getText("input_CONSTRUCTION_HEIGHT").. " ".. tostring(values.autoDimension.maxHeight[1]).. "\n".. alignWarning;
				return {icon=overlayDefaultGroup[overlayDefaultByName["autoDimensionHeight"]], iconColor=iconColor, typ="number", text={[1]={text=textL, helpText=helpText}, [2]={text=textR, helpText=helpText2}} };
			end;
		else
			if values.autoDimension.height[1] == 1 then stateColor = textOffColor;end;
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["autoDimensionHeight"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=false}} };
		end;
	end;	
	---align---
	---optional optionen---
	if box.guiMenu.guiLines[line] == "optionalHeadline_" then
		textL = g_i18n:getText("box_optionalHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "train_" then
		textL = g_i18n:getText("box_viewTrain_title");
		if values.view["train"][1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_viewTrain_help");
		if values.view["train"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["train"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["train"][1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "horse_" then
		textL = g_i18n:getText("box_viewHorse_title");
		if values.view["horse"][1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_viewHorse_help");
		if values.view["horse"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["horse"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["horse"][1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "contractor_" then
		textL = g_i18n:getText("box_viewContractor_title");		
		helpText = g_i18n:getText("box_viewContractor_help");
		if g_currentMission.missionDynamicInfo.isMultiplayer then
			local stateText = g_i18n:getText("defaultFarmName");
			if values.view["contractor"][1] > 1 then
				if values.view["contractor"][1] == 2 then stateText = stateText.. "/".. g_i18n:getText("contractorFarm");iconColor = box.overlays.color.on;else stateText = g_i18n:getText("contractorFarm");iconColor = box.overlays.color.warning;end;
			else
				stateColor = textOffColor;
			end;
			helpText2 = g_i18n:getText("ui_mapHotspotFilter_vehicles").. ": ".. stateText;
			return {icon=overlayDefaultGroup[overlayDefaultByName["contractor"]], iconColor=iconColor, iconBlinking=values.view["contractor"][1] == 3, typ="number", text={[1]={text=textL,helpText=helpText,stateColor=iconColor, blinking=values.view["contractor"][1] == 3}, [2]={text=tostring(values.view["contractor"][1]).. "/".. tostring(values.view["contractor"][3]),helpText=helpText2,color=iconColor, blinking=values.view["contractor"][1] == 3}} };
		else			
			return {icon=overlayDefaultGroup[overlayDefaultByName["contractor"]], iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL,color=iconColor}} };
		end;		
	end;
	if box.guiMenu.guiLines[line] == "previewVehicles_" then
		textL = g_i18n:getText("box_previewVehicles_title");
		textR = "-";
		if VehicleInspector.values.previewData.vehicles.view[1] > 1 then iconColor = box.overlays.color.on;textR = tostring(VehicleInspector.values.previewData.vehicles.iSize[1]);end;
		helpText = g_i18n:getText("box_previewVehicles_help");
		state = VehicleInspector.values.previewData.vehicles.view[1] > 1;		
		if VehicleInspector.values.previewData.vehicles.view[1] > 1 then
			helpText2 = g_i18n:getText("box_iconSize");			
			return {icon=overlayDefaultGroup[overlayDefaultByName["previewVehicles"]], iconColor=iconColor, typ="number", text={[1]={text=textL, helpText=helpText}, [2]={text=textR, helpText=helpText2}} };
		else
			if VehicleInspector.values.previewData.vehicles.view[1] == 1 then stateColor = textOffColor;end;
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewVehicles"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
		end;
	end;
	if box.guiMenu.guiLines[line] == "field_" then
		textL = g_i18n:getText("box_viewField_title");		
		infoTxt = stateOff;
		moreTxt = "";
		if values.view["field"][1] > 1 then 
			iconColor = values.showColors.field;
			if values.view["field"][1] == 3 then infoTxt = "+Nr.(SP)";moreTxt = "\n".. g_i18n:getText("performance_attention");end;
			if values.view["field"][1] == 4 then infoTxt = "+Nr.(SP/MP)";moreTxt = "\n".. g_i18n:getText("performance_attention");end;
			if values.view["field"][1] >= 3 then textL = textL.. infoTxt;infoTxt = stateOn.. " ".. infoTxt;else infoTxt = stateOn;end;
		end;		
		helpText = string.format(g_i18n:getText("box_viewField_help"), infoTxt).. moreTxt;
		if values.view["field"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["field"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["field"][1] > 1}} };		
	end;	
	if box.guiMenu.guiLines[line] == "leasing_" then
		textL = g_i18n:getText("box_viewLeasingIcons_title");
		helpText = string.format(g_i18n:getText("box_viewLeasingIcons_help"), tostring(values.showColors.leasing):upper(), tostring(values.showColors.missionsLeasing):upper() );
		local leasingIconTyp = "leasing_icon";
		if values.view["leasing"][1] > 1 then 
			if g_currentMission.hlUtils.runsTimer("5sec", true) then
				iconColor = values.showColors.missionsLeasing;
			else
				iconColor = values.showColors.leasing;
			end;
			if values.view["leasing"][1] == 3 then textL = "Leasing Text";leasingIconTyp = "leasing_text";end;
		end;
		if values.view["leasing"][1] == 1 then stateColor = textOffColor;end;		
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName[leasingIconTyp]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["leasing"][1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "vmGroup_" then
		textL = g_i18n:getText("box_viewGroupIcons_title");
		helpText = g_i18n:getText("box_viewGroupIcons_help");
		state = false;
		if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil then
			state = values.view["group"][1] > 1;
			if values.view["group"][1] > 1 then iconColor = values.showColors.isGroup;end;		
		end;
		if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] == nil or values.view["group"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["groups"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "attachedTotal_" then
		textL = g_i18n:getText("box_viewAttachedTotal_title");
		helpText = g_i18n:getText("box_viewAttachedTotal_help");
		if values.view["attachedTotal"][1] > 1 then iconColor = box.overlays.color.on;end;
		if values.view["attachedTotal"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["attached"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["attachedTotal"][1] > 1}} };
	end;
	---optional optionen---
	---infos/warnings---
	if box.guiMenu.guiLines[line] == "infoWarningHeadline_" then
		textL = g_i18n:getText("box_infoWarningHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	
	if box.guiMenu.guiLines[line] == "helperJobEndTimeBlinking_" then 
		textL = g_i18n:getText("box_viewHelperJobEndTimeBlinking_title");
		textR = "-";
		if values.view.helperJobEndTimeBlinking[1] > 1 then iconColor = values.showColors.helperJobEndTimeBlinking;textR = tostring(values.length.helperJobEndTimeBlinking[1]).. "s";end;
		helpText = string.format(g_i18n:getText("box_viewHelperJobEndTimeBlinking_help"), tostring(values.length.helperJobEndTimeBlinking[1]));		
		if values.view.helperJobEndTimeBlinking[1] > 1 then
			helpText2 = string.format(g_i18n:getText("box_viewHelperJobEndTime_help"), tostring(values.length.helperJobEndTimeBlinking[1])); 
			return {icon=overlayDefaultGroup[overlayDefaultByName["jobEnd"]], iconColor=iconColor, typ="number", text={[1]={text=textL,helpText=helpText}, [2]={text=textR,helpText=helpText2}} };
		else		
			if values.view.helperJobEndTimeBlinking[1] == 1 then stateColor = textOffColor;end;
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["jobEnd"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=false}} };
		end;
	end;	
	if box.guiMenu.guiLines[line] == "isBlocking_" then
		textL = g_i18n:getText("box_viewIsBlocking_title");
		if values.viewWarnings.isBlocking[1] > 1 then iconColor = values.showColors.blockingTyp1;end;
		helpText = string.format(g_i18n:getText("box_viewIsBlocking_help"), tostring(values.showColors.blockingTyp1):upper(), tostring(values.showColors.blockingTyp2):upper());
		if values.viewWarnings.isBlocking[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["speed"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.viewWarnings.isBlocking[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "isWater_" then
		textL = g_i18n:getText("box_viewIsWater_title");
		if values.viewWarnings.isWater[1] > 1 then iconColor = values.showColors.water;end;
		helpText = g_i18n:getText("box_viewIsWater_help");
		if values.viewWarnings.isWater[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["speed"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.viewWarnings.isWater[1] > 1}} };
	end;
	if box.guiMenu.guiLines[line] == "isDamage_" then
		textL = g_i18n:getText("box_viewIsDamage_title");
		textR = "-"
		if values.viewWarnings.isDamage[1] > 1 then iconColor = values.showColors.damage;textR=tostring(values.length.damageProzent[1]).. "%";end;
		helpText = g_i18n:getText("box_viewIsDamage_help");
		if values.viewWarnings.isDamage[1] > 1 then
			helpText2 = string.format(g_i18n:getText("box_viewDamageProzent"), tostring(values.length.damageProzent[1]).. "%");
			return {icon=overlayDefaultGroup[overlayDefaultByName["damage"]], iconColor=iconColor, typ="number", text={[1]={text=textL,helpText=helpText}, [2]={text=textR, helpText=helpText2}} };
		else
			if values.viewWarnings.isDamage[1] == 1 then stateColor = textOffColor;end;
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["damage"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=false}} };
		end;
	end;	
	if box.guiMenu.guiLines[line] == "isFuelEmpty_" then
		textL = g_i18n:getText("box_viewIsFuelEmpty_title");
		textR = "-";
		if values.viewWarnings.isFuelEmpty[1] > 1 then iconColor = values.showColors.fuelEmpty;textR=tostring(values.length.fuelProzent[1]).. "%";end;
		helpText = g_i18n:getText("box_viewIsFuelEmpty_help");
		if values.viewWarnings.isFuelEmpty[1] > 1 then
			helpText2 = string.format(g_i18n:getText("box_viewFuelEmptyProzent"), tostring(values.length.fuelProzent[1]).. "%");
			return {icon=overlayDefaultGroup[overlayDefaultByName["fuel"]], iconColor=iconColor, typ="number", text={[1]={text=textL,helpText=helpText}, [2]={text=textR, helpText=helpText2}} };
		else
			if values.viewWarnings.isFuelEmpty[1] == 1 then stateColor = textOffColor;end;
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["fuel"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=false}} };
		end;
	end;	
	---infos/warnings---
	---global---
	if box.guiMenu.guiLines[line] == "globalHeadline_" then
		textL = g_i18n:getText("box_globalHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "autoLight_" then
		textL = g_i18n:getText("box_otherAutoLight_title");
		if VehicleInspector.values.otherData.autoLight.view[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_otherAutoLight_help");
		state = VehicleInspector.values.otherData.autoLight.view[1] > 1;
		if VehicleInspector.values.otherData.autoLight.view[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["light"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "previewVehicleInfos_" then
		textL = g_i18n:getText("box_previewVehicleInfos_title");
		if VehicleInspector.values.previewData.vehicleInfos.view[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewVehicleInfos_help");
		state = VehicleInspector.values.previewData.vehicleInfos.view[1] > 1;
		if VehicleInspector.values.previewData.vehicleInfos.view[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewVehicleInfos"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };		
	end;
	if box.guiMenu.guiLines[line] == "previewUnloadSide_" then
		textL = g_i18n:getText("box_previewUnloadSide_title");
		if VehicleInspector.values.previewData.unloadSide.view[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewUnloadSide_help");
		state = VehicleInspector.values.previewData.unloadSide.view[1] > 1;		
		if VehicleInspector.values.previewData.unloadSide.view[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewUnloadSide"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };	
	end;
	if box.guiMenu.guiLines[line] == "previewWorkingWidth_" then
		textL = g_i18n:getText("box_previewWorkingWidth_title");
		if VehicleInspector.values.previewData.workingWidth.view[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewWorkingWidth_help");
		state = VehicleInspector.values.previewData.workingWidth.view[1] > 1;		
		if VehicleInspector.values.previewData.workingWidth.view[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewWorkingWidth"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "previewAttachedDamage_" then
		textL = g_i18n:getText("box_previewAttachedDamage_title");
		if VehicleInspector.values.previewData.attachedDamage.view[1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewAttachedDamage_help");
		state = VehicleInspector.values.previewData.attachedDamage.view[1] > 1;		
		if VehicleInspector.values.previewData.attachedDamage.view[1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewAttachedDamage"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if box.guiMenu.guiLines[line] == "previewLoadedFillTypes_" then
		textL = g_i18n:getText("box_previewLoadedFillTypes_title");		
		textR = "-";
		if VehicleInspector.values.previewData.loadedFillTypes.view[1] > 1 then 
			if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 2 then textL = textL.. " (mittig)";else textL = textL.. " (in Fahrz. InfoBox)";end;
			iconColor = box.overlays.color.on;
		end;
		helpText = g_i18n:getText("box_previewLoadedFillTypes_help");
		state = VehicleInspector.values.previewData.loadedFillTypes.view[1] > 1;
		if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 2 then 
			helpText2 = g_i18n:getText("box_iconSize");
			textR = tostring(VehicleInspector.values.previewData.loadedFillTypes.iSize[1]);
			return {icon=overlayDefaultGroup[overlayDefaultByName["previewLoadedFillTypes"]], iconColor=iconColor, typ="number", text={[1]={text=textL, helpText=helpText}, [2]={text=textR, helpText=helpText2}} };
		else
			if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 3 then
				return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewLoadedFillTypes"]], iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL}} };
			else
				if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 1 then state=false;stateColor = textOffColor;end;
				return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewLoadedFillTypes"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
			end;
		end;
	end;	
	---global---	
	---extension---
	if box.guiMenu.guiLines[line] == "extensionHeadline_" then
		textL = "Hidden Optionen";	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "boxBgTransparents_" then
		textL = "Box Transparents";
		textR = string.format("%1.2f", values.bgTransparent[1]);
		helpText = string.format(g_i18n:getText("box_settingBackgroundTransparent"), textR);
		if values.bgTransparent[1] < 0.76 and values.bgTransparent[1] > 0.74 then stateColor = box.overlays.color.on;end;
		return {typ="number", helpText=helpText, text={[1]={text=textL}, [2]={text=textR,color=stateColor}} };
	end;
	---extension---
	return nil;
end;

function viGuiBoxSetGet.getLinesAllInBox(args)
	local box = args.box;
	if box == nil then  box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_AllInBox");end;
	local line = args.line or 1;
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local values = box.ownTable;
	local textL = "";
	local textR = "-";
	local textColor = "white";
	local textOffColor = box.overlays.color.notActive;
	local iconColor = box.overlays.color.notActive;	
	local helpText = "";
	local helpText2 = "";
	local alignWarning = g_i18n:getText("box_alignWarning");
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");
	local state = false;
	local stateColor = nil;
	local alignRightTxt = " (".. g_i18n:getText("info_tipSideRight").. ")";
	local moreTxt = "";
	local infoTxt = "";
	---trailer---
	if box.guiMenu.guiLines[line] == "vehicleHeadline_" then	
		textL = g_i18n:getText("box_vehicleHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "vehicleIcon_" then
		textL = g_i18n:getText("box_viewVehicleIcons_title");
		infoTxt = stateOff;
		local icon = overlayDefaultGroup[overlayDefaultByName["tractor"]];
		if values.view["vehicleIcon"][1] > 1 then 
			iconColor = box.overlays.color.on;
			if values.view["vehicleIcon"][1] == 2 then infoTxt = "TypeDesc";elseif values.view["vehicleIcon"][1] == 3 then icon = overlayDefaultGroup[overlayDefaultByName["tractor_org"]];iconColor = {1,1,1,1};infoTxt = g_i18n:getText("input_TOGGLE_STORE");end;
			textL = textL.. " (".. infoTxt.. ")";
		end;
		helpText = string.format(g_i18n:getText("box_viewVehicleIcons_help"), infoTxt);
		if values.view["vehicleIcon"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=icon, iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleIcon"][1] > 1}} };	
	end;
	if box.guiMenu.guiLines[line] == "vehicleName_" then
		textL = g_i18n:getText("box_viewVehicleName_title");
		infoTxt = " (AutoDrive*/VehicleManager)";
		local driverText = "";
		if values.view["vehicleName"][1] > 1 then iconColor = box.overlays.color.on;end;
		if values.view["vehicleName"][1] == 5 then if VehicleInspector.otherMods.autoDrive then driverText = " (AutoDrive)";elseif g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil then driverText = " (VehicleManager)";end;end;
		if values.view["vehicleName"][1] == 1 then infoTxt = "\nView: ".. stateOff;elseif values.view["vehicleName"][1] == 2 then infoTxt = "\nView: VehicleName";elseif values.view["vehicleName"][1] == 3 then infoTxt = "\nView: FullName";elseif values.view["vehicleName"][1] == 4 then infoTxt = "\nView: TypName";elseif values.view["vehicleName"][1] == 5 then infoTxt = "\nView: DriverName".. driverText;end;
		helpText = string.format(g_i18n:getText("box_viewVehicleName_help"), driverText, driverText).. infoTxt;
		if values.view["vehicleName"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["tractor"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleName"][1] > 1}} };	
	end;
	if box.guiMenu.guiLines[line] == "vehicleNameLength_" then
		textL = g_i18n:getText("box_vehicleNameLength_title");
		if values.view["vehicleName"][1] == 1 then
			stateColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", text={[1]={text=textL,color=stateColor}} };
		else
			helpText = string.format(g_i18n:getText("box_vehicleNameLength_help"), tostring(values.length.vehicleName[1]));
			return {typ="number", helpText=helpText, text={[1]={text=textL}, [2]={text=tostring(values.length.vehicleName[1])}} };
		end;
	end;
	---trailer---
	---Vi Box Reset---
	if box.guiMenu.guiLines[line] == "viBoxHeadline_" then	
		textL = g_i18n:getText("box_viBoxResetHeadline");	
		return {typ="headline", text={[1]={text=textL, color="ls22"}} };
	end;
	if box.guiMenu.guiLines[line] == "viBoxSetting_" then
		textL = "VI Box Setting";
		helpText = g_i18n:getText("box_viBoxSetting");
		return {oneClick=true, typ="string", helpText=helpText, text={[1]={text=textL}} };	
	end;
	---VI Box Reset---
end;