VehicleInspector_Display_MouseKeyEventsBox = {};

function VehicleInspector_Display_MouseKeyEventsBox.onClick(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "settingIcon_" then
					if box.isSetting then						
						box.ownTable.lastStateExtraLine=box.viewExtraLine;
						box.viewExtraLine = true;						
					else 
						box.viewExtraLine = box.ownTable.lastStateExtraLine;						
					end;
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "menueClose_" then
					box.isSetting = false;box.viewExtraLine = box.ownTable.lastStateExtraLine;					
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "viewExtraLine_" then
					box.ownTable.lastStateExtraLine=box.viewExtraLine;
				end;
			end;
		end;
	end;
end;

function VehicleInspector_Display_MouseKeyEventsBox.onClickArea(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
		
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "settingTyp_" then
						if box.settingTyp >= box.ownTable.maxSettingTyp then 
							box.settingTyp = 1;							
						else 
							box.settingTyp = box.settingTyp+1;							
						end;
						box:setUpdateState(true);
					elseif args.clickAreaTable.whereClick == "settingGuiBox_" and box.guiMenu ~= nil and box.guiMenu.setShow ~= nil then
						box.guiMenu:setShow(not box.guiMenu.show);
						if box.guiMenu.show then box.isSetting = false;end;
						return;					
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local maxDistance = box.screen.pixelH*8;
						if box.screen.size.distance.textLine+(box.screen.pixelH/2) <= maxDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine+(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;					
					elseif args.clickAreaTable.whereClick == "settingModView_" then
						if args.clickAreaTable.ownTable.view ~= nil and box.ownTable.view[args.clickAreaTable.ownTable.view] ~= nil then
							if box.ownTable.view[args.clickAreaTable.ownTable.view][1]+1 > box.ownTable.view[args.clickAreaTable.ownTable.view][3] then
								box.ownTable.view[args.clickAreaTable.ownTable.view][1] = box.ownTable.view[args.clickAreaTable.ownTable.view][2];
							else
								box.ownTable.view[args.clickAreaTable.ownTable.view][1] = box.ownTable.view[args.clickAreaTable.ownTable.view][1]+1;								
							end;
							if args.clickAreaTable.ownTable.view == "contractor" then
								if box.ownTable.view.contractor[1] == 3 then
									if not viSetGet:hasFarmContracting() then
										box.ownTable.view.contractor[1] = 1;
										g_currentMission.hlHudSystem.showInfoBox( {"Your Farm has not Contractor Farms\nView Only Contractor Vehicles Off", 2000, g_currentMission.hlUtils.getColor("orangeRed", true)} );										
									end;
								end;
							end;
							if args.clickAreaTable.ownTable.view == "attachedIcon" then
								if box.ownTable.view.attachedIcon[1] == 1 then 
									if g_currentMission.hlUtils.timers["viAttachedIconTimer_"] ~= nil then g_currentMission.hlUtils.removeTimer("viAttachedIconTimer_");end;										
								else
									if g_currentMission.hlUtils.timers["viAttachedIconTimer_"] == nil then
										g_currentMission.hlUtils.addTimer({name="viAttachedIconTimer_", delay=box.ownTable.view.attachedIcon[5], repeatable=false, action=VehicleInspector_Display_MouseKeyEventsBox.removeAttachedIconTimer, ownTable={box}});
									end;									
								end;
							end;
							if args.clickAreaTable.ownTable.view == "adRemaining" and VehicleInspector.otherMods.autoDrive and FS25_AutoDrive.AutoDrive ~= nil and box.ownTable.view[args.clickAreaTable.ownTable.view][1] > 1 then
								local state = FS25_AutoDrive.AutoDrive.getSettingState("remainingDriveTimeInterval");
								if state ~= nil and state <= 1 then									
									g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("box_viewAdRemainingWarning"), 3000, g_currentMission.hlUtils.getColor("orangeRed", true)} );
								end;
							end;
							if not args.clickAreaTable.ownTable.view == "attachedIcon" then g_currentMission.hlHudSystem.isSave = false;end; --global
						end;																				
					elseif args.clickAreaTable.whereClick == "showVehicles_" then
						if args.clickAreaTable.ownTable[1] ~= nil and box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]] ~= nil then
							if box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][1]+1 > box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][3] then
								box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][1] = box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][2];
							else
								box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][1] = box.ownTable.showVehicles[args.clickAreaTable.ownTable[1]][1]+1;
							end;
							g_currentMission.hlHudSystem.isSave = false --global
						end;					
					end;					
				end;
				if args.clickAreaTable.whereClick == "vehicleLine_" then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then VehicleInspector_DisplaySetGet:clickVehicleLine("left", args.clickAreaTable.ownTable.vehicleNode);end;				
				end;
			end;		
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "settingTyp_" then
						if box.settingTyp <= 1 then 
							box.settingTyp = box.ownTable.maxSettingTyp;							
						else 
							box.settingTyp = box.settingTyp-1;							
						end;
						box:setUpdateState(true);
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local minDistance = box.screen.pixelH*1;
						if box.screen.size.distance.textLine-(box.screen.pixelH/2) >= minDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine-(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;						
					elseif args.clickAreaTable.whereClick == "settingModView_" then 
						if args.clickAreaTable.ownTable.view == "attachedIcon" then
							box.ownTable.view.attachedIcon[4] = not box.ownTable.view.attachedIcon[4];
							g_currentMission.hlHudSystem.isSave = false --global
						elseif args.clickAreaTable.ownTable.view == "adRemaining" and VehicleInspector.otherMods.autoDrive then --only on/off (view AD Hud)
							viSetGet:openCloseAdHud();
						elseif args.clickAreaTable.ownTable.view == "cpRemaining" and VehicleInspector.otherMods.coursePlay then --only on/off (view CP Hud)
							viSetGet:openCloseCpHud();						
						end;										
					end;				
				end;
				if args.clickAreaTable.whereClick == "vehicleLine_" then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then VehicleInspector_DisplaySetGet:clickVehicleLine("right", args.clickAreaTable.ownTable.vehicleNode);end;
				end;
			end;		
		elseif args.button == Input.MOUSE_BUTTON_MIDDLE then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "settingModView_" then 
						if args.clickAreaTable.ownTable.view ~= nil and box.ownTable.view[args.clickAreaTable.ownTable.view] ~= nil and (args.clickAreaTable.ownTable.view == "adRemaining" or args.clickAreaTable.ownTable.view == "cpRemaining") then	--only boolean (view ad/cp Remaining Waypoints)						
							box.ownTable.view[args.clickAreaTable.ownTable.view][4] = not box.ownTable.view[args.clickAreaTable.ownTable.view][4];							
							if box.ownTable.view[args.clickAreaTable.ownTable.view][1] > 1 then
								local typ = "AD";
								if args.clickAreaTable.ownTable.view == "cpRemaining" then typ = "CP";end;
								local state = g_i18n:getText("ui_on");
								if not box.ownTable.view[args.clickAreaTable.ownTable.view][4] then state = g_i18n:getText("ui_off");end;
								g_currentMission.hlHudSystem.showInfoBox( {typ.. " Waypoints ".. state, 1500, g_currentMission.hlUtils.getColor("ls25active", true)} );
							end;
							g_currentMission.hlHudSystem.isSave = false --global
						end;
					end;	
				end;
			end;
		end;
	end;
end;

function VehicleInspector_Display_MouseKeyEventsBox.removeAttachedIconTimer(timer)
	if timer ~= nil and timer.ownTable ~= nil then
		local box = timer.ownTable[1];
		box.ownTable.view.attachedIcon[1] = 1;
		g_currentMission.hlUtils.removeTimer("viAttachedIconTimer_");
	end;
end;

function VehicleInspector_Display_MouseKeyEventsBox.onClickCamBox(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
		
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_Box");
		if box ~= nil then
			local data = g_currentMission.hlHudSystem.camera.object; 
			if args.button == Input.MOUSE_BUTTON_LEFT then				
				if args.clickAreaTable.whereClick == "cameraOverlay_" then
					if box.ownTable.camera.rotX[1]+5 > box.ownTable.camera.rotX[3] then
						return;
					else
						box.ownTable.camera.rotX[1] = box.ownTable.camera.rotX[1]+5;
						data.camRotation[1] = box.ownTable.camera.rotX[1];
						g_currentMission.hlHudSystem.isSave = false --global
						g_currentMission:showBlinkingWarning("rotX: ".. tostring(box.ownTable.camera.rotX[1]).. "/Default 85", 2000);
					end;
				end;
				--if data.camRotation[1] > 350 then return;end;
				--g_currentMission.hlHudSystem.camera.object.camRotation[1] = g_currentMission.hlHudSystem.camera.object.camRotation[1]+5;
				--print("click camBox left/rotation: ".. tostring(g_currentMission.hlHudSystem.camera.object.camRotation[1]))
			elseif args.button == Input.MOUSE_BUTTON_RIGHT then
				if args.clickAreaTable.whereClick == "cameraOverlay_" then
					if box.ownTable.camera.rotX[1]-5 < box.ownTable.camera.rotX[2] then
						return;
					else
						box.ownTable.camera.rotX[1] = box.ownTable.camera.rotX[1]-5;
						data.camRotation[1] = box.ownTable.camera.rotX[1];
						g_currentMission.hlHudSystem.isSave = false --global
						g_currentMission:showBlinkingWarning("rotX: ".. tostring(box.ownTable.camera.rotX[1]).. "/Default 85", 2000);
					end;				
				end;
				--if data.camRotation[1] < 5 then return;end;
				--g_currentMission.hlHudSystem.camera.object.camRotation[1] = g_currentMission.hlHudSystem.camera.object.camRotation[1]-5;
				--print("click camBox right/rotation: ".. tostring(g_currentMission.hlHudSystem.camera.object.camRotation[1]))
			elseif args.button == Input.MOUSE_BUTTON_WHEEL_DOWN then
				if args.clickAreaTable.whereClick == "cameraOverlay_" then
					if box.ownTable.camera.zoom[1]+1 > box.ownTable.camera.zoom[3] then
						return;
					else
						box.ownTable.camera.zoom[1] = box.ownTable.camera.zoom[1]+1;
						data.camZoom = box.ownTable.camera.zoom[1];
						g_currentMission.hlHudSystem.isSave = false --global
					end;
				end;
			elseif args.button == Input.MOUSE_BUTTON_WHEEL_UP then
				if args.clickAreaTable.whereClick == "cameraOverlay_" then
					if box.ownTable.camera.zoom[1]-1 < box.ownTable.camera.zoom[2] then
						return;
					else
						box.ownTable.camera.zoom[1] = box.ownTable.camera.zoom[1]-1;
						data.camZoom = box.ownTable.camera.zoom[1];
						g_currentMission.hlHudSystem.isSave = false --global
					end;
				end;
			end;
		end;
	end;
end;

