VehicleInspector_Display_MouseKeyEventsAllInBox = {};

function VehicleInspector_Display_MouseKeyEventsAllInBox.onClick(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "settingIcon_" then
					if box.isSetting then						
						box.ownTable.lastStateExtraLine=box.viewExtraLine;
						box.viewExtraLine = true;						
					else 
						box.viewExtraLine = box.ownTable.lastStateExtraLine;						
					end;
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "menueClose_" then
					box.isSetting = false;box.viewExtraLine = box.ownTable.lastStateExtraLine;					
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "viewExtraLine_" then
					box.ownTable.lastStateExtraLine=box.viewExtraLine;
				end;
			end;
		end;
	end;
end;

function VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
		
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "settingTyp_" then
						if box.settingTyp >= box.ownTable.maxSettingTyp then 
							box.settingTyp = 1;							
						else 
							box.settingTyp = box.settingTyp+1;							
						end;
						box:setUpdateState(true);
					elseif args.clickAreaTable.whereClick == "settingGuiBox_" and box.guiMenu ~= nil and box.guiMenu.setShow ~= nil then
						box.guiMenu:setShow(not box.guiMenu.show);
						if box.guiMenu.show then box.isSetting = false;end;
						return;					
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local maxDistance = box.screen.pixelH*8;
						if box.screen.size.distance.textLine+(box.screen.pixelH/2) <= maxDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine+(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;											
					elseif args.clickAreaTable.whereClick == "settingModView_" then
						if args.clickAreaTable.ownTable.view ~= nil and box.ownTable.view[args.clickAreaTable.ownTable.view] ~= nil then
							if box.ownTable.view[args.clickAreaTable.ownTable.view][1]+1 > box.ownTable.view[args.clickAreaTable.ownTable.view][3] then
								box.ownTable.view[args.clickAreaTable.ownTable.view][1] = box.ownTable.view[args.clickAreaTable.ownTable.view][2];
							else
								box.ownTable.view[args.clickAreaTable.ownTable.view][1] = box.ownTable.view[args.clickAreaTable.ownTable.view][1]+1;								
							end;
							g_currentMission.hlHudSystem.isSave = false; --global
						end;	
					end;					
				end;
				if args.clickAreaTable.whereClick == "vehicleLine_" then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then VehicleInspector_DisplaySetGet:clickVehicleLine("left", args.clickAreaTable.ownTable.vehicleNode);end;				
				elseif args.clickAreaTable.whereClick == "typIconLineBounds_" then
					if args.clickAreaTable.ownTable[1] ~= nil then
						VehicleInspector_DisplaySetGet:setBounds(box, args.clickAreaTable.ownTable[1] == "left", args.clickAreaTable.ownTable[1] == "right");
					end;
				elseif args.clickAreaTable.whereClick == "typIcon_" then
					if args.clickAreaTable.ownTable.typ ~= nil then						
						local viewTyp = box.ownTable.viewTyp[box.ownTable.typIcon[args.clickAreaTable.ownTable.typ].name];
						if viewTyp[1]+1 > viewTyp[3] then
							viewTyp[1] = viewTyp[2];
						else
							viewTyp[1] = viewTyp[1]+1;
						end;
						g_currentMission.hlHudSystem.isSave = false --global											
					end;
				elseif args.clickAreaTable.whereClick == "typJoin_" then
					if args.clickAreaTable.ownTable.typ ~= nil then
						local typName = box.ownTable.typIcon[args.clickAreaTable.ownTable.typ].name;
						VehicleInspector_DisplaySetGet:joinVehicle(1, typName, false, "all")
					end;
				elseif args.clickAreaTable.whereClick == "statisticIcon_" then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then
						local hasPlayerFarmId = g_currentMission.hlUtils.hasPlayerFarmId();
						if hasPlayerFarmId then 
							VehicleInspector_DisplaySetGet:showInGameMenuFrame("ingameMenuGameStats", "SUB_CATEGORY.VEHICLE_OVERVIEW", args.clickAreaTable.ownTable.vehicleNode, args.clickAreaTable.ownTable.attached, false, 0, true, args.clickAreaTable.ownTable.controlled);
						end;
					end;
				end;
			end;		
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "settingTyp_" then
						if box.settingTyp <= 1 then 
							box.settingTyp = box.ownTable.maxSettingTyp;							
						else 
							box.settingTyp = box.settingTyp-1;							
						end;
						box:setUpdateState(true);
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local minDistance = box.screen.pixelH*1;
						if box.screen.size.distance.textLine-(box.screen.pixelH/2) >= minDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine-(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;															
					end;				
				end;
				if args.clickAreaTable.whereClick == "vehicleLine_" then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then VehicleInspector_DisplaySetGet:clickVehicleLine("right", args.clickAreaTable.ownTable.vehicleNode);end;
				elseif args.clickAreaTable.whereClick == "typIcon_" then --all on/off
					if args.clickAreaTable.ownTable.typ ~= nil then						
						local viewTyp = box.ownTable.viewTyp[box.ownTable.typIcon[args.clickAreaTable.ownTable.typ].name];						
						if viewTyp[1] == 1 then --all on
							VehicleInspector_DisplaySetGet:setAllViewTypIcons(box, 2);
						else
							VehicleInspector_DisplaySetGet:setAllViewTypIcons(box, 1);
						end;						
						g_currentMission.hlHudSystem.isSave = false --global											
					end;
				elseif args.clickAreaTable.whereClick == "typJoin_" then 
					if args.clickAreaTable.ownTable.typ ~= nil then
						local typName = box.ownTable.typIcon[args.clickAreaTable.ownTable.typ].name;
						VehicleInspector_DisplaySetGet:joinVehicle(-1, typName, false, "all")
					end;
				elseif args.clickAreaTable.whereClick == "statisticIcon_" and VehicleInspector.values.hiddenFunctions > 1 then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then
						local hasPlayerFarmId = g_currentMission.hlUtils.hasPlayerFarmId();
						if hasPlayerFarmId then
							if not args.clickAreaTable.ownTable.controlled[2] and not args.clickAreaTable.ownTable.controlled[3] then
								VehicleInspector_DisplaySetGet:sellFrameVehicle(args.clickAreaTable.ownTable.vehicleNode, args.clickAreaTable.ownTable.attached);
							end;
						end;
					end;					
				end;
			end;		
		elseif args.button == Input.MOUSE_BUTTON_MIDDLE then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then
					if args.clickAreaTable.whereClick == "typIcon_" then --has typ vehicles on/off
						if args.clickAreaTable.ownTable.typ ~= nil then						
							local viewTyp = box.ownTable.viewTyp[box.ownTable.typIcon[args.clickAreaTable.ownTable.typ].name];						
							if viewTyp[1] == 1 then --typ vehicle on
								VehicleInspector_DisplaySetGet:setTotalViewTypIcons(box, true, viewTyp[4].total);
							else
								VehicleInspector_DisplaySetGet:setTotalViewTypIcons(box, false, viewTyp[4].total);
							end;						
							g_currentMission.hlHudSystem.isSave = false --global											
						end;
					end;	
				end;
				if args.clickAreaTable.whereClick == "statisticIcon_" and VehicleInspector.values.hiddenFunctions > 1 then
					if args.clickAreaTable.ownTable.vehicleNode ~= nil then
						local hasPlayerFarmId = g_currentMission.hlUtils.hasPlayerFarmId();
						if hasPlayerFarmId then 
							if not args.clickAreaTable.ownTable.controlled[2] and not args.clickAreaTable.ownTable.controlled[3] then
								VehicleInspector_DisplaySetGet:sellFrameVehicleWorkshop(args.clickAreaTable.ownTable.vehicleNode);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;