VehicleInspector_Display_DrawBox = {};

function VehicleInspector_Display_DrawBox.canDrawBox(args) --auto position
	---box.visibleDraw for Hud Icon color state/other Mods !!---
	if args == nil or type(args) ~= "table" or args.typPos == nil then return true;end;
	local box = g_currentMission.hlHudSystem.box[args.typPos];	
	if box == nil then return true;end;	
	if not box.show then box.visibleDraw = false;return false;end;	
	
	local openVehicleDetails, lengthData = VehicleInspector_DisplaySetGet:setViewVehiclesBox(box); --for view Box load 1x
	box.ownTable.openVehicleDetails = openVehicleDetails;box.ownTable.lengthData = lengthData; --for view Box load 1x
		
	--set first start temporär iconWidth, is box data not generate--	
	local lineHeight = box.ownTable.lineHeight;
	if lineHeight == nil then		
		local distance = box:getSize( {"distance"} ); 
		local difW = distance.textWidth --default width
		local difH = distance.textHeight; --default height	
		local size = box.screen.size.zoomOutIn.text[1];
		lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;		
		box.ownTable.iconWidth, box.ownTable.iconHeight = box:getOptiWidthHeight( {typ="icon", height=lineHeight-distance.textLine-(difH), width=box:getWidth()-(difW*2)} );
	end;
	--set first start temporär iconWidth, is box data not generate--
	
	--autoHeight--	
	if box.ownTable.autoDimension.height[1] > 1 then		
		if VehicleInspector_DisplaySetGet.viewVehiclesBox == nil or #VehicleInspector_DisplaySetGet.viewVehiclesBox == 0 or lineHeight == 0 or lineHeight == nil then 
			local isHeight = box:getHeight();
			if isHeight > box.screen.size.background[4] then
				box:setWidthHeight(nil, box.screen.size.background[4], true); --default min Height			
			elseif isHeight < box.screen.size.background[4] then
				box:setWidthHeight(nil, box.screen.size.background[4], true); --default min Height	
			end;					
		else
			local length = #VehicleInspector_DisplaySetGet.viewVehiclesBox+1;
			if box.ownTable.autoDimension.height[1] == 3 then --max line by Player
				if length > box.ownTable.autoDimension.maxHeight[1] then length = box.ownTable.autoDimension.maxHeight[1];end;
			end;
			if box.viewExtraLine then length = length+1;end;
			local maxHeight = viSetGet:getAvailableHeight(box, lineHeight);			
			if length > maxHeight then length = maxHeight;end;
			local isHeight = box:getHeight();
			if isHeight > lineHeight*length then
				box:setWidthHeight(nil, lineHeight*length, true); 
			elseif isHeight < lineHeight*length then
				box:setWidthHeight(nil, lineHeight*length, true); 
			end;
		end;	
	end;	
	--autoHeight--
	
	if VehicleInspector_DisplaySetGet.viewVehiclesBox == nil or (box.ownTable.view.emptyVehicleBox[1] == 1 and #VehicleInspector_DisplaySetGet.viewVehiclesBox == 0) then box.visibleDraw = false;return false;end;	
	
	if box.ownTable.showBox.helpMenu[1] == 1 and box.ownTable.showBox.ingameMap[1] == 1 then box.visibleDraw = true;return true;end;
	local x, y, w, h = box:getScreen();	
	local fixX, fixY = 0.1, 0.99;
	--prio helpMenu--
	if box.ownTable.showBox.helpMenu[1] > 1 then		
		local helpMenu = g_currentMission.hlUtils.getHelpMenuData();
		if helpMenu == nil or helpMenu.posY == nil then box.visibleDraw = false;return false;end; --! error !
		local f1PosX, f1PosY, f1Width, f1Height = helpMenu.posX, helpMenu.posY, helpMenu.lineWidth, helpMenu.totalHeight;
		f1PosY = f1PosY - f1Height; 
		
		local isPF = helpMenu.isPF; --precision Farming DLC
		
		--local isHelpMenu, f1PosX, f1PosY, f1Width, f1Height = viSetGet:getHelpMenueData(box.ownTable);
		
		if helpMenu.isVisible and (box.ownTable.showBox.helpMenu[1] == 2 or box.ownTable.showBox.helpMenu[1] == 4) then 
			if not box.ownTable.showBox.helpMenu[4] then
				if helpMenu.hasEventElement then f1PosY = f1PosY - helpMenu.lineComboHeight;end;
				if helpMenu.offsetY > 0 then f1PosY = f1PosY + helpMenue.offsetY;end;				
				box.screen:setPosition(f1PosX, f1PosY-h, "box"); --helpMenu On/under it--
				box.visibleDraw = true;
				return true;
			elseif box.ownTable.showBox.helpMenu[4] then 
				f1Width = f1Width + (helpMenu.textOffsetX*0.5);
				local difWidth = (box.ownTable.iconWidth*1.3)/2;
				if box.ownTable.view.vehicleName[1] == 1 then f1Width = f1Width + difWidth;end;
				box.screen:setPosition(f1PosX+f1Width, f1PosY+f1Height-h, "box"); --helpMenu On/right--
				box.visibleDraw = true;
				return true;
			end;
		elseif not helpMenu.isVisible and (box.ownTable.showBox.helpMenu[1] == 3 or box.ownTable.showBox.helpMenu[1] == 4) then	
			local f1cPosY = helpMenu.posY;			
			local multipleLine = 1; --precision Farming DLC
			local pfHeight = 0;
			if helpMenu.hasVehicleSchema and g_currentMission.hlUtils.isControlledVehicle() then 
				if isPF then 
					if helpMenu.helpExtensionHeight > 0 then pfHeight = helpMenu.helpExtensionHeight;end;
					multipleLine = 2;				
				end;				
				f1cPosY = f1cPosY - (helpMenu.lineHeight*multipleLine) - pfHeight - helpMenu.lineOffsetY;
			end;			
			box.screen:setPosition(f1PosX, f1cPosY-h, "box");
			box.visibleDraw = true;
			return true;
		end;		
	elseif box.ownTable.showBox.ingameMap[1] > 1 then		
		local isIngameMap, mPosX, mPosY, mWidth, mHeight = viSetGet:getIngameMapData(box.ownTable);
		if isIngameMap == nil then return false;end;
		if isIngameMap and (box.ownTable.showBox.ingameMap[1] == 2 or box.ownTable.showBox.ingameMap[1] == 4) then 
			if not box.ownTable.showBox.ingameMap[4] then
				box.screen:setPosition(mPosX, mPosY, "box"); --inGameMap On/about it--
				box.visibleDraw = true;
				return true;
			elseif box.ownTable.showBox.ingameMap[4] then				
				box.screen:setPosition(mPosX+mWidth, mPosY-h, "box"); --inGameMap On/right--
				box.visibleDraw = true;
				return true;
			end;			
		elseif not isIngameMap and (box.ownTable.showBox.ingameMap[1] == 3 or box.ownTable.showBox.ingameMap[1] == 4) then			
			box.screen:setPosition(mPosX, mPosY, "box");
			box.visibleDraw = true;
			return true;			
		end;
	end;
	box.visibleDraw = false;
	return false;	
end;

function VehicleInspector_Display_DrawBox.setBox(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local box = g_currentMission.hlHudSystem.box[args.typPos];
	if box == nil then return;end;
	
	box.visibleDraw = true; --for Hud Icon color state !!
	
	--locked/unlocked dragDrop--
	if box.ownTable.showBox.helpMenu[1] == 1 and box.ownTable.showBox.ingameMap[1] == 1 then box.canDragDrop = true;box.canDragDropWidth = true;if box.ownTable.autoDimension.height[1] > 1 then box.canDragDropHeight = false;else box.canDragDropHeight = true;end;end;
	if box.ownTable.showBox.helpMenu[1] > 1 then
		box.canDragDrop = false;
		box.canDragDropWidth = true;
		if box.ownTable.autoDimension.height[1] > 1 then box.canDragDropHeight = false;else box.canDragDropHeight = true;end;
	elseif box.ownTable.showBox.ingameMap[1] > 1 then
		box.canDragDrop = false;
		box.canDragDropWidth = true;
		if box.ownTable.showBox.ingameMap[4] then
			local inGameMapState = g_currentMission.hlUtils.getIngameMapState();
			if inGameMapState == 1 then
				box.canDragDropHeight = false;				
			else
				if box.ownTable.autoDimension.height[1] > 1 then box.canDragDropHeight = false;else box.canDragDropHeight = true;end;							
			end;
		else
			if box.ownTable.autoDimension.height[1] > 1 then box.canDragDropHeight = false;else box.canDragDropHeight = true;end;			
		end;
	end;
	--locked/unlocked dragDrop--
	
	--on/off bounds info--
	if box.ownTable.autoDimension.height[1] == 2 then box.screen.canBounds.setInfo = false;else box.screen.canBounds.setInfo = true;end;
	--on/off bounds info--
	local inArea = args.inArea;
	local boxNumber = args.typPos;
	
	local x, y, w, h = box:getScreen();	
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = box:getSize( {"distance"} ); 
	local difW = distance.textWidth --default width
	local difH = distance.textHeight; --default height	
	local size = box.screen.size.zoomOutIn.text[1];
	local optiSize = size;
	local difSize = 0.0015;	
	
	local overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
	local overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];	
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local overlayVehiclesGroup = nil;
	local overlayVehiclesByName = nil;	
	if g_currentMission.hlUtils.overlays["LS_Vehicles"] ~= nil then
		overlayVehiclesGroup = g_currentMission.hlUtils.overlays["LS_Vehicles"]["vehicles"];
		overlayVehiclesByName = g_currentMission.hlUtils.overlays.byName["LS_Vehicles"]["vehicles"];		
	end;
	local overlay = nil;
	local bgRound = overlayDefaultGroup[overlayDefaultByName["bgRound"]];
	local bgFront = overlayDefaultGroup[overlayDefaultByName["bgFront"]];
	local bgMiddle = overlayDefaultGroup[overlayDefaultByName["bgMiddle"]];
	local bgBack = overlayDefaultGroup[overlayDefaultByName["bgBack"]];
	local bgFrontNoBox = overlayDefaultGroup[overlayDefaultByName["bgFrontNoBox"]];
	local bgMiddleNoBox = overlayDefaultGroup[overlayDefaultByName["bgMiddleNoBox"]];
	local bgBackNoBox = overlayDefaultGroup[overlayDefaultByName["bgBackNoBox"]];
	local tempOverlay = nil;
	local fillTypeOverlay = nil;
	local vehicleOverlay = nil;
	
	function needsUpdate()		
		if box.needsUpdate or box.ownTable.lineHeight == nil then			
			box.ownTable.lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;
			box.ownTable.iconWidth, box.ownTable.iconHeight = box:getOptiWidthHeight( {typ="icon", height=box.ownTable.lineHeight-distance.textLine-(difH), width=w-(difW*2)} );
			box.ownTable.optiSize1Int = g_currentMission.hlUtils.optiWidthSize((box.ownTable.iconWidth*1.3)*0.94, "9", size);
			box.ownTable.optiSize2Int = g_currentMission.hlUtils.optiWidthSize((box.ownTable.iconWidth*1.3)*0.94, "99", size);
			box.ownTable.optiSize3Int = g_currentMission.hlUtils.optiWidthSize((box.ownTable.iconWidth*1.3)*0.94, "999", size);			
			--box.ownTable.optiSizePercent = g_currentMission.hlUtils.optiWidthSize((box.ownTable.iconWidth*1.3)*0.94, "100%", size);
			----
			local noBoxString = "Äg";
			box.ownTable.optiSizeNoBox = g_currentMission.hlUtils.optiHeightSize((box.ownTable.iconHeight*0.94), noBoxString, size-difSize);
			----
			local fillDataTxt = "999.999(100%)";
			local iconTxtWidth = getTextWidth(size-difSize, utf8Substr(fillDataTxt, 0));
			box.ownTable.maxIconsFillDataL = g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, box.ownTable.iconWidth*1.3);
			if box.ownTable.maxIconsFillDataL < 2 then box.ownTable.maxIconsFillDataL = 2;end;
			box.ownTable.optiSizeFillDataL = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsFillDataL, fillDataTxt, size-difSize);
			box.ownTable.optiSizeFillDataL = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsFillDataL, fillDataTxt, box.ownTable.optiSizeFillDataL);
			----			
			fillDataTxt = "999.999";
			iconTxtWidth = getTextWidth(size-difSize, utf8Substr(fillDataTxt, 0));
			box.ownTable.maxIconsFillData = g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, box.ownTable.iconWidth*1.3);
			if box.ownTable.maxIconsFillData < 2 then box.ownTable.maxIconsFillDataL = 2;end;
			box.ownTable.optiSizeFillData = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsFillData, fillDataTxt, size-difSize);
			box.ownTable.optiSizeFillData = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsFillData, fillDataTxt, box.ownTable.optiSizeFillData);
			----			
			local remainingTxt = "999".. box.ownTable.viewText.remainingTimeSeparator.. "99".. box.ownTable.viewText.remainingWaypointsSeparator.. "99";
			iconTxtWidth = getTextWidth(size, utf8Substr(remainingTxt, 0));
			box.ownTable.maxIconsRemainingTimeLarge = g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, box.ownTable.iconWidth);
			if box.ownTable.maxIconsRemainingTimeLarge < 2 then box.ownTable.maxIconsRemainingTimeLarge = 2;end;			
			box.ownTable.optiSizeRemainingTimeLarge = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsRemainingTimeLarge, remainingTxt, size-difSize);
			----
			remainingTxt = "999".. box.ownTable.viewText.remainingTimeSeparator.. "99";
			iconTxtWidth = getTextWidth(size, utf8Substr(remainingTxt, 0));
			box.ownTable.maxIconsRemainingTime = g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, box.ownTable.iconWidth);
			if box.ownTable.maxIconsRemainingTime < 2 then box.ownTable.maxIconsRemainingTime = 2;end;
			box.ownTable.optiSizeRemainingTime = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsRemainingTime, remainingTxt, size-difSize);
			----			
			remainingTxt = box.ownTable.viewText.remainingWaypointsSeparator.. "9999".. box.ownTable.viewText.remainingWaypoints;
			iconTxtWidth = getTextWidth(size, utf8Substr(remainingTxt, 0));
			box.ownTable.maxIconsRemainingWaypoints= g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, box.ownTable.iconWidth);
			if box.ownTable.maxIconsRemainingWaypoints < 2 then box.ownTable.maxIconsRemainingWaypoints = 2;end;
			box.ownTable.optiSizeRemainingWaypoints = g_currentMission.hlUtils.optiWidthSize(box.ownTable.maxIconsRemainingWaypoints, remainingTxt, size-difSize);			
			----			
		end;		
		box.needsUpdate = false;
	end;	
	needsUpdate();
	
	if not g_currentMission.hlUtils.isMouseCursor then box.isSetting = false;end;
		
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local iconColor = nil;
	local iconWidth = box.ownTable.iconWidth;
	local iconHeight = box.ownTable.iconHeight;
	local iconWidthS = iconWidth/1.3;
	local iconHeightS = iconHeight/1.3;
	local iconWidthBV = iconWidth*1.15;
	local iconHeightBV = iconHeight*1.15;
	local iconWidthB = iconWidth*1.3;
	local iconHeightB = iconHeight*1.3;
	local iconWidthT = iconWidth*1.5;
	local iconHeightT = iconHeight*1.5;
	local iconWidthV = iconWidth*1.8;
	local iconHeightV = iconHeight*1.8;
	----
	local noBoxNextLeftPosX = x-difW;
	local noBoxNextRightPosX = x+w+difW;
	local noBoxLastLeftPosX = noBoxNextLeftPosX; --no Front or Back Icon
	local noBoxLastRightPosX = noBoxNextRightPosX; --no Front or Back Icon
	----
	local nextPosX = x+difW;
	local nextPosY = y;		
	local nextIconPosX = x+difW;
	local nextLeftPosX = nextPosX;
	local nextRightPosX = x+w-difW;
	nextPosY = nextPosY+(h)-(box.ownTable.lineHeight)-difH;
	
	local openVehicleDetails, lengthData = false,{attachedTotal=0};
	if (box.ownTable.showBox.helpMenu[1] == 1 and box.ownTable.showBox.ingameMap[1] == 1) or VehicleInspector_DisplaySetGet.viewVehiclesBox == nil then	
		openVehicleDetails, lengthData = VehicleInspector_DisplaySetGet:setViewVehiclesBox(box);
	else
		openVehicleDetails = box.ownTable.openVehicleDetails;lengthData = box.ownTable.lengthData;
	end;
	
	if VehicleInspector_DisplaySetGet.viewVehiclesBox == nil then return;end;
	box.screen.bounds[4] = #VehicleInspector_DisplaySetGet.viewVehiclesBox+1; -- +1 for Imaginäre Line wenn untergruppe an ist (viewVehicleDetails etc.)
		
	if box.viewExtraLine then box.screen.bounds[4] = box.screen.bounds[4]+1;end;
	
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if box.isSetting and box.settingTyp == 1 and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			box:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	
	if box.screen.bounds[1] > 0 then
		local camBox = g_currentMission.hlHudSystem.hlBox:getData("hlHudSystem_CameraBox");		
		local data = g_currentMission.hlHudSystem.camera.object; 
		local isSwitchTimerTwo = g_currentMission.hlUtils.getIsSwitchTimer("vi_switchTwo");
		local isSwitchTimerWarning = g_currentMission.hlUtils.getIsSwitchTimer("vi_switchWarnings");		
		------
		local canNextView = true;
		local lineWidth = w-(difW*2);
		------
		--inIconArea Text--
		function getInIconArea(posX, posY, width, height)
			if not inArea then return false;end;
			overlay = box.overlays.bgLine; --hidden overlay
			if overlay ~= nil then
				g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width or lineWidth, height or box.ownTable.lineHeight);
				return overlay.mouseInArea();
			end;
			return false;
		end;
		--inIconArea Text--
		--warningLine--
		function setWarningLineIcon(posY)
			overlay = overlayDefaultGroup[overlayDefaultByName["right"]];
			g_currentMission.hlUtils.setOverlay(overlay, x+w-((iconWidth/1.5/2)), posY or nextPosY-0.003, iconWidth/1.5, iconHeight/1.5);
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
			local inIconArea = overlay.mouseInArea();			
			if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_viewNotAllIcons"), "Box"), 0);end; 
			if (g_currentMission.hlUtils.runsTimer("1sec", true) and g_currentMission.hlUtils.isMouseCursor) or (not g_currentMission.hlUtils.isMouseCursor) then
				overlay:render();
			end;
		end;
		--warningLine--
		--viewExtraLineSetting--
		function viewExtraLineSetting()
			if nextPosY < y then return;end;			
			local setWarningLine = false;
			local inIconArea = false;
		
			--if not setWarningLine and nextIconPosX+iconWidth < x+w then --settingTyp switch
			--	overlay = overlayDefaultGroup[overlayDefaultByName["switch"]];
			--	if overlay ~= nil then
			--		g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
			--		inIconArea = false;
			--		if inArea then inIconArea = overlay.mouseInArea();end;
			--		if inIconArea then
			--			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
			--		else
			--			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));					
			--		end;
			--		overlay:render();
			--		if box.isHelp and inIconArea then setInfoHelpText(string.format(g_i18n:getText("box_settingSwitch"), tostring(box.settingTyp)), 0);end;					
			--		if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleInspector_Display_Box", typPos=boxNumber, whereClick="settingTyp_", ownTable={}} );end;
			--		nextIconPosX = nextIconPosX+iconWidth+difW;
			--	end;
			--else
			--	setWarningLine = true;
			--end;
			--if box.settingTyp > 1 then				
			--	if not setWarningLine and nextIconPosX+iconWidth < x+w then
			--		local settingTyp = {[1]="",[2]="view"};
			--		overlay = overlayDefaultGroup[overlayDefaultByName[settingTyp[box.settingTyp]]];
			--		if overlay ~= nil then
			--			g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
			--			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.selectArea, true));
			--			overlay:render();
			--			nextIconPosX = nextIconPosX+iconWidth+difW;
			--		end;						
			--	else
			--		setWarningLine = true;
			--	end;
			--end;
			if box.settingTyp == 1 then
				if nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["settingExtension"]];					
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
						elseif box.guiMenu.show then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
						else
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						end;
						overlay:render();
						if inIconArea and box.isHelp then setInfoHelpText(g_i18n:getText("box_showGuiBox"));end; 				
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleInspector_Display_Box", typPos=boxNumber, whereClick="settingGuiBox_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;
				else
					setWarningLine = true;
				end;
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUpDown"]];
					tempOverlay = box.overlays.bgLine;
					if overlay ~= nil and tempOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));end;
						overlay:render();
						if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_lineDistance"), string.format("%1.2f", box.screen.size.distance.textLine/box.screen.pixelH)));end;					
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleInspector_Display_Box", typPos=boxNumber, whereClick="settingLineDistance_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;
				else
					setWarningLine = true;
				end;				
				if not setWarningLine and nextIconPosX+(iconWidthB*3) < x+w then
					local sizeText = tostring(" |S:"..string.format("%1.1f", size*1000));
					setTextColor(1, 1, 1, 1);
					renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sizeText));
					local textWidth = getTextWidth(size, utf8Substr(sizeText, 0));
					if box.isHelp and inArea and getInIconArea(nextIconPosX+difW, nil, textWidth) then setInfoHelpText(g_i18n:getText("box_settingSize"));end;
					nextIconPosX = nextIconPosX+textWidth+difW;
				else
					setWarningLine = true;
				end;															
			end;
			
			if setWarningLine then
				setWarningLineIcon();
			end;			
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLineSetting--
		--viewExtraLine--
		function viewExtraLine()
			if nextPosY < y then return;end;			
			local onOffTxt = g_i18n:getText("ui_on").. "/".. g_i18n:getText("ui_off");
			local setWarningLine = false;
			local inIconArea = false;
			function setOverlay(whereClick, ownTable, color, setPosX, otherWidth, otherHeight)
				if color == nil then color = box.overlays.color.notActive;end;
				g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);
				inIconArea = false;
				if inArea then inIconArea = overlay.mouseInArea();end;
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
				overlay:render();
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleInspector_Display_Box", typPos=boxNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
				if setPosX == nil or setPosX then nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;end;
				iconColor = nil;				
			end;
			--if not setWarningLine and nextIconPosX+iconWidth < x+w then
			--	overlay = overlayDefaultGroup[overlayDefaultByName["controlled"]];
			--	if overlay ~= nil then
			--		if box.ownTable.showVehicles.controlled[1] > 1 then iconColor = box.overlays.color.on;end;					
			--		setOverlay("showVehicles_", {"controlled"}, iconColor);					
			--		if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_showVehicles"), 0);end;
			--	end;					
			--else
			--	setWarningLine = true;
			--end;
			if VehicleInspector.otherMods.autoDrive then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["adRemaining"]];
					local waypointOverlay = overlayDefaultGroup[overlayDefaultByName["waypoints"]];
					local timeOverlay = overlayDefaultGroup[overlayDefaultByName["remainingTime"]];
					if overlay ~= nil and waypointOverlay ~= nil and timeOverlay ~= nil then						
						setOverlay("settingModView_", {view="adRemaining"}, box.overlays.color.text);	
						local acceptsMouse = {"left","right"};
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_viewAdRemaining").. "\n".. g_i18n:getText("performance_attention"), 0);end;						
						g_currentMission.hlUtils.setOverlay(timeOverlay, overlay.x, nextPosY, iconWidth, iconHeight);
						g_currentMission.hlUtils.setOverlay(waypointOverlay, overlay.x, nextPosY, iconWidth, iconHeight);
						if box.ownTable.view["adRemaining"][1] == 1 then 
							g_currentMission.hlUtils.setBackgroundColor(timeOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						else
							g_currentMission.hlUtils.setBackgroundColor(timeOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
							if box.ownTable.view["adRemaining"][4] then g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));else g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));end;
							acceptsMouse = {"left","middle","right"};
						end;						
						if not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse=acceptsMouse} );end;
						timeOverlay:render();
						waypointOverlay:render();						
					end;
				else
					setWarningLine = true;
				end;
			end;
			if VehicleInspector.otherMods.coursePlay then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["cpRemaining"]];
					local waypointOverlay = overlayDefaultGroup[overlayDefaultByName["waypoints"]];					
					local timeOverlay = overlayDefaultGroup[overlayDefaultByName["remainingTime"]];
					if overlay ~= nil and waypointOverlay ~= nil and timeOverlay ~= nil then						
						setOverlay("settingModView_", {view="cpRemaining"}, box.overlays.color.text);	
						local acceptsMouse = {"left","right"};
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_viewCpRemaining").. "\n".. g_i18n:getText("performance_attention"), 0);end;						
						g_currentMission.hlUtils.setOverlay(timeOverlay, overlay.x, nextPosY, iconWidth, iconHeight);
						g_currentMission.hlUtils.setOverlay(waypointOverlay, overlay.x, nextPosY, iconWidth, iconHeight);
						if box.ownTable.view["cpRemaining"][1] == 1 then 
							g_currentMission.hlUtils.setBackgroundColor(timeOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));							
						else
							g_currentMission.hlUtils.setBackgroundColor(timeOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
							if box.ownTable.view["cpRemaining"][4] then g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));else g_currentMission.hlUtils.setBackgroundColor(waypointOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));end;
							acceptsMouse = {"left","middle","right"};
						end;
						if not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse=acceptsMouse} );end;
						timeOverlay:render();
						waypointOverlay:render();						
					end;
				else
					setWarningLine = true;
				end;			
			end;
			if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["tractorattached"]];				
				if overlay ~= nil then					
					if box.ownTable.view.attachedIcon[1] > 1 then iconColor = box.overlays.color.warning;elseif box.ownTable.view.attachedIcon[4] then iconColor = box.overlays.color.text;end;									
					setOverlay("settingModView_", {view="attachedIcon"}, iconColor, nil, iconWidthBV, iconHeightBV);
					if box.isHelp and inIconArea then setInfoHelpText(string.format(g_i18n:getText("box_viewAttachedIcon"), tostring(box.ownTable.view.attachedIcon[5])), 0);end;
					if not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","right"}} );end;
				end;
			else
				setWarningLine = true;
			end;
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["contractor"]];
					if overlay ~= nil then
						local stateText = g_i18n:getText("defaultFarmName");
						if box.ownTable.view.contractor[1] == 2 then stateText = stateText.. "/".. g_i18n:getText("contractorFarm");iconColor = box.overlays.color.on;elseif box.ownTable.view.contractor[1] == 3 then stateText = g_i18n:getText("contractorFarm");iconColor = box.overlays.color.warning;end;									
						setOverlay("settingModView_", {view="contractor"}, iconColor);
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("ui_mapHotspotFilter_vehicles").. ": ".. stateText);end;					
					end;
				else
					setWarningLine = true;
				end;
			end;			
			if box.isHelp then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["infos"]];
					if overlay ~= nil then					
						setOverlay(nil, nil, box.overlays.color.title); 				
						if inIconArea then setInfoHelpText(g_i18n:getText("box_clickInfos"), 0);end;
					end;					
				else
					setWarningLine = true;
				end;
			end;
			if setWarningLine then
				setWarningLineIcon();
			end;
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLine--
		if box.viewExtraLine and not box.isSetting then viewExtraLine();elseif box.viewExtraLine and box.isSetting then viewExtraLineSetting();end;
		
		--box lines--
		local isColorByControlled = false;
		local color = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);		
		local textColor = nil;
		local viewDetailsColor = g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true);
		local bounds1 = box.screen.bounds[1];
		local bounds2 = box.screen.bounds[2];
		local lastPosX = 0;
		local setWarningCanNotNextView = false;
		for t=bounds1, bounds2 do			
			isColorByControlled = false;
			overlay = nil;
			typesOverlay = nil;				
			local vehicle = nil;
			local line = nil;
			local text = "";
			if nextPosY < y then break;end;
			
			local canNextView = true;
			local lineWidth = w-(difW*2);
			
			local isNextPosY = false;
			function setNextPosY()
				if isNextPosY then					
					--no at box--
					noBoxNextLeftPosX = x-difW;
					noBoxNextRightPosX = x+w+difW;
					noBoxLastLeftPosX = noBoxNextLeftPosX; 
					noBoxLastRightPosX = noBoxNextRightPosX;
					--not at box--
					nextPosY = nextPosY-box.ownTable.lineHeight;							
					lineWidth = w-(difW*2);
					nextLeftPosX = x+difW;				
					nextRightPosX = x+w-difW;
					canNextView = true;
					isNextPosY = false;
				end;
			end;
								
			function setMarkedVehicle(halfIcon)
				if vehicle.viIsMarked ~= nil and vehicle.viIsMarked then
					overlay = overlayDefaultGroup[overlayDefaultByName["markedVehicle"]];
					if overlay ~= nil then						
						if halfIcon and box.ownTable.view.speed[1] == 1 then
							g_currentMission.hlUtils.setOverlay(overlay, x-(iconWidth/2.2), nextPosY, iconWidth, iconHeight/2);
						else
							g_currentMission.hlUtils.setOverlay(overlay, x-(iconWidth/2.2), nextPosY, iconWidth, iconHeight);
						end;
						overlay:render();
					end;
				end;			
			end;
			local markedControlledVehiclePosX = 0;
			function setMarkedControlledVehicle(halfIcon)				
				overlay = overlayDefaultGroup[overlayDefaultByName["markedControlledVehicle"]];
				if overlay ~= nil then
					if markedControlledVehiclePosX > 0 then
						g_currentMission.hlUtils.setOverlay(overlay, markedControlledVehiclePosX, nextPosY, iconWidth, iconHeight);
					else
						if halfIcon and box.ownTable.view.speed[1] == 1 then
							g_currentMission.hlUtils.setOverlay(overlay, x-(iconWidth/2), nextPosY+(iconHeight/2), iconWidth, iconHeight/2);
						else
							g_currentMission.hlUtils.setOverlay(overlay, x-(iconWidth/2), nextPosY, iconWidth, iconHeight);
						end;
					end;
					if line.isPlayer then
						iconColor = box.ownTable.showColors.playerControlled; --box.overlays.color.inArea;
					elseif line.isOtherPlayer then
						iconColor = box.ownTable.showColors.otherControlled; --box.overlays.color.title;
					elseif line.isHelper then
						iconColor = box.ownTable.showColors.helperControlled; --box.overlays.color.on;				
					end;
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));
					overlay:render();
				end;							
			end;
			function setGroupIcon(iconPosX, double, noBox)				
				overlay = bgRound;
				if noBox then overlay = overlayDefaultGroup[overlayDefaultByName["bgRoundNoBox"]];end;
				tempOverlay = overlayDefaultGroup[overlayDefaultByName["groups"]];
				if double then
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB)-(iconHeightB/2), iconWidthB/2, iconHeightB/2);					
				else
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB/2)-(iconHeightB/4), iconWidthB/2, iconHeightB/2);					
				end;
				overlay:render();							
				if not line.vmViewGroup then iconColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.isGroup, true);else iconColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.viewGroup, true, nil, 0.90);end;
				g_currentMission.hlUtils.setOverlay(tempOverlay, overlay.x, overlay.y, iconWidthB/2, iconHeightB/2);
				g_currentMission.hlUtils.setBackgroundColor(tempOverlay, iconColor);
				tempOverlay:render();				
			end;
			function setLeasingIcon(iconPosX, double, noBox)				
				overlay = bgRound;
				if noBox then overlay = overlayDefaultGroup[overlayDefaultByName["bgRoundNoBox"]];end;
				if double then
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH, iconWidthB/2, iconHeightB/2);
				else
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB/2)-(iconHeightB/4), iconWidthB/2, iconHeightB/2);
				end;
				overlay:render();
				if box.ownTable.view.leasing[1] == 2 then
					tempOverlay = overlayDefaultGroup[overlayDefaultByName["leasing_icon"]];
				else
					tempOverlay = overlayDefaultGroup[overlayDefaultByName["leasing_text"]];
				end;
				if tempOverlay ~= nil then					
					g_currentMission.hlUtils.setOverlay(tempOverlay, overlay.x, overlay.y, iconWidthB/2, iconHeightB/2);
					iconColor = box.ownTable.showColors.leasing;
					if line.isMissionLeasing then iconColor = box.ownTable.showColors.missionsLeasing;end;
					g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(iconColor, true));
					tempOverlay:render();
				else
					optiSize = g_currentMission.hlUtils.optiHeightSize(iconHeightS, "L", size-difSize);
					textColor = box.ownTable.showColors.leasing;
					if line.isMissionLeasing then textColor = box.ownTable.showColors.missionsLeasing;end;
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
					setTextAlignment(RenderText.ALIGN_CENTER);
					renderText(overlay.x+(overlay.width/2), overlay.y+(difH/2), optiSize, tostring("L"));
					setTextAlignment(0);
					setTextColor(1, 1, 1, 1);
				end;				
			end;			
			function setSpeed()
				if box.ownTable.view.speed[1] > 1 then
					overlay = overlayDefaultGroup[overlayDefaultByName["speed"]];
					local dropJobEndBlinking = vehicle.viJobIsActive and g_currentMission.hlUtils.timers ~= nil and g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)] ~= nil and g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].action ~= nil;
					if dropJobEndBlinking then overlay = overlayDefaultGroup[overlayDefaultByName["jobEnd"]];g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.helperJobEndTimeBlinking, true));end;
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(bgRound, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						bgRound:render();
						if not dropJobEndBlinking then
							iconColor = box.overlays.color.notActive;
							if line.isEngine then iconColor = box.overlays.color.on;end;						
							local dropWarning = false;
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));
							if not line.isPlayer and line.isWarning then
								if line.warnings.isBlocking then --prio
									if line.warnings.blockingTyp == 1 then								
										iconColor = box.ownTable.showColors.blockingTyp1;dropWarning = true;									
									else
										iconColor = box.ownTable.showColors.blockingTyp2;dropWarning = true;									
									end;
								elseif line.warnings.isDamage then
									iconColor = box.ownTable.showColors.damage;dropWarning = true;
								elseif line.warnings.isFuelEmpty then
									iconColor = box.ownTable.showColors.fuelEmpty;dropWarning = true;
								elseif line.warnings.isWater then
									iconColor = box.ownTable.showColors.water;dropWarning = true;
								end;							
							end;
							iconColor = g_currentMission.hlUtils.getColor(iconColor, true)
							if dropWarning and (line.warnings.isBlocking or line.warnings.isWater) then g_currentMission.hlUtils.setBackgroundColor(overlay, iconColor);end;
							if line.speed ~= nil and tonumber(line.speed) > 0 then
								optiSize = box.ownTable.optiSize2Int;
								if tonumber(line.speed) > 99 then optiSize = box.ownTable.optiSize3Int;end;
								if line.isReverses then
									textColor = g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true);
								else
									if dropWarning then textColor = iconColor;else textColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.speed, true);end;
								end;
								setTextColor(unpack(textColor));
								setTextAlignment(RenderText.ALIGN_CENTER);
								renderText(bgRound.x+(bgRound.width/2), bgRound.y+(bgRound.height/4), optiSize, tostring(line.speed));
								setTextAlignment(0);
								setTextColor(1, 1, 1, 1);
								if line.isTempomat then											
									tempOverlay = overlayDefaultGroup[overlayDefaultByName["tempomat"]];
									if tempOverlay ~= nil then
										g_currentMission.hlUtils.setOverlay(tempOverlay, bgRound.x-(iconWidth/5), bgRound.y+bgRound.height-(iconHeight/2.5), iconWidth/1.8, iconHeight/1.8);
										tempOverlay:render();
									end;
								end;
							elseif line.hasEngine then							
								if dropWarning and (line.warnings.isDamage or line.warnings.isFuelEmpty) then 
									local switchTimerIcon = {[1]="",[2]="fuel",[3]="damage"};
									local warningIcon1 = overlayDefaultGroup[overlayDefaultByName["fuel"]];									
									if line.warnings.fuelType ~= nil then 
										if line.warnings.fuelType == FillType.ELECTRICCHARGE then 
											switchTimerIcon[2] = "fuelCharge";											
											warningIcon1 = overlayDefaultGroup[overlayDefaultByName["fuelCharge"]];
										elseif line.warnings.fuelType == FillType.METHANE then 
											switchTimerIcon[2] = "fuelMethan";											
											warningIcon1 = overlayDefaultGroup[overlayDefaultByName["fuelMethan"]];																					
										end;
									end;									
									local warningIcon = nil;									
									if isSwitchTimerWarning ~= nil and isSwitchTimerWarning == 2 and line.warnings.isFuelEmpty then 
										warningIcon = overlayDefaultGroup[overlayDefaultByName[switchTimerIcon[isSwitchTimerWarning]]];
										if warningIcon ~= nil then g_currentMission.hlUtils.setBackgroundColor(warningIcon, g_currentMission.hlUtils.getColor(box.ownTable.showColors.fuelEmpty, true));end;
									elseif isSwitchTimerWarning ~= nil and isSwitchTimerWarning == 3 and line.warnings.isDamage then 
										warningIcon = overlayDefaultGroup[overlayDefaultByName[switchTimerIcon[isSwitchTimerWarning]]];
										if warningIcon ~= nil then g_currentMission.hlUtils.setBackgroundColor(warningIcon, g_currentMission.hlUtils.getColor(box.ownTable.showColors.damage, true));end;
									end;									
									if warningIcon ~= nil then
										g_currentMission.hlUtils.setOverlay(warningIcon, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);										
										warningIcon:render();
										dropWarning = true;
									else
										dropWarning = false;
									end;									
									if not dropWarning then overlay:render();end;
								else
									overlay:render();
								end;																
							end;
						else
							if g_currentMission.hlUtils.runsTimer("1sec", true) then
								overlay:render();
							end;
						end;
						if box.ownTable.view.vehicleIcon[1] == 3 then --marked ControlledVehicle Dif
							lineWidth = lineWidth-iconWidthB-(difW*1.5);
							nextLeftPosX = nextLeftPosX+iconWidthB+(difW*1.5);
						else
							lineWidth = lineWidth-iconWidthB-difW;
							nextLeftPosX = nextLeftPosX+iconWidthB+difW;
						end;
						canNextView = lineWidth > iconWidth;
						isNextPosY = true;
						markedControlledVehiclePosX = nextLeftPosX-(iconWidth/2)-(difW/2);
					end;
				end;
			end;
			function setField()
				if box.ownTable.view.field[1] > 1 then
					overlay = overlayDefaultGroup[overlayDefaultByName["field"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(bgRound, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						bgRound:render();
						if line.isOnField and tonumber(line.fieldNumber) <= 0 then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.field, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));end;
						if line.isOnField and tonumber(line.fieldNumber) > 0 then
							optiSize = box.ownTable.optiSize2Int;
							if tonumber(line.fieldNumber) > 99 then optiSize = box.ownTable.optiSize3Int;end;										
							textColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.fieldNumber, true);
							setTextColor(unpack(textColor));
							setTextAlignment(RenderText.ALIGN_CENTER);
							renderText(bgRound.x+(bgRound.width/2), bgRound.y+(bgRound.height/4), optiSize, tostring(line.fieldNumber));
							setTextAlignment(0);
							setTextColor(1, 1, 1, 1);
						else
							overlay:render();
						end;
						lineWidth = lineWidth-iconWidthB-difW;
						nextLeftPosX = nextLeftPosX+iconWidthB+difW;
						canNextView = lineWidth > iconWidth;
						isNextPosY = true;						
					end;
				end;
			end;
			function setVehicleIcon()
				if box.ownTable.view.vehicleIcon[1] > 1 then
					--g_currentMission.hlUtils.setOverlay(bgRound, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					--bgRound:render();
					if box.ownTable.view.vehicleIcon[1] == 3 and overlayVehiclesGroup ~= nil and not line.isTrain and vehicle.viStoreName ~= nil then
						overlay = overlayVehiclesGroup[overlayVehiclesByName[vehicle.viStoreName]];
						if overlay ~= nil then							
							g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX-(difW*1.9), nextPosY-difH, iconWidthV, iconHeightV);							
							overlay:render();
							lineWidth = lineWidth-iconWidthB-(difW*1.9);
							nextLeftPosX = nextLeftPosX+iconWidthB+(difW*1.9);
						end;
					else
						tempOverlay = nil;
						local typIcon = vehicle.viTypIcon;
						if line.frontloaderAttached then typIcon = "tractor_frontloader";end;
						overlay = overlayDefaultGroup[overlayDefaultByName[typIcon]];						
						if box.ownTable.view.frontloaderReady[1] > 1 and line.hasFrontloader and not line.frontloaderAttached then tempOverlay = overlayDefaultGroup[overlayDefaultByName["isFrontloader"]];end;						
						if overlay == nil then overlay = overlayDefaultGroup[overlayDefaultByName["tractor_other"]];end;
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY-(difH*1.5), iconWidthT, iconHeightT);
							if tempOverlay ~= nil then g_currentMission.hlUtils.setOverlay(tempOverlay, nextLeftPosX, nextPosY-(difH*1.5), iconWidthT, iconHeightT);end;
							if line.isPlayer then
								iconColor = box.ownTable.showColors.playerControlled; --box.overlays.color.inArea;
							elseif line.isOtherPlayer then
								iconColor = box.ownTable.showColors.otherControlled; --box.overlays.color.title;
							elseif line.isHelper then
								iconColor = box.ownTable.showColors.helperControlled; --box.overlays.color.on;
							else
								iconColor = box.overlays.color.notActive;
							end;
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));							
							overlay:render();
							if tempOverlay ~= nil then
								if not line.isFrontloader then g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor("orange", true));else g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor("khaki", true));end;
								tempOverlay:render();
							end;
							isColorByControlled = true;
							lineWidth = lineWidth-iconWidthT-difW;
							nextLeftPosX = nextLeftPosX+iconWidthT+difW;
						end;
					end;
					if overlay ~= nil then						
						canNextView = lineWidth > iconWidth;
						isNextPosY = true;
					end;
				end;
			end;
			function setAttachedTotal()
				if box.ownTable.view.attachedTotal[1] > 1 then
					overlay = overlayDefaultGroup[overlayDefaultByName["attached"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(bgRound, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, iconWidthBV, iconHeightBV);
						bgRound:render();						
						if line.hasAttached then							
							if isSwitchTimerTwo ~= nil and isSwitchTimerTwo == 2 then
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("darkGrayOff", true)); 
								overlay:render();
								optiSize = box.ownTable.optiSize2Int;
								text = tostring(#line.attached);
								textColor = g_currentMission.hlUtils.getColor(box.overlays.color.on, true);
								setTextBold(true);
								setTextColor(unpack(textColor));
								setTextAlignment(RenderText.ALIGN_CENTER);
								renderText(bgRound.x+(bgRound.width/2), bgRound.y+(bgRound.height/4), optiSize-difSize, tostring(text));
								setTextBold(false);
								setTextAlignment(0);
								setTextColor(1, 1, 1, 1);
							else								
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true)); 
								overlay:render();
							end;							
						else
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.off, true)); 
							overlay:render();
						end;
						lineWidth = lineWidth-iconWidthB-difW;
						nextLeftPosX = nextLeftPosX+iconWidthB+difW;
						canNextView = lineWidth > iconWidth;
						isNextPosY = true;
					end;
				end;
			end;
			function setAttachedIcons(intern)
				if overlayVehiclesGroup == nil or line.isTrain or line.isHorse or (box.ownTable.view.attachedIcon[1] == 1 and intern) or not line.hasAttached then return;end;					
				local tempNextLeftPosX = nextLeftPosX;
				local dropOverlay = {front=bgFront, middle=bgMiddle, back=bgBack};
				local maxIconWidth = lengthData.attachedTotal;
				if lineWidth < iconWidthB*(maxIconWidth+1) then 
					if intern then return;end;
					tempNextLeftPosX = noBoxLastRightPosX;dropOverlay = {front=bgFrontNoBox, middle=bgMiddleNoBox, back=bgBackNoBox};				
				else
					if not intern and canNextView then 
											
					elseif not intern and not canNextView then
						tempNextLeftPosX = noBoxLastRightPosX;dropOverlay = {front=bgFrontNoBox, middle=bgMiddleNoBox, back=bgBackNoBox};										
					end;
				end;				
				g_currentMission.hlUtils.setOverlay(dropOverlay.front, tempNextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
				dropOverlay.front:render();
				tempNextLeftPosX = tempNextLeftPosX+(iconWidthB/2);
				local iconPosX = tempNextLeftPosX;							
				for i=1, maxIconWidth do
					g_currentMission.hlUtils.setOverlay(dropOverlay.middle, iconPosX, nextPosY-difH, iconWidthB, iconHeightB);
					dropOverlay.middle:render();					
					iconPosX = iconPosX+iconWidthB;	
				end;
				g_currentMission.hlUtils.setOverlay(dropOverlay.back, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
				dropOverlay.back:render();
				iconPosX = iconPosX+(iconWidthB/2);
				for a=1, #line.attached do									
					local attachedVehicle = g_currentMission:getNodeObject(line.attached[a].rootNode)
					if attachedVehicle ~= nil and attachedVehicle.viStoreName ~= nil then
						overlay = overlayVehiclesGroup[overlayVehiclesByName[attachedVehicle.viStoreName]];
						if overlay ~= nil then							
							g_currentMission.hlUtils.setOverlay(overlay, tempNextLeftPosX, nextPosY-(difH), iconWidthV, iconHeightV);							
							overlay:render();							
							tempNextLeftPosX = tempNextLeftPosX+iconWidthV+(difW/2);							
						end;
					end;
				end;
				lineWidth = lineWidth-(iconWidthB*(maxIconWidth+1))-difW;
				tempNextLeftPosX = iconPosX+difW;
				if intern then 
					nextLeftPosX = tempNextLeftPosX;
					canNextView = lineWidth > iconWidth;
				else
					noBoxLastRightPosX = tempNextLeftPosX;
					canNextView = true;
				end;				
				isNextPosY = true;
			end;			
			function setVehicleName()
				if box.ownTable.view.vehicleName[1] > 1 then
					local maxIconWidth = box.ownTable.length.vehicleName[1];
					local vehicleName = tostring(line.vehicleName); --or storeName !					
					if lineWidth < iconWidthB*(maxIconWidth+1) then return true;end;
					optiSize = g_currentMission.hlUtils.optiHeightSize(iconHeightB, vehicleName, size-difSize);
					g_currentMission.hlUtils.setOverlay(bgFront, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					bgFront:render();				
					nextLeftPosX = nextLeftPosX+(iconWidthB/2);
					local iconPosX = nextLeftPosX;
					for a=1, maxIconWidth do						
						g_currentMission.hlUtils.setOverlay(bgMiddle, iconPosX, nextPosY-difH, iconWidthB, iconHeightB);
						bgMiddle:render();
						iconPosX = iconPosX+iconWidthB;	
					end;					
					g_currentMission.hlUtils.setOverlay(bgBack, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
					bgBack:render();					
					iconPosX = iconPosX+(iconWidthB/2);										
					if box.ownTable.view.vehicleIcon[1] == 1 or box.ownTable.view.vehicleIcon[1] == 3 then
						if line.isPlayer then
							textColor = box.ownTable.showColors.playerControlled; --box.overlays.color.inArea;
						elseif line.isOtherPlayer then
							textColor = box.ownTable.showColors.otherControlled; --box.overlays.color.title;
						elseif line.isHelper then
							textColor = box.ownTable.showColors.helperControlled; --box.overlays.color.on;
						else
							textColor = box.overlays.color.text;
						end;
					else
						textColor = box.overlays.color.text;
					end;
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(vehicleName), optiSize-difSize, iconWidthB*maxIconWidth-(iconWidthB/1.2), false, ".");
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
					renderText(nextLeftPosX, nextPosY+difH, optiSize, tostring(text));
					setTextColor(1, 1, 1, 1);
					if box.ownTable.view.group[1] > 1 and line.vmIsGroup then						
						setGroupIcon(iconPosX-(iconWidthB/2)+(difW/2), box.ownTable.view.leasing[1] > 1 and line.isLeasing, false);
					end;
					if box.ownTable.view.leasing[1] > 1 and line.isLeasing then							
						setLeasingIcon(iconPosX-(iconWidthB/2)+(difW/2), box.ownTable.view.group[1] > 1 and line.vmIsGroup, false);
					end;
					lineWidth = lineWidth-(iconWidthB*(maxIconWidth+1))-difW;					
					nextLeftPosX = iconPosX+difW;
					canNextView = lineWidth > iconWidth;
					isNextPosY = true;
					isColorByControlled = true;								
				end;
				return false;
			end;
			-------------------------------------
			function setFillData(fillData, pColor, intern)
				if fillData.capacity == nil then return false;end;
				if fillData.fillLevel == nil or (fillData.fillLevel == 0 and not fillData.isSeedsOrAnd) then return false, false;end;
				local tempNextLeftPosX = nextLeftPosX;				
				local dropOverlay = {front=bgFront, middle=bgMiddle, back=bgBack};
				if not intern then tempNextLeftPosX = noBoxLastRightPosX;dropOverlay = {front=bgFrontNoBox, middle=bgMiddleNoBox, back=bgBackNoBox};end;
				text = "";
				optiSize = size-difSize;
				local maxIconWidth = 0;				
				if box.ownTable.view.fillData[1] == 2 then optiSize = box.ownTable.optiSizeFillDataL;maxIconWidth = box.ownTable.maxIconsFillDataL;text = g_i18n:formatVolume(Utils.getNoNil(fillData.fillLevel, 0), 0, "").. "(".. tostring(string.format("%1.0f", "".. tonumber(fillData.fillProzent))).. "%)";
				elseif box.ownTable.view.fillData[1] == 3 then optiSize = box.ownTable.optiSizeFillData;maxIconWidth = box.ownTable.maxIconsFillData;text = g_i18n:formatVolume(Utils.getNoNil(fillData.fillLevel, 0), 0, "");				
				elseif box.ownTable.view.fillTypeName[1] > 1 then optiSize = box.ownTable.optiSizeFillData;maxIconWidth = box.ownTable.maxIconsFillData;text = fillData.fillTypeTitle;end;				
				local dropFillTypeIcon = false;
				if box.ownTable.view.fillTypeIcon[1] > 1 and overlayFillTypesGroup ~= nil and overlayFillTypesByName ~= nil and overlayFillTypesGroup[overlayFillTypesByName[fillData.fillTypeName]] ~= nil then maxIconWidth = maxIconWidth+1;dropFillTypeIcon = true;end;
				if maxIconWidth == 0 or (intern and lineWidth < iconWidthB*(maxIconWidth+1)) then canNextView = false;return false, fillData.fillLevel ~= nil and fillData.fillLevel > 0;end;				
				g_currentMission.hlUtils.setOverlay(dropOverlay.front, tempNextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
				dropOverlay.front:render();				
				tempNextLeftPosX = tempNextLeftPosX+(iconWidthB/2);
				local iconPosX = tempNextLeftPosX;
				for a=1, maxIconWidth do					
					g_currentMission.hlUtils.setOverlay(dropOverlay.middle, iconPosX, nextPosY-difH, iconWidthB, iconHeightB);
					dropOverlay.middle:render();					
					if a == 1 and dropFillTypeIcon then 
						overlay = overlayFillTypesGroup[overlayFillTypesByName[fillData.fillTypeName]];						
						g_currentMission.hlUtils.setOverlay(overlay, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
						overlay:render();
						tempNextLeftPosX = tempNextLeftPosX+(iconWidthB/2);
					end;					
					iconPosX = iconPosX+iconWidthB;					
				end;				
				g_currentMission.hlUtils.setOverlay(dropOverlay.back, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
				dropOverlay.back:render();
				iconPosX = iconPosX+(iconWidthB/2);				
				if g_currentMission.missionInfo.trailerFillLimit and box.ownTable.view.fillLimit[1] > 1 and fillData.maxReached ~= nil and fillData.maxReached then
					overlay = overlayDefaultGroup[overlayDefaultByName["fillLimit"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, iconPosX-(iconWidthB/2), nextPosY-difH+(iconHeightB/2)-(iconHeightB/4), iconWidthB/2, iconHeightB/2);
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.fillLimit, true)); 
						overlay:render();
					end;
				end;				
				if (isSwitchTimerTwo ~= nil and isSwitchTimerTwo == 2 and box.ownTable.view.fillTypeName[1] > 1) or (box.ownTable.view.fillData[1] == 1 and box.ownTable.view.fillTypeName[1] > 1) then
					if box.ownTable.view.fillTypeIcon[1] > 1 then 
						text = g_currentMission.hlUtils.getTxtToWidth(tostring(fillData.fillTypeTitle), optiSize-difSize, iconWidthB*maxIconWidth-(iconWidthB/2), false, ".");
					else
						text = g_currentMission.hlUtils.getTxtToWidth(tostring(fillData.fillTypeTitle), optiSize-difSize, iconWidthB*maxIconWidth+(iconWidthB/2)-difW, false, ".");
					end;
				else
					local largeTxt = g_i18n:formatVolume(Utils.getNoNil(fillData.fillLevel, 0),0,""):len() > 8; --unrealistische Fillwerte ?
					if largeTxt then optiSize = g_currentMission.hlUtils.optiWidthSize(iconWidthB*maxIconWidth-(iconWidthB/2), text, optiSize);end;
				end;
				if text:len() > 0 then
					setTextColor(unpack(pColor));					
					if box.ownTable.view.fillTypeIcon[1] > 1 then 						
						renderText(tempNextLeftPosX, nextPosY+difH, optiSize, tostring(text));
					else
						renderText(tempNextLeftPosX-(iconWidthB/2)+difW, nextPosY+difH, optiSize, tostring(text));
					end;
					setTextAlignment(0);
					setTextColor(1, 1, 1, 1);
				end;
				lineWidth = lineWidth-(iconWidthB*(maxIconWidth+1))-difW;
				tempNextLeftPosX = iconPosX+difW;
				if intern then 
					nextLeftPosX = tempNextLeftPosX;
					canNextView = lineWidth > iconWidth;
				else
					noBoxLastRightPosX = tempNextLeftPosX;
					canNextView = true;
				end;				
				isNextPosY = true;
				return true, true;
			end;
			
			function setCameraOnInfo(ownerFarmId) --last is free
				if x+w-iconWidthS-difW >= nextLeftPosX then
					if camBox ~= nil and camBox.show and data ~= nil and data.isVehicle and data.node == line.node then
						overlay = overlayDefaultGroup[overlayDefaultByName["camera"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, x+w-iconWidthS-difW, nextPosY+difH, iconWidthS, iconHeightS);
							if ownerFarmId then
								iconColor = box.ownTable.showColors.camera;
							else
								iconColor = box.ownTable.showColors.contractor;
							end;
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));
							overlay:render();
							return true;
						end;
					end;
					return false;
				end;
				return nil;
			end;
			function setContractorIcon()
				if x+w-iconWidthS-(difW) >= nextLeftPosX then
					overlay = overlayDefaultGroup[overlayDefaultByName["contractor"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, x+w-iconWidthS-(difW), nextPosY+(difH), iconWidthS, iconHeightS);
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.contractor, true));
						overlay:render();
					end;
				end;
			end;
			-------------------------------------						
			function setControlledName(dropNoBoxGroupOrLeasing, dropNoBoxRemainingString) --not drop at box	
				local controlledName = "";				
				local canDropControlledName = false;
				if box.ownTable.view.controlledName[1] > 1 then
					if g_currentMission.missionDynamicInfo.isMultiplayer then
						if box.ownTable.view.controlledName[1] == 2 and (line.isPlayer or line.isOtherPlayer) then canDropControlledName = true;controlledName = tostring(line.controlledName);
						elseif box.ownTable.view.controlledName[1] == 3 and (line.isPlayer or line.isOtherPlayer or line.isHelper) then canDropControlledName = true; 
							if line.isPlayer or line.isOtherPlayer then controlledName = tostring(line.controlledName);else controlledName = line.helperName;end;
						elseif box.ownTable.view.controlledName[1] == 4 and line.isHelper then canDropControlledName = true;controlledName = line.helperName;end;						
					else
						if (box.ownTable.view.controlledName[1] == 3 or box.ownTable.view.controlledName[1] == 4) and line.isHelper then canDropControlledName = true;controlledName = line.helperName;end;						
					end;					
				end;
				if canDropControlledName and controlledName:len() > 0 then
					local maxIconWidth = box.ownTable.length.controlledName[1];					
					optiSize = box.ownTable.optiSizeNoBox;
					if line.isPlayer then
						textColor = box.ownTable.showColors.playerControlled; --box.overlays.color.inArea;
					elseif line.isOtherPlayer then
						textColor = box.ownTable.showColors.otherControlled; --box.overlays.color.title;
					elseif line.isHelper then
						textColor = box.ownTable.showColors.helperControlled; --box.overlays.color.on;
					else
						textColor = box.overlays.color.text;
					end;					
					----					
					local iconPosX = noBoxLastRightPosX;
					local startTextPosX = noBoxLastRightPosX;
					local toleranzMaxIconWidth = difW;
					if box.ownTable.view.vehicleName[1] == 1 and not dropNoBoxRemainingString then toleranzMaxIconWidth = iconWidth;end;
					if box.ownTable.view.controlledNameSide[1] == 2 then iconPosX = noBoxLastLeftPosX-(iconWidthB/2)-difW-(iconWidth*maxIconWidth)-toleranzMaxIconWidth;startTextPosX=iconPosX;end;
					local canDropLeft = iconPosX >= 0;
					local canDropRight = iconPosX+(iconWidth*(maxIconWidth+1)) <= 1.0;
					if box.ownTable.view.controlledNameSide[1] == 2 and not canDropLeft then iconPosX = noBoxLastRightPosX;startTextPosX = noBoxLastRightPosX;end;
					if box.ownTable.view.controlledNameSide[1] == 3 and not canDropRight then iconPosX = noBoxLastLeftPosX-(iconWidthB/2)-difW-(iconWidth*maxIconWidth)-toleranzMaxIconWidth;startTextPosX=iconPosX;end;
					----
					overlay = bgFrontNoBox;
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY, iconWidth, iconHeight);
					overlay:render();				
					iconPosX = iconPosX+(iconWidth/2);					
					for a=1, maxIconWidth do						
						overlay = bgMiddleNoBox;
						g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY, iconWidth, iconHeight);
						overlay:render();
						iconPosX = iconPosX+iconWidth;	
					end;					
					overlay = bgBackNoBox;
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX-(iconWidth/2), nextPosY, iconWidth, iconHeight);
					overlay:render();					
					iconPosX = iconPosX+(iconWidth/2);					
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(controlledName), optiSize, iconWidth*maxIconWidth+(iconWidth/2.3), false, ".");
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));					
					renderText(startTextPosX+(iconWidth/1.9), nextPosY+(iconHeight/5), optiSize, tostring(text));					
					setTextColor(1, 1, 1, 1);
					if startTextPosX <= x then 
						noBoxLastLeftPosX = iconPosX-(iconWidth/2);
					else
						noBoxLastRightPosX = iconPosX+difW;
					end;
					return true;
				end;
				return false;
			end;
			function setRemainingString(dropNoBoxGroupOrLeasing) --not drop at box				
				if line.remainingData == nil or line.remainingData.timeTxt == nil or line.remainingData.timeTxt:len() <= 0 then return false;end;
				if box.ownTable.view.adRemaining[1] > 1 or box.ownTable.view.cpRemaining[1] > 1 then
					local remainingTxt = line.remainingData.timeTxt;
					local maxIconWidth = 2;
					local adString = false;
					local cpString = false;
					local largeWaypointsTxt = false; --big Field Maps ?
					optiSize = size;
					if line.jobType.ad and box.ownTable.view.adRemaining[1] > 1 then
						maxIconWidth = box.ownTable.maxIconsRemainingTime;optiSize = box.ownTable.optiSizeRemainingTime;
						if line.remainingData.timeLarge ~= nil and line.remainingData.timeLarge then maxIconWidth = box.ownTable.maxIconsRemainingTimeLarge;optiSize = box.ownTable.optiSizeRemainingTimeLarge;end;
						if box.ownTable.view.adRemaining[4] and line.remainingData.waypointsTxt ~= nil and line.remainingData.waypointsTxt:len() > 0 and line.remainingData.waypoints > 0 then largeWaypointsTxt = line.remainingData.waypoints > 9999;maxIconWidth = maxIconWidth+box.ownTable.maxIconsRemainingWaypoints;remainingTxt = remainingTxt.. box.ownTable.viewText.remainingWaypointsSeparator.. line.remainingData.waypointsTxt;end;
						textColor = box.ownTable.showColors.adRemainingString;
						adString = true;
					elseif box.ownTable.view.cpRemaining[1] > 1 then
						maxIconWidth = box.ownTable.maxIconsRemainingTime;optiSize = box.ownTable.optiSizeRemainingTime;
						if line.remainingData.timeLarge ~= nil and line.remainingData.timeLarge then maxIconWidth = box.ownTable.maxIconsRemainingTimeLarge;optiSize = box.ownTable.optiSizeRemainingTimeLarge;end;
						if box.ownTable.view.cpRemaining[4] and line.remainingData.waypointsTxt ~= nil and line.remainingData.waypointsTxt:len() > 0 and line.remainingData.waypoints > 0 then largeWaypointsTxt = line.remainingData.waypoints > 9999;maxIconWidth = maxIconWidth+box.ownTable.maxIconsRemainingWaypoints;remainingTxt = remainingTxt.. box.ownTable.viewText.remainingWaypointsSeparator.. line.remainingData.waypointsTxt;end;
						textColor = box.ownTable.showColors.cpRemainingString;
						cpString = true;
					else --unknown
						local iconTxtWidth = getTextWidth(size, utf8Substr(remainingTxt, 0));
						maxIconWidth = g_currentMission.hlUtils.getMaxIconWidth(iconTxtWidth, iconWidth);
						if maxIconWidth < 2 then maxIconWidth = 2;end;
						optiSize = g_currentMission.hlUtils.optiWidthSize(maxIconWidth, remainingTxt, size-difSize);
						textColor = box.overlays.color.text;
					end;
					----					
					local iconPosX = noBoxLastRightPosX;
					local startTextPosX = noBoxLastRightPosX;
					local toleranzMaxIconWidth = difW;
					if box.ownTable.view.vehicleName[1] == 1 then toleranzMaxIconWidth = iconWidth;end;
					if box.ownTable.view.remainingSide[1] == 2 then iconPosX = noBoxLastLeftPosX-(iconWidthB/2)-difW-(iconWidth*maxIconWidth)-toleranzMaxIconWidth;startTextPosX=iconPosX;end;
					local canDropLeft = iconPosX >= 0;
					local canDropRight = iconPosX+(iconWidth*(maxIconWidth+1)) <= 1.0;
					if box.ownTable.view.remainingSide[1] == 2 and not canDropLeft then iconPosX = noBoxLastRightPosX;startTextPosX = noBoxLastRightPosX;end;
					if box.ownTable.view.remainingSide[1] == 3 and not canDropRight then iconPosX = noBoxLastLeftPosX-(iconWidthB/2)-difW-(iconWidth*maxIconWidth)-toleranzMaxIconWidth;startTextPosX=iconPosX;end;
					----
					if adString then tempOverlay = overlayDefaultGroup[overlayDefaultByName["adLogoH"]];elseif cpString then tempOverlay = overlayDefaultGroup[overlayDefaultByName["cpLogoH"]];end;
					overlay = bgFrontNoBox;
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY, iconWidth, iconHeight);
					overlay:render();
					if tempOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(tempOverlay, iconPosX, nextPosY, iconWidth, iconHeight);
						tempOverlay:render();
					end;
					iconPosX = iconPosX+(iconWidth/2);
					for i=1, maxIconWidth do						
						overlay = bgMiddleNoBox;
						g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY, iconWidth, iconHeight);
						overlay:render();
						iconPosX = iconPosX+iconWidth;						
					end;
					overlay = bgBackNoBox;
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX-(iconWidth/2), nextPosY, iconWidth, iconHeight);
					overlay:render();
					iconPosX = iconPosX+(iconWidth/2);	
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
					--setTextAlignment(RenderText.ALIGN_CENTER);
					--renderText(x+w+difW+(iconWidth*maxIconWidth/2), nextPosY-difH+(iconHeight/4.5), optiSize, tostring(remainingTxt));
					--renderText(x+w+difW+(iconWidth*maxIconWidth/2), nextPosY-difH+(iconHeight/4.5), optiSize, tostring(remainingTxt));
					local setRemainingTxt = true;
					if (line.remainingData.waypoints ~= nil and line.remainingData.waypoints >= 0 and line.remainingData.waypoints < 5) or (line.remainingData.nSec ~= nil and tonumber(line.remainingData.nSec) <= 10) then						
						if g_currentMission.hlUtils.runsTimer("1sec", true) then setRemainingTxt = true;else setRemainingTxt = false;end;				
					end;
					if setRemainingTxt then						
						if largeWaypointsTxt then
							optiSize = g_currentMission.hlUtils.optiWidthSize(iconPosX-(startTextPosX+(iconWidth/1.9)), remainingTxt, optiSize)
						end;
						renderText(startTextPosX+(iconWidth/1.9), nextPosY+(iconHeight/5), optiSize, tostring(remainingTxt));
						renderText(startTextPosX+(iconWidth/1.9), nextPosY+(iconHeight/5), optiSize, tostring(remainingTxt));
						--renderText(noBoxLastRightPosX+(iconWidth/1.9), nextPosY-difH+(iconHeight/5), optiSize, tostring(remainingTxt));
						--renderText(noBoxLastRightPosX+(iconWidth/1.9), nextPosY-difH+(iconHeight/5), optiSize, tostring(remainingTxt));
					end;					
					setTextAlignment(0);
					setTextColor(1, 1, 1, 1);
					if startTextPosX <= x then 
						noBoxLastLeftPosX = iconPosX-(iconWidth/2);
					else
						noBoxLastRightPosX = iconPosX+difW;
					end;
					return true;
				end;
				return false;
			end;
			local setWarningWidth = false;
			if VehicleInspector_DisplaySetGet.viewVehiclesBox[t] ~= nil then
				line = VehicleInspector_DisplaySetGet.viewVehiclesBox[t];				
				if canNextView then
					if nextPosY > y then
						vehicle = g_currentMission.nodeToObject[line.node];									
						if vehicle ~= nil then													
							--speed--
							if canNextView then setSpeed();end;
							--speed--
							--field--
							if canNextView then setField();end;							
							--field--							
							--vehicle icon--
							if canNextView then setVehicleIcon();end;	
							--vehicle icon--
							--attached total--
							if canNextView then setAttachedTotal();end;
							--attached total--
							--attached icon--
							local onlyAttached = box.ownTable.view.attachedIcon[1] > 1;
							if canNextView then setAttachedIcons(true);end;	
							--attached icon--
							--vehicle name--
							if not onlyAttached and canNextView then setWarningWidth = setVehicleName();else setWarningWidth = true;end;													
							--vehicle name--
							--fillLevel Information--
							local dropViewFillData = false;
							if not onlyAttached and (canNextView or (not canNextView and box.ownTable.autoDimension.width[1] > 1)) then
								if box.ownTable.view.fillTypeIcon[1] > 1 or box.ownTable.view.fillData[1] > 1 or box.ownTable.view.fillTypeName[1] > 1 then 
									if line.fillLevelInformation ~= nil and #line.fillLevelInformation > 0 then									
										local viewFillDataTotal = 0;
										local attachedLimit = 0;
										local attachedBreak = false;
										for f=1, #line.fillLevelInformation do
											local fillData = line.fillLevelInformation[f];
											if fillData ~= nil then
												local isViewFillData = false;
												local hasFillDataFillLevel = false;
												if attachedLimit >= box.ownTable.length.attached[1] then attachedBreak = true;break;end;
												local pColor = 1;
												if box.ownTable.view.fillDataColor[1] > 1 then
													if box.ownTable.invertPercentFillData[fillData.fillType] ~= nil then
														pColor = g_currentMission.hlUtils.getProzentColor(fillData.fillProzent, true);
													else
														pColor = g_currentMission.hlUtils.getProzentColor(fillData.fillProzent, fillData.isSeedsOrAnd);
													end;												
													pColor = g_currentMission.hlUtils.getColorProzent(pColor,true);
												else
													pColor = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);
												end;											
												if box.ownTable.notViewFillData[fillData.fillType] == nil then
													isViewFillData, hasFillDataFillLevel = setFillData(fillData, pColor, true); --view at Box
												end;											
												if isViewFillData and line.node ~= fillData.rootNodes[1] then						
													attachedLimit = attachedLimit+1;
												end;
												if box.ownTable.autoDimension.width[1] > 1 and box.ownTable.notViewFillData[fillData.fillType] == nil and not isViewFillData and (line.node ~= fillData.rootNodes[1] or (line.node == fillData.rootNodes[1] and hasFillDataFillLevel)) then
													attachedLimit = attachedLimit+1;
													isViewFillData, hasFillDataFillLevel = setFillData(fillData, pColor, false); --view extern
												elseif not canNextView and box.ownTable.autoDimension.width[1] == 1 and box.ownTable.notViewFillData[fillData.fillType] == nil and not isViewFillData and (line.node ~= fillData.rootNodes[1] or (line.node == fillData.rootNodes[1] and hasFillDataFillLevel)) then --info
													overlay = overlayDefaultGroup[overlayDefaultByName["right"]];
													g_currentMission.hlUtils.setOverlay(overlay, x+w-(iconWidth/2), nextPosY+(box.ownTable.lineHeight/2)-iconHeight/2, iconWidth, iconHeight);
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
													overlay:render();
													local inIconArea = overlay.mouseInArea();			
													if not g_currentMission.hlUtils:disableInArea() and inIconArea then setInfoHelpText(g_i18n:getText("box_autoDimensionWidthWarning"), 0);end; 
												end;
												if isViewFillData then viewFillDataTotal = viewFillDataTotal+1;dropViewFillData = true;end;
											end;
										end;
										if attachedBreak then
											
										end;
										
										--setFillLevelInformation();								
									end;
								end;								
							end;
							--fillLevel Information--
							--set attached icon is not viewFillData--
							if not onlyAttached and not dropViewFillData and box.ownTable.view.attachedIcon[4] then
								setAttachedIcons(false);
							end;
							--set attached icon is not viewFillData--
							--marked Vehicle--							
							setMarkedVehicle((line.isPlayer or line.isOtherPlayer or line.isHelper) and not isColorByControlled);
							--marked Vehicle--	
							--controlled color--
							if (line.isPlayer or line.isOtherPlayer or line.isHelper) and not isColorByControlled then
								setMarkedControlledVehicle(vehicle.viIsMarked);
							end;
							--controlled color--
							--group icon needs VehicleManager--
							local dropNoBoxGroupOrLeasing = false;
							if box.ownTable.view.vehicleName[1] == 1 and box.ownTable.view.group[1] > 1 and line.vmIsGroup then
								dropNoBoxGroupOrLeasing = true;
								setGroupIcon(noBoxNextLeftPosX-(iconWidthB/2), box.ownTable.view.leasing[1] > 1 and line.isLeasing, true);
							end;
							--group icon needs VehicleManager--
							--leasing icon--
							if box.ownTable.view.vehicleName[1] == 1 and box.ownTable.view.leasing[1] > 1 and line.isLeasing then
								dropNoBoxGroupOrLeasing = true;
								setLeasingIcon(noBoxNextLeftPosX-(iconWidthB/2), box.ownTable.view.group[1] > 1 and line.vmIsGroup, true);
							end;
							--leasing icon--
							--camera on icon--
							local isDrawCam = setCameraOnInfo(line.ownerFarmId);
							--camera on icon--
							--contractor icon--
							if not line.ownerFarmId and isDrawCam ~= nil and not isDrawCam then setContractorIcon();end;
							--contractor icon--
							--ad/cp remaining needs AutoDrive/Courseplay--
							local dropNoBoxRemainingString = setRemainingString(dropNoBoxGroupOrLeasing); --not drop at box	
							--ad/cp remaining needs AutoDrive/Courseplay--
							--controlled name--
							if line.isPlayer or line.isOtherPlayer or line.isHelper then setControlledName(dropNoBoxGroupOrLeasing, dropNoBoxRemainingString);end;
							--controlled name--
							--vehicle preview/join line--
							overlay = box.overlays.bgLine;
							if overlay ~= nil and inArea then
								g_currentMission.hlUtils.setOverlay(overlay, x+difW, nextPosY, x+w-difW, box.ownTable.lineHeight);
								local inIconArea = overlay.mouseInArea();
								if VehicleInspector.values.previewData.vehicles.view[1] > 1 then
									if not g_currentMission.hlUtils:disableInArea() and inIconArea then VehicleInspector_DrawPreviewData:setVehiclesOpen( {node=line.node, isTrain=line.isTrain, isHorse=line.isHorse} );end;
								end;
								if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleInspector_Display_Box", typPos=boxNumber, whereClick="vehicleLine_", ownTable={vehicleNode=line.node}} );end;
							end;
							--vehicle preview/join line--
						else
							text = g_currentMission.hlUtils.getTxtToWidth("Ghost Vehicle", size, lineWidth, false, ".");
							setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)));
							renderText(nextLeftPosX, nextPosY, size, tostring(text));					
							setTextColor(1, 1, 1, 1);
							isNextPosY = true;
						end;
						
						------
						setNextPosY();
						------	
					else
						break;
					end;
				end;				
			else
			
			end;
			if setWarningWidth then setWarningLineIcon(y+(h/2));end;
		end;
		--box lines--
	end;	
end;