VehicleInspector_Display_DrawAllInBox = {};

function VehicleInspector_Display_DrawAllInBox.setBox(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local box = g_currentMission.hlHudSystem.box[args.typPos];
	if box == nil then return;end;
		
	local inArea = args.inArea;
	local boxNumber = args.typPos;
	
	local x, y, w, h = box:getScreen();	
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = box:getSize( {"distance"} ); 
	local difW = distance.textWidth --default width
	local difH = distance.textHeight; --default height	
	local size = box.screen.size.zoomOutIn.text[1];	
	local difSize = 0.0015;
	
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local overlayVehiclesGroup = nil;
	local overlayVehiclesByName = nil;	
	if g_currentMission.hlUtils.overlays["LS_Vehicles"] ~= nil then
		overlayVehiclesGroup = g_currentMission.hlUtils.overlays["LS_Vehicles"]["vehicles"];
		overlayVehiclesByName = g_currentMission.hlUtils.overlays.byName["LS_Vehicles"]["vehicles"];		
	end;
	local overlay = nil;
	local tempOverlay = nil;
	local typesOverlay = nil;
	local bgRound = overlayDefaultGroup[overlayDefaultByName["bgRound"]];
	local bgFront = overlayDefaultGroup[overlayDefaultByName["bgFront"]];
	local bgMiddle = overlayDefaultGroup[overlayDefaultByName["bgMiddle"]];
	local bgBack = overlayDefaultGroup[overlayDefaultByName["bgBack"]];
	
	function needsUpdate()		
		if box.needsUpdate or box.ownTable.lineHeight == nil then			
			box.ownTable.lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;
			box.ownTable.iconWidth, box.ownTable.iconHeight = box:getOptiWidthHeight( {typ="icon", height=box.ownTable.lineHeight-distance.textLine-(difH), width=w-(difW*2)} );
			box.ownTable.maxIconWidth = g_currentMission.hlUtils.getMaxIconWidth(w-(difW*2)-(box.ownTable.iconWidth*2), box.ownTable.iconWidth*1.15);
			VehicleInspector_DisplaySetGet:resetBounds(box);
		end;		
		box.needsUpdate = false;
	end;	
	needsUpdate();
	
	if not g_currentMission.hlUtils.isMouseCursor then box.isSetting = false;end;
	
	if box.ownTable.bounds[1] <= 0 then VehicleInspector_DisplaySetGet:generateBounds(box);end;
	
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local iconColor = nil;
	local iconWidth = box.ownTable.iconWidth;
	local iconHeight = box.ownTable.iconHeight;
	local iconWidthS = iconWidth/1.3;
	local iconHeightS = iconHeight/1.3;
	local iconWidthBV = iconWidth*1.15;
	local iconHeightBV = iconHeight*1.15;
	local iconWidthB = iconWidth*1.3;
	local iconHeightB = iconHeight*1.3;
	local iconWidthT = iconWidth*1.5;
	local iconHeightT = iconHeight*1.5;
	local iconWidthV = iconWidth*1.8;
	local iconHeightV = iconHeight*1.8;
	
	local nextPosX = x+difW;
	local nextPosY = y;		
	local nextIconPosX = x+difW;
	local nextLeftPosX = nextPosX;
	local nextRightPosX = x+w-difW;
	nextPosY = nextPosY+(h)-(box.ownTable.lineHeight)-difH;
	
	VehicleInspector_DisplaySetGet:setViewVehiclesAllInBox(box);
	
	if VehicleInspector_DisplaySetGet.viewVehiclesAllInBox == nil then return;end;
	box.screen.bounds[4] = #VehicleInspector_DisplaySetGet.viewVehiclesAllInBox+2; -- +1 for Imaginäre Line, +1 for typIcons on/off
		
	if box.viewExtraLine then box.screen.bounds[4] = box.screen.bounds[4]+1;end;
	
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if box.isSetting and box.settingTyp == 1 and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			box:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	
	if box.screen.bounds[1] > 0 then
		------
		local camBox = g_currentMission.hlHudSystem.hlBox:getData("hlHudSystem_CameraBox");		
		local data = g_currentMission.hlHudSystem.camera.object; 
		local canNextView = true;
		local lineWidth = w-(difW*2);
		------
		--inIconArea Text--
		function getInIconArea(posX, posY, width, height)
			if not inArea then return false;end;
			overlay = box.overlays.bgLine; --hidden overlay
			if overlay ~= nil then
				g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width or lineWidth, height or box.ownTable.lineHeight);
				return overlay.mouseInArea();
			end;
			return false;
		end;
		--inIconArea Text--
		--warningLine--
		function setWarningLineIcon(posY)
			overlay = overlayDefaultGroup[overlayDefaultByName["right"]];
			g_currentMission.hlUtils.setOverlay(overlay, x+w-((iconWidth/1.5/2)), posY or nextPosY-0.003, iconWidth/1.5, iconHeight/1.5);
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
			local inIconArea = overlay.mouseInArea();			
			if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_viewNotAllIcons"), "Box"), 0);end; 
			if (g_currentMission.hlUtils.runsTimer("1sec", true) and g_currentMission.hlUtils.isMouseCursor) or (not g_currentMission.hlUtils.isMouseCursor) then
				overlay:render();
			end;
		end;
		--warningLine--
		--viewExtraLineSetting--
		function viewExtraLineSetting()
			if nextPosY < y then return;end;			
			local setWarningLine = false;
			local inIconArea = false;		
			if box.settingTyp == 1 then				
				if nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["settingExtension"]];					
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
						elseif box.guiMenu.show then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
						else
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						end;
						overlay:render();
						if inIconArea and box.isHelp then setInfoHelpText(g_i18n:getText("box_showGuiBox"));end; 				
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="settingGuiBox_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;
				else
					setWarningLine = true;
				end;
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUpDown"]];
					tempOverlay = box.overlays.bgLine;
					if overlay ~= nil and tempOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));end;
						overlay:render();
						if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_lineDistance"), string.format("%1.2f", box.screen.size.distance.textLine/box.screen.pixelH)));end;					
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="settingLineDistance_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;
				else
					setWarningLine = true;
				end;				
				if not setWarningLine and nextIconPosX+(iconWidthB*3) < x+w then
					local sizeText = tostring(" |S:"..string.format("%1.1f", size*1000));
					setTextColor(1, 1, 1, 1);
					renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sizeText));
					local textWidth = getTextWidth(size, utf8Substr(sizeText, 0));
					if box.isHelp and inArea and getInIconArea(nextIconPosX+difW, nil, textWidth) then setInfoHelpText(g_i18n:getText("box_settingSize"));end;
					nextIconPosX = nextIconPosX+textWidth+difW;
				else
					setWarningLine = true;
				end;															
			end;
			
			if setWarningLine then
				setWarningLineIcon();
			end;			
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLineSetting--
		--viewExtraLine--
		function viewExtraLine()
			if nextPosY < y then return;end;			
			local onOffTxt = g_i18n:getText("ui_on").. "/".. g_i18n:getText("ui_off");
			local setWarningLine = false;
			local inIconArea = false;			
			function setOverlay(whereClick, color, ownTable, blinking, setPosX, otherX, otherY, otherWidth, otherHeight)
				if color == nil then color = box.overlays.color.notActive;end;
				g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, otherY or nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);				
				inIconArea = overlay.mouseInArea();
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
				local dropIcon = false;
				if blinking ~= nil then
					if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
						dropIcon = true;
					end;
				else
					dropIcon = true;
				end;
				if dropIcon then overlay:render();end;				
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
				if setPosX == nil or setPosX then 
					if otherX ~= nil then 
						nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
					else
						nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
					end;
				end;
				iconColor = nil;				
			end;								
			if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["joinTypes"]];
				if overlay ~= nil then
					if box.ownTable.view.joinVehicles[1] > 1 then iconColor = box.overlays.color.on;end;
					setOverlay("settingModView_", iconColor, {view="joinVehicles"});
					if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_viewJoinVehicles"), 0);end;
				end;
			end;
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["contractor"]];
					if overlay ~= nil then
						local stateText = g_i18n:getText("defaultFarmName");
						if box.ownTable.view.contractor[1] == 2 then stateText = stateText.. "/".. g_i18n:getText("contractorFarm");iconColor = box.overlays.color.on;elseif box.ownTable.view.contractor[1] == 3 then stateText = g_i18n:getText("contractorFarm");iconColor = box.overlays.color.warning;end;									
						setOverlay("settingModView_", iconColor, {view="contractor"});
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("ui_mapHotspotFilter_vehicles").. ": ".. stateText);end;					
					end;
				else
					setWarningLine = true;
				end;
			end;
			if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["extraIcons"]];
				if overlay ~= nil then
					if box.ownTable.view.extraIcons[1] > 1 then iconColor = box.overlays.color.on;end;
					setOverlay("settingModView_", iconColor, {view="extraIcons"}, nil, nil, nil, nil, iconWidthBV, iconHeightBV);
					if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("ui_details").. "-".. g_i18n:getText("ui_statisticViewVehicleSelection").. "/".. g_i18n:getText("input_MOTOR_STATE_ON").. "/".. g_i18n:getText("infohud_damage").. "/... (".. onOffTxt.. ")", 0);end;
				end;
			end;
			if box.ownTable.view.extraIcons[1] > 1 then
				if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["statistic"]];
					if overlay ~= nil then
						if box.ownTable.view.statisticIcon[1] > 1 then iconColor = box.overlays.color.columText1;end;
						setOverlay("settingModView_", iconColor, {view="statisticIcon"}, nil, nil, nil, nextPosY+0.0015);
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("ui_statistic").. "-".. g_i18n:getText("ui_statisticViewVehicleSelection").. " ".. onOffTxt, 0);end;
					end;					
				else
					setWarningLine = true;
				end;
				if not setWarningLine and nextIconPosX+iconWidthB < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["fuel"]];
					if overlay ~= nil then
						if box.ownTable.view.fuelIcon[1] > 1 then iconColor = box.overlays.color.columText1;end;
						setOverlay("settingModView_", iconColor, {view="fuelIcon"}, nil, nil, nil, nil, iconWidthB, iconHeightB);
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("warning_motorFuelEmpty"), 0);end;
					end;					
				else
					setWarningLine = true;
				end;
				if not setWarningLine and nextIconPosX+iconWidthB < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["damage"]];
					if overlay ~= nil then
						if box.ownTable.view.damageIcon[1] > 1 then iconColor = box.overlays.color.columText1;end;
						setOverlay("settingModView_", iconColor, {view="damageIcon"}, nil, nil, nil, nil, iconWidthB, iconHeightB);
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("infohud_damage"), 0);end;
					end;					
				else
					setWarningLine = true;
				end;
				if not setWarningLine and nextIconPosX+iconWidthBV < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["engine"]];
					if overlay ~= nil then
						if box.ownTable.view.engineIcon[1] > 1 then iconColor = box.overlays.color.columText1;end;
						setOverlay("settingModView_", iconColor, {view="engineIcon"}, nil, nil, nil, nil, iconWidthBV, iconHeightBV);
						if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("input_MOTOR_STATE_ON").. " (".. g_i18n:getText("setting_automaticMotorStart").. " ! ".. g_i18n:getText("ui_off").. "?)", 0);end;
					end;					
				else
					setWarningLine = true;
				end;
			end;						
			if box.isHelp then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["infos"]];
					if overlay ~= nil then					
						setOverlay(nil, box.overlays.color.title); 				
						if inIconArea then setInfoHelpText(g_i18n:getText("box_clickInfos"), 0);end;
					end;					
				else
					setWarningLine = true;
				end;
			end;
			if setWarningLine then
				setWarningLineIcon();
			end;
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLine--
		if box.viewExtraLine and not box.isSetting then viewExtraLine();elseif box.viewExtraLine and box.isSetting then viewExtraLineSetting();end;
		
		--box lines--
		local isColorByControlled = false;
		local isTypIconsLine = false;
		local inTypIconArea = "";
		local color = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);		
		local textColor = nil;
		local viewDetailsColor = g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true);
		local bounds1 = box.screen.bounds[1];
		local bounds2 = box.screen.bounds[2];
		for t=bounds1, bounds2 do			
			isColorByControlled = false;
			overlay = nil;						
			local vehicle = nil;
			local line = nil;
			local text = "";
			if nextPosY < y then break;end;
			
			local canNextView = true;
			local lineWidth = w-(difW*2);
			
			local isNextPosY = false;
			function setNextPosY()
				if isNextPosY then					
					nextPosY = nextPosY-box.ownTable.lineHeight;							
					lineWidth = w-(difW*2);
					nextLeftPosX = x+difW;				
					nextRightPosX = x+w-difW;
					canNextView = true;
					isNextPosY = false;
				end;
			end;
			
			local isDrawJoinLine = false;			
			function setTypIconsLine()
				isTypIconsLine = true;
				local maxIconWidth = box.ownTable.maxIconWidth;
				if maxIconWidth < #box.ownTable.typIcon then 
					local canBounds = true;
					overlay = overlayDefaultGroup[overlayDefaultByName["left"]];
					g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, iconWidth, iconHeight);
					iconColor = box.overlays.color.text;
					if box.ownTable.bounds[1] <= 1 then iconColor = box.overlays.color.off;canBounds = false;end;
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));					
					overlay:render();
					local inIconArea = canBounds and inArea and overlay.mouseInArea();								
					if canBounds and not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="typIconLineBounds_", ownTable={"left"}} );end;
					canBounds = true;
					nextLeftPosX = nextLeftPosX+iconWidth+difW;
					nextRightPosX = nextRightPosX-iconWidth;
					overlay = overlayDefaultGroup[overlayDefaultByName["right"]];					
					g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX, nextPosY, iconWidth, iconHeight);
					iconColor = box.overlays.color.text;
					if box.ownTable.bounds[2] >= box.ownTable.bounds[4] then iconColor = box.overlays.color.off;canBounds = false;end;
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));					
					overlay:render();
					inIconArea = canBounds and inArea and overlay.mouseInArea();								
					if canBounds and not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="typIconLineBounds_", ownTable={"right"}} );end;
					nextRightPosX = nextRightPosX-difW;
					isNextPosY = true; 
				end;				
				tempOverlay = overlayDefaultGroup[overlayDefaultByName["joinvehicles"]];
				local typIconBounds1 = box.ownTable.bounds[1];
				local typIconBounds2 = box.ownTable.bounds[2];
				for i=typIconBounds1, typIconBounds2 do
					if box.ownTable.typIcon[i] ~= nil then
						if canNextView then
							local typIconName = box.ownTable.typIcon[i].name;
							typesOverlay = overlayDefaultGroup[overlayDefaultByName[typIconName]];
							g_currentMission.hlUtils.setOverlay(typesOverlay, nextLeftPosX, nextPosY-difH, iconWidthBV, iconHeightBV);							
							local total = box.ownTable.viewTyp[typIconName][4].total;
							----							
							local inJoinArea = false;							
							if box.ownTable.view.joinVehicles[1] > 1 and nextPosY-box.ownTable.lineHeight > y then 
								local canEnterable = true;								
								if typIconName == "implement_conveyorbelt" or typIconName == "handtoolmower" then canEnterable = false;end;
								isDrawJoinLine = true;
								g_currentMission.hlUtils.setOverlay(tempOverlay, nextLeftPosX, nextPosY-box.ownTable.lineHeight, iconWidthBV, iconHeightBV);
								inJoinArea = inArea and tempOverlay.mouseInArea();
								if not canEnterable then iconColor = box.overlays.color.off;elseif inJoinArea then iconColor = box.overlays.color.inArea;else iconColor = box.overlays.color.text;end;
								g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(iconColor, true));
								if canEnterable then tempOverlay:render();end;
								if canEnterable and box.isHelp and inJoinArea then setInfoHelpText("Join ".. g_i18n:getText("ui_mapHotspotFilter_vehicles").. " Typ: ".. tostring(typIconName).. " (Forward/Back)");end;
								if canEnterable and not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inJoinArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","right"}} );end;
								if total > 0 and canEnterable and not g_currentMission.hlUtils:disableInArea() and inJoinArea then box:setClickArea( {tempOverlay.x, tempOverlay.x+tempOverlay.width, tempOverlay.y, tempOverlay.y+tempOverlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="typJoin_", ownTable={typ=i}} );end;
							end;
							----
							if inJoinArea then
								iconColor = box.overlays.color.inArea;
							elseif box.ownTable.viewTyp[typIconName][1] > 1 then
								iconColor = box.overlays.color.on;
							else
								iconColor = box.overlays.color.notActive;
							end;
							g_currentMission.hlUtils.setBackgroundColor(typesOverlay, g_currentMission.hlUtils.getColor(iconColor, true));
							typesOverlay:render();
							local inIconArea = inArea and typesOverlay.mouseInArea();							
							textColor = box.overlays.color.text;
							local mouseAccepts = {"left","right"};
							if total > 0 and box.ownTable.viewTyp[typIconName][1] > 1 and inJoinArea or inIconArea then	inTypIconArea = typIconName;end;
							if total > 0 then	
								if inIconArea then textColor = "ls15";else textColor = "ls22";end;
								mouseAccepts = {"left","middle","right"};
							else
								total = "-";
							end;
							setTextBold(true);
							setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
							setTextAlignment(RenderText.ALIGN_CENTER);							
							renderText(typesOverlay.x+(typesOverlay.width/2), typesOverlay.y+typesOverlay.height-0.0015, size/2, tostring(total));					
							setTextColor(1, 1, 1, 1);
							setTextAlignment(0);
							setTextBold(false);
							if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("ui_mapHotspotFilter_vehicles").. " Typ: ".. tostring(typIconName).. " (".. tostring(total).. ")");end;
							if not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse=mouseAccepts} );end;
							if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {typesOverlay.x, typesOverlay.x+typesOverlay.width, typesOverlay.y, typesOverlay.y+typesOverlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="typIcon_", ownTable={typ=i}} );end;
							nextLeftPosX = nextLeftPosX+iconWidthBV+(difW);
							canNextView = nextLeftPosX+iconWidthBV <= nextRightPosX;
							isNextPosY = true;						
						end;
					end;
				end;				
			end;
			if not isTypIconsLine then setTypIconsLine();setNextPosY();if isDrawJoinLine then isNextPosY=true;setNextPosY();end;end;
			
			function setGroupIcon(iconPosX, double)				
				overlay = bgRound;				
				tempOverlay = overlayDefaultGroup[overlayDefaultByName["groups"]];
				if double then
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB)-(iconHeightB/2), iconWidthB/2, iconHeightB/2);
				else
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB/2)-(iconHeightB/4), iconWidthB/2, iconHeightB/2);					
				end;
				overlay:render();				
				if line.vmIsGroup and not line.vmViewGroup then iconColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.isGroup, true);else iconColor = g_currentMission.hlUtils.getColor(box.ownTable.showColors.viewGroup, true, nil, 0.90);end;
				g_currentMission.hlUtils.setOverlay(tempOverlay, overlay.x, overlay.y, iconWidthB/2, iconHeightB/2);	
				g_currentMission.hlUtils.setBackgroundColor(tempOverlay, iconColor);
				tempOverlay:render();				
			end;
			function setLeasingIcon(iconPosX, double)				
				overlay = bgRound;				
				if double then
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH, iconWidthB/2, iconHeightB/2);
				else
					g_currentMission.hlUtils.setOverlay(overlay, iconPosX, nextPosY-difH+(iconHeightB/2)-(iconHeightB/4), iconWidthB/2, iconHeightB/2);							
				end;
				overlay:render();
				if box.ownTable.view.leasing[1] == 2 then
					tempOverlay = overlayDefaultGroup[overlayDefaultByName["leasing_icon"]];
				else
					tempOverlay = overlayDefaultGroup[overlayDefaultByName["leasing_text"]];
				end;
				if tempOverlay ~= nil then
					if line.isMissionLeasing then iconColor = box.ownTable.showColors.missionsLeasing;else iconColor = box.ownTable.showColors.leasing;end;
					g_currentMission.hlUtils.setOverlay(tempOverlay, overlay.x, overlay.y, iconWidthB/2, iconHeightB/2);
					g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(iconColor, true));
					tempOverlay:render();
				else
					optiSize = g_currentMission.hlUtils.optiHeightSize(iconHeightS, "L", size-difSize);
					textColor = box.ownTable.showColors.leasing;
					if line.isMissionLeasing then textColor = box.ownTable.showColors.missionsLeasing;end;
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
					setTextAlignment(RenderText.ALIGN_CENTER);
					renderText(overlay.x+(overlay.width/2), overlay.y+(difH/2), optiSize, tostring("L"));
					setTextAlignment(0);
					setTextColor(1, 1, 1, 1);
				end;
			end;			
			function setVehicleIcon()
				if box.ownTable.view.vehicleIcon[1] > 1 then
					--g_currentMission.hlUtils.setOverlay(bgRound, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					--bgRound:render();
					if box.ownTable.view.vehicleIcon[1] == 3 and overlayVehiclesGroup ~= nil and not line.isTrain and vehicle.viStoreName ~= nil then
						overlay = overlayVehiclesGroup[overlayVehiclesByName[vehicle.viStoreName]];
						if overlay ~= nil then							
							g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX-(difW*1.9), nextPosY-difH, iconWidthV, iconHeightV);							
							overlay:render();
							lineWidth = lineWidth-iconWidthB-(difW*1.9);
							nextLeftPosX = nextLeftPosX+iconWidthB+(difW*1.9);
						end;
					else
						tempOverlay = nil;
						local typIcon = vehicle.viTypIcon;
						if line.frontloaderAttached then typIcon = "tractor_frontloader";end;
						overlay = overlayDefaultGroup[overlayDefaultByName[typIcon]];						
						if box.ownTable.view.frontloaderReady[1] > 1 and line.hasFrontloader and not line.frontloaderAttached then tempOverlay = overlayDefaultGroup[overlayDefaultByName["isFrontloader"]];end;						
						if overlay == nil then overlay = overlayDefaultGroup[overlayDefaultByName["tractor_other"]];end;
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY-(difH*1.5), iconWidthT, iconHeightT);
							if tempOverlay ~= nil then g_currentMission.hlUtils.setOverlay(tempOverlay, nextLeftPosX, nextPosY-(difH*1.5), iconWidthT, iconHeightT);end;
							if line.isPlayer then
								iconColor = box.ownTable.showColors.playerControlled; 
							elseif line.isOtherPlayer then
								iconColor = box.ownTable.showColors.otherControlled;
							elseif line.isHelper then
								iconColor = box.ownTable.showColors.helperControlled;
							else
								iconColor = box.overlays.color.notActive;
							end;
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));							
							overlay:render();
							if tempOverlay ~= nil then
								if not line.isFrontloader then g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor("orange", true));else g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor("khaki", true));end;
								tempOverlay:render();
							end;
							isColorByControlled = true;
							lineWidth = lineWidth-iconWidthT-difW;
							nextLeftPosX = nextLeftPosX+iconWidthT+difW;
						end;
					end;
					if overlay ~= nil then						
						canNextView = lineWidth > iconWidth;
						isNextPosY = true;
					end;
				end;
			end;
			function setVehicleName()
				if box.ownTable.view.vehicleName[1] > 1 then
					local maxIconWidth = box.ownTable.length.vehicleName[1];
					local vehicleName = tostring(line.vehicleName); --or storeName !					
					if lineWidth < iconWidthB*(maxIconWidth+1) then return true;end;
					optiSize = g_currentMission.hlUtils.optiHeightSize(iconHeightB, vehicleName, size-difSize);
					g_currentMission.hlUtils.setOverlay(bgFront, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					bgFront:render();				
					nextLeftPosX = nextLeftPosX+(iconWidthB/2);
					local iconPosX = nextLeftPosX;
					for a=1, maxIconWidth do						
						g_currentMission.hlUtils.setOverlay(bgMiddle, iconPosX, nextPosY-difH, iconWidthB, iconHeightB);
						bgMiddle:render();
						iconPosX = iconPosX+iconWidthB;	
					end;					
					g_currentMission.hlUtils.setOverlay(bgBack, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
					bgBack:render();					
					iconPosX = iconPosX+(iconWidthB/2);										
					if box.ownTable.view.vehicleIcon[1] == 1 or box.ownTable.view.vehicleIcon[1] == 3 then
						if line.isPlayer then
							textColor = box.ownTable.showColors.playerControlled;
						elseif line.isOtherPlayer then
							textColor = box.ownTable.showColors.otherControlled;
						elseif line.isHelper then
							textColor = box.ownTable.showColors.helperControlled;
						else
							textColor = box.overlays.color.text;
						end;
					else
						textColor = box.overlays.color.text;
					end;
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(vehicleName), optiSize-difSize, iconWidthB*maxIconWidth-(iconWidthB/1.2), false, ".");
					setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
					renderText(nextLeftPosX, nextPosY+difH, optiSize, tostring(text));
					setTextColor(1, 1, 1, 1);
					if box.ownTable.view.group[1] > 1 and line.vmIsGroup then
						setGroupIcon(iconPosX-(iconWidthB/2)+(difW/2), box.ownTable.view.leasing[1] > 1 and line.isLeasing, false);
					end;
					if box.ownTable.view.leasing[1] > 1 and line.isLeasing then						
						--setLeasingIcon(nextLeftPosX-(iconWidthB/2)-(difW/2), box.ownTable.view.group[1] > 1 and line.vmIsGroup, false);
						setLeasingIcon(iconPosX-(iconWidthB/2)+(difW/2), box.ownTable.view.group[1] > 1 and line.vmIsGroup, false);
					end;
					lineWidth = lineWidth-(iconWidthB*(maxIconWidth+1))-difW;
					nextLeftPosX = iconPosX+difW;
					canNextView = lineWidth > iconWidth;
					isNextPosY = true;
					isColorByControlled = true;								
				end;
				return false;
			end;
			function setExtraIcons()
				local maxIconWidth = 0;
				if box.ownTable.view.engineIcon[1] > 1 then maxIconWidth = maxIconWidth+1;end;
				if box.ownTable.view.statisticIcon[1] > 1 then maxIconWidth = maxIconWidth+1;end;
				if box.ownTable.view.damageIcon[1] > 1 then maxIconWidth = maxIconWidth+1;end;
				if box.ownTable.view.fuelIcon[1] > 1 then maxIconWidth = maxIconWidth+1;end;
				if maxIconWidth <= 0 then return false;end;
				if lineWidth < iconWidthB*(maxIconWidth+1) then return true;end;
				g_currentMission.hlUtils.setOverlay(bgFront, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
				bgFront:render();				
				nextLeftPosX = nextLeftPosX+(iconWidthB/2);
				local iconPosX = nextLeftPosX;
				local extraIconPosX = {};
				--function setCourseIcon()
				--	if not line.isOtherPlayer and not line.isTrain and not line.isHorse then						
				--		overlay = overlayDefaultGroup[overlayDefaultByName["fuel"]];
				--		if overlay ~= nil then
				--			g_currentMission.hlUtils.setOverlay(overlay, extraIconPosX[1], nextPosY+(difH/2), iconWidth, iconHeight);
				--			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
				--			overlay:render();							
				--		end;						
				--	end;
				--	table.remove(extraIconPosX, 1);
				--end;
				function setStatisticIcon()
					local canClickArea = line.ownerFarmId and not line.isMissionLeasing and not line.isTrain and not line.isHorse; -- and not g_currentMission.hlUtils.isControlledVehicle();					
					--local markerMod = VehicleInspector.otherMods.vehicleStatisticMarker or VehicleInspector.otherMods.allRoundExtension;					
					local controlled = {line.isPlayer,line.isOtherPlayer,line.isHelper}
					local dropIcon = true; --line.isPlayer and not line.isOtherPlayer and not line.isHelper;
					if dropIcon then						
						overlay = overlayDefaultGroup[overlayDefaultByName["statistic"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, extraIconPosX[1], nextPosY+(difH/2), iconWidth, iconHeight);
							local inIconArea = false;
							if canClickArea then
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true));
								inIconArea = inArea and overlay.mouseInArea();
							else
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
							end;							
							overlay:render();
							if canClickArea then
								if VehicleInspector.values.hiddenFunctions > 1 and not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then 
									local mouseAccepts = {"left","middle","right"};
									if line.isOtherPlayer or line.isHelper then mouseAccepts = {"left"};end;
									g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse=mouseAccepts} );
								end;
								if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="statisticIcon_", ownTable={vehicleNode=line.node,attached=line.attached,controlled=controlled}} );end;
							end;
						end;						
					end;					
					table.remove(extraIconPosX, 1);
				end;
				function setFuelIcon()
					if not line.isPlayer and line.fuelInfo ~= nil then						
						overlay = overlayDefaultGroup[overlayDefaultByName["fuel"]];
						if line.fuelInfo[3] ~= nil then
							if line.fuelInfo[3] == FillType.ELECTRICCHARGE then overlay = overlayDefaultGroup[overlayDefaultByName["fuelCharge"]];elseif line.fuelInfo[3] == FillType.METHANE then overlay = overlayDefaultGroup[overlayDefaultByName["fuelMethan"]];end;
						end;
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, extraIconPosX[1], nextPosY, iconWidthBV, iconHeightBV);
							local inIconArea = false;
							if line.fuelInfo[1] then 
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.damage, true));
								inIconArea = inArea and overlay.mouseInArea();
							elseif line.fuelInfo[2] ~= nil then
								local pColor = g_currentMission.hlUtils.getProzentColor(line.fuelInfo[2], true);
								if pColor == 1 then pColor = 2;end;
								pColor = g_currentMission.hlUtils.getColorProzent(pColor, true);
								g_currentMission.hlUtils.setBackgroundColor(overlay, pColor);
								inIconArea = inArea and overlay.mouseInArea();
							else	
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
							end;
							overlay:render();
							if inIconArea then setInfoHelpText(tostring(line.fuelInfo[2]).. "%");end; 
						end;						
					end;
					table.remove(extraIconPosX, 1);
				end;
				function setDamageIcon()
					if not line.isPlayer and line.damageInfo ~= nil then						
						overlay = overlayDefaultGroup[overlayDefaultByName["damage"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, extraIconPosX[1], nextPosY, iconWidthBV, iconHeightBV);
							local inIconArea = false;
							if line.damageInfo[1] then 
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.fuelEmpty, true));
								inIconArea = inArea and overlay.mouseInArea();
							elseif line.damageInfo[2] ~= nil then
								local pColor = g_currentMission.hlUtils.getProzentColor(line.damageInfo[2], true);
								if pColor == 1 then pColor = 2;end;
								pColor = g_currentMission.hlUtils.getColorProzent(pColor, true);
								g_currentMission.hlUtils.setBackgroundColor(overlay, pColor);
								inIconArea = inArea and overlay.mouseInArea();
							else
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
							end;
							overlay:render();
							if inIconArea then setInfoHelpText(tostring(line.damageInfo[2]).. "%");end; 
						end;						
					end;
					table.remove(extraIconPosX, 1);
				end;
				function setEngineIcon()
					if line.hasEngine and not line.isPlayer and not line.isOtherPlayer and not line.isHelper then						
						overlay = overlayDefaultGroup[overlayDefaultByName["engine"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, extraIconPosX[1], nextPosY, iconWidthBV, iconHeightBV);
							if line.isEngine then
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
							else
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
							end;
							overlay:render();							
						end;						
					end;
					table.remove(extraIconPosX, 1);
				end;
				for a=1, maxIconWidth do						
					g_currentMission.hlUtils.setOverlay(bgMiddle, iconPosX, nextPosY-difH, iconWidthB, iconHeightB);
					bgMiddle:render();
					table.insert(extraIconPosX, iconPosX);
					iconPosX = iconPosX+iconWidthB;	
				end;
				if box.ownTable.view.statisticIcon[1] > 1 and #extraIconPosX > 0 then setStatisticIcon();end;
				if box.ownTable.view.fuelIcon[1] > 1 and #extraIconPosX > 0 then setFuelIcon();end;
				if box.ownTable.view.damageIcon[1] > 1 and #extraIconPosX > 0 then setDamageIcon();end;
				if box.ownTable.view.engineIcon[1] > 1 and #extraIconPosX > 0 then setEngineIcon();end;				
				g_currentMission.hlUtils.setOverlay(bgBack, iconPosX-(iconWidthB/2), nextPosY-difH, iconWidthB, iconHeightB);
				bgBack:render();					
				iconPosX = iconPosX+(iconWidthB/2);
				
				lineWidth = lineWidth-(iconWidthB*(maxIconWidth+1))-difW;
				nextLeftPosX = iconPosX+difW;
				canNextView = lineWidth > iconWidth;
				isNextPosY = true;
				
				return false;
			end;
			function setCameraOnInfo(ownerFarmId) --last is free
				if nextRightPosX-iconWidthS-(difW) >= nextLeftPosX then
					if camBox ~= nil and camBox.show and data ~= nil and data.isVehicle and data.node == line.node then
						overlay = overlayDefaultGroup[overlayDefaultByName["camera"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidthS-(difW), nextPosY+(difH), iconWidthS, iconHeightS);
							if ownerFarmId then
								iconColor = box.ownTable.showColors.camera;
							else
								iconColor = box.ownTable.showColors.contractor;
							end;
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));
							overlay:render();
							nextRightPosX = nextRightPosX-iconWidthS-difW;
							return true;
						end;
					end;
					return false;
				end;
				return nil;
			end;
			function setContractorIcon()
				if nextRightPosX-iconWidthS-(difW) >= nextLeftPosX then
					overlay = overlayDefaultGroup[overlayDefaultByName["contractor"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidthS-(difW), nextPosY+(difH), iconWidthS, iconHeightS);
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.contractor, true));
						overlay:render();
						nextRightPosX = nextRightPosX-iconWidthS-difW;
					end;
				end;
			end;			
			local setWarningWidth = false;
			if VehicleInspector_DisplaySetGet.viewVehiclesAllInBox[t] ~= nil then
				line = VehicleInspector_DisplaySetGet.viewVehiclesAllInBox[t];				
				if canNextView then
					if nextPosY > y then						
						vehicle = g_currentMission.nodeToObject[line.node];									
						if vehicle ~= nil then							
							if inTypIconArea:len() > 0 then
								local typIcon = vehicle.viTypIcon;
								if line.frontloaderAttached then typIcon = "tractor_frontloader";end;
								if line.isTrain or line.isHorse then typIcon = "miscvehicles";end;
								if inTypIconArea == typIcon then
									overlay = overlayDefaultGroup[overlayDefaultByName["bgByTyp"]];
									g_currentMission.hlUtils.setOverlay(overlay, x, nextPosY-difH, w, box.ownTable.lineHeight);
									overlay:render();
								end;
							end;
							--vehicle icon--
							if canNextView then setVehicleIcon();end;	
							--vehicle icon--
							--vehicle name--
							if canNextView then setWarningWidth = setVehicleName();else setWarningWidth = true;end;							
							--vehicle name--
							--vehicle join line--
							overlay = box.overlays.bgLine;
							if overlay ~= nil and inArea then
								--g_currentMission.hlUtils.setOverlay(overlay, x+difW, nextPosY, x+w-difW, box.ownTable.lineHeight); 
								g_currentMission.hlUtils.setOverlay(overlay, x+difW, nextPosY, nextLeftPosX-x, box.ownTable.lineHeight);
								local inIconArea = overlay.mouseInArea();								
								if box.ownTable.view["vorschauVehicles"][1] > 1 then
									if not g_currentMission.hlUtils:disableInArea() and inIconArea then VehicleInspector_DrawPreviewData:setVehiclesOpen( {node=line.node, isTrain=line.isTrain, isHorse=line.isHorse}, true);end;
								end;
								if not box.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inIconArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","right"}} );end;
								if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleInspector_Display_MouseKeyEventsAllInBox.onClickArea, whatClick="VehicleInspector_Display_AllInBox", typPos=boxNumber, whereClick="vehicleLine_", ownTable={vehicleNode=line.node}} );end;
							end;
							--vehicle join line--
							--extra icons--
							if box.ownTable.view.extraIcons[1] > 1 then
								if canNextView then 
									setWarningWidth = setExtraIcons();
								else 
									setWarningWidth = true;
								end;
							end;
							--extra icons--
							--camera on icon--
							local isDrawCam = setCameraOnInfo(line.ownerFarmId);
							--camer on icon--
							--contractor icon--
							if not line.ownerFarmId and isDrawCam ~= nil and not isDrawCam then setContractorIcon();end;
							--contractor icon--							
						else
							text = g_currentMission.hlUtils.getTxtToWidth("Ghost Vehicle", size, lineWidth, false, ".");
							setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)));
							renderText(nextLeftPosX, nextPosY, size, tostring(text));					
							setTextColor(1, 1, 1, 1);
							isNextPosY = true;
						end;
						
						------
						setNextPosY();
						------	
					else
						break;
					end;
				end;
			else
			
			end;
			if setWarningWidth then setWarningLineIcon(y+(h/2));end;
		end;
		--box lines--
	end;
end;