viSetGetSettingsXml = {};

function viSetGetSettingsXml:loadConfig()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(VehicleInspector.settingsDir);
	local file = VehicleInspector.settingsDir.. "vehicleInspectorSettings.xml";
	if not fileExists(file) then
		viSetGetSettingsXml:saveConfig();
	else
		local Xml = loadXMLFile("VehicleInspector_XML", file, "vehicleInspectorSettings");
				
		local groupNameTag = ("vehicleInspectorSettings.global(%d)"):format(0);
		
		if getXMLBool(Xml, groupNameTag.. "#hlDebugMode") ~= nil then VehicleInspector.hlDebugMode = getXMLBool(Xml, groupNameTag.. "#hlDebugMode");end;
		--invert color fillTypes--
		viSetGetSettingsXml:loadSearchInvertConfig(Xml);
		--invert color fillTypes--
		--vehicle join own or contractor (over this Mod)--
		groupNameTag = ("vehicleInspectorSettings.global.otherValues.joinVehicles(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") ~= nil then VehicleInspector.values.joinVehicles = getXMLInt(Xml, groupNameTag.. "#int");end;		
		--vehicle join own or contractor (over this Mod)--
		groupNameTag = ("vehicleInspectorSettings.global.otherValues.functions(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") ~= nil then VehicleInspector.values.hiddenFunctions = getXMLInt(Xml, groupNameTag.. "#int");end;
		--otherData--	
		groupNameTag = ("vehicleInspectorSettings.global.otherDataValues(%d)"):format(0);
		for key, values in pairs (VehicleInspector.values.otherData) do
			if getXMLInt(Xml, groupNameTag.. "#".. tostring(key)) ~= nil then VehicleInspector.values.otherData[key].view[1] = getXMLInt(Xml, groupNameTag.. "#".. tostring(key));end;			
		end;
		--otherData--
		--previewData--	
		groupNameTag = ("vehicleInspectorSettings.global.previewDataValues(%d)"):format(0);
		for key, values in pairs (VehicleInspector.values.previewData) do
			if getXMLInt(Xml, groupNameTag.. "#".. tostring(key)) ~= nil then VehicleInspector.values.previewData[key].view[1] = getXMLInt(Xml, groupNameTag.. "#".. tostring(key));end;
			if getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "IconSize") ~= nil then VehicleInspector.values.previewData[key].iSize[1] = getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "IconSize");end;
			if getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "TextSize") ~= nil then VehicleInspector.values.previewData[key].tSize[1] = getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "TextSize");end;
			if getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "Position") ~= nil then VehicleInspector.values.previewData[key].pos[1] = getXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "Position");end;
			if getXMLString(Xml, groupNameTag.. "#".. tostring(key).. "Color") ~= nil then 
				local color = getXMLString(Xml, groupNameTag.. "#".. tostring(key).. "Color");
				if g_currentMission.hlUtils.colorIntern[color] ~= nil then VehicleInspector.values.previewData[key].color = color;end;
			end;
		end;
		viSetGet:loadUnlodSideOverlays();
		--previewData--
		--speciale--
		groupNameTag = ("vehicleInspectorSettings.global.speciale(%d)"):format(0);
		if SpeedControl ~= nil then
			if getXMLBool(Xml, groupNameTag.. "#speedControlVisibleOnDraw") ~= nil then SpeedControl.visibleOnDraw = getXMLBool(Xml, groupNameTag.. "#speedControlVisibleOnDraw");end;
			if getXMLBool(Xml, groupNameTag.. "#speedControlVisibleEventText") ~= nil then SpeedControl.visibleEventText = getXMLBool(Xml, groupNameTag.. "#speedControlVisibleEventText");if SpeedControl.visibleEventText then SpeedControl:setVisibleEventText(true);end;end; --SpeedControl
		end;
		if TrailerJointBlock ~= nil then
			if getXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleOnDraw") ~= nil then TrailerJointBlock.visibleOnDraw = getXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleOnDraw");end;
			if getXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleEventText") ~= nil then TrailerJointBlock.visibleEventText = getXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleEventText");if TrailerJointBlock.visibleEventText then TrailerJointBlock:setVisibleEventText(true);end;end; --TrailerJointBlock
		end;
		--speciale--
	end;	
end;

function viSetGetSettingsXml:saveConfig()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(VehicleInspector.settingsDir);
	local file = VehicleInspector.settingsDir.. "vehicleInspectorSettings.xml";
	local Xml = createXMLFile("VehicleInspector_XML", file, "vehicleInspectorSettings");
	local groupNameTag = ("vehicleInspectorSettings.global(%d)"):format(0);	
	setXMLBool(Xml, groupNameTag.. "#hlDebugMode", VehicleInspector.hlDebugMode);
	setXMLString(Xml, groupNameTag.."#WARNING", "NOT EDIT THIS XML OR VI CAN CRASH");
	--invert color fillTypes--
	local searchInvertTemp = ""
	for a=1, #VehicleInspector.values.searchInvert do
		if a == 1 then searchInvertTemp = tostring(VehicleInspector.values.searchInvert[a]); else searchInvertTemp = searchInvertTemp.. ",".. tostring(VehicleInspector.values.searchInvert[a]);end;
	end;	
	groupNameTag = ("vehicleInspectorSettings.global.otherValues.searchInvertColorByVehicleTypeName(%d)"):format(0);
	setXMLString(Xml, groupNameTag.. "#stringWithCommaSeparator", tostring(searchInvertTemp));
	--invert color fillTypes--
	--vehicle join own or contractor (over this Mod)--	
	groupNameTag = ("vehicleInspectorSettings.global.otherValues.joinVehicles(%d)"):format(0);
	setXMLInt(Xml, groupNameTag.. "#int", VehicleInspector.values.joinVehicles);	
	--vehicle join own or contractor (over this Mod)--
	groupNameTag = ("vehicleInspectorSettings.global.otherValues.functions(%d)"):format(0);
	setXMLInt(Xml, groupNameTag.. "#int", VehicleInspector.values.hiddenFunctions);
	--otherData--	
	groupNameTag = ("vehicleInspectorSettings.global.otherDataValues(%d)"):format(0);
	for key, values in pairs (VehicleInspector.values.otherData) do
		setXMLInt(Xml, groupNameTag.. "#".. tostring(key), values.view[1]);
	end;
	--otherData--
	--previewData--
	groupNameTag = ("vehicleInspectorSettings.global.previewDataValues(%d)"):format(0);
	for key, values in pairs (VehicleInspector.values.previewData) do
		setXMLInt(Xml, groupNameTag.. "#".. tostring(key), values.view[1]);
		if values.iSize ~= nil then setXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "IconSize", values.iSize[1]);end;
		if values.tSize ~= nil then setXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "TextSize", values.tSize[1]);end;
		if values.pos ~= nil then setXMLInt(Xml, groupNameTag.. "#".. tostring(key).. "Position", values.pos[1]);end;
		if values.color ~= nil then setXMLString(Xml, groupNameTag.. "#".. tostring(key).. "Color", values.color);end;
	end;
	--previewData--
	--speciale--
	groupNameTag = ("vehicleInspectorSettings.global.speciale(%d)"):format(0);
	if SpeedControl ~= nil then
		setXMLBool(Xml, groupNameTag.. "#speedControlVisibleOnDraw", SpeedControl.visibleOnDraw);
		setXMLBool(Xml, groupNameTag.. "#speedControlVisibleEventText", SpeedControl.visibleEventText);
	end;
	if TrailerJointBlock ~= nil then
		setXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleOnDraw", TrailerJointBlock.visibleOnDraw);
		setXMLBool(Xml, groupNameTag.. "#trailerJointBlockVisibleEventText", TrailerJointBlock.visibleEventText);
	end;
	--speciale--
	
	saveXMLFile(Xml);
end;

function viSetGetSettingsXml:loadSearchInvertConfig(Xml)
	local searchInvertTemp = "";		
	local groupNameTag = ("vehicleInspectorSettings.global.otherValues.searchInvertColorByVehicleTypeName(%d)"):format(0);
	if getXMLString(Xml, groupNameTag.. "#stringWithCommaSeparator") ~= nil then searchInvertTemp = getXMLString(Xml, groupNameTag.. "#stringWithCommaSeparator");end;
	local stringSplit = g_currentMission.hlUtils.stringSplit(searchInvertTemp, ",", true);
	if stringSplit ~= nil and #stringSplit > 0 then			
		for key,value in pairs(stringSplit) do				
			if string.len(stringSplit[key]) > 1 then
				local nameExists = viSetGet:isInvertFill(tostring(string.lower(stringSplit[key])))
				if not nameExists then table.insert(VehicleInspector.values.searchInvert, tostring(string.lower(stringSplit[key])));end;
			end;
		end;			
	end;
end;