--[[
Copyright (C) GtX (Andy), 2024

Author: GtX | Andy
Date: 09.12.2024
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS25 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Frei verwendbar (Nur LS25) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]

HandToolHPWLanceExtension = {}

HandToolHPWLanceExtension.MOD_NAME = g_currentModName
HandToolHPWLanceExtension.BASE_DIRECTORY = g_currentModDirectory
HandToolHPWLanceExtension.SPEC_NAME = string.format("spec_%s.highPressureWasherLanceExtension", HandToolHPWLanceExtension.MOD_NAME)

function HandToolHPWLanceExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(HandToolHPWLance, specializations)
end

function HandToolHPWLanceExtension.registerXMLPaths(schema)
    schema:setXMLSpecializationType("HandToolHPWLanceExtension")

    schema:register(XMLValueType.NODE_INDEX, "handTool.highPressureWasherLance.lance.handle#node", "Lance handle node")
    schema:register(XMLValueType.VECTOR_ROT, "handTool.highPressureWasherLance.lance.handle#rotationInactive", "Handle inactive rotation")
    schema:register(XMLValueType.VECTOR_ROT, "handTool.highPressureWasherLance.lance.handle#rotationActive", "Handle active rotation")

    schema:setXMLSpecializationType()
end

function HandToolHPWLanceExtension.registerEventListeners(handToolType)
    SpecializationUtil.registerEventListener(handToolType, "onLoad", HandToolHPWLanceExtension)
    SpecializationUtil.registerEventListener(handToolType, "onPostLoad", HandToolHPWLanceExtension)
    SpecializationUtil.registerEventListener(handToolType, "onPreUpdate", HandToolHPWLanceExtension)
end

function HandToolHPWLanceExtension.registerOverwrittenFunctions(handToolType)
    SpecializationUtil.registerOverwrittenFunction(handToolType, "setIsActivated", HandToolHPWLanceExtension.setIsActivated)
end

function HandToolHPWLanceExtension.registerFunctions(handToolType)
    SpecializationUtil.registerFunction(handToolType, "setHighPressureWasher", HandToolHPWLanceExtension.setHighPressureWasher)
    SpecializationUtil.registerFunction(handToolType, "getHighPressureWasher", HandToolHPWLanceExtension.getHighPressureWasher)
    SpecializationUtil.registerFunction(handToolType, "getBaseWashMultiplier", HandToolHPWLanceExtension.getBaseWashMultiplier)
end

function HandToolHPWLanceExtension:onLoad(savegame)
    local spec = self[HandToolHPWLanceExtension.SPEC_NAME]

    if self.isClient then
        local handleNode = self.xmlFile:getValue("handTool.highPressureWasherLance.lance.handle#node", nil, self.components, self.i3dMappings)

        if handleNode ~= nil then
            local rotationInactive = self.xmlFile:getValue("handTool.highPressureWasherLance.lance.handle#rotationInactive", {getRotation(handleNode)}, true)
            local rotationActive = self.xmlFile:getValue("handTool.highPressureWasherLance.lance.handle#rotationActive", rotationInactive, true)

            spec.handle = {
                node = handleNode,
                rotationInactive = rotationInactive,
                rotationActive = rotationActive
            }

            setRotation(handleNode, rotationInactive[1], rotationInactive[2], rotationInactive[3])
        end
    end

    spec.baseWashMultiplier = 3
end

function HandToolHPWLanceExtension:onPostLoad(savegame)
    local lanceSpec = self.spec_highPressureWasherLance

    if lanceSpec ~= nil then
        self[HandToolHPWLanceExtension.SPEC_NAME].baseWashMultiplier = lanceSpec.washMultiplier
        lanceSpec.pricePerSecond = 0
    end
end

function HandToolHPWLanceExtension:onPreUpdate(dt)
    if self.isServer then
        local carryingPlayer = self:getCarryingPlayer()

        if carryingPlayer == nil then
            return
        end

        local lanceSpec = self.spec_highPressureWasherLance

        if lanceSpec ~= nil then
            local spec = self[HandToolHPWLanceExtension.SPEC_NAME]

            if spec.highPressureWasher ~= nil then
                lanceSpec.washMultiplier = spec.highPressureWasher:updatePressureWasherConsumers(dt, lanceSpec.isActivated, spec.baseWashMultiplier or 3)
            end
        end
    end
end

function HandToolHPWLanceExtension:setHighPressureWasher(highPressureWasher)
    local spec = self[HandToolHPWLanceExtension.SPEC_NAME]

    if highPressureWasher ~= nil and highPressureWasher.updatePressureWasherConsumers == nil then
        highPressureWasher = nil
    end

    if highPressureWasher == nil then
        local lanceSpec = self.spec_highPressureWasherLance

        if lanceSpec ~= nil then
            lanceSpec.washMultiplier = spec.baseWashMultiplier or 3
        end
    end

    spec.highPressureWasher = highPressureWasher
end

function HandToolHPWLanceExtension:getHighPressureWasher()
    return self[HandToolHPWLanceExtension.SPEC_NAME].highPressureWasher
end

function HandToolHPWLanceExtension:getBaseWashMultiplier()
    return self[HandToolHPWLanceExtension.SPEC_NAME].baseWashMultiplier
end

function HandToolHPWLanceExtension:setIsActivated(superFunc, isActivated)
    local spec = self[HandToolHPWLanceExtension.SPEC_NAME]
    local highPressureWasher = spec.highPressureWasher

    if isActivated and self.carryingPlayer ~= nil and self.carryingPlayer.isOwner then
        if highPressureWasher ~= nil then
            local canRun, warning = highPressureWasher:getCanPressureWasherRun(true)

            if not canRun then
                if not string.isNilOrWhitespace(warning) then
                    g_currentMission:showBlinkingWarning(warning, 2000)
                end

                isActivated = false
            end
        end
    end

    if isActivated ~= self.spec_highPressureWasherLance.isActivated then
        if self.isClient then
            local handle = spec.handle

            if handle ~= nil then
                if isActivated then
                    setRotation(handle.node, handle.rotationActive[1], handle.rotationActive[2], handle.rotationActive[3])
                else
                    setRotation(handle.node, handle.rotationInactive[1], handle.rotationInactive[2], handle.rotationInactive[3])
                end
            end
        end

        -- Fix base game bug as of v1.4.0.0 and lower for dedicated servers where clients do not see effects when lance is used.
        if g_dedicatedServer ~= nil and g_server ~= nil and HandToolHPWLanceExtensionEvent ~= nil then
            local connection = nil

            if self.carryingPlayer ~= nil then
                connection = self.carryingPlayer:getOwnerConnection()
            end

            g_server:broadcastEvent(HandToolHPWLanceExtensionEvent.new(self, isActivated), false, connection, self)
        end
    end

    superFunc(self, isActivated)

    if highPressureWasher ~= nil then
        highPressureWasher:setPressureWasherIsWashing(isActivated)
    end
end
