-- Desabilita a rolagem para todas as culturas originais do FS25
-- Compatível com Precision Farming

NoNeedToRoll = {}

function NoNeedToRoll.disableRollingForFruits()
    -- Lista de culturas do FS25 que NÃO precisam mais rolagem
    local excludedFruitTypes = {
        "wheat", "barley", "canola", "oat", "sorghum", "maize", "sunflower",
        "soybean", "potato", "sugarBeet", "sugarcane", "cotton", "grass", "spinach", "rice", "poplar", "oilseedRadish"
    }

    for _, fruitName in ipairs(excludedFruitTypes) do
        local fruitType = g_fruitTypeManager:getFruitTypeByName(fruitName)
        if fruitType ~= nil then
            fruitType.needsRolling = false
            print(string.format("[NoNeedToRoll] needsRolling disabled for: %s", fruitName))
        else
            print(string.format("[NoNeedToRoll] Warning: fruitType '%s' not found", fruitName))
        end
    end
end

local function onLoadMapFinished(mission, ...)
    NoNeedToRoll.disableRollingForFruits()
end

FSBaseMission.loadMapFinished = Utils.appendedFunction(FSBaseMission.loadMapFinished, onLoadMapFinished)