Missions_Display_XmlPda = {};

function Missions_Display_XmlPda:defaultValues(pda)
	pda.ownTable = {updateList=false, lastStateExtraLine=false};
	pda.ownTable.view = {
		isOpen = {false,9};
		timeLimit = {1,1,2,10}; --temporary for 10 sec.
		autoAlign = {1,1,2,true}; --off,on right weather - auto height		
		typIcon = {1,1,4}; --off,vehicle/tool,vehicle,tool		
		typName = {2,1,2};
		fruitIcon = {1,1,3,true};
		fruitNameLength = {3,3,7}; --fruit or filltype
	};
end;

function Missions_Display_XmlPda:onLoadXml(pda, Xml, xmlNameTag)
	if pda.ownTable.lastStateExtraLine == nil then Missions_Display_XmlPda:defaultValues(pda);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
		
		else
			return; --first config not found
		end;		
		--view--
		local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (pda.ownTable.view) do
			if key ~= "isOpen" then
				if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then pda.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;
				if getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean") ~= nil then pda.ownTable.view[key][4] = getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean");end;
			end;
		end;
		--view--		
	end;	
end;

function Missions_Display_XmlPda.onSaveXml(pda, Xml, xmlNameTag)
	setXMLInt(Xml, xmlNameTag.."#version", Missions_Display.metadata.xmlVersion);	
	
	--view--
	local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
	for key, value in pairs (pda.ownTable.view) do
		if key ~= "isOpen" then
			setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			if value[4] ~= nil then
				if type(value[4]) == "boolean" then setXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean", value[4]);end;
			end;
		end;
	end;
	--view--	
end;

function Missions_Display_XmlPda:loadPda(name, show)
	if name == "Missions_Display_Pda" then
		local pda = g_currentMission.hlHudSystem.hlPda.generate( {name=name, width=250, height=150, info="Missions Display Mod\nMissions Pda", autoZoomOutIn="text", displayName="MissionsDisplay Pda", hiddenMod="MissionsDisplay"} );
		pda:setMinWidth(pda.screen.pixelW*40); --set min. width new (default ..pixelW*30)
		pda.onDraw = Missions_Display_DrawPda.setPda;
		pda.canDraw = Missions_Display_DrawPda.beforeDraw;
		pda.onClick = Missions_Display_MouseKeyEventsPda.onClick;		
		--pda.screen.canBounds.on = true;	
		--pda.screen.canBounds.typ = "text";
		--pda.screen.canBounds.setInfo = true;
		pda.resetBoundsByDragDrop = false;
		pda.overlays.settingIcons.up.visible = true; --for viewExtraLine
		pda.overlays.settingIcons.down.visible = true; --for viewExtraLine
		pda.overlays.settingIcons.save.visible = false;
		pda.isHelp = true;
		pda.onSaveXml = Missions_Display_XmlPda.onSaveXml;						
		Missions_Display_XmlPda:onLoadXml(pda, pda:getXml()); --own pda load over Xml (replace Data)
		pda.autoZoomOutIn = "text";
		pda.displayName = "MissionsDisplay Pda" --fix DisplayName;
		pda.drawIsIngameMapLarge = true;
		pda.canAutoClose = false;
		if show ~= nil and show and not pda.show then pda.show = true;end;
	end;
end;