Missions_Display_XmlHud = {};

function Missions_Display_XmlHud:defaultValues(hud)
	hud.ownTable = {viewHudTyp={1,1,3}, viewStateInHud=true};
	g_currentMission.hlUtils.addSwitchTimer( {name="missionsDisplay_switchTwo", delay=10, switch={[1]=20,[2]=5}} ); --two all 10/3 sec. ,for switch pda and box, timelimit warning
end;

function Missions_Display_XmlHud:onLoadXml(hud, Xml, xmlNameTag)
	if hud.ownTable.viewHudTyp == nil then Missions_Display_XmlHud:defaultValues(hud);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
		
		else
			return; --first config not found
		end;
		
		if getXMLInt(Xml, xmlNameTag.."#viewHudTyp") ~= nil then 
			hud.ownTable.viewHudTyp[1] = getXMLInt(Xml, xmlNameTag.. "#viewHudTyp");
			if hud.ownTable.viewHudTyp[1] > hud.ownTable.viewHudTyp[3] or hud.ownTable.viewHudTyp[1] < 1 then hud.ownTable.viewHudTyp[1] = 1;end;		
		end;
		if getXMLInt(Xml, xmlNameTag.."#viewMissionsFarm") ~= nil then 
			Missions_Display.values.viewMissionsFarm[1] = getXMLInt(Xml, xmlNameTag.. "#viewMissionsFarm");
			if Missions_Display.values.viewMissionsFarm[1] > Missions_Display.values.viewMissionsFarm[3] or Missions_Display.values.viewMissionsFarm[1] < 1 then Missions_Display.values.viewMissionsFarm[1] = 1;end;
		end;
		if getXMLInt(Xml, xmlNameTag.."#viewProgressBars") ~= nil then 
			Missions_Display.values.viewProgressBars[1] = getXMLInt(Xml, xmlNameTag.. "#viewProgressBars");
			if Missions_Display.values.viewProgressBars[1] > Missions_Display.values.viewProgressBars[3] or Missions_Display.values.viewProgressBars[1] < 1 then Missions_Display.values.viewProgressBars[1] = 1;end;
		end;
		if getXMLBool(Xml, xmlNameTag.."#viewStateInHud") ~= nil then 
			hud.ownTable.viewStateInHud = getXMLBool(Xml, xmlNameTag.. "#viewStateInHud");
		end;
		local groupNameTag = (xmlNameTag.. ".updateTimersSec(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.."#missiosTimer") ~= nil then 
			Missions_Display.values.missionsUpdateTimer = getXMLInt(Xml, groupNameTag.. "#missionsTimer");
		end;		
	end;	
end;

function Missions_Display_XmlHud.onSaveXml(hud, Xml, xmlNameTag)	
	setXMLInt(Xml, xmlNameTag.."#version", Missions_Display.metadata.xmlVersion);
	setXMLInt(Xml, xmlNameTag.."#viewHudTyp", hud.ownTable.viewHudTyp[1]);
	setXMLInt(Xml, xmlNameTag.."#viewMissionsFarm", Missions_Display.values.viewMissionsFarm[1]);	
	setXMLInt(Xml, xmlNameTag.."#viewProgressBars", Missions_Display.values.viewProgressBars[1]);
	setXMLBool(Xml, xmlNameTag.."#viewStateInHud", hud.ownTable.viewStateInHud);
	local groupNameTag = (xmlNameTag.. ".updateTimersSec(%d)"):format(0);
	setXMLInt(Xml, groupNameTag.."#missionsTimer", Missions_Display.values.missionsUpdateTimer);	
end;

function Missions_Display_XmlHud:loadHud(name) 
	local hud = nil;
	if name == "Missions_Display_Hud" then
		local hud = g_currentMission.hlHudSystem.hlHud.generate( {name=name, width=40, info="Missions Display Mod", displayName="MissionsDisplay Hud", hiddenMod="MissionsDisplay", ownTable={}} ); --loadDefaultIcons=true	
		if hud ~= nil then			
			g_currentMission.hlUtils.loadLanguage( {modTitle=tostring(Missions_Display.metadata.title), class=Missions_Display.modName, modDir=Missions_Display.modDir.. "scripte_missionsdisplay/", xmlDir="FS25_MissionsDisplay", xmlVersion=Missions_Display.metadata.languageVersion} );
			Missions_DisplaySetGet:loadFillTypesIcons();
			Missions_DisplaySetGet:loadHudIcons(hud);				
			hud.onDraw = Missions_Display_DrawHud.setHud;
			hud.onClick = Missions_Display_MouseKeyEventsHud.onClick;
			hud.onSaveXml = Missions_Display_XmlHud.onSaveXml;			
			Missions_Display_XmlHud:onLoadXml(hud, hud:getXml()); --own hud load over Xml
			hud.displayName = "MissionsDisplay Hud" --fix DisplayName;
			if hud.ownTable.viewHudTyp[1] == 3 then hud.autoZoomOutIn = "text";else hud.autoZoomOutIn = "";end; --set text zoom is ...typ 1
			if g_currentMission.hlHudSystem.isAlreadyExistsXml("box", "Missions_Display_Box") then Missions_Display_XmlBox:loadBox("Missions_Display_Box");end; --optional load
			if g_currentMission.hlHudSystem.isAlreadyExistsXml("pda", "Missions_Display_Pda") then Missions_Display_XmlPda:loadPda("Missions_Display_Pda");end; --optional load
			return true;
		end;	
	end;
	return false;
end;