Missions_Display_XmlBox = {};

function Missions_Display_XmlBox:defaultValues(box)
	box.ownTable = {updateList=false, lastStateExtraLine=false};
	box.ownTable.missionsTypes = Missions_DisplaySetGet:getMissionsTypes(true); --all - list for save view state
	box.ownTable.typeIcons = Missions_DisplaySetGet:getTypeIconsLength();
	box.ownTable.view = {
		isOpen = {false,9};
		timeLimit = {1,1,2,20,false}; --temporary for 20 sec.
		fieldHectar = {2,1,4}; --off,field,field/hectar,hectar
		missions = {1,1,3}; --own,own/contractor,contractor
		typIcon = {1,1,4}; --off,vehicle/tool,vehicle,tool
		fillType = {1,1,3,true}; --name,icon,name/icon - otherFillType icon
		fruitNameLength = {3,3,7}; --fruit or filltype
		sortBy = {1,1,7};
		typLine = {1,1,2};
		typName = {2,1,2};
	};
	box.ownTable.sortByText = {					
		[1] = g_i18n:getText("button_no");
		[2] = g_i18n:getText("ui_ingameMissionMoney");
		[3] = g_i18n:getText("contract_title").. " Type";
		[4] = g_i18n:getText("shop_fruitTypes");
		[5] = g_i18n:getText("ui_fieldNo");
		[6] = g_i18n:getText("ui_fieldArea");
		[7] = g_i18n:getText("ui_ingameMissionTimeLimit");
	};	
	box.ownTable.bounds = {0,0,0,box.ownTable.typeIcons or 1}; --for typIcon line	
end;

function Missions_Display_XmlBox:onLoadXml(box, Xml, xmlNameTag)
	if box.ownTable.lastStateExtraLine == nil then Missions_Display_XmlBox:defaultValues(box);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
		
		else
			return; --first config not found
		end;		
		
		--view--
		local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (box.ownTable.view) do
			if key ~= "isOpen" then
				if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;
				if getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean") ~= nil then box.ownTable.view[key][4] = getXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean");end;
			end;
		end;
		--view--		
		--view missionsTypes boolean--
		local groupNameTag = (xmlNameTag.. ".viewMissionsTypes(%d)"):format(0);			
		for key, value in pairs (box.ownTable.missionsTypes) do			
			if getXMLBool(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.missionsTypes[key].view = getXMLBool(Xml, groupNameTag.."#".. tostring(key));end;			
		end;
		--compare view Box save state with org table--
		for missionId, missionsType in ipairs(Missions_Display.values.missionsTypes) do
			if box.ownTable.missionsTypes[missionsType.name] ~= nil then Missions_Display.values.missionsTypes[missionId].view = box.ownTable.missionsTypes[missionsType.name].view;end;
		end;
		--compare view Box save state with org table--
		--view missionsTypes boolean--
		local groupNameTag = (xmlNameTag.. ".other(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.."#newMarkerMissionTimer") ~= nil then Missions_Display.values.markerNewMission = getXMLInt(Xml, groupNameTag.."#newMarkerMissionTimer");end;
	end;	
end;

function Missions_Display_XmlBox.onSaveXml(box, Xml, xmlNameTag)
	setXMLInt(Xml, xmlNameTag.."#version", Missions_Display.metadata.xmlVersion);	
	
	--view--
	local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
	for key, value in pairs (box.ownTable.view) do
		if key ~= "isOpen" then
			setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
			if value[4] ~= nil then
				if type(value[4]) == "boolean" then setXMLBool(Xml, groupNameTag.."#".. tostring(key).. "Boolean", value[4]);end;
			end;
		end;
	end;
	--view--	
	--view missionsTypes boolean--
	local groupNameTag = (xmlNameTag.. ".viewMissionsTypes(%d)"):format(0);
	for key, value in pairs (box.ownTable.missionsTypes) do		
		setXMLBool(Xml, groupNameTag.."#".. tostring(key), value.view);		
	end;
	--view missionsTypes boolean--
	local groupNameTag = (xmlNameTag.. ".other(%d)"):format(0);
	setXMLInt(Xml, groupNameTag.."#newMarkerMissionTimer", Missions_Display.values.markerNewMission);
	
end;

function Missions_Display_XmlBox:loadBox(name, show)
	if name == "Missions_Display_Box" then
		local box = g_currentMission.hlHudSystem.hlBox.generate( {name=name, width=250, height=150, info="Missions Display Mod\nMissions Box", autoZoomOutIn="text", displayName="MissionsDisplay Box", hiddenMod="MissionsDisplay"} );
		box:setMinWidth(box.screen.pixelW*80); --set min. width new (default ..pixelW*30)
		box.onDraw = Missions_Display_DrawBox.setBox;
		box.onClick = Missions_Display_MouseKeyEventsBox.onClick;							
		box.screen.canBounds.on = true;		
		box.resetBoundsByDragDrop = false;
		box.overlays.settingIcons.save.visible = false; --save over global icon
		box.overlays.settingIcons.up.visible = true; --for viewExtraLine
		box.overlays.settingIcons.down.visible = true; --for viewExtraLine
		box.isHelp = true;
		box.onSaveXml = Missions_Display_XmlBox.onSaveXml;						
		Missions_Display_XmlBox:onLoadXml(box, box:getXml()); --own box load over Xml (replace Data)
		box.displayName = "MissionsDisplay Box" --fix DisplayName;
		box.ownTable.lastStateExtraLine = box.viewExtraLine;
		if show ~= nil and show and not box.show then box.show = true;end;
	end;
end;