Missions_Display_MouseKeyEventsPda = {};

function Missions_Display_MouseKeyEventsPda.onClick(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local pda = args.pda;
			if pda ~= nil then
				if args.clickAreaTable.whereClick == "settingInPda_" and args.clickAreaTable.areaClick == "settingIcon_" then
					if pda.isSetting then 
						pda.ownTable.lastStateExtraLine=pda.viewExtraLine;
						pda.viewExtraLine = true;
					else 
						pda.viewExtraLine = pda.ownTable.lastStateExtraLine;
					end;
				elseif args.clickAreaTable.whereClick == "settingInPda_" and args.clickAreaTable.areaClick == "menueClose_" then
					pda.isSetting = false;pda.viewExtraLine = pda.ownTable.lastStateExtraLine;				
				elseif args.clickAreaTable.whereClick == "settingInPda_" and args.clickAreaTable.areaClick == "viewExtraLine_" then
					pda.ownTable.lastStateExtraLine=pda.viewExtraLine;
				end;
			end;
		end;
	end;
end;

function Missions_Display_MouseKeyEventsPda.onClickArea(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
		
	function setValue(what, level, up, typTable)		
		if typTable == nil or typTable[what] == nil then return 0;end;
		local lv = level or 1;
		if up == nil or up then
			if typTable[what][1]+lv > typTable[what][3] then
				typTable[what][1] = typTable[what][2];
			else
				typTable[what][1] = typTable[what][1]+lv;
			end;
		else
			if typTable[what][1]-lv < typTable[what][2] then
				typTable[what][1] = typTable[what][3];
			else
				typTable[what][1] = typTable[what][1]-lv;
			end;
		end;
		g_currentMission.hlHudSystem.isSave = false; --global
		return typTable[what][1];		
	end;	
	
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local pda = args.pda;
			if pda ~= nil then
				if pda.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil then							
							local typTable = pda.ownTable.view;
							if args.clickAreaTable.ownTable[1] == "viewMissionsFarm" or args.clickAreaTable.ownTable[1] == "viewProgressBars" then typTable = Missions_Display.values;end;
							local state = setValue(args.clickAreaTable.ownTable[1], 1, true, typTable);
							if state > 0 then
								if args.clickAreaTable.ownTable[1] == "timeLimit" then
									if state == 2 then
										if g_currentMission.hlUtils.timers["mdTimeLimitPdaTimer_"] == nil then
											g_currentMission.hlUtils.addTimer({name="mdTimeLimitPdaTimer_", delay=pda.ownTable.view.timeLimit[4], repeatable=false, action=Missions_Display_MouseKeyEventsPda.removeTimeLimitTimer, ownTable={pda}});
										end;
									else
										if g_currentMission.hlUtils.timers["mdTimeLimitPdaTimer_"] ~= nil then g_currentMission.hlUtils.removeTimer("mdTimeLimitPdaTimer_");end;
									end;
								elseif args.clickAreaTable.ownTable[1] == "missionsFarm" then
									Missions_DisplaySetGet:setMissions();
									pda:setUpdateState(true);
								else
									if args.clickAreaTable.ownTable[2] ~= nil then pda:setUpdateState(args.clickAreaTable.ownTable[2]);end;
								end;								
							end;							
						end;
						return;		
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local maxDistance = pda.screen.pixelH*5;
						if pda.screen.size.distance.textLine+(pda.screen.pixelH/2) <= maxDistance then
							pda.screen.size.distance.textLine = pda.screen.size.distance.textLine+(pda.screen.pixelH/2);
							pda:setUpdateState(true);							
						end;
						return;					
					end;					
				end;
				if args.clickAreaTable.whereClick == "autoHeight_" then 
					pda.ownTable.view.autoAlign[4] = not pda.ownTable.view.autoAlign[4];
					pda:setUpdateState(false);
					return;				
				elseif args.clickAreaTable.whereClick == "activeMission_" or args.clickAreaTable.whereClick == "fieldNumber_" or args.clickAreaTable.whereClick == "farmlandNumber_" then
					local missionId = args.clickAreaTable.ownTable.missionId;
					if missionId ~= nil then
						if g_currentMission.hlUtils.getPlayerFarmId() == 0 then g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("warning_joinFarmFirst"), 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} );return;end;
						Missions_DisplaySetGet:showInGameMenuFrame("ingameMenuContracts", missionId, false, 0, true);
					end;							
				elseif args.clickAreaTable.whereClick == "fruitNameIcon_" then
					local fillTypeIndex = args.clickAreaTable.ownTable.fillTypeIndex;
					local jobName = args.clickAreaTable.ownTable.jobName;
					if fillTypeIndex ~= nil then
						local fillTypeTitle = "";
						if fillTypeIndex == FillType.FERTILIZER or fillTypeIndex == FillType.LIQUIDFERTILIZER then
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(FillType.FERTILIZER);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.LIQUIDFERTILIZER);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.MANURE);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.LIQUIDMANURE);
						elseif fillTypeIndex == FillType.SQUAREBALE_COTTON or fillTypeIndex == FillType.ROUNDBALE_COTTON then
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(FillType.SILAGE).. "/".. g_i18n:getText("category_bales");							
						else							
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(fillTypeIndex);
						end;						
						g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("statistic_fillType").. ": ".. tostring(fillTypeTitle), 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );						
					elseif jobName ~= nil then
						g_currentMission.hlHudSystem.showInfoBox( {tostring(jobName), 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );						
					end;
				end;							
			end;
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			local pda = args.pda;
			if pda ~= nil then
				if pda.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil and args.clickAreaTable.ownTable[1] == "fruitNameLength" then
							local typTable = pda.ownTable.view;
							local state = setValue(args.clickAreaTable.ownTable[1], 1, false, typTable);
							if state > 0 then								
								if args.clickAreaTable.ownTable[2] ~= nil then pda:setUpdateState(args.clickAreaTable.ownTable[2]);end;															
							end;							
						end;
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local minDistance = pda.screen.pixelH*0.2;
						if pda.screen.size.distance.textLine-(pda.screen.pixelH/2) >= minDistance then
							pda.screen.size.distance.textLine = pda.screen.size.distance.textLine-(pda.screen.pixelH/2);
							pda:setUpdateState(true);							
						end;
						return;						
					end;					
				end;						
			end;		
		elseif args.button == Input.MOUSE_BUTTON_MIDDLE then
			local pda = args.pda;
			if pda ~= nil then
				if pda.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil then
							if args.clickAreaTable.ownTable[1] == "fruitIcon" then pda.ownTable.view.fruitIcon[4] = not pda.ownTable.view.fruitIcon[4];end;							
							return;	
						end;						
					end;
				end;
				if args.clickAreaTable.whereClick == "activeMission_" or args.clickAreaTable.whereClick == "fieldNumber_" or args.clickAreaTable.whereClick == "farmlandNumber_" then --map hotspot
					local missionId = args.clickAreaTable.ownTable.missionId;
					if missionId ~= nil then
						Missions_DisplaySetGet:setMapHotspot(missionId);
					end;									
				end;
			end;
		end;	
	end;
end;

function Missions_Display_MouseKeyEventsPda.removeTimeLimitTimer(timer)
	if timer ~= nil and timer.ownTable ~= nil then
		local pda = timer.ownTable[1];
		pda.ownTable.view.timeLimit[1] = 1;
		g_currentMission.hlUtils.removeTimer("mdTimeLimitPdaTimer_");
	end;
end;