Missions_Display_MouseKeyEventsBox = {};

function Missions_Display_MouseKeyEventsBox.onClick(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "settingIcon_" then
					if box.isSetting then 
						box.ownTable.lastStateExtraLine=box.viewExtraLine;
						box.viewExtraLine = true;
					else 
						box.viewExtraLine = box.ownTable.lastStateExtraLine;
					end;
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "menueClose_" then
					box.isSetting = false;box.viewExtraLine = box.ownTable.lastStateExtraLine;				
				elseif args.clickAreaTable.whereClick == "settingInBox_" and args.clickAreaTable.areaClick == "viewExtraLine_" then
					box.ownTable.lastStateExtraLine=box.viewExtraLine;
				end;
			end;
		end;
	end;
end;

function Missions_Display_MouseKeyEventsBox.onClickArea(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	
	function setValue(what, level, up, typTable)		
		if typTable == nil or typTable[what] == nil then return 0;end;
		local lv = level or 1;
		if up == nil or up then
			if typTable[what][1]+lv > typTable[what][3] then
				typTable[what][1] = typTable[what][2];
			else
				typTable[what][1] = typTable[what][1]+lv;
			end;
		else
			if typTable[what][1]-lv < typTable[what][2] then
				typTable[what][1] = typTable[what][3];
			else
				typTable[what][1] = typTable[what][1]-lv;
			end;
		end;
		g_currentMission.hlHudSystem.isSave = false; --global
		return typTable[what][1];		
	end;
	
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil then
							local typTable = box.ownTable.view;
							if args.clickAreaTable.ownTable[1] == "viewMissionsFarm" or args.clickAreaTable.ownTable[1] == "viewProgressBars" then typTable = Missions_Display.values;end;
							local state = setValue(args.clickAreaTable.ownTable[1], 1, true, typTable);
							if state > 0 then
								if args.clickAreaTable.ownTable[1] == "timeLimit" then
									if state == 2 then
										box.ownTable.view.timeLimit[5] = false;
										if g_currentMission.hlUtils.timers["mdTimeLimitBoxTimer_"] ~= nil then g_currentMission.hlUtils.removeTimer("mdTimeLimitBoxTimer_");end;
									end;
								elseif args.clickAreaTable.ownTable[1] == "missions" or args.clickAreaTable.ownTable[1] == "viewMissionsFarm" then
									Missions_DisplaySetGet:setMissions();
									box:setUpdateState(true);
								else
									if args.clickAreaTable.ownTable[2] ~= nil then box:setUpdateState(args.clickAreaTable.ownTable[2]);end;
								end;								
							end;							
						end;
						return;								
					elseif args.clickAreaTable.whereClick == "closeAllDetailsLines_" then
						Missions_DisplaySetGet:setCloseAllMissionsDetails();						
						return;	
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local maxDistance = box.screen.pixelH*8;
						if box.screen.size.distance.textLine+(box.screen.pixelH/2) <= maxDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine+(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;					
					end;					
				end;
				if args.clickAreaTable.whereClick == "viewMissionsTyp_" then						
						if Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId] ~= nil then
							Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId].view = not Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId].view;
							if box.ownTable.missionsTypes[Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId].name] ~= nil then --compare view Box save state with org table
								box.ownTable.missionsTypes[Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId].name].view = Missions_Display.values.missionsTypes[args.clickAreaTable.ownTable.missionId].view;
							end;
							Missions_DisplaySetGet:setMissions();
							box:setUpdateState(true);
						end;
				elseif args.clickAreaTable.whereClick == "typIconLineBounds_" then
					if args.clickAreaTable.ownTable[1] ~= nil then
						Missions_DisplaySetGet:setBounds(box, args.clickAreaTable.ownTable[1] == "left", args.clickAreaTable.ownTable[1] == "right");
					end;		
				elseif args.clickAreaTable.whereClick == "viewMissionDetails_" then
					local missionId = args.clickAreaTable.ownTable.missionId;
					if missionId ~= nil then						
						Missions_DisplaySetGet:setViewMissionDetails(missionId, byObject);
					end;					
				elseif args.clickAreaTable.whereClick == "rewardPercent_" then
					local missionId = args.clickAreaTable.ownTable.missionId;
					if missionId ~= nil then
						if g_currentMission.hlUtils.getPlayerFarmId() == 0 then g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("warning_joinFarmFirst"), 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} );return;end;
						Missions_DisplaySetGet:showInGameMenuFrame("ingameMenuContracts", missionId, false, 0, true);
					end;				
				elseif args.clickAreaTable.whereClick == "fruitNameIcon_" then
					local fillTypeIndex = args.clickAreaTable.ownTable.fillTypeIndex;
					local jobName = args.clickAreaTable.ownTable.jobName;
					if fillTypeIndex ~= nil then
						local fillTypeTitle = "";
						if fillTypeIndex == FillType.FERTILIZER or fillTypeIndex == FillType.LIQUIDFERTILIZER then
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(FillType.FERTILIZER);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.LIQUIDFERTILIZER);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.MANURE);
							fillTypeTitle = fillTypeTitle.. "/".. g_fillTypeManager:getFillTypeTitleByIndex(FillType.LIQUIDMANURE);
						elseif fillTypeIndex == FillType.SQUAREBALE_COTTON or fillTypeIndex == FillType.ROUNDBALE_COTTON then
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(FillType.SILAGE).. "/".. g_i18n:getText("category_bales");							
						else							
							fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(fillTypeIndex);
						end;						
						g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("statistic_fillType").. ": ".. tostring(fillTypeTitle), 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );						
					elseif jobName ~= nil then
						g_currentMission.hlHudSystem.showInfoBox( {tostring(jobName), 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );						
					end;	
				end;							
			end;
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil and (args.clickAreaTable.ownTable[1] == "sortBy" or args.clickAreaTable.ownTable[1] == "fruitNameLength" or args.clickAreaTable.ownTable[1] == "timeLimit") then
							if args.clickAreaTable.ownTable[1] == "timeLimit" then
								if box.ownTable.view.timeLimit[1] == 2 then 
									if g_currentMission.hlUtils.timers["mdTimeLimitBoxTimer_"] ~= nil then g_currentMission.hlUtils.removeTimer("mdTimeLimitBoxTimer_");end;
									return;
								end;
								box.ownTable.view.timeLimit[5] = not box.ownTable.view.timeLimit[5];
								if box.ownTable.view.timeLimit[5] then
									if g_currentMission.hlUtils.timers["mdTimeLimitBoxTimer_"] == nil then
										g_currentMission.hlUtils.addTimer({name="mdTimeLimitBoxTimer_", delay=box.ownTable.view.timeLimit[4], repeatable=false, action=Missions_Display_MouseKeyEventsBox.removeTimeLimitTimer, ownTable={box}});
									end;
								else
									if g_currentMission.hlUtils.timers["mdTimeLimitBoxTimer_"] ~= nil then g_currentMission.hlUtils.removeTimer("mdTimeLimitBoxTimer_");end;
								end;
							else							
								local typTable = box.ownTable.view;
								local state = setValue(args.clickAreaTable.ownTable[1], 1, false, typTable);
								if state > 0 then								
									if args.clickAreaTable.ownTable[2] ~= nil then box:setUpdateState(args.clickAreaTable.ownTable[2]);end;															
								end;
							end;
						end;												
					elseif args.clickAreaTable.whereClick == "settingLineDistance_" then
						local minDistance = box.screen.pixelH*1;
						if box.screen.size.distance.textLine-(box.screen.pixelH/2) >= minDistance then
							box.screen.size.distance.textLine = box.screen.size.distance.textLine-(box.screen.pixelH/2);
							box:setUpdateState(true);							
						end;
						return;												
					end;					
				end;					
			end;
		elseif args.button == Input.MOUSE_BUTTON_MIDDLE then
			local box = args.box;
			if box ~= nil then
				if box.viewExtraLine then					
					if args.clickAreaTable.whereClick == "view_" then
						if args.clickAreaTable.ownTable[1] ~= nil then
							if args.clickAreaTable.ownTable[1] == "fillType" then box.ownTable.view.fillType[4] = not box.ownTable.view.fillType[4];end;
							if args.clickAreaTable.ownTable[2] ~= nil then box:setUpdateState(args.clickAreaTable.ownTable[2]);end;
							return;	
						end;						
					end;
				end;
				if args.clickAreaTable.whereClick == "viewMissionDetails_" or args.clickAreaTable.whereClick == "fruitNameIcon_" or args.clickAreaTable.whereClick == "rewardPercent_" then --map hotspot
					local missionId = args.clickAreaTable.ownTable.missionId;
					if missionId ~= nil then
						Missions_DisplaySetGet:setMapHotspot(missionId);
					end;									
				end;
			end;
		end;	
	end;
end;

function Missions_Display_MouseKeyEventsBox.removeTimeLimitTimer(timer)
	if timer ~= nil and timer.ownTable ~= nil then
		local box = timer.ownTable[1];
		box.ownTable.view.timeLimit[5] = false;
		g_currentMission.hlUtils.removeTimer("mdTimeLimitBoxTimer_");
	end;
end;