Missions_Display_DrawPda = {};

function Missions_Display_DrawPda.beforeDraw(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil then return true;end;
	local pda = g_currentMission.hlHudSystem.pda[args.typPos];
	if pda == nil then return true;end;
		
	--disable icon upDown in SP (currently only "contractor" icon in this line)	
	if not g_currentMission.missionDynamicInfo.isMultiplayer and not pda.isSetting then 
		if pda.viewExtraLine then pda.viewExtraLine = false;end;
		pda.overlays.settingIcons.up.visible = false; --for viewExtraLine
		pda.overlays.settingIcons.down.visible = false; --for viewExtraLine
	else		
		pda.overlays.settingIcons.up.visible = true; --for viewExtraLine
		pda.overlays.settingIcons.down.visible = true; --for viewExtraLine
	end;
	--disable icon upDown in SP (currently only "contractor" icon in this line)
	
	--locked/unlocked dragDrop--
	if pda.ownTable.view.autoAlign[1] == 1 then pda.overlays.settingIcons.dragDrop.visible = true;pda.overlays.settingIcons.sizeWidthHeight.visible = true;
	else pda.overlays.settingIcons.dragDrop.visible = false;pda.overlays.settingIcons.sizeWidthHeight.visible = false;end;
	--locked/unlocked dragDrop--
	
	return true;
end;

function Missions_Display_DrawPda.setPda(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local pda = g_currentMission.hlHudSystem.pda[args.typPos];
	if pda == nil then return;end;
	
	Missions_DisplaySetGet:setPdaAlign(pda);
		
	local inArea = args.inArea
	local pdaNumber = args.typPos;
	
	local x, y, w, h = pda:getScreen();	
	
	local mW = w/2;
	local mH = h/2;
		
	local sY = y;	
	local sH = h;
	local eY = y;
	local eH = h;
	
	local distance = pda:getSize( {"distance"} ); 
	local difW = distance.textWidth --default width
	local difH = distance.textHeight; --default height	
	local size = pda.screen.size.zoomOutIn.text[1];
	local difSize = 0.0015;
	
	local overlayModGroup = g_currentMission.hlUtils.overlays["Missions_Display"]["missions"];
	local overlayModByName = g_currentMission.hlUtils.overlays.byName["Missions_Display"]["missions"];	
	local overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
	local overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];	
	local bgExpandOverlay = nil;
	if pda.ownTable.view.autoAlign[4] then bgExpandOverlay = overlayModGroup[overlayModByName["bg"]];end;	
	local overlay = nil;
	local tempOverlay = nil;	
	local fillTypeOverlay = nil;
	local typOverlay = nil;
	local classOverlay = nil;	
	
	function needsUpdate()		
		if pda.needsUpdate or pda.ownTable.lineHeight == nil then
			pda.ownTable.lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;
			pda.ownTable.iconWidth, pda.ownTable.iconHeight = pda:getOptiWidthHeight( {typ="icon", height=pda.ownTable.lineHeight-distance.textLine-(difH), width=w-(difW*2)} );			
			pda.ownTable.percentWidth = getTextWidth(size, utf8Substr(" 100%", 0));
			pda.ownTable.fieldWidth = getTextWidth(size, utf8Substr("F-999", 0));
			pda.ownTable.activeWidth = getTextWidth(size-difW, utf8Substr("10x", 0));
			local fruitNameLengthText = "";
			for f=1, pda.ownTable.view.fruitNameLength[1] do
				fruitNameLengthText = fruitNameLengthText.. "M";
			end;
			pda.ownTable.fillTypeNameWidth = getTextWidth(size-difSize, utf8Substr(tostring(fruitNameLengthText), 0)); --1-5--
		end;		
		pda.needsUpdate = false;
	end;	
	needsUpdate();
	
	if not g_currentMission.hlUtils.isMouseCursor then pda.isSetting = false;end;
	
	local isSetBgExpand = false;
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local iconColor = nil;
	local iconWidth = pda.ownTable.iconWidth;
	local iconHeight = pda.ownTable.iconHeight;
	local iconWidthS = iconWidth/1.3;
	local iconHeightS = iconHeight/1.3;
	local iconWidthB = iconWidth*1.3;
	local iconHeightB = iconHeight*1.3;
	local nextPosX = x+difW;
	local nextPosY = y;		
	local nextIconPosX = x+difW;
	local nextLeftPosX = nextPosX;
	local nextRightPosX = x+w-difW;
	nextPosY = nextPosY+(h)-(pda.ownTable.lineHeight)-difH;
	Missions_DisplaySetGet:setViewMissions(pda);	
	local bounds1 = 1;
	local bounds2 = #Missions_DisplaySetGet.viewMissionsPda;
	if bounds2 == 0 then bounds2 = 1;end;
	if pda.viewExtraLine then bounds2 = bounds2+1;end;	
	local canBgExpand = false;
	if pda.ownTable.lineHeight*bounds2 >= h-difH then 
		canBgExpand = true;
		if pda.ownTable.view.autoAlign[4] and bgExpandOverlay ~= nil then
			eH = pda.ownTable.lineHeight*(bounds2+1)-h; --math.floor((pda.ownTable.lineHeight*bounds2)-h+difH, 0.5);
			eY = y-(iconWidth/1.5)-eH;
			g_currentMission.hlUtils.setOverlay(bgExpandOverlay, x, eY, w, eH);
			isSetBgExpand = true;
			bgExpandOverlay:render();
		end;
	end;
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if pda.isSetting and pda.settingTyp == 1 and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			pda:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	--warningLine--
	function setWarningLineIcon()
		overlay = overlayModGroup[overlayModByName["right"]];
		g_currentMission.hlUtils.setOverlay(overlay, x+w-((iconWidth/1.5/2)), nextPosY-0.003, iconWidth/1.5, iconHeight/1.5);
		g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(pda.overlays.color.warning, true));
		local inIconArea = overlay.mouseInArea();
		if inIconArea and pda.isHelp then setInfoHelpText(string.format(pda:getI18n("hl_infoDisplay_viewNotAllIcons"), "Pda"), 0);end;
		if g_currentMission.hlUtils.runsTimer("1sec", true) then
			overlay:render();
		end;
	end;
	--warningLine--
	--autoHeight--
	function setAutoHeightIcon()			
		overlay = overlayModGroup[overlayModByName["bgRound"]];
		tempOverlay = overlayModGroup[overlayModByName["autoHeight"]];
		g_currentMission.hlUtils.setOverlay(overlay, x+mW-((iconWidth/1.5)/2), y-(iconWidth/1.5), iconWidth/1.5, iconHeight/1.5);
		g_currentMission.hlUtils.setOverlay(tempOverlay, x+mW-((iconWidth/1.5)/2), y-(iconWidth/1.5), iconWidth/1.5, iconHeight/1.5);			
		g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("black", true));
		local formatTxt = g_i18n:getText("ui_on");
		if pda.ownTable.view.autoAlign[4] then g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(pda.overlays.color.on, true));else formatTxt = g_i18n:getText("ui_off");g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(pda.overlays.color.text, true));end;
		local inIconArea = overlay.mouseInArea();
		if inIconArea and inArea and pda.isHelp then setInfoHelpText(string.format(g_i18n:getText("pda_autoHeight"), formatTxt), 0);end;
		overlay:render();
		tempOverlay:render();
		if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then pda:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Missions_Display_Pda", typPos=pdaNumber, whereClick="autoHeight_", ownTable={}} );end;
		if canBgExpand and (not pda.ownTable.view.autoAlign[4] or not isSetBgExpand) then
			
		end;
	end;
	--autoHeight--
	--viewExtraLineSetting--
	function viewExtraLineSetting()
		if nextPosY < y then return;end;
		local setWarningLine = false;
		local inIconArea = false;		
				
		function setOverlay(whereClick, color, ownTable, blinking, setPosX, otherX, otherWidth, otherHeight)
			if color == nil then color = pda.overlays.color.notActive;end;			
			g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);	
			inIconArea = overlay.mouseInArea();
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
			local dropIcon = false;
			if blinking ~= nil then
				if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
					dropIcon = true;
				end;
			else
				dropIcon = true;
			end;
			if dropIcon then overlay:render();end;
			if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then pda:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Missions_Display_Pda", typPos=pdaNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
			if setPosX == nil or setPosX then 
				if otherX ~= nil then 
					nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
				else
					nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
				end;
			end;
			iconColor = nil;				
		end;		
		if nextIconPosX+iconWidth < x+w then
			overlay = overlayModGroup[overlayModByName["lineHorizontalUpDown"]];
			tempOverlay = pda.overlays.bgLine;
			if overlay ~= nil and tempOverlay ~= nil then
				g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
				inIconArea = overlay.mouseInArea();
				if inIconArea then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(pda.overlays.color.inArea, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(pda.overlays.color.text, true));end;
				overlay:render();
				if inIconArea and pda.isHelp then setInfoHelpText(string.format(pda:getI18n("hl_infoDisplay_lineDistance"), string.format("%1.2f", pda.screen.size.distance.textLine/pda.screen.pixelH)));end; 					
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then pda:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Missions_Display_Pda", typPos=pdaNumber, whereClick="settingLineDistance_", ownTable={}} );end;
				nextIconPosX = nextIconPosX+iconWidth+difW;
			end;
		else
			setWarningLine = true;
		end;
		if nextIconPosX+(iconWidthB*3) < x+w then
			local sizeText = tostring(" |S:"..string.format("%1.1f", size*1000));
			setTextColor(1, 1, 1, 1);
			renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sizeText));			
			local textWidth = getTextWidth(size, utf8Substr(sizeText, 0));
			nextIconPosX = nextIconPosX+textWidth+difW;
		else
			setWarningLine = true;
		end;
		--------
		if not setWarningLine and nextIconPosX+iconWidth < x+w then
			overlay = overlayModGroup[overlayModByName["textLength"]];				
			if overlay ~= nil then					
				setOverlay("view_", pda.overlays.color.text, {"fruitNameLength", false});
				if inIconArea and pda.isHelp then setInfoHelpText(string.format(g_i18n:getText("pda_settingFruitNameLength"), pda.ownTable.view.fruitNameLength[1]));end;
			end;
		else
			setWarningLine = true;
		end;		
		if not setWarningLine and nextIconPosX+iconWidth < x+w then
			overlay = overlayModGroup[overlayModByName["wheat"]];
			if overlay ~= nil then				
				local moreTxt = "";
				if pda.ownTable.view.fruitIcon[1] == 2 then iconColor = pda.overlays.color.on;moreTxt = "(Icon)";elseif pda.ownTable.view.fruitIcon[1] == 3 then iconColor = pda.overlays.color.warning;moreTxt = "(Icon + Name)";else moreTxt = "(Name)";end;
				setOverlay("view_", iconColor, {"fruitIcon", false});				
				local addText = g_i18n:getText("shop_fruitTypes").. "/Name,Icon,Icon + Name ".. moreTxt;
				if pda.ownTable.view.fruitIcon[4] then addText = addText.. "\n"..  string.format(g_i18n:getText("pda_otherFruitIcons"), g_i18n:getText("ui_on"));else addText = addText.. "\n"..  string.format(g_i18n:getText("pda_otherFruitIcons"), g_i18n:getText("ui_off"));end;
				if inIconArea and pda.isHelp then setInfoHelpText(addText, 0);end; 
			end;					
		else
			setWarningLine = true;
		end;
		if not setWarningLine and nextIconPosX+iconWidth < x+w then 
			overlay = overlayModGroup[overlayModByName["missionsTypesIcon"]];
			if overlay ~= nil then
				local viewTypIconByWhat = "";				
				if pda.ownTable.view.typIcon[1] > 1 then 
					iconColor = pda.overlays.color.on;
					if pda.ownTable.view.typIcon[1] == 2 then
						viewTypIconByWhat = g_i18n:getText("typeDesc_vehicle").. "/".. g_i18n:getText("typeDesc_tool");
					elseif pda.ownTable.view.typIcon[1] == 3 then
						viewTypIconByWhat = g_i18n:getText("typeDesc_vehicle");						
					elseif pda.ownTable.view.typIcon[1] == 4 then
						viewTypIconByWhat = g_i18n:getText("typeDesc_tool");	
					end;
				else
					viewTypIconByWhat = g_i18n:getText("button_no");
					iconColor = pda.overlays.color.notActive;
				end;										
				setOverlay("view_", iconColor, {"typIcon", false});	
				local addText = "Icon ".. g_i18n:getText("infohud_type").. ": ".. viewTypIconByWhat;					
				if inIconArea and pda.isHelp then setInfoHelpText(addText);end;
			end;					
		else
			setWarningLine = true;
		end;
		if not setWarningLine and nextIconPosX+iconWidth < x+w then 
			overlay = overlayModGroup[overlayModByName["plow"]];
			if overlay ~= nil then
				local viewTypNameByWhat = "";				
				if pda.ownTable.view.typName[1] > 1 then 
					iconColor = pda.overlays.color.on;
					viewTypNameByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_yes")					
				else
					iconColor = pda.overlays.color.notActive;
					viewTypNameByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_no");
				end;					
				setOverlay("view_", iconColor, {"typName", false});						
				local addText = g_i18n:getText("infohud_type").. " ".. g_i18n:getText("infohud_name").. ": ".. viewTypNameByWhat;
				if inIconArea and pda.isHelp then setInfoHelpText(addText);end; 
			end;					
		else
			setWarningLine = true;
		end;
		--------
		--set icon right--
		local nextIconRightPosX = nextRightPosX;
		if not setWarningLine and nextIconPosX+iconWidth < x+w then
			overlay = pda.overlays.state;
			tempOverlay = pda.overlays.statePercent;
			local viewOverlay = pda.overlays.settingIcons.view;
			if overlay ~= nil and tempOverlay ~= nil and viewOverlay ~= nil then
				g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(pda.overlays.color.active, true));
				if Missions_Display.values.viewProgressBars[1] > 1 then
					g_currentMission.hlUtils.setBackgroundColor(viewOverlay, g_currentMission.hlUtils.getColor(pda.overlays.color.off, true));
				else
					g_currentMission.hlUtils.setBackgroundColor(viewOverlay, g_currentMission.hlUtils.getColor(pda.overlays.color.on, true));
				end;
				setOverlay("view_", pda.overlays.color.backgroundSetting, {"viewProgressBars"}, nil, false, nextIconRightPosX-iconWidth);
				g_currentMission.hlUtils.setOverlay(tempOverlay, nextIconRightPosX-iconWidth, nextPosY, iconWidth/1.5, iconHeight);
				tempOverlay:render();
				g_currentMission.hlUtils.setOverlay(viewOverlay, nextIconRightPosX-(iconWidth/2)-(iconWidthS/2), nextPosY, iconWidthS, iconHeightS);
				viewOverlay:render();
				if inIconArea and pda.isHelp then setInfoHelpText(g_i18n:getText("box_viewProgressBars"));end;
				nextIconRightPosX = nextIconRightPosX-iconWidth-difW;
				nextIconPosX = nextIconPosX+iconWidth+difW; --set manual
			end;					
		else
			setWarningLine = true;
		end;
		if not setWarningLine and nextIconPosX+iconWidth < x+w then
			overlay = overlayModGroup[overlayModByName["autoAlign"]];			
			if overlay ~= nil then
				--g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-(iconWidth*2)-difW, nextPosY, iconWidth, iconHeight);
				inIconArea = overlay.mouseInArea();
				local formatTxt = g_i18n:getText("ui_off");
				local status = "";
				if pda.ownTable.view.autoAlign[1] > 1 then 
					formatTxt = g_i18n:getText("ui_on");
					status = "-GAMEINFODISPLAY-";
					iconColor = pda.overlays.color.on, true;					
				else 
					iconColor = pda.overlays.color.text, true;
				end;
				setOverlay("view_", iconColor, {"autoAlign", false}, nil, false, nextIconRightPosX-iconWidth);				
				if inIconArea and pda.isHelp then setInfoHelpText(string.format(g_i18n:getText("pda_autoAlign"), formatTxt, status));end;
				nextIconRightPosX = nextIconRightPosX-iconWidth-difW;
				nextIconPosX = nextIconPosX+iconWidth+difW; --set manual
			end;
		else
			setWarningLine = true;
		end;		
		--set icon right--
		if setWarningLine then
			setWarningLineIcon();
		end;
		nextPosY = nextPosY-pda.ownTable.lineHeight;
	end;
	--viewExtraLineSetting--
	--viewExtraLine--
	function viewExtraLine()		
		if nextPosY < y then return;end;			
		local onOffTxt = g_i18n:getText("ui_on").. "/".. g_i18n:getText("ui_off");
		local setWarningLine = false;
		local inIconArea = false;
		function setOverlay(whereClick, color, ownTable, blinking, setPosX, otherX, otherWidth, otherHeight)
			if color == nil then color = pda.overlays.color.notActive;end;			
			g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);	
			inIconArea = overlay.mouseInArea();
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
			local dropIcon = false;
			if blinking ~= nil then
				if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
					dropIcon = true;
				end;
			else
				dropIcon = true;
			end;
			if dropIcon then overlay:render();end;
			if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then pda:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Missions_Display_Pda", typPos=pdaNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
			if setPosX == nil or setPosX then 
				if otherX ~= nil then 
					nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
				else
					nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
				end;
			end;
			iconColor = nil;				
		end;						
		if not setWarningLine and nextIconPosX+iconWidth < x+w then
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				overlay = overlayModGroup[overlayModByName["contractor"]];
				if overlay ~= nil then
					local moreTxt = g_i18n:getText("defaultFarmName");		
					if Missions_Display.values.viewMissionsFarm[1] == 1 then iconColor = pda.overlays.color.notActive;elseif Missions_Display.values.viewMissionsFarm[1] == 2 then iconColor = pda.overlays.color.on;moreTxt = moreTxt.. "/".. g_i18n:getText("contractorFarm");else iconColor = pda.overlays.color.warning;moreTxt = g_i18n:getText("contractorFarm");end;					
					setOverlay("view_", iconColor, {"viewMissionsFarm", true});	
					local addText = g_i18n:getText("ui_ingameMenuContracts").. ": ".. moreTxt;
					if inIconArea and pda.isHelp then setInfoHelpText(addText);end; 
				end;
			end;				
		else
			setWarningLine = true;
		end;		
		if setWarningLine then
			setWarningLineIcon();
		end;
		nextPosY = nextPosY-pda.ownTable.lineHeight;
	end;
	if pda.viewExtraLine and not pda.isSetting then viewExtraLine();elseif pda.viewExtraLine and pda.isSetting then viewExtraLineSetting();end;
	--viewExtraLine--		
	local color = nil;		
	local extraLineBounds = 0;		
	local isSwitchTimerTwo = g_currentMission.hlUtils.getIsSwitchTimer("missionsDisplay_switchTwo");
	for t=bounds1, bounds2 do			
		overlay = nil;
		classOverlay = nil;
		fillTypeOverlay = nil;
		typOverlay = nil;			
		if nextPosY < sY then 
			if isSetBgExpand and pda.ownTable.view.autoAlign[4] and sY == y then
				sY = eY;
				nextPosY = eY+eH-pda.ownTable.lineHeight;
			else
				break;
			end;
		end;
		if nextPosY < sY then break;end;
		if Missions_DisplaySetGet.viewMissionsPda[t] ~= nil then
			local mission = Missions_DisplaySetGet.viewMissionsPda[t];												
			
			color = g_currentMission.hlUtils.getColor(pda.overlays.color.inArea, true);
							
			local canNextView = true;
			local lineWidth = w-(difW*2);
			
			function getInIconArea(posX, posY, width, height)
				if not inArea then return false;end;
				overlay = pda.overlays.bgLine; --hidden overlay
				if overlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width or lineWidth, height or pda.ownTable.lineHeight);
					return overlay.mouseInArea();
				end;
				return false;
			end;
				
			---percent---
			if canNextView then					
				local text = "";					
				local percent = tostring(mission.percent).. "%";
				text = g_currentMission.hlUtils.getTxtToWidth(percent, size, lineWidth, true, ".");
				
				local minutesWarning = (mission.isRunning or mission.finish) and mission.hasTimeLimit and mission.minutes <= Missions_Display.values.warningIsTimeLimit[1];
				local dropMinutesWarning = false;
				if minutesWarning then
					overlay = overlayModGroup[overlayModByName["clock"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth-difW, nextPosY, iconWidth, iconHeight);
						if mission.minutes < Missions_Display.values.warningIsTimeLimit[2] then
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("orangeRed", true));
						else
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(pda.overlays.color.warning, true));
						end;
						dropMinutesWarning = isSwitchTimerTwo ~= nil and isSwitchTimerTwo == 2;
					end;
				end;
				if dropMinutesWarning and g_currentMission.hlUtils.runsTimer("1sec", true) then --blinking
					overlay:render();
				else
					if minutesWarning then
						if mission.minutes < Missions_Display.values.warningIsTimeLimit[2] then
							setTextColor(unpack(g_currentMission.hlUtils.getColor("orangeRed", true)));
						else
							setTextColor(unpack(g_currentMission.hlUtils.getColor(pda.overlays.color.warning, true)));
						end;
					else
						setTextColor(unpack(color));
					end;
					setTextAlignment(2);					
					renderText(nextRightPosX, nextPosY, size-difSize, tostring(text));					
					setTextColor(1, 1, 1, 1);
					setTextAlignment(0);
				end;				
				lineWidth = lineWidth-pda.ownTable.percentWidth;
				nextRightPosX = nextRightPosX-pda.ownTable.percentWidth-(iconWidthS/3);
				canNextView = lineWidth > iconWidth;
				
				local tempNextRightPosX = x+w-difW-pda.ownTable.percentWidth-(iconWidthS/3);					
									
				---contractor mission---
				if g_currentMission.missionDynamicInfo.isMultiplayer then
					if canNextView and Missions_Display.values.viewMissionsFarm[1] > 1 and mission.farmId ~= nil and mission.farmId ~= playerFarmId then
						overlay = overlayModGroup[overlayModByName["contractor"]];
						if overlay ~= nil then								
							g_currentMission.hlUtils.setOverlay(overlay, tempNextRightPosX, nextPosY, iconWidthS, iconHeightS);
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(pda.overlays.color.columText1, true));
							overlay:render();								
							canNextView = lineWidth > iconWidth;
						end;
					end;
				end;
				---contractor mission---
			end;
			---Percent---
						
			---field/farmland---
			if canNextView then					
				local nextWidth = pda.ownTable.fieldWidth;					
				if mission.field ~= nil and mission.field.id ~= nil then
					
					local tempLineWidth = w-(difW*2)-pda.ownTable.percentWidth;
					local tempRightPosX = nextRightPosX;						
					local fieldText = "F-".. tostring(mission.field.id);
					
					if mission.finish or mission.failed or mission.isRunning then
						setTextColor(unpack(color));
					else
						setTextColor(unpack(g_currentMission.hlUtils.getColor(pda.overlays.color.columText1, true)));
					end;
					fieldText = g_currentMission.hlUtils.getTxtToWidth(fieldText, size-difSize, tempLineWidth, false, ".");
					if nextRightPosX-nextWidth < nextLeftPosX then
						tempRightPosX = nextLeftPosX;
					else
						tempRightPosX = tempRightPosX-nextWidth
					end;					
					setTextBold(true);
					renderText(tempRightPosX, nextPosY, size-difSize, tostring(fieldText));					
					setTextColor(1, 1, 1, 1);
					setTextBold(false);
					if lineWidth-nextWidth > iconWidth then													
						if not g_currentMission.hlUtils:disableInArea() and inArea then pda:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+pda.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Mission_Display_Pda", typPos=pdaNumber, whereClick="fieldNumber_", ownTable={missionId=mission.id, fieldId=mission.field.id}} );end;
					end;
				elseif mission.farmlandId ~= nil then
					local tempLineWidth = w-(difW*2)-pda.ownTable.percentWidth;
					local tempRightPosX = nextRightPosX;						
					local farmlandText = "L-";
					if mission.farmlandId == 0 then farmlandText = farmlandText.. g_i18n:getText("ui_no");else farmlandText = farmlandText.. tostring(mission.farmlandId);end;
					
					if mission.finish or mission.failed or mission.isRunning then
						setTextColor(unpack(color));
					else
						setTextColor(unpack(g_currentMission.hlUtils.getColor(pda.overlays.color.columText1, true)));
					end;
					farmlandText = g_currentMission.hlUtils.getTxtToWidth(farmlandText, size-difSize, tempLineWidth, false, ".");
					if nextRightPosX-nextWidth < nextLeftPosX then
						tempRightPosX = nextLeftPosX;
					else
						tempRightPosX = tempRightPosX-nextWidth
					end;					
					setTextBold(true);
					renderText(tempRightPosX, nextPosY, size-difSize, tostring(farmlandText));					
					setTextColor(1, 1, 1, 1);
					setTextBold(false);
					if lineWidth-nextWidth > iconWidth then													
						if not g_currentMission.hlUtils:disableInArea() and inArea then pda:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+pda.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Mission_Display_Pda", typPos=pdaNumber, whereClick="farmlandNumber_", ownTable={missionId=mission.id, farmlandId=mission.farmlandId}} );end;
					end;
				end;
				--with empty is not field, better for Alignment line--
				lineWidth = lineWidth-nextWidth;
				nextRightPosX = nextRightPosX-nextWidth;
				canNextView = lineWidth > iconWidth;
				--with empty is not field, better for Alignment line--					
			end;
			---field/farmland---
			local baleType = nil;
			---fruitType/fillType name---
			if canNextView and (pda.ownTable.view.fruitIcon[1] == 1 or pda.ownTable.view.fruitIcon[1] == 2) then
				local fillTypeIndex, baleTyp = Missions_DisplaySetGet:getFillTypeIndex(mission, false);
				baleType = baleTyp;
				local nextWidth = pda.ownTable.fillTypeNameWidth;					
				if fillTypeIndex ~= nil then
					local tempRightPosX = nextRightPosX;
					local fillTypeTitle = string.sub(g_fillTypeManager:getFillTypeTitleByIndex(fillTypeIndex), 1, pda.ownTable.view.fruitNameLength[1]).. "#";
					fillTypeTitle = g_currentMission.hlUtils.getTxtToWidth(fillTypeTitle, size, lineWidth, false, ".");
					if mission.finish or mission.failed or mission.isRunning then
						setTextColor(unpack(color));
					else
						setTextColor(unpack(g_currentMission.hlUtils.getColor(pda.overlays.color.columText1, true)));
					end;
					if nextRightPosX-nextWidth < nextLeftPosX then
						tempRightPosX = nextLeftPosX;
					else
						tempRightPosX = tempRightPosX-nextWidth
					end;
					renderText(tempRightPosX, nextPosY, size-difSize, tostring(fillTypeTitle));					
					setTextColor(1, 1, 1, 1);
					if lineWidth-nextWidth > iconWidth then
						if not g_currentMission.hlUtils:disableInArea() and inArea then pda:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+pda.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Mission_Display_Pda", typPos=pdaNumber, whereClick="fruitNameIcon_", ownTable={missionId=mission.id, fillTypeIndex=fillTypeIndex}} );end;
					end;
				end;
				--with empty is not fillType, better for Alignment line--
				nextRightPosX = nextRightPosX-nextWidth;
				lineWidth = lineWidth-nextWidth;
				canNextView = lineWidth > iconWidth;
				--with empty is not fillType, better for Alignment line--
			end;
			---fruitType/fillType name---
				
			---fruitType/fillType icon---
			if canNextView and (pda.ownTable.view.fruitIcon[1] == 2 or pda.ownTable.view.fruitIcon[1] == 3) then 				
				local setNextWidth = false;
				local fillTypeIndex = nil;				
				if mission.typ == "roller" or string.find(mission.typ, "roller") or mission.typ == "plow" or mission.typ == "cultivate" or mission.typ == "transport" or mission.typ == "weed" or mission.typ == "hoe" or mission.typ == "treetransport" or mission.typ == "deadwood" or mission.typ == "destructiblerock" or mission.typ == "stonepick" or mission.typ == "tedder" or mission.typ == "mow" then						
					if pda.ownTable.view.fruitIcon[4] then
						if mission.typ == "treetransport" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_woodTree"]];
						elseif mission.typ == "transport" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_product"]];						
						elseif mission.typ == "deadwood" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_deadTree"]];
						elseif mission.typ == "destructiblerock" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_rock"]];
						elseif mission.typ == "stonepick" then fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(FillType.STONE)]];
						elseif mission.typ == "mow" then fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(FillType.GRASS_WINDROW)]];
						else fillTypeOverlay = overlayModGroup[overlayModByName["fillType_field"]];end;
					else
						setNextWidth = true;
					end;
				else
					fillTypeIndex, baleTyp, modOverlay = Missions_DisplaySetGet:getFillTypeIndex(mission, true);									
					baleType = baleTyp;
					if fillTypeIndex ~= nil then														
						fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(fillTypeIndex)]];														
					else
						if modOverlay ~= nil then 
							fillTypeOverlay = overlayModGroup[overlayModByName[modOverlay]];
						elseif mission.field ~= nil and mission.field.id ~= nil then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_field"]];else fillTypeOverlay = overlayModGroup[overlayModByName["fillType_other"]];end;
					end;
				end;					
				if fillTypeOverlay ~= nil then
					g_currentMission.hlUtils.setOverlay(fillTypeOverlay, nextRightPosX-iconWidthB, nextPosY-difH, iconWidthB, iconHeightB);
					fillTypeOverlay:render();								
					if not g_currentMission.hlUtils:disableInArea() and inArea then pda:setClickArea( {fillTypeOverlay.x, fillTypeOverlay.x+fillTypeOverlay.width, nextPosY, nextPosY+pda.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Mission_Display_Pda", typPos=pdaNumber, whereClick="fruitNameIcon_", ownTable={mission=mission.id, fillTypeIndex=fillTypeIndex, jobName=tostring(mission.jobTyp)}} );end;
					setNextWidth = true;
				end;
				if setNextWidth then
					nextRightPosX = nextRightPosX-iconWidthB-difW;
					lineWidth = lineWidth-iconWidthB;
					canNextView = lineWidth > iconWidth;
				end;
			end;
			---fruitType/fillType icon---
								
			---job type icon---
			if canNextView and pda.ownTable.view.typIcon[1] > 1 then
				local classOverlayString, typOverlayString = Missions_DisplaySetGet:getTypesOverlays(mission);
				classOverlay = overlayModGroup[overlayModByName[classOverlayString]];
				typOverlay = overlayModGroup[overlayModByName[typOverlayString]];				
				if canNextView and (pda.ownTable.view.typIcon[1] == 2 or pda.ownTable.view.typIcon[3] == 3) and classOverlay ~= nil then
					g_currentMission.hlUtils.setOverlay(classOverlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					g_currentMission.hlUtils.setBackgroundColor(classOverlay, color);
					classOverlay:render();
					nextLeftPosX = nextLeftPosX+iconWidthB+difW;
					lineWidth = lineWidth-iconWidthB-difW;
					canNextView = lineWidth > iconWidthB;
				end;
				if canNextView and (pda.ownTable.view.typIcon[1] == 2 or pda.ownTable.view.typIcon[1] == 4) and typOverlay ~= nil then
					g_currentMission.hlUtils.setOverlay(typOverlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
					g_currentMission.hlUtils.setBackgroundColor(typOverlay, color);
					typOverlay:render();
					nextLeftPosX = nextLeftPosX+iconWidthB+difW;
					lineWidth = lineWidth-iconWidthB-difW;
					canNextView = lineWidth > iconWidthB;
				end;					
			end;
			---job type icon---				
			
			---job name/other---				
			if canNextView and pda.ownTable.view.typName[1] > 1 then
				local text = tostring(mission.jobTyp);										
				if baleType ~= nil and pda.ownTable.view.fruitIcon[1] == 1 then if baleType == "square" then text = text.. "/Q" else text = text.. "/R";end;end;
				text = g_currentMission.hlUtils.getTxtToWidth(text, size, lineWidth, false, ".");
				setTextColor(unpack(color));
				renderText(nextLeftPosX, nextPosY, size, tostring(text));					
				setTextColor(1, 1, 1, 1);
				local textWidth = getTextWidth(size, utf8Substr(text, 0));					
				nextLeftPosX = nextLeftPosX+textWidth;
				lineWidth = lineWidth-textWidth;
				canNextView = lineWidth > iconWidth;					
			end;
			---job name/other---
			
			if pda.isHelp and getInIconArea(x+difW, nil, w-(difW*2), nil) then setInfoHelpText(g_i18n:getText("mission_ingameMenue"));end;
			if not g_currentMission.hlUtils:disableInArea() and inArea then pda:setClickArea( {x+difW, x+difW+(w-(difW*2)), nextPosY, nextPosY+pda.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsPda.onClickArea, whatClick="Mission_Display_Pda", typPos=pdaNumber, whereClick="activeMission_", ownTable={missionId=mission.id}} );end;
						
			nextPosY = nextPosY-pda.ownTable.lineHeight;
			nextRightPosX = x+w-difW;
			nextLeftPosX = x+difW;				
		elseif #Missions_DisplaySetGet.viewMissionsPda == 0 then
			color = pda.overlays.color.text;				
			local text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("helpLine_FirstSteps_Contracts")).. ": ".. tostring(g_i18n:getText("ui_none")), size, w-(difW*2), false, ".");						
			setTextColor(unpack(g_currentMission.hlUtils.getColor(color, true)));
			renderText(nextLeftPosX, nextPosY, size, tostring(text));
			setTextColor(1, 1, 1, 1);
			break;
		end;			
	end;
	pda.screen.bounds[4] = pda.screen.bounds[4]+extraLineBounds;
	if g_currentMission.hlUtils.isMouseCursor and not pda.isSetting then setAutoHeightIcon();end;	
end;