Missions_Display_DrawHud = {};

function Missions_Display_DrawHud.setHud(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local hud = g_currentMission.hlHudSystem.hud[args.typPos];
	if hud == nil then return;end;
	local inArea = args.inArea
	local hudNumber = args.typPos;
	if hud.overlays.modIcons["Missions_Display"] == nil or hud.overlays.modIcons["Missions_Display"]["hud"] == nil then return;end; --check Mod Icons is loaded
	if not g_currentMission.hlHudSystem.isSetting.hud then hud.isSetting = false;end;
	
	local box = g_currentMission.hlHudSystem.hlBox:getData("Missions_Display_Box");
	local showBox = box ~= nil and ((box.show and not box.autoClose) or (box.show and box.autoClose and g_currentMission.hlUtils.isMouseCursor));
	
	local x, y, w, h = hud:getScreen();
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = hud:getSize( {"distance"} ); 
	local difW = distance.iconWidth --default width
	local difH = distance.iconHeight; --default height	
		
	local overlayModGroup = g_currentMission.hlUtils.overlays["Missions_Display"]["missions"];
	local overlayModByName = g_currentMission.hlUtils.overlays.byName["Missions_Display"]["missions"];
	local overlayGroup = hud.overlays.modIcons["Missions_Display"]["hud"];
	local overlayByName = hud.overlays.modIcons.byName["Missions_Display"]["hud"];
	local overlay = nil;
	local overlayNotice = overlayGroup[overlayByName["notice"]];	
	local overlayState = hud.overlays.state;
	local overlayStatePercent = hud.overlays.statePercent;	
	
	local txt = g_i18n:getText("ui_mapHotspotFilter_contracts"); --ui_contracts
	
	function needsUpdate()		
		if hud.needsUpdate or hud.ownTable.iconHeight == nil or hud.ownTable.optiSize == nil then			
			hud.ownTable.iconWidth, hud.ownTable.iconHeight = hud:getOptiWidthHeight( {typ="hud", height=h-(difH*2), width=w-difW} );
			hud.ownTable.optiSize, hud.ownTable.text = hud:getOptiSizeText( {typ="text", text=txt, cut=true, width=w-(difW*2), height=h-difH} );
			hud.ownTable.txtHeight = getTextHeight(hud.ownTable.optiSize, utf8Substr(hud.ownTable.text, 0));			
		end;		
		hud.needsUpdate = false;
	end;	
	needsUpdate();
	
	local nextPosX = x;
	local nextPosY = y;
	local iconWidth = hud.ownTable.iconWidth;
	local iconHeight = hud.ownTable.iconHeight;
	local iconWidthS = iconWidth/2;
	local iconHeightS = iconHeight/2;
	local statePosY = y+h-iconHeight-difH;
	local statePercentWidth = (iconWidth-difW)/100;
	nextPosX = nextPosX+difW;		
	nextPosY = nextPosY+(h/2)-(iconHeight/2)-difH;
	if hud.ownTable.viewHudTyp[1] == 1 then
		overlay = overlayGroup[overlayByName["missionsBW"]];
	elseif hud.ownTable.viewHudTyp[1] == 2 then
		overlay = overlayGroup[overlayByName["missionsColor"]];
	end;
	function setInfo()
		local text = string.format(hud:getI18n("hl_infoDisplay_displayTypSwitch"), "HUD");
		if hud.ownTable.viewHudTyp[1] > 2 then text = text.. "\n".. string.format(hud:getI18n("hl_infoDisplay_displayChangeSize"), "HUD", "Text", "Text");end;
		setInfoHelpText(tostring(text), 0);		
	end;
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if hud.isSetting and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			hud:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	local percent, notice = Missions_DisplaySetGet:getPercentAndNotice();
	if percent < 6 then percent = 6;elseif percent > 100 then percent = 100;end;
	function setState()
		if not g_currentMission.hlHudSystem.isSetting.hud and not hud.isSetting then			
			g_currentMission.hlUtils.setOverlay(overlayState, nextPosX, statePosY, iconWidth, iconHeight);
			overlayState:render();
			if #Missions_Display.missions.farmId > 0 and #Missions_Display.missions.farmId > notice.finish+notice.failed then			
				g_currentMission.hlUtils.setOverlay(overlayStatePercent, nextPosX+(difW/2), statePosY, statePercentWidth*percent, iconHeight);
				local prozentColor = g_currentMission.hlUtils.getProzentColor(percent, true);
				g_currentMission.hlUtils.setBackgroundColor(overlayStatePercent, g_currentMission.hlUtils.getColorProzent(prozentColor, true));			
				overlayStatePercent:render();
			end;
		end;		
	end;
	function setNotice(otherX, otherY)
		if overlayNotice ~= nil and (notice.finish > 0 or notice.failed > 0 or (#Missions_Display.missions.free > 0 and #Missions_Display.missions.farmId == 0)) then 
			g_currentMission.hlUtils.setOverlay(overlayNotice, otherX or nextPosX, otherY or nextPosY, iconWidthS, iconHeightS);
			if notice.finish > 0 and notice.failed == 0 then
				g_currentMission.hlUtils.setBackgroundColor(overlayNotice, g_currentMission.hlUtils.getColor(hud.overlays.color.on, true));
			elseif notice.finish == 0 and notice.failed > 0 then
				g_currentMission.hlUtils.setBackgroundColor(overlayNotice, g_currentMission.hlUtils.getColor(hud.overlays.color.off, true));
			elseif notice.finish == 0 and notice.failed == 0 and #Missions_Display.missions.free > 0 and #Missions_Display.missions.farmId == 0 then
				if showBox then return;end;
				g_currentMission.hlUtils.setBackgroundColor(overlayNotice, g_currentMission.hlUtils.getColor(hud.overlays.color.columText1, true));
			else
				g_currentMission.hlUtils.setBackgroundColor(overlayNotice, g_currentMission.hlUtils.getColor(hud.overlays.color.warning, true));
			end;
			overlayNotice:render();
		end;
	end;
	if overlay ~= nil then		
		g_currentMission.hlUtils.setOverlay(overlay, nextPosX, nextPosY, iconWidth, iconHeight);		
		if hud.ownTable.viewHudTyp[1] == 1 then
			if inArea and overlay.mouseInArea() then 
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.inArea, true));					
			else 				
				if showBox then 
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.isShow, true));
				else
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.txt, true));
				end;
			end;
		end;
		overlay:render();		
		if hud.ownTable.viewStateInHud then setState();end;
		setNotice();
		if hud.isSetting and inArea and g_currentMission.hlHudSystem.infoDisplay.on then setInfo();end;
		if not hud.isSetting and g_currentMission.hlHudSystem.infoDisplay.on and inArea then setInfoHelpText(g_i18n:getText("hud_box_pda"), 0);end;
		if not hud.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","right"}} );end;
		if not g_currentMission.hlUtils:disableInArea() and not g_currentMission.hlHudSystem.isSetting.hud and inArea then hud:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, whatClick="Missions_Display_DrawHud", typPos=hudNumber, whereClick="missionsDisplayIcon_", ownTable={}} );end;
	else		
		--viewHudTyp 3 (Text)--
		setTextColor(1, 1, 1, 1);					
		setTextBold(true);
		if inArea then
			setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.inArea, true)));
		else
			if showBox then 
				setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.isShow, true)));
			else
				setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.txt, true)));
			end;
		end;			
		renderText(x+difW, y+mH-(hud.ownTable.txtHeight/2)+difH, hud.ownTable.optiSize, tostring(hud.ownTable.text));
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		if hud.isSetting and inArea and g_currentMission.hlHudSystem.infoDisplay.on then setInfo();end;
		if not hud.isSetting and g_currentMission.hlHudSystem.infoDisplay.on and inArea then setInfoHelpText(g_i18n:getText("hud_box_pda"), 0);end;
		if not hud.isSetting and g_currentMission.hlHudSystem.infoDisplay.mouseAccepts and inArea then g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","right"}} );end;
		if not g_currentMission.hlUtils:disableInArea() and not g_currentMission.hlHudSystem.isSetting.hud and inArea then hud:setClickArea( {x, x+w, y, y+h, whatClick="Missions_Display_DrawHud", typPos=hudNumber, whereClick="missionsDisplayIcon_", ownTable={}} );end;
		--viewHudTyp 3 (Text)--
	end;
end;