Missions_Display_DrawBox = {};

function Missions_Display_DrawBox.setBox(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local box = g_currentMission.hlHudSystem.box[args.typPos];
	if box == nil then return;end;
		
	local inArea = args.inArea
	local boxNumber = args.typPos;
	
	local x, y, w, h = box:getScreen();	
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = box:getSize( {"distance"} ); 
	local difW = distance.textWidth --default width
	local difH = distance.textHeight; --default height	
	local size = box.screen.size.zoomOutIn.text[1];
	local difSize = 0.0015;
	
	local overlayModGroup = g_currentMission.hlUtils.overlays["Missions_Display"]["missions"];
	local overlayModByName = g_currentMission.hlUtils.overlays.byName["Missions_Display"]["missions"];	
	local overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
	local overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];	
	local overlay = nil;
	local tempOverlay = nil;
	local fillTypeOverlay = nil;
	local typOverlay = nil;
	local classOverlay = nil;	
	
	function needsUpdate()		
		if box.needsUpdate or box.ownTable.lineHeight == nil then
			box.ownTable.lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;
			box.ownTable.iconWidth, box.ownTable.iconHeight = box:getOptiWidthHeight( {typ="icon", height=box.ownTable.lineHeight-distance.textLine-(difH), width=w-(difW*2)} );			
			box.ownTable.maxIconWidth = g_currentMission.hlUtils.getMaxIconWidth(w-(difW*2)-(box.ownTable.iconWidth*2), box.ownTable.iconWidth*1.15);			
			box.ownTable.minutesWidth = getTextWidth(size, utf8Substr("999:99 mmm", 0));
			box.ownTable.rewardWidth = getTextWidth(size, utf8Substr(g_i18n:formatMoney(999999, 0, true, false), 0).. ".")+0.002;
			box.ownTable.percentWidth = getTextWidth(size-difSize, utf8Substr(" 100%", 0));
			box.ownTable.fieldWidth = getTextWidth(size-difSize, utf8Substr("F-999", 0));			
			--box.ownTable.hectarWidthLarge = getTextWidth(size, utf8Substr("999.99".. tostring(g_i18n:getText("unit_haShort")), 0));
			box.ownTable.hectarWidth = getTextWidth(size, utf8Substr("99.99".. tostring(g_i18n:getText("unit_haShort")), 0));
			local fruitNameLengthText = "";
			for f=1, box.ownTable.view.fruitNameLength[1] do
				fruitNameLengthText = fruitNameLengthText.. "M";
			end;
			box.ownTable.fillTypeNameWidth = getTextWidth(size-difSize, utf8Substr(tostring(fruitNameLengthText), 0)); --1-5--
			--tostring(string.format("%1.2f", "".. tostring(mission.fieldHectar))).. " ".. tostring(g_i18n:getText("unit_haShort"));
			Missions_DisplaySetGet:resetBounds(box);
		end;		
		box.needsUpdate = false;
	end;	
	needsUpdate();
	
	if not g_currentMission.hlUtils.isMouseCursor then box.isSetting = false;end;
	
	box.ownTable.typeIcons = Missions_DisplaySetGet:getTypeIconsLength();
	if box.ownTable.bounds[1] <= 0 then Missions_DisplaySetGet:generateBounds(box);end;
	
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local iconColor = nil;
	local iconWidth = box.ownTable.iconWidth;
	local iconHeight = box.ownTable.iconHeight;
	local iconWidthS = iconWidth/1.3;
	local iconHeightS = iconHeight/1.3;
	local iconWidthB = iconWidth*1.3;
	local iconHeightB = iconHeight*1.3;
	local iconWidthV = iconWidth*1.8;
	local iconHeightV = iconHeight*1.8;
	local nextPosX = x+difW;
	local nextPosY = y;		
	local nextIconPosX = x+difW;
	local nextLeftPosX = nextPosX;
	local nextRightPosX = x+w-difW;
	nextPosY = nextPosY+(h)-(box.ownTable.lineHeight)-difH;
	local openMissionDetails = Missions_DisplaySetGet:setViewMissions(box);
	box.screen.bounds[4] = #Missions_DisplaySetGet.viewMissionsBox+1; -- +1 for Imaginäre Line wenn untergruppe an ist (viewMissionDetails etc.)
	if box.ownTable.view.missions[1] == 1 or box.ownTable.view.missions[1] == 3 and box.ownTable.view.typLine[1] > 1 then box.screen.bounds[4] = box.screen.bounds[4]+1;end;
	if box.viewExtraLine then box.screen.bounds[4] = box.screen.bounds[4]+1;end;
	
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if box.isSetting and box.settingTyp == 1 and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			box:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	
	if box.screen.bounds[1] > 0 then		
		--warningLine--
		function setWarningLineIcon()
			overlay = overlayModGroup[overlayModByName["right"]];
			g_currentMission.hlUtils.setOverlay(overlay, x+w-((iconWidth/1.5/2)), nextPosY-0.003, iconWidth/1.5, iconHeight/1.5);
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
			local inIconArea = overlay.mouseInArea();
			if inIconArea and box.isHelp then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_viewNotAllIcons"), "Box"), 0);end;
			if g_currentMission.hlUtils.runsTimer("1sec", true) then
				overlay:render();
			end;
		end;
		--warningLine--
		--viewExtraLineSetting--
		function viewExtraLineSetting()
			if nextPosY < y then return;end;
			local setWarningLine = false;
			local inIconArea = false;			
			function setOverlay(whereClick, color, ownTable, blinking, setPosX, otherX, otherWidth, otherHeight)
				if color == nil then color = box.overlays.color.notActive;end;
				g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);				
				inIconArea = overlay.mouseInArea();
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
				local dropIcon = false;
				if blinking ~= nil then
					if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
						dropIcon = true;
					end;
				else
					dropIcon = true;
				end;
				if dropIcon then overlay:render();end;				
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
				if setPosX == nil or setPosX then 
					if otherX ~= nil then 
						nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
					else
						nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
					end;
				end;
				iconColor = nil;				
			end;
			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["lineHorizontalUpDown"]];
				tempOverlay = box.overlays.bgLine;
				if overlay ~= nil and tempOverlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
					inIconArea = overlay.mouseInArea();
					if inIconArea then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));end;
					overlay:render();
					if inIconArea and box.isHelp then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_lineDistance"), string.format("%1.2f", box.screen.size.distance.textLine/box.screen.pixelH)));end;					
					if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick="settingLineDistance_", ownTable={}} );end;
					nextIconPosX = nextIconPosX+iconWidth+difW;
				end;
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+(iconWidthB*3) < x+w then
				local sizeText = tostring(" |S:"..string.format("%1.1f", size*1000));
				setTextColor(1, 1, 1, 1);
				renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sizeText));
				local textWidth = getTextWidth(size, utf8Substr(sizeText, 0));
				nextIconPosX = nextIconPosX+textWidth+difW;
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["textLength"]];				
				if overlay ~= nil then					
					setOverlay("view_", box.overlays.color.text, {"fruitNameLength", false});
					if inIconArea and box.isHelp then setInfoHelpText(string.format(g_i18n:getText("box_settingFruitNameLength"), box.ownTable.view.fruitNameLength[1]));end;
				end;
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["wheat"]];
				if overlay ~= nil then
					local moreTxt = "";					
					if box.ownTable.view.fillType[1] == 2 then iconColor = box.overlays.color.on;moreTxt = "(Icon)";elseif box.ownTable.view.fillType[1] == 3 then iconColor = box.overlays.color.warning;moreTxt = "(Icon + Name)";else moreTxt = "(Name)";end;					
					setOverlay("view_", iconColor, {"fillType", false});	
					local addText = g_i18n:getText("shop_fruitTypes").. "/Name,Icon,Icon + Name ".. moreTxt;
					if box.ownTable.view.fillType[4] then addText = addText.. "\n"..  string.format(g_i18n:getText("box_otherFruitIcons"), g_i18n:getText("ui_on"));else addText = addText.. "\n"..  string.format(g_i18n:getText("box_otherFruitIcons"), g_i18n:getText("ui_off"));end;
					if inIconArea and box.isHelp then setInfoHelpText(addText, 0);end; 
				end;					
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then 
				overlay = overlayModGroup[overlayModByName["missionsTypesIcon"]];
				if overlay ~= nil then					
					local viewTypIconByWhat = "";
					if box.ownTable.view.typIcon[1] > 1 then 
						iconColor = box.overlays.color.on;
						if box.ownTable.view.typIcon[1] == 2 then
							viewTypIconByWhat = g_i18n:getText("typeDesc_vehicle").. "/".. g_i18n:getText("typeDesc_tool");
						elseif box.ownTable.view.typIcon[1] == 3 then
							viewTypIconByWhat = g_i18n:getText("typeDesc_vehicle");						
						elseif box.ownTable.view.typIcon[1] == 4 then
							viewTypIconByWhat = g_i18n:getText("typeDesc_tool");	
						end;
					else
						viewTypIconByWhat = g_i18n:getText("button_no");
						iconColor = box.overlays.color.notActive;
					end;										
					setOverlay("view_", iconColor, {"typIcon", false});	
					local addText = "Icon ".. g_i18n:getText("infohud_type").. ": ".. viewTypIconByWhat;					
					if inIconArea and box.isHelp then setInfoHelpText(addText);end;
				end;					
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then 
				overlay = overlayModGroup[overlayModByName["plow"]];
				if overlay ~= nil then
					local viewTypNameByWhat = "";					
					if box.ownTable.view.typName[1] > 1 then 
						iconColor = box.overlays.color.on;
						viewTypNameByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_yes")					
					else
						iconColor = box.overlays.color.notActive;
						viewTypNameByWhat = g_i18n:getText("button_no");
					end;					
					setOverlay("view_", iconColor, {"typName", false});						
					local addText = g_i18n:getText("infohud_type").. " ".. g_i18n:getText("infohud_name").. ": ".. viewTypNameByWhat;
					if inIconArea and box.isHelp then setInfoHelpText(addText);end; 				
				end;					
			else
				setWarningLine = true;
			end;
			--set icon right last--
			local nextIconRightPosX = nextRightPosX;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = box.overlays.state;
				tempOverlay = box.overlays.statePercent;
				local viewOverlay = box.overlays.settingIcons.view;
				if overlay ~= nil and tempOverlay ~= nil and viewOverlay ~= nil then
					g_currentMission.hlUtils.setBackgroundColor(tempOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.active, true));
					if Missions_Display.values.viewProgressBars[1] > 1 then
						g_currentMission.hlUtils.setBackgroundColor(viewOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.off, true));
					else
						g_currentMission.hlUtils.setBackgroundColor(viewOverlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
					end;
					setOverlay("view_", box.overlays.color.backgroundSetting, {"viewProgressBars"}, nil, false, nextIconRightPosX-iconWidth);
					g_currentMission.hlUtils.setOverlay(tempOverlay, nextIconRightPosX-iconWidth, nextPosY, iconWidth/1.5, iconHeight);
					tempOverlay:render();
					g_currentMission.hlUtils.setOverlay(viewOverlay, nextIconRightPosX-(iconWidth/2)-(iconWidthS/2), nextPosY, iconWidthS, iconHeightS);
					viewOverlay:render();
					if inIconArea and box.isHelp then setInfoHelpText(g_i18n:getText("box_viewProgressBars"));end;
					nextIconRightPosX = nextIconRightPosX-iconWidth-difW;
					nextIconPosX = nextIconPosX+iconWidth+difW; --set manual
				end;					
			else
				setWarningLine = true;
			end;
			--set icon right last--
			if setWarningLine then
				setWarningLineIcon();
			end;
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLineSetting--
		--viewExtraLine--
		function viewExtraLine()
			if nextPosY < y then return;end;			
			local onOffTxt = g_i18n:getText("ui_on").. "/".. g_i18n:getText("ui_off");
			local setWarningLine = false;
			local inIconArea = false;
			function setOverlay(whereClick, color, ownTable, blinking, setPosX, otherX, otherWidth, otherHeight)
				if color == nil then color = box.overlays.color.notActive;end;
				g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);				
				inIconArea = overlay.mouseInArea();
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
				local dropIcon = false;
				if blinking ~= nil then
					if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
						dropIcon = true;
					end;
				else
					dropIcon = true;
				end;
				if dropIcon then overlay:render();end;				
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
				if setPosX == nil or setPosX then 
					if otherX ~= nil then 
						nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
					else
						nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
					end;
				end;
				iconColor = nil;				
			end;
			--if nextIconPosX+iconWidth < x+w then
			--	overlay = overlayModGroup[overlayModByName["search"]];
			--	if overlay ~= nil then
			--		if box.searchFilter:len() > 0 then iconColor = box.overlays.color.on;end;
			--		setOverlay("search_", iconColor);
			--		if inIconArea and box.isHelp then setInfoHelpText(g_i18n:getText("box_searchFilterInfo"), 0);end;
			--	end;				
			--else
			--	setWarningLine = true;
			--end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["flip"]];
				if overlay ~= nil then
					if box.ownTable.view.sortBy[1] > 1 then iconColor = box.overlays.color.on;end;
					setOverlay("view_", iconColor, {"sortBy", true});
					local moreTxt = "\n".. string.format(g_i18n:getText("updateTact"), Missions_Display.values.missionsUpdateTimer).. "\n".. g_i18n:getText("mission_maphotspot");
					local sortByWhat = box.ownTable.sortByText[box.ownTable.view.sortBy[1]];
					if inIconArea then setInfoHelpText(g_i18n:getText("button_sortTable").. "... ".. g_i18n:getText("ui_contractsActive").. ": ".. tostring(sortByWhat).. moreTxt, 0);end;  --fieldJob_active
				end;				
			else
				setWarningLine = true;
			end;			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["missionsActive"]];
				if overlay ~= nil then
					local moreTxt = g_i18n:getText("ui_runningMissions");		
					if box.ownTable.view.missions[1] == 1 then iconColor = box.overlays.color.notActive;moreTxt = g_i18n:getText("ui_runningMissions").. "/".. g_i18n:getText("ui_pendingMissions");elseif box.ownTable.view.missions[1] == 2 then iconColor = box.overlays.color.on;moreTxt = g_i18n:getText("ui_runningMissions");elseif box.ownTable.view.missions[1] == 3 then iconColor = box.overlays.color.warning;moreTxt = g_i18n:getText("ui_pendingMissions");end;					
					setOverlay("view_", iconColor, {"missions"});	
					local addText = g_i18n:getText("ui_mapHotspotFilter_contracts").. ": ".. moreTxt;
					if inIconArea and box.isHelp then setInfoHelpText(addText);end; 
				end;					
			else
				setWarningLine = true;
			end;			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then 
				overlay = overlayModGroup[overlayModByName["missionsTypes"]];
				if overlay ~= nil then
					if box.ownTable.view.typLine[1] > 1 then iconColor = box.overlays.color.on;end;					
					setOverlay("view_", iconColor, {"typLine", false});	
					local addText = g_i18n:getText("button_showCategories").. ": ".. g_i18n:getText("box_viewMissionsTypLine");
					if inIconArea and box.isHelp then setInfoHelpText(addText);end; 
				end;					
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				if g_currentMission.missionDynamicInfo.isMultiplayer then
					overlay = overlayModGroup[overlayModByName["contractor"]];
					if overlay ~= nil then
						local moreTxt = g_i18n:getText("defaultFarmName");		
						if Missions_Display.values.viewMissionsFarm[1] == 1 then iconColor = box.overlays.color.notActive;elseif Missions_Display.values.viewMissionsFarm[1] == 2 then iconColor = box.overlays.color.on;moreTxt = moreTxt.. "/".. g_i18n:getText("contractorFarm");else iconColor = box.overlays.color.warning;moreTxt = g_i18n:getText("contractorFarm");end;					
						setOverlay("view_", iconColor, {"viewMissionsFarm", true});	
						local addText = g_i18n:getText("ui_ingameMenuContracts").. ": ".. moreTxt;
						if inIconArea and box.isHelp then setInfoHelpText(addText);end; 
					end;
				end;				
			else
				setWarningLine = true;
			end;			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then 
				overlay = overlayModGroup[overlayModByName["field"]];
				if overlay ~= nil then
					local viewFieldHectarByWhat = "";	
					if box.ownTable.view.fieldHectar[1] > 1 then 
						iconColor = box.overlays.color.on;
						if box.ownTable.view.fieldHectar[1] == 2 then
							viewFieldHectarByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_yes").. "/".. g_i18n:getText("ui_fieldNo").. "+".. g_i18n:getText("ui_fieldArea");							
						elseif box.ownTable.view.fieldHectar[1] == 3 then
							viewFieldHectarByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_yes").. "/".. g_i18n:getText("ui_fieldNo");	
						else
							viewFieldHectarByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_yes").. "/".. g_i18n:getText("ui_fieldArea");	
						end;
					elseif box.ownTable.view.fieldHectar[1] == 1 then 
						iconColor = box.overlays.color.notActive;
						viewFieldHectarByWhat = g_i18n:getText("ui_contractsActive").. "/".. g_i18n:getText("button_no");
					end;					
					setOverlay("view_", iconColor, {"fieldHectar", false});						
					local addText = g_i18n:getText("toolTip_showFieldInfo").. ": ".. viewFieldHectarByWhat;
					if inIconArea and box.isHelp then setInfoHelpText(addText);end; 
				end;					
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["clock"]];
				if overlay ~= nil then
					if box.ownTable.view.timeLimit[1] > 1 then 
						iconColor = box.overlays.color.on;
					elseif box.ownTable.view.timeLimit[5] and box.ownTable.view.timeLimit[1] == 1 then 
						iconColor = box.overlays.color.warning;
					else					
						iconColor = box.overlays.color.notActive;
					end;
					setOverlay("view_", iconColor, {"timeLimit"});
					local addText = "View ".. g_i18n:getText("contract_title").. " ".. g_i18n:getText("ui_ingameMissionTimeLimit").. " (RightClick view ".. tostring(box.ownTable.view.timeLimit[4]).. "s)"; --ui_statisticViewOverview = Überblick
					if inIconArea and box.isHelp then setInfoHelpText(addText);end;
				end;
			else
				setWarningLine = true;
			end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayModGroup[overlayModByName["closeLines"]];
				if overlay ~= nil then
					if openMissionDetails ~= nil and openMissionDetails then iconColor = box.overlays.color.warning;end;
					if openMissionDetails ~= nil and not openMissionDetails then
						setOverlay(nil, iconColor);
					else
						setOverlay("closeAllDetailsLines_", iconColor);
					end;
					if inIconArea and box.isHelp then setInfoHelpText(g_i18n:getText("box_closeDetailsLines"));end;
				end;					
			else
				setWarningLine = true;
			end;
			if box.isHelp then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayModGroup[overlayModByName["infos"]];
					if overlay ~= nil then					
						setOverlay(nil, box.overlays.color.title); --"missionClickInfos_"					
						local totalMissions = 0;
						if Missions_Display.missions.all ~= nil then totalMissions = #Missions_Display.missions.all;end;
						local moreTxt = g_i18n:getText("ui_mapHotspotFilter_contracts").. ": ".. tostring(totalMissions).. "\n";
						if inIconArea then setInfoHelpText(moreTxt.. g_i18n:getText("box_clickInfos"), 0);end; 
					end;					
				else
					setWarningLine = true;
				end;
			end;			
			if setWarningLine then
				setWarningLineIcon();
			end;
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		if box.viewExtraLine and not box.isSetting then viewExtraLine();elseif box.viewExtraLine and box.isSetting then viewExtraLineSetting();end;
		--viewExtraLine--		
		local color = nil;		
		local textColor = nil;
		local bounds1 = box.screen.bounds[1];
		local bounds2 = box.screen.bounds[2];
		local extraLineBounds = 0;		
		local isSwitchTimerTwo = g_currentMission.hlUtils.getIsSwitchTimer("missionsDisplay_switchTwo");
		for t=bounds1, bounds2 do			
			overlay = nil;
			classOverlay = nil;
			typOverlay = nil;
			fillTypeOverlay = nil;			
			if nextPosY < y then break;end;			
			
			---view Missions Types Icons---
			if t==bounds1 and (box.ownTable.view.missions[1] == 1 or box.ownTable.view.missions[1] == 3) and box.ownTable.view.typLine[1] > 1 then				
				local mNextLeftPosX = nextLeftPosX;
				local mNextRightPosX = nextRightPosX;
				local mLineWidth = w-(difW*2);
				local mCanNextView = true;
				local isNextPosY = false;
				local setWarningLine = false;
				if box.ownTable.typeIcons > 0 then							
					local maxIconWidth = box.ownTable.maxIconWidth;
					if maxIconWidth < box.ownTable.typeIcons then 
						local canBounds = true;
						overlay = overlayModGroup[overlayModByName["left"]];
						g_currentMission.hlUtils.setOverlay(overlay, mNextLeftPosX, nextPosY, iconWidth, iconHeight);
						iconColor = box.overlays.color.text;
						if box.ownTable.bounds[1] <= 1 then iconColor = box.overlays.color.off;canBounds = false;end;
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));					
						overlay:render();
						local inIconArea = canBounds and inArea and overlay.mouseInArea();								
						if canBounds and not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick="typIconLineBounds_", ownTable={"left"}} );end;
						canBounds = true;
						mNextLeftPosX = mNextLeftPosX+iconWidth+difW;
						mNextRightPosX = mNextRightPosX-iconWidth;
						overlay = overlayModGroup[overlayModByName["right"]];					
						g_currentMission.hlUtils.setOverlay(overlay, mNextRightPosX, nextPosY, iconWidth, iconHeight);
						iconColor = box.overlays.color.text;
						if box.ownTable.bounds[2] >= box.ownTable.bounds[4] then iconColor = box.overlays.color.off;canBounds = false;end;
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));					
						overlay:render();
						inIconArea = canBounds and inArea and overlay.mouseInArea();								
						if canBounds and not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick="typIconLineBounds_", ownTable={"right"}} );end;
						mNextRightPosX = mNextRightPosX-difW;
						isNextPosY = true; 
					end;				
				end;
				local typIconBounds1 = box.ownTable.bounds[1];
				local typIconBounds2 = box.ownTable.bounds[2];
				local typIconBounds = 0;
				for missionId, missionsType in ipairs(Missions_Display.values.missionsTypes) do
					if missionsType.isActive() then
						typIconBounds = typIconBounds+1;
						if typIconBounds >= typIconBounds1 and typIconBounds <= typIconBounds2 then
							if mNextLeftPosX+iconWidth <= mNextRightPosX then
								overlay = overlayModGroup[overlayModByName[missionsType.overlay]];
								if overlay ~= nil then
									local modMission = missionsType.modName ~= nil;
									local unknownMission = missionsType.overlay == "unknown";
									g_currentMission.hlUtils.setOverlay(overlay, mNextLeftPosX, nextPosY-difH, iconWidth, iconHeight);
									local inIconArea = false;
									if inArea then inIconArea = overlay.mouseInArea();end;
									if missionsType.view then
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
									else
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
									end;
									overlay:render();
									local total = tostring(missionsType.total)
									textColor = box.overlays.color.text;
									if missionsType.total > 0 then textColor = "ls22";else total = "-";end;
									setTextColor(unpack(g_currentMission.hlUtils.getColor(textColor, true)));
									setTextAlignment(RenderText.ALIGN_CENTER);					
									renderText(overlay.x+(overlay.width/2), overlay.y+overlay.height-0.0015, size/2, tostring(total));					
									setTextColor(1, 1, 1, 1);
									setTextAlignment(0);
									local maxNumInstances = "\n".. g_i18n:getText("ui_contracts").. ": ".. g_i18n:getText("ui_max");
									local moreText = "\n".. g_i18n:getText("ui_settingsMods").. " ".. g_i18n:getText("ui_name").. ": ";
									if modMission then moreText = moreText.. tostring(missionsType.modName);elseif unknownMission then moreText = moreText.. "! ".. g_i18n:getText("unknown").. " !";else moreText = "";end;
									local addText = string.format(g_i18n:getText("box_viewMissionsTyp"), missionsType.jobTypName);
									if missionsType.changeMaxNumInstance ~= nil then
										local tempMaxNumInstance = missionsType.changeMaxNumInstance();
										if tempMaxNumInstance ~= nil then missionsType.maxNumInstances = tempMaxNumInstance;end;
									end;
									if missionsType.maxNumInstances == nil then 
										Missions_DisplaySetGet:setMaxNumInstances(missionId, missionsType.name);
									end;
									if missionsType.maxNumInstances > 0 then maxNumInstances = maxNumInstances.. " ".. tostring(missionsType.maxNumInstances);else maxNumInstances = maxNumInstances.. " ! ".. g_i18n:getText("unknown").. " !";end;
									if inIconArea then setInfoHelpText(addText.. tostring(maxNumInstances).. tostring(moreText), 0);end; --info immer anzeigen
									if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Missions_Display_Box", typPos=boxNumber, whereClick="viewMissionsTyp_", ownTable={missionId=missionId}} );end;
									mLineWidth = mLineWidth-iconWidth
									mNextLeftPosX = mNextLeftPosX+iconWidth+difW;
									mCanNextView = mLineWidth > iconWidth;
									isNextPosY = true;
								end;
							else								
								mCanNextView = false;
							end;						
						end;						
					end;
					if not mCanNextView then break;end;
				end;				
				if isNextPosY then nextPosY = nextPosY-box.ownTable.lineHeight;end;
			end;
			---view Missions Types Icons---
			
			if nextPosY < y then break;end;	
			if Missions_DisplaySetGet.viewMissionsBox[t] ~= nil then
				local mission = Missions_DisplaySetGet.viewMissionsBox[t];												
				
				if mission.failed then color = g_currentMission.hlUtils.getColor(box.overlays.color.off, true);elseif mission.finish then color = g_currentMission.hlUtils.getColor(box.overlays.color.on, true);elseif mission.isRunning then color = g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true);else color = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);end;
								
				local canNextView = true;
				local lineWidth = w-(difW*2);
				
				function getInIconArea(posX, posY, width, height)
					if not inArea then return false;end;
					overlay = box.overlays.bgLine; --hidden overlay
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width or lineWidth, height or box.ownTable.lineHeight);
						return overlay.mouseInArea();
					end;
					return false;
				end;
				
				---marker for new mission---
				if mission.setNewMarker ~= nil and mission.setNewMarker then
					if not mission.isRunning and not mission.failed and not mission.finish then
						overlay = overlayModGroup[overlayModByName["new"]];
						tempOverlay = overlayModGroup[overlayModByName["bgRound"]];
						if overlay ~= nil and tempOverlay ~= nil then
							g_currentMission.hlUtils.setOverlay(tempOverlay, x-iconWidth, nextPosY, iconWidth, iconHeight);
							g_currentMission.hlUtils.setOverlay(overlay, tempOverlay.x+(tempOverlay.width/2)-(iconWidthS/2), tempOverlay.y+(tempOverlay.height/2)-(iconHeightS/2), iconWidthS, iconHeightS);
							tempOverlay:render();
							if g_currentMission.hlUtils.runsTimer("1sec", true) then overlay:render();end; --blinking
						end;
					end;
				end;
				---marker for new mission---
				
				---reward/percent---
				if canNextView then					
					local text = "";					
					if mission.isRunning and not mission.failed and not mission.finish then ---wegen überlappung mit eventuell leasing/contractor icons
						local percent = tostring(mission.percent).. "%";
						text = g_currentMission.hlUtils.getTxtToWidth(percent, size, lineWidth, true, ".");
						setTextBold(true);						
					else
						local reward = "0";						
						if mission.failed then reward = tostring(g_i18n:formatMoney(mission.totalReward, 0, true, false));else reward = tostring(g_i18n:formatMoney(mission.reward, 0, true, false));end;
						if g_currentMission.missionDynamicInfo.isMultiplayer then
							if Missions_Display.values.viewMissionsFarm[1] > 1 and mission.isRunning and mission.farmId ~= nil and mission.farmId ~= playerFarmId then reward = "xxxx".. " ".. g_i18n:getCurrencySymbol(true);end;
						end;
						text = g_currentMission.hlUtils.getTxtToWidth(reward, size, lineWidth, true, ".");
					end;
					local minutesWarning = not mission.failed and mission.hasTimeLimit and mission.minutes <= Missions_Display.values.warningIsTimeLimit[1];
					local dropMinutesWarning = false;
					if not mission.viewDetails and (box.ownTable.view.timeLimit[1] == 2 or box.ownTable.view.timeLimit[5]) then --switch view for ~20 sec.
						if not mission.failed and mission.hasTimeLimit then 
							text = g_i18n:formatMinutes(mission.minutes);
						else
							text = g_i18n:getText("ui_hours_none");
						end;
					end;					
					if not mission.viewDetails and minutesWarning and box.ownTable.view.timeLimit[1] ~= 2 and not box.ownTable.view.timeLimit[5] then
						overlay = overlayModGroup[overlayModByName["clock"]];
						if overlay ~= nil then
							g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth-difW, nextPosY, iconWidth, iconHeight);
							if mission.minutes < Missions_Display.values.warningIsTimeLimit[2] then
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("orangeRed", true));
							else
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
							end;							
							dropMinutesWarning = isSwitchTimerTwo ~= nil and isSwitchTimerTwo == 2;
						end;
					end;
					if dropMinutesWarning and g_currentMission.hlUtils.runsTimer("1sec", true) then --blinking
						overlay:render();
					else
						if minutesWarning then
							if mission.minutes < Missions_Display.values.warningIsTimeLimit[2] then
								setTextColor(unpack(g_currentMission.hlUtils.getColor("orangeRed", true)));
							else
								setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)));
							end;
						else
							setTextColor(unpack(color));
						end;
						setTextAlignment(2);					
						renderText(nextRightPosX, nextPosY, size-difSize, tostring(text));					
						setTextColor(1, 1, 1, 1);
						setTextAlignment(0);
						setTextBold(false);	
					end;
					lineWidth = lineWidth-box.ownTable.rewardWidth;
					nextRightPosX = nextRightPosX-box.ownTable.rewardWidth;
					canNextView = lineWidth > iconWidth;
					
					local tempNextRightPosX = x+w-difW-box.ownTable.rewardWidth+(iconWidth/2);					
					---leasing vehicles---					
					local isLeasingVehicles = mission.leasingVehicles and (mission.isRunning or mission.failed or mission.finish);
					local canLeasingVehicles = false; --mission.canLeasingVehicles;
					if box.ownTable.view.timeLimit[1] ~= 2 and not box.ownTable.view.timeLimit[5] and canNextView and (isLeasingVehicles or canLeasingVehicles) then
						overlay = overlayModGroup[overlayModByName["leasing"]];
						if overlay ~= nil then							
							g_currentMission.hlUtils.setOverlay(overlay, tempNextRightPosX, nextPosY-difH, iconWidth, iconHeight);
							if isLeasingVehicles then 
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true));
							else
								g_currentMission.hlUtils.setBackgroundColor(overlay, color);
							end;
							overlay:render();
							tempNextRightPosX = tempNextRightPosX-iconWidthS;							
							canNextView = lineWidth > iconWidth;
						end;
					end;
					---leasing vehicles---
					
					---contractor mission---
					if g_currentMission.missionDynamicInfo.isMultiplayer then
						if canNextView and Missions_Display.values.viewMissionsFarm[1] > 1 and (mission.isRunning or mission.finish) and mission.farmId ~= nil and mission.farmId ~= playerFarmId then
							overlay = overlayModGroup[overlayModByName["contractor"]];
							if overlay ~= nil then								
								g_currentMission.hlUtils.setOverlay(overlay, tempNextRightPosX, nextPosY, iconWidthS, iconHeightS);
								g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true));
								overlay:render();								
								canNextView = lineWidth > iconWidth;
							end;
						end;
					end;
					---contractor mission---
					
					---for clickArea and help text---
					local areaLineWidth = lineWidth+box.ownTable.rewardWidth;
					if areaLineWidth >= box.ownTable.rewardWidth then areaLineWidth = box.ownTable.rewardWidth;else areaLineWidth = getTextWidth(size, utf8Substr(text, 0));end;
					if box.isHelp and getInIconArea(nextRightPosX, nil, areaLineWidth, nil) then setInfoHelpText(g_i18n:getText("mission_ingameMenue"));end;					
					---for clickArea and help text---
					if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextRightPosX, nextRightPosX+areaLineWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="rewardPercent_", ownTable={missionId=mission.id}} );end;
				end;
				---reward/Percent---
				
				---field/hectar/farmland---
				if canNextView and box.ownTable.view.fieldHectar[1] > 1 then					
					local nextWidth = box.ownTable.fieldWidth;					
					if (mission.field ~= nil and mission.field.id ~= nil) then
						local tempLineWidth = w-(difW*2)-box.ownTable.rewardWidth;
						local tempRightPosX = nextRightPosX;						
						local fieldText = "F-".. tostring(mission.field.id);						
						local hectarLarge = Utils.getNoNil(mission.field.hectar,0) > 999;
						if box.ownTable.view.fieldHectar[1] == 2 then
							if mission.field.hectar ~= nil then								
								if hectarLarge then 
									fieldText = fieldText.. "/".. tostring(string.format("%1.1f", "".. tostring(mission.field.hectar))).. " ".. tostring(g_i18n:getText("unit_haShort")); --to long
								else
									fieldText = fieldText.. "/".. tostring(string.format("%1.2f", "".. tostring(mission.field.hectar))).. " ".. tostring(g_i18n:getText("unit_haShort")); 
								end;
							end;
							nextWidth = nextWidth+box.ownTable.hectarWidth; --to long
						elseif box.ownTable.view.fieldHectar[1] == 4 then
							if hectarLarge then
								fieldText = tostring(string.format("%1.1f", "".. tostring(mission.field.hectar))).. " ".. tostring(g_i18n:getText("unit_haShort")); --to long
							else
								fieldText = tostring(string.format("%1.2f", "".. tostring(mission.field.hectar))).. " ".. tostring(g_i18n:getText("unit_haShort"));
							end;
							nextWidth = box.ownTable.hectarWidth;
						end;
						if mission.finish or mission.failed or mission.isRunning then
							setTextColor(unpack(color));
						else
							setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true)));
						end;
						fieldText = g_currentMission.hlUtils.getTxtToWidth(fieldText, size-difSize, tempLineWidth, false, ".");
						if nextRightPosX-nextWidth < nextLeftPosX then
							tempRightPosX = nextLeftPosX;
						else
							tempRightPosX = tempRightPosX-nextWidth
						end;
						setTextBold(true);
						renderText(tempRightPosX, nextPosY, size-difSize, tostring(fieldText));					
						setTextColor(1, 1, 1, 1);
						setTextBold(false);
						if lineWidth-nextWidth > iconWidth then
							if box.isHelp and getInIconArea(tempRightPosX, nil, nextWidth, nil) then setInfoHelpText(g_i18n:getText("box_viewMissionDetails"));end;							
							if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id, fieldId=mission.field.id}} );end;
						end;
					elseif mission.farmlandId ~= nil then
						local tempLineWidth = w-(difW*2)-box.ownTable.rewardWidth;
						local tempRightPosX = nextRightPosX;						
						local farmlandText = "L-";
						if mission.farmlandId == 0 then farmlandText = farmlandText.. g_i18n:getText("ui_no");else farmlandText = farmlandText.. tostring(mission.farmlandId);end;
						if box.ownTable.view.fieldHectar[1] == 2 or box.ownTable.view.fieldHectar[1] == 4 then nextWidth = nextWidth+box.ownTable.hectarWidth;end;
						if mission.finish or mission.failed or mission.isRunning then
							setTextColor(unpack(color));
						else
							setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true)));
						end;
						farmlandText = g_currentMission.hlUtils.getTxtToWidth(farmlandText, size-difSize, tempLineWidth, false, ".");
						if nextRightPosX-nextWidth < nextLeftPosX then
							tempRightPosX = nextLeftPosX;
						else
							tempRightPosX = tempRightPosX-nextWidth
						end;
						setTextBold(true);
						renderText(tempRightPosX, nextPosY, size-difSize, tostring(farmlandText));					
						setTextColor(1, 1, 1, 1);
						setTextBold(false);
						if lineWidth-nextWidth > iconWidth then
							if box.isHelp and getInIconArea(tempRightPosX, nil, nextWidth, nil) then setInfoHelpText(g_i18n:getText("box_viewMissionDetails"));end;							
							if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id, farmlandId=mission.farmlandId}} );end;
						end;
					else						
						if box.ownTable.view.fieldHectar[1] == 2 then nextWidth = nextWidth+box.ownTable.hectarWidth;elseif box.ownTable.view.fieldHectar[1] == 4 then nextWidth = box.ownTable.hectarWidth;end;
					end;
					--with empty is not fillType, better for Alignment line--
					lineWidth = lineWidth-nextWidth;
					nextRightPosX = nextRightPosX-nextWidth;
					canNextView = lineWidth > iconWidth;
					--with empty is not fillType, better for Alignment line--					
				end;
				---field/hectar/farmland---
				
				local baleType = nil;
				---fruitType/fillType name---
				if canNextView and (box.ownTable.view.fillType[1] == 1 or box.ownTable.view.fillType[1] == 2) then
					local fillTypeIndex, baleTyp = Missions_DisplaySetGet:getFillTypeIndex(mission, false);
					baleType = baleTyp;
					local nextWidth = box.ownTable.fillTypeNameWidth;					
					if fillTypeIndex ~= nil then
						local tempRightPosX = nextRightPosX;
						local fillTypeTitle = string.sub(g_fillTypeManager:getFillTypeTitleByIndex(fillTypeIndex), 1, box.ownTable.view.fruitNameLength[1]).. "#";
						fillTypeTitle = g_currentMission.hlUtils.getTxtToWidth(fillTypeTitle, size, lineWidth, false, ".");
						if mission.finish or mission.failed or mission.isRunning then
							setTextColor(unpack(color));
						else
							setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true)));
						end;
						if nextRightPosX-nextWidth < nextLeftPosX then
							tempRightPosX = nextLeftPosX;
						else
							tempRightPosX = tempRightPosX-nextWidth
						end;
						renderText(tempRightPosX, nextPosY, size-difSize, tostring(fillTypeTitle));					
						setTextColor(1, 1, 1, 1);
						if lineWidth-nextWidth > iconWidth then
							if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {tempRightPosX, tempRightPosX+nextWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="fruitNameIcon_", ownTable={missionId=mission.id, fillTypeIndex=fillTypeIndex}} );end;
						end;
					end;
					--with empty is not fillType, better for Alignment line--
					nextRightPosX = nextRightPosX-nextWidth;
					lineWidth = lineWidth-nextWidth;
					canNextView = lineWidth > iconWidth;
					--with empty is not fillType, better for Alignment line--
				end;
				---fruitType/fillType name---
				
				---fruitType/fillType icon---
				if canNextView and (box.ownTable.view.fillType[1] == 2 or box.ownTable.view.fillType[1] == 3) then 				
					local setNextWidth = false;
					local fillTypeIndex = nil;					
					if mission.typ == "roller" or string.find(mission.typ, "roller") or mission.typ == "plow" or mission.typ == "cultivate" or mission.typ == "transport" or mission.typ == "weed" or mission.typ == "hoe" or mission.typ == "treetransport" or mission.typ == "deadwood" or mission.typ == "destructiblerock" or mission.typ == "stonepick" or mission.typ == "tedder" or mission.typ == "mow" then						
						if box.ownTable.view.fillType[4] then
							if mission.typ == "treetransport" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_woodTree"]];
							elseif mission.typ == "transport" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_product"]];							
							elseif mission.typ == "deadwood" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_deadTree"]];
							elseif mission.typ == "destructiblerock" then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_rock"]];
							elseif mission.typ == "stonepick" then fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(FillType.STONE)]];
							elseif mission.typ == "mow" then fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(FillType.GRASS_WINDROW)]];							
							else fillTypeOverlay = overlayModGroup[overlayModByName["fillType_field"]];end;
						else
							setNextWidth = true;
						end;
					else
						fillTypeIndex, baleTyp, modOverlay = Missions_DisplaySetGet:getFillTypeIndex(mission, true);									
						baleType = baleTyp;
						if fillTypeIndex ~= nil then														
							fillTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(fillTypeIndex)]];						
						else
							if modOverlay ~= nil then 
								fillTypeOverlay = overlayModGroup[overlayModByName[modOverlay]];
							elseif mission.field ~= nil and mission.field.id ~= nil then fillTypeOverlay = overlayModGroup[overlayModByName["fillType_field"]];else fillTypeOverlay = overlayModGroup[overlayModByName["fillType_other"]];end;
						end;
					end;					
					if fillTypeOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(fillTypeOverlay, nextRightPosX-iconWidthB, nextPosY-difH, iconWidthB, iconHeightB);
						fillTypeOverlay:render();								
						if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {fillTypeOverlay.x, fillTypeOverlay.x+fillTypeOverlay.width, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="fruitNameIcon_", ownTable={mission=mission.id, fillTypeIndex=fillTypeIndex, jobName=tostring(mission.jobTyp)}} );end;
						setNextWidth = true;
					end;
					if setNextWidth then
						nextRightPosX = nextRightPosX-iconWidthB-difW;
						lineWidth = lineWidth-iconWidthB;
						canNextView = lineWidth > iconWidth;
					end;
				end;
				---fruitType/fillType icon---
				
				---job type icon---
				if canNextView and box.ownTable.view.typIcon[1] > 1 then
					local classOverlayString, typOverlayString = Missions_DisplaySetGet:getTypesOverlays(mission);
					
					classOverlay = overlayModGroup[overlayModByName[classOverlayString]];
					typOverlay = overlayModGroup[overlayModByName[typOverlayString]];										
					
					if canNextView and (box.ownTable.view.typIcon[1] == 2 or box.ownTable.view.typIcon[1] == 3) and classOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(classOverlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						g_currentMission.hlUtils.setBackgroundColor(classOverlay, color);
						classOverlay:render();
						if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {classOverlay.x, classOverlay.x+classOverlay.width, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id}} );end;
						nextLeftPosX = nextLeftPosX+iconWidthB+difW;
						lineWidth = lineWidth-iconWidthB-difW;
						canNextView = lineWidth > iconWidthB;
					end;
					if canNextView and (box.ownTable.view.typIcon[1] == 2 or box.ownTable.view.typIcon[1] == 4) and typOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(typOverlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
						g_currentMission.hlUtils.setBackgroundColor(typOverlay, color);
						typOverlay:render();
						if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {typOverlay.x, typOverlay.x+typOverlay.width, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id}} );end;
						nextLeftPosX = nextLeftPosX+iconWidthB+difW;
						lineWidth = lineWidth-iconWidthB-difW;
						canNextView = lineWidth > iconWidthB;
					end;					
				end;
				---job type icon---				
				
				---job name/other---				
				if canNextView and box.ownTable.view.typName[1] > 1 then
					local text = tostring(mission.jobTyp);
					if baleType ~= nil and box.ownTable.view.fillType[1] == 1 then if baleType == "square" then text = text.. "/Q" else text = text.. "/R";end;end;
					text = g_currentMission.hlUtils.getTxtToWidth(text, size, lineWidth, false, ".");
					setTextColor(unpack(color));
					renderText(nextLeftPosX, nextPosY, size, tostring(text));					
					setTextColor(1, 1, 1, 1);
					local textWidth = getTextWidth(size, utf8Substr(text, 0));					
					if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+textWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id}} );end;
					nextLeftPosX = nextLeftPosX+textWidth;
					lineWidth = lineWidth-textWidth;
					canNextView = lineWidth > iconWidth;					
				end;
				---job name/other---				
				
				---mission details---
				if mission.viewDetails then					
					nextPosY = nextPosY-box.ownTable.lineHeight;
					local detailsLineWidth = w-(difW*2);
					local detailsNextLeftPosX = x+difW;				
					local detailsNextRightPosX = x+w-difW;
					local detailsColor = g_currentMission.hlUtils.getColor(box.overlays.color.columTitle, true);
					if nextPosY > y then
						local isNextPosY = false;
						function setNextPosY()
							if isNextPosY then
								nextPosY = nextPosY-box.ownTable.lineHeight;							
								detailsLineWidth = w-(difW*2);
								detailsNextLeftPosX = x+difW;				
								detailsNextRightPosX = x+w-difW;
								canNextView = true;
								isNextPosY = false;
							end;
						end;
						local text = "";	
						local dropTimeLimit = false;
						---time limit---
						if nextPosY > y then
							local minutesText = "--.--";							
							local runningMinutesText = "";
							local minutesWarning = false;
							if mission.isRunning then
								text = tostring(g_i18n:getText("ui_pendingMissionTimeLeftTitle"));								
							else
								text = tostring(g_i18n:getText("ui_ingameMissionTimeLimit"));
							end;
							if not mission.failed and mission.hasTimeLimit then
								minutesText = g_i18n:formatMinutes(mission.minutes);
								if mission.hasTimeLimitMod and not mission.isRunning and not mission.failed and not mission.finish then
									if mission.runningMinutes ~= nil then 
										local dropRunningMinutes = math.ceil(mission.runningMinutes) ~= math.ceil(mission.minutes);
										if dropRunningMinutes then runningMinutesText = "|*".. g_i18n:formatMinutes(mission.runningMinutes);end;
									else 
										runningMinutesText = "|*--.--";
									end;
								end;
								minutesWarning = mission.minutes <= Missions_Display.values.warningIsTimeLimit[1];
							else																	
								minutesText = tostring(g_i18n:getText("ui_no"));								
							end;
							minutesText = g_currentMission.hlUtils.getTxtToWidth(minutesText.. runningMinutesText, size, detailsLineWidth, true, ".");
							if minutesWarning then
								if mission.minutes < Missions_Display.values.warningIsTimeLimit[2] then
									setTextColor(unpack(g_currentMission.hlUtils.getColor("orangeRed", true)));
								else
									setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)));
								end;
							else
								setTextColor(unpack(detailsColor));
							end;
							setTextAlignment(2);					
							renderText(detailsNextRightPosX, nextPosY, size, tostring(minutesText));							
							setTextAlignment(0);
							detailsLineWidth = detailsLineWidth-box.ownTable.minutesWidth;
							detailsNextRightPosX = detailsNextRightPosX-box.ownTable.minutesWidth;
							canNextView = detailsLineWidth > iconWidth;
							if canNextView then
								text = g_currentMission.hlUtils.getTxtToWidth(text, size, detailsLineWidth, false, ".");
								renderText(detailsNextLeftPosX, nextPosY, size, tostring(text));
							end;
							setTextColor(1, 1, 1, 1);
							extraLineBounds = extraLineBounds+1;
							isNextPosY = true;
						end;
						---time limit---
						setNextPosY();
						---reward isRunning---
						if nextPosY > y then
							if mission.isRunning and not mission.failed and not mission.finish then
								text = "";	
								local reward = tostring(g_i18n:formatMoney(mission.reward, 0, true, false));						
								if g_currentMission.missionDynamicInfo.isMultiplayer then
									if Missions_Display.values.viewMissionsFarm[1] > 1 and mission.isRunning and mission.farmId ~= nil and mission.farmId ~= playerFarmId then reward = "xxxx".. " ".. g_i18n:getCurrencySymbol(true);end;
								end;
								text = g_currentMission.hlUtils.getTxtToWidth(reward, size, detailsLineWidth, true, ".");
								setTextColor(unpack(detailsColor));
								setTextAlignment(2);					
								renderText(detailsNextRightPosX, nextPosY, size, tostring(text));							
								setTextAlignment(0);
								detailsLineWidth = detailsLineWidth-box.ownTable.rewardWidth;
								detailsNextRightPosX = detailsNextRightPosX-box.ownTable.rewardWidth;
								canNextView = detailsLineWidth > iconWidth;							
								if canNextView then
									text = g_currentMission.hlUtils.getTxtToWidth(g_i18n:getText("ui_ingameMissionMoney"), size, detailsLineWidth, false, ".");
									renderText(detailsNextLeftPosX, nextPosY, size, tostring(text));
								end;
								setTextColor(1, 1, 1, 1);
								extraLineBounds = extraLineBounds+1;
								isNextPosY = true;
							end;
						end;
						---reward isRunning---
						setNextPosY();
						---sell... station/trigger---
						if nextPosY > y then
							local transport = mission.dataByMod ~= nil and mission.dataByMod.typ ~= nil and (mission.dataByMod.typ == "TRANSPORT" or mission.dataByMod.typ == "TRANSFER");
							if mission.sellPointId ~= nil or mission.sellingStationId ~= nil or mission.typ == "transport" or mission.typ == "treetransport" or mission.typ == "deadwood" or mission.typ == "destructiblerock" or transport then								
								text = "-";
								if not mission.finish then
									if mission.field ~= nil then
										if mission.field.expectedLiters ~= nil then 
											local isLiters = mission.field.expectedLiters-Utils.getNoNil(mission.field.depositedLiters, 0);											
											if isLiters <= 0.1 then isLiters = 0;else 
											text = g_i18n:formatVolume(Utils.getNoNil(isLiters, 0));end;
										end;
									elseif mission.transport.supplyLiters ~= nil then
										local isLiters = mission.transport.supplyLiters-Utils.getNoNil(mission.transport.deliveredLiters, 0);									
										text = g_i18n:formatVolume(Utils.getNoNil(isLiters, 0));									
									elseif mission.typ == "transport" or mission.typ == "treetransport" or mission.typ == "deadwood" or mission.typ == "destructiblerock" or transport then
										if mission.typ == "transport" then text = tostring(mission.transport.numObjects).. " ".. g_i18n:getText("category_pallets");
										elseif transport then
											text = tostring(mission.transport.numObjects);
											local objectTypString = g_i18n:getText("category_misc");
											if mission.transport.objectTypString ~= nil then
												objectTypString = tostring(mission.transport.objectTypString);
												if string.find(objectTypString:lower(), "missing") then objectTypString = g_i18n:getText("category_misc");end;												
											end;
											text = tostring(mission.transport.numObjects).. " ".. objectTypString;										
										elseif mission.typ == "treetransport" then text = tostring(mission.transport.numTrees-mission.transport.numDeliveredTrees).. " ".. g_i18n:getText("helpLine_Misc_Transport_Logs_title");
										elseif mission.typ == "deadwood" then text = tostring(mission.numDeadTrees-mission.numCutDownTrees ).. " ".. g_i18n:getText("ui_permissions_cutTrees");
										elseif mission.typ == "destructiblerock" then text = tostring(mission.numRocks-mission.numRocksDestroyed).. "x"; 
										else text = "?x";end;							
									end;
								end;
								if text:len() > 1 then
									text = g_currentMission.hlUtils.getTxtToWidth(text, size, detailsLineWidth, true, ".");									
								else
									text = g_currentMission.hlUtils.getTxtToWidth(text, size, detailsLineWidth, true, "");	
								end;
								setTextColor(unpack(detailsColor));
								setTextAlignment(2);					
								renderText(detailsNextRightPosX, nextPosY, size, tostring(text));							
								setTextAlignment(0);
								local textWidth = getTextWidth(size, utf8Substr(text, 0));	
								detailsLineWidth = detailsLineWidth-textWidth;
								detailsNextRightPosX = detailsNextRightPosX-textWidth;
								canNextView = detailsLineWidth > iconWidth;								
								
								if canNextView then								
									local stationName = "";
									if mission.sellingStationId ~= nil then  
										stationName = mission.sellingStationName; 
									elseif mission.typ == "transport" or transport then
										stationName = mission.transport.dropoffTriggerName;									
									else
										stationName = mission.sellPointName;
									end;
									if stationName == nil or stationName:len() == 0 then 
										if string.find(mission.typ, "forestrypack") then
											stationName = "---";
										else
											stationName = g_i18n:getText("ui_name").. " ? (".. g_i18n:getText("ai_parameterGroupTitleUnloadingStation").. ")";
										end;
									else 
										local distance = "";										
										if mission.distance ~= nil and mission.distance > 0 then distance = "/".. g_i18n:formatDistance(mission.distance, 0);end;
										stationName = stationName.. distance; 
									end; 
									text = g_currentMission.hlUtils.getTxtToWidth(stationName, size, detailsLineWidth, false, ".");									
									renderText(detailsNextLeftPosX, nextPosY, size, tostring(text));					
								end;
								
								extraLineBounds = extraLineBounds+1;
								isNextPosY = true;
								if mission.transport.supplyTimeLimit ~= nil then
									setNextPosY();
									text = g_currentMission.hlUtils.getTxtToWidth(tostring(mission.transport.supplyTimeLimit), size, detailsLineWidth, true, ".");									
									renderText(detailsNextLeftPosX, nextPosY, size, tostring(text));
									extraLineBounds = extraLineBounds+1;
									isNextPosY = true;
								end;
								if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {detailsNextLeftPosX, detailsNextLeftPosX+detailsLineWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=Missions_Display_MouseKeyEventsBox.onClickArea, whatClick="Mission_Display_Box", typPos=boxNumber, whereClick="viewMissionDetails_", ownTable={missionId=mission.id}} );end;
								setTextColor(1, 1, 1, 1);
							end;
						end;
						---sell... station/trigger---
						setNextPosY();
						---leasing cost---
						if nextPosY > y and mission.canLeasingVehicles and mission.leasingVehicleCost ~= nil and (not mission.isRunning or (mission.isRunning and mission.leasingVehicles)) then
							local leasingCost =  "-".. tostring(g_i18n:formatMoney(mission.leasingVehicleCost, 0, true, false));
							text = g_currentMission.hlUtils.getTxtToWidth(leasingCost, size, detailsLineWidth, true, ".");
							setTextColor(unpack(detailsColor));
							setTextAlignment(2);					
							renderText(detailsNextRightPosX, nextPosY, size, tostring(text));							
							setTextAlignment(0);
							detailsLineWidth = detailsLineWidth-box.ownTable.rewardWidth;
							detailsNextRightPosX = detailsNextRightPosX-box.ownTable.rewardWidth;
							canNextView = detailsLineWidth > iconWidth;							
							if canNextView then
								text = g_currentMission.hlUtils.getTxtToWidth(g_i18n:getText("finance_vehicleLeasingCost"), size, detailsLineWidth, false, "."); 
								renderText(detailsNextLeftPosX, nextPosY, size, tostring(text));
							end;
							setTextColor(1, 1, 1, 1);
							extraLineBounds = extraLineBounds+1;
							isNextPosY = true;
						end;
						---leasing cost---						
						setNextPosY();
						---leasing vehicles---
						if nextPosY > y and mission.canLeasingVehicles and #mission.leasingVehicleName > 0 and not mission.isRunning and not mission.failed and not mission.finish then							
							local overlayVehiclesGroup = g_currentMission.hlUtils.overlays["LS_Vehicles"]["vehicles"];
							local overlayVehiclesByName = g_currentMission.hlUtils.overlays.byName["LS_Vehicles"]["vehicles"];
							overlay = overlayModGroup[overlayModByName["markedLine"]];
							if overlay ~= nil then
								g_currentMission.hlUtils.setOverlay(overlay, x, nextPosY-(difH*2), w, iconHeightV-difH);
								overlay:render();
							end;
							for v=1, #mission.leasingVehicleName do
								local vehicleOverlay = overlayVehiclesGroup[overlayVehiclesByName[mission.leasingVehicleName[v]]];
								if vehicleOverlay ~= nil and canNextView then									
									g_currentMission.hlUtils.setOverlay(vehicleOverlay, detailsNextLeftPosX, nextPosY-difH, iconWidthV, iconHeightV);
									vehicleOverlay:render();									
									detailsLineWidth = detailsLineWidth-iconWidthV;
									detailsNextLeftPosX = detailsNextLeftPosX+iconWidthV;
									canNextView = detailsLineWidth > iconWidthV;
									isNextPosY = true;
								end;
							end;
							if isNextPosY then extraLineBounds = extraLineBounds+1;end;							
						end;
						---leasing vehicles---
						setNextPosY();						
						--- ??? ---
						--ideen !--
						--- ??? ---
						
						nextPosY = nextPosY+box.ownTable.lineHeight;
					end;
				end;
				---mission details---
				
				nextPosY = nextPosY-box.ownTable.lineHeight;
				nextRightPosX = x+w-difW;
				nextLeftPosX = x+difW;
			elseif #Missions_DisplaySetGet.viewMissionsBox == 0 then
				color = box.overlays.color.text;
				local moreTxt = "";
				--if not box.viewExtraLine and box.searchFilter:len() > 0 then moreTxt = tostring(g_i18n:getText("searchFilter_On"));end;
				local text = "";				
				if box.ownTable.view.missions[1] == 2 then
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("ui_noRunningMissions")).. moreTxt, size, w-(difW*2), false, ".");				
				elseif box.ownTable.view.missions[1] == 3 then
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("ui_noPendingMissions")).. moreTxt, size, w-(difW*2), false, ".");						
				else
					text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("ui_noMissions")).. moreTxt, size, w-(difW*2), false, ".");
				end;				
				--	text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("character_option_none")).. moreTxt, size, w-(difW*2), false, ".");							
				setTextColor(unpack(g_currentMission.hlUtils.getColor(color, true)));
				renderText(nextLeftPosX, nextPosY, size, tostring(text));
				setTextColor(1, 1, 1, 1);
				break;
			end;
			if extraLineBounds+t >= bounds2 then break;end;
		end;
		box.screen.bounds[4] = box.screen.bounds[4]+extraLineBounds;
	end;	
end;