Missions_DisplaySetGet = {};

function Missions_DisplaySetGet:loadFillTypesIcons()
	g_currentMission.hlUtils.loadFillTypesOverlays();	
end;

function Missions_DisplaySetGet:loadHudIcons(hud) -- + box icons in global table
	if hud.overlays.modIcons == nil then hud.overlays.modIcons = {byName={}};end;
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.hudIcons", modDir=Missions_Display.modDir, iconFile="icons_missionsdisplay/icons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="hud", fileFormat={64,128,64}, iconTable=hud.overlays.modIcons} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.iconsByHud", modDir=Missions_Display.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="hud", fileFormat={64,512,1024}, iconTable=hud.overlays.modIcons} );
	--missionsType Icons--
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.iconsMissionsOther32", modDir=Missions_Display.modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,256,512}} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.iconsMissions64", modDir=Missions_Display.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={64,512,1024}} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.boxIcons", modDir=Missions_Display.modDir, iconFile="icons_missionsdisplay/icons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={64,128,64}} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.other1Icons32", modDir=Missions_Display.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,256,512}} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="missions_display.colorIcons32", modDir=Missions_Display.modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlFile="icons_missionsdisplay/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,128,256}} );
	
	--missionsType Icons--
end;

function Missions_DisplaySetGet:getMissionsTypes(boxList)
	local map = g_currentMission.missionInfo.map;
	local jobTypes = {
		cultivateMission = {jobTypName="contract_field_cultivate_title", overlay="cultivate", getIsActive=function()return true;end, view=true};
		fertilizeMission = {jobTypName="contract_field_fertilize_title", overlay="spray", getIsActive=function()return true;end, view=true};
		harvestMission = {jobTypName="contract_field_harvest_title", overlay="harvest", getIsActive=function()return true;end, view=true};
		plowMission = {jobTypName="contract_field_plow_title", overlay="plow", getIsActive=function()return true;end, view=true}; --g_currentMission.missionInfo.plowingRequiredEnabled
		sowMission = {jobTypName="contract_field_sow_title", overlay="sow", getIsActive=function()return true;end};		
		weedMission = {jobTypName="contract_field_weed_title", overlay="weed", getIsActive=function()return g_currentMission.missionInfo.weedsEnabled;end, view=true};
		deadwoodMission = {jobTypName="contract_forestry_deadwood_title", overlay="chainsaw", getIsActive=function()return true;end, view=true};
		treeTransportMission = {jobTypName="contract_forestry_treeTransport_title", overlay="woodTrailer", getIsActive=function()return true;end, view=true};
		destructibleRockMission = {jobTypName="contract_map_destructibleRock_title", overlay="hammer", getIsActive=function()return true;end, view=true};
		
		herbicideMission = {jobTypName="contract_field_herbicide_title", overlay="spray", getIsActive=function()return g_currentMission.missionInfo.weedsEnabled;end, view=true};
		baleMission = {jobTypName="contract_field_bale_title", overlay="bale", getIsActive=function()return true;end, view=true};	
		mowMission = {jobTypName="contract_field_mow_title", overlay="selfpropelledmower", getIsActive=function()return true;end, view=true};	
		baleWrapMission = {jobTypName="contract_field_baleWrap_title", overlay="wraping", getIsActive=function()return true;end, view=true};	
		hoeMission = {jobTypName="contract_field_hoe_title", overlay="hoe", getIsActive=function()return g_currentMission.missionInfo.weedsEnabled;end, view=true};
		tedderMission = {jobTypName="contract_field_tedder_title", overlay="tedder", getIsActive=function()return true;end, view=true};
		stonePickMission = {jobTypName="contract_field_stonePick_title", overlay="stonepicking", getIsActive=function()return true;end, view=true}; --g_currentMission.missionInfo.stonesEnabled;
		
		--transport = {jobTypName="contract_transport_title", overlay="pickupPal", getIsActive=function()if Missions_Display.missionsExpanded or (g_modIsLoaded["FS25_TransportMissions"] and _G["FS25_TransportMissions"] ~= nil) then local map = g_currentMission.missionInfo.map;if map.id == "TheElmcreekExtension.ElmcreekExtension" or map.id == "MapUS" or string.find(map.id, "ElmcreekExtension") then return true;end;end;return false;end, view=true}; --mod + ls22
			
		---
		mowbaleMission = {jobTypName="contract_field_mowbale_title", modName="FS25_MowBaleMission", overlay="bale", getIsActive=function()return true;end, view=true}; --mod
		limeMission = {jobTypName="contract_field_lime_title", modName="FS25_LimeMission", overlay="spray", getIsActive=function()return true;end, view=true}; --mod --g_currentMission.missionInfo.limeRequired		
		irrigationMission = {jobTypName="rw_contract_field_irrigation_title", modName="FS25_RealisticWeather", overlay="water", getIsActive=function()return true;end, view=true}; --mod
		rollerMission = {jobTypName="contract_field_roller_title", modName="FS25_AdditionalContracts", overlay="roller", getIsActive=function()return true;end, view=true}; --mod old/new ?		
		mulcherMission = {jobTypName="contract_field_mulcher_title", modName="FS25_AdditionalContracts", overlay="weed", getIsActive=function()return true;end, view=true}; --mod
		chaffMission = {jobTypName="contract_field_chaff_title", modName="FS25_AdditionalContracts", overlay="chop", getIsActive=function()return true;end, view=true}; --mod		
		supplyTransportMission = {jobTypName="supplyTransport_title", modName="FS25_SupplyTransportContracts", overlay="supply", getIsActive=function()return true;end, view=true}; --mod
		kommunalMission = {jobTypName="fieldJob_jobType_kommunal", modName="FS25_KommunalServices", overlay="mowing", getIsActive=function()return true;end, view=true}; --mod		
		transportMission = {jobTypName="contract_transport_title", modName="FS25_TransportMission", overlay="pickupPal", getIsActive=function()return true;end, view=true}; --mod
		additionalContracts = {jobTypName="ui_setting_title", modName="FS25_AdditionalContracts", overlay="unknownContract", getIsActive=function()return true;end, view=true}; --mod		
		---
		unknown = {jobTypName="Type... Unknown", overlay="unknown", modName=nil, getIsActive=function()return true;end, view=true};
	};
	if boxList ~= nil and boxList then --compare list for view Box save state with org table
		local list = {};		
		for key, value in pairs (jobTypes) do
			list[key] = {view=true};			
		end;
		return list;
	end;
	--if Missions_Display.otherMods.missionsExpanded then --mod by HappyLooser
	--	jobTypes.limeMission.modName = "MissionsExpanded";jobTypes.chaffMission.modName = "MissionsExpanded";jobTypes.rollerMission.modName = "MissionsExpanded";jobTypes.supplyTransportMission.modName = "MissionsExpanded";jobTypes.mowbaleMission.modName = "MissionsExpanded"
	--end;
	local missionsTypes = {};
	for index, mission in ipairs(g_missionManager.missionTypes) do		
		if missionsTypes[mission.typeId] == nil then			
			local jobTypName = nil;			
			if jobTypes[mission.name] ~= nil then jobTypName = g_i18n:getText(jobTypes[mission.name].jobTypName, jobTypes[mission.name].modName or "missing");else jobTypName = jobTypes["unknown"].jobTypName;end;
			if string.find(jobTypName:lower(), "missing") then jobTypName = "Mod Type... ".. mission.name;end;
			local isActive = nil;
			local overlay = nil;					
			if jobTypes[mission.name] == nil then
				isActive = jobTypes["unknown"].getIsActive;
				overlay = jobTypes["unknown"].overlay;				
			else
				isActive = jobTypes[mission.name].getIsActive;
				overlay = jobTypes[mission.name].overlay;				
			end;			
			local modName = nil;
			if jobTypes[mission.name] ~= nil and jobTypes[mission.name].modName ~= nil then modName = jobTypes[mission.name].modName;end;			
			missionsTypes[mission.typeId] = {name=mission.name,jobTypName=jobTypName,typId=mission.typeId,isActive=isActive, overlay=overlay, modName=modName, view=true, total=0};
			if mission.classObject ~= nil then --change				
				if mission.classObject.className == "FS25_RollerMission.RollerMission" then --old mod
					missionsTypes[mission.typeId].modName = "FS25_RollerMission";
					jobTypName = g_i18n:getText(jobTypes[mission.name].jobTypName, jobTypes[mission.name].modName or "missing");
					if string.find(jobTypName:lower(), "missing") then jobTypName = "Mod Type... ".. mission.name;end;
					missionsTypes[mission.typeId].jobTypName = jobTypName;
				end;
				if mission.classObject.getMaxNumInstance ~= nil then
					missionsTypes[mission.typeId].changeMaxNumInstance = function(args)return mission.classObject:getMaxNumInstance(args);end;
				end;
				if mission.classObject.getOnOff ~= nil then
					missionsTypes[mission.typeId].isActive = function(args)return mission.classObject:getOnOff(args);end;					
				end;				
			end;
		end;
	end;	
	return missionsTypes;
end;

function Missions_DisplaySetGet:setMaxNumInstances(missionId, name)
	local maxNumInstances = 0;
	local data = g_missionManager:getMissionTypeDataByName(name);			
	if data ~= nil then maxNumInstances = data.maxNumInstances;end;
	Missions_Display.values.missionsTypes[missionId].maxNumInstances = maxNumInstances;	
end;

function Missions_DisplaySetGet:getTypeIconsLength()
	local length = 1;
	for missionId, missionsType in ipairs(Missions_Display.values.missionsTypes) do
		if missionsType.isActive() then length = length+1;end;
	end;
	return length;
end;

function Missions_DisplaySetGet:getFillTypeIndex(mission, convertFillType)
	local baleTyp = nil;	
	if convertFillType then
		if mission.typ == "fertilize" then return FillType.LIQUIDFERTILIZER;
		elseif mission.typ == "herbicide" then return FillType.HERBICIDE;end;
		
	else
		if mission.typ == "fertilize" then return FillType.FERTILIZER;
		elseif mission.typ == "herbicide" then return FillType.HERBICIDE;end;						
	end;
	if mission.getFillTypeIndexOverlay ~= nil then
		local modFillType, modOverlay = mission.getFillTypeIndexOverlay( {convertFillType=convertFillType} );
		if modFillType ~= nil then return modFillType;elseif modOverlay ~= nil then return nil,nil,modOverlay;end;
	end;
	--if mission.typ == "universal" or string.find(mission.typ, "universal") then 
	--	local missionByUniqueId = g_missionManager:getMissionByUniqueId(mission.uniqueId);
	--	if missionByUniqueId ~= nil and missionByUniqueId.typ ~= nil and missionByUniqueId.typ.getFillTypeIndexOverlay ~= nil then
	--		local modFillType, modOverlay = missionByUniqueId.typ:getFillTypeIndexOverlay( {convertFillType=convertFillType} );
	--		if modFillType ~= nil then return modFillType;elseif modOverlay ~= nil then return nil,nil,modOverlay;end;
	--	end;		
	--end;
	if mission.typ == "mow" or mission.typ == "kommunal" or string.find(mission.typ, "kommunal") then return FillType.GRASS_WINDROW;end;
	if mission.typ == "lime" or string.find(mission.typ, "lime") then return FillType.LIME;end;	
	if mission.typ == "irrigation" or string.find(mission.typ, "irrigation") then return FillType.WATER;end;
	local fillTypeIndex = mission.fruitType;							
	if fillTypeIndex ~= nil and fillTypeIndex > 0 then fillTypeIndex = g_fruitTypeManager:getFillTypeIndexByFruitTypeIndex(fillTypeIndex);end;
	if fillTypeIndex == nil or fillTypeIndex == 0 then fillTypeIndex = mission.fillType;end;					
		
	function getBalesTyp(pos, round)		
		baleTyp = "square";
		if (mission.isRoundBales ~= nil and mission.isRoundBales) or (round ~= nil and round) then baleTyp = "round";end;
		local balesTyp = {round={"ROUNDBALE_DRYGRASS", "ROUNDBALE", "ROUNDBALE_COTTON"}, square={"SQUAREBALE_DRYGRASS", "SQUAREBALE", "SQUAREBALE_COTTON"} };
		return balesTyp[baleTyp][pos];
	end;
	if convertFillType and mission.typ == "bale" and fillTypeIndex ~= nil then		
		if fillTypeIndex == FillType.DRYGRASS_WINDROW then fillTypeIndex = FillType[getBalesTyp(1)];else fillTypeIndex = FillType[getBalesTyp(2)];end; --FillType.SQUAREBALE_DRYGRASS;else fillTypeIndex = FillType.SQUAREBALE;end;
	elseif convertFillType and (mission.typ == "mowbale" or string.find(mission.typ, "mowbale")) and fillTypeIndex ~= nil then
		if mission.fillType ~= nil then
			if mission.fillType == FillType.SILAGE then	fillTypeIndex = FillType[getBalesTyp(3, true)];else fillTypeIndex = FillType[getBalesTyp(1, true)];end;		
		elseif fillTypeIndex == FillType.DRYGRASS_WINDROW then fillTypeIndex = FillType[getBalesTyp(1, true)];else fillTypeIndex = FillType[getBalesTyp(3, true)];end;	
	elseif convertFillType and (mission.typ == "bale" or mission.typ == "mowbale" or string.find(mission.typ, "mowbale")) then
		fillTypeIndex = FillType[getBalesTyp(1)]; --FillType.SQUAREBALE_DRYGRASS;
	elseif convertFillType and mission.typ == "balewrap" then
		fillTypeIndex = FillType.BALE_WRAP;
	end;
	return fillTypeIndex, baleTyp;
end;

function Missions_DisplaySetGet:getTypesOverlays(mission, change)
	local classOverlay = "";
	local typOverlay = "";	
	if mission.getClassTypOverlay ~= nil and change == nil or false then
		classOverlay, typOverlay = mission.getClassTypOverlay();
		if classOverlay == nil or typOverlay == nil then return Missions_DisplaySetGet:getTypesOverlays(mission, true);end;
	elseif mission.typ == "harvest" then
		classOverlay = "harvester";						
		typOverlay = "harvest";
		local fillTypeIndex = Missions_DisplaySetGet:getFillTypeIndex(mission, false);
		if fillTypeIndex ~= nil then
			if fillTypeIndex == FillType.COTTON then classOverlay = "harvester_cotton";typOverlay = "chop";
			elseif fillTypeIndex == FillType.SUGARBEET or fillTypeIndex == FillType.POTATO or fillTypeIndex == FillType.BEETROOT or fillTypeIndex == FillType.BEETROOT or fillTypeIndex == FillType.CARROT or fillTypeIndex == FillType.PARSNIP  then classOverlay = "harvester_other";typOverlay = "chop";
			elseif fillTypeIndex == FillType.SUGARCANE then classOverlay = "harvester_sugarcane";typOverlay = "chop";end;							
		end;	
	elseif string.find(mission.typ, "supplytransport") then
		classOverlay = "supply";
		typOverlay = "trailer";
	elseif mission.typ == "transport" or mission.typ == "treetransport" or mission.typ == "deadwood" or mission.typ == "destructiblerock" then
		classOverlay = "frontLoaderTractor";
		if mission.typ == "treetransport" then
			typOverlay = "woodTrailer";
		elseif mission.typ == "deadwood" then
			typOverlay = "chainsaw";
		elseif mission.typ == "destructiblerock" then
			typOverlay = "hammer"; --hydraulik hammer elektrisch für frontlader
		elseif mission.typ == "transport" then
			typOverlay = "pickupPal";
		else
			typOverlay = "unknownTrailer"; 
		end;	
	elseif mission.typ == "mowbale" or string.find(mission.typ, "mowbale") then
		classOverlay = "selfpropelledmower";
		typOverlay = "bale";
	elseif string.find(mission.typ, "mow") then
		classOverlay = "selfpropelledmower";
		typOverlay = "chop";
	else
		classOverlay = "tractor";					
		if mission.typ == "plow" then 
			typOverlay = "plow";
		elseif mission.typ == "roller" or string.find(mission.typ, "roller") then
			typOverlay = "roller";
		elseif mission.typ == "cultivate" then
			typOverlay = "cultivate";						
		elseif mission.typ == "sow" then
			typOverlay = "sow";			
		elseif mission.typ == "fertilize" or mission.typ == "herbicide" or mission.typ == "lime" or string.find(mission.typ, "lime") then
			typOverlay = "spray";
		elseif mission.typ == "weed" then
			typOverlay = "weed";	
		elseif mission.typ == "bale" then							
			typOverlay = "bale";
		elseif mission.typ == "balewrap" then							
			typOverlay = "wraping";							
		elseif mission.typ == "tedder" then							
			typOverlay = "tedder";
		elseif mission.typ == "stonepick" then							
			typOverlay = "stonepicking";
		elseif mission.typ == "hoe" then							
			typOverlay = "hoe";		
		elseif mission.typ == "kommunal" or string.find(mission.typ, "kommunal") then
			typOverlay = "mowing";	
		elseif mission.typ == "irrigation" or string.find(mission.typ, "irrigation") then
			typOverlay = "water";
		else
			typOverlay = "unknownTrailer";	
		end;
	end;
	return classOverlay, typOverlay;
end;

function Missions_DisplaySetGet:setPdaAlign(pda)
	if pda == nil or not pda.show or pda.ownTable.view.autoAlign[1] == 1 then return;end;
	local alignX, alignY, alignW, alignH, alignL, alignR = 0,0,0,0,false,false;
	
	if pda.ownTable.view.autoAlign[1] == 2 then
		if g_currentMission.hud.isVisible then			
			alignX, alignY, alignW, alignH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.infoBgLeft);
			if Missions_Display.otherMods.extendedGameInfoDisplay then alignX = alignX - g_currentMission.hud.gameInfoDisplay:scalePixelToScreenWidth(FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY);end;
		else
			alignX = 0.99;
		end;
		alignR = true;
	end;		
	
	if alignX ~= nil and alignY ~= nil and alignW ~= nil and alignH ~= nil and (alignR or alignL) then
		local difW = g_currentMission.hlHudSystem.screen.pixelW*1;
		local x, y, w, h = pda:getScreen();
		if alignR then
			local newX = x;
			local newY = y;
			if alignX-w-difW ~= newX then
				newX = alignX-w-difW;
			end;
			if alignY+alignH ~= newY+h then
				newY = alignY+alignH-h;
			end;
			if newX ~= x or newY ~= y then
				pda:setPosition(newX, newY);
			end;
		end;
	end;
end;

function Missions_DisplaySetGet:refreshPlayerFarmId() --MP hotspots blinking start other switch farms
	if ls25convert then
		if not Missions_Display.missionsExpanded then 
			function createMapHotspot(sellingStation)
				if sellingStation.owningPlaceable.rootNode == nil then
					return nil;
				end;
				local x, _, z = getWorldTranslation(sellingStation.owningPlaceable.rootNode);
				local hotspot = sellingStation.mapHotspot;

				if hotspot ~= nil then
					x, z = hotspot:getWorldPosition();
				end;

				local mapHotspot = MissionHotspot.new();

				mapHotspot:setWorldPosition(x, z);
				g_currentMission:addMapHotspot(mapHotspot);
				return mapHotspot;		
			end;
			function destroyMapHotspot(mission)
				if mission.mapHotspot ~= nil then
					g_currentMission:removeMapHotspot(mission.mapHotspot);
					mission.mapHotspot:delete();

					mission.mapHotspot = nil;
				end;
			end;
			for _, mission in ipairs(g_missionManager.missions) do
				if mission.isInMissionMap and mission.field ~= nil and mission.field.fieldId ~= nil then
					local field = g_fieldManager.fields[mission.field.fieldId];
					if field ~= nil then
						if mission.farmId == g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId then
							field.mapHotspot:setBlinking(true);
							field.mapHotspot:setPersistent(true);
						else
							field.mapHotspot:setBlinking(false);
							field.mapHotspot:setPersistent(false);
						end;
						if mission.sellPoint ~= nil then
							local sellingStation = mission.sellPoint;
							if mission.farmId == g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId then
								if mission.mapHotspot ~= nil and sellingStation.mapHotspot ~= nil and mission.status == AbstractMission.STATUS_RUNNING then
									mission.mapHotspot = createMapHotspot(sellingStation);
								end;
							else
								destroyMapHotspot(mission);
							end;
						end;
					end;
				end;
			end;
		end;
		if Missions_Display.missions == nil then return;end;
		Missions_DisplaySetGet:setMissions();
	end;
end;

function Missions_DisplaySetGet:loadMissions() --first start	
	if g_currentMission.hlUtils.timers["missionsdisplay_updateMissions"] == nil then g_currentMission.hlUtils.addTimer( {delay=Missions_Display.values.missionsUpdateTimer or 1, name="missionsdisplay_updateMissions", repeatable=1, ms=false, action=Missions_DisplaySetGet.setMissionsUpdateByTimer} );
	Missions_DisplaySetGet:setMissions(nil, nil, true);end;	
end;

function Missions_DisplaySetGet:setViewMissions(typ)
	if g_currentMission.hlUtils.timers["missionsdisplay_updateMissions"] == nil then g_currentMission.hlUtils.addTimer( {delay=Missions_Display.values.missionsUpdateTimer or 1, name="missionsdisplay_updateMissions", repeatable=1, ms=false, action=Missions_DisplaySetGet.setMissionsUpdateByTimer} );end;
	if typ.typ == "box" then
		return Missions_DisplaySetGet:setViewMissionsBox(typ)
	elseif typ.typ == "pda" then
		Missions_DisplaySetGet:setViewMissionsPda(typ)
	end;	
end;

function Missions_DisplaySetGet:setViewMissionsPda(pda) --small active
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local viewMissions = {};
	local values = pda.ownTable;
	local valuesGlobal = Missions_Display.values;
	
	local farmIdMissions = {};
	local otherFarmIdMissions = {};
	
	function sortBy()
		function sortByNumber(w1,w2)		
			if w1.sortByNumber > w2.sortByNumber then
				return true;
			end;				
		end;
		if #farmIdMissions > 0 then
			for m=1, #farmIdMissions do --force by percent
				if farmIdMissions[m].failed then
					farmIdMissions[m].sortByNumber = -1;
				else
					farmIdMissions[m].sortByNumber = farmIdMissions[m].percent;
				end;
			end;
			table.sort(farmIdMissions, sortByNumber);
		end;
		if #otherFarmIdMissions > 0 then
			for m=1, #otherFarmIdMissions do --force by percent
				if otherFarmIdMissions[m].failed then
					otherFarmIdMissions[m].sortByNumber = -1;
				else
					otherFarmIdMissions[m].sortByNumber = otherFarmIdMissions[m].percent;
				end;
			end;
			table.sort(otherFarmIdMissions, sortByNumber);
		end;
	end;	
	if #Missions_Display.missions.farmId > 0 then
		for m=1, #Missions_Display.missions.farmId do
			mission = Missions_Display.missions.farmId[m];			
			if mission.isRunning and not mission.failed and not mission.finish then
				if mission.farmId == playerFarmId then --only player farm				
					farmIdMissions[#farmIdMissions+1] = mission;
				else
					otherFarmIdMissions[#otherFarmIdMissions+1] = mission; --contractor farm			
				end;
			end;
		end;
	end;
	sortBy();
	if #farmIdMissions > 0 then
		table.foreach(farmIdMissions, function(k, v) table.insert(viewMissions, v) end);		
	end;
	if #otherFarmIdMissions > 0 then
		table.foreach(otherFarmIdMissions, function(k, v) table.insert(viewMissions, v) end);		
	end;
	Missions_DisplaySetGet.viewMissionsPda = viewMissions;
end;

function Missions_DisplaySetGet:setViewMissionsBox(box)
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local viewMissions = {};
	local values = box.ownTable;
	local valuesGlobal = Missions_Display.values;
	local openMissionDetails = false;
	local farmIdMissions = {};
	local otherFarmIdMissions = {};
	local freeMissions = {};
	
	function sortBy()		
		function sortByString(w1,w2)			
			if w1.sortByString < w2.sortByString then
				return true;
			end;			
		end;
		function sortByNumberNegative(w1,w2)		
			if w1.sortByNumber < w2.sortByNumber then
				return true;
			end;				
		end;
		function sortByNumber(w1,w2)		
			if w1.sortByNumber > w2.sortByNumber then
				return true;
			end;				
		end;
		function sortByBoolean(w1,w2)		
			return w1.sortByBoolean and not w2.sortByBoolean;							
		end;
		if #farmIdMissions > 0 then
			for m=1, #farmIdMissions do --force by percent
				if farmIdMissions[m].failed then
					farmIdMissions[m].sortByNumber = -1;
				else
					farmIdMissions[m].sortByNumber = farmIdMissions[m].percent;
				end;
			end;
			table.sort(farmIdMissions, sortByNumber);
		end;
		if #otherFarmIdMissions > 0 then
			for m=1, #otherFarmIdMissions do --force by percent
				if otherFarmIdMissions[m].failed then
					otherFarmIdMissions[m].sortByNumber = -1;
				else
					otherFarmIdMissions[m].sortByNumber = otherFarmIdMissions[m].percent;
				end;
			end;
			table.sort(otherFarmIdMissions, sortByNumber);
		end;
		if #freeMissions > 0 and values.view.sortBy[1] > 1 then			
			for m=1, #freeMissions do
				if values.view.sortBy[1] == 2 then --price
					freeMissions[m].sortByNumber = freeMissions[m].reward;
				elseif values.view.sortBy[1] == 3 then --missions jobtyp
					freeMissions[m].sortByString = freeMissions[m].jobTyp;
				elseif values.view.sortBy[1] == 4 then --fruitTyp/fillType
					local setNumber = 0;					
					if freeMissions[m].fillType ~= nil and freeMissions[m].fillType > 0 then 
						setNumber = freeMissions[m].fillType;
					elseif freeMissions[m].fruitType ~= nil and freeMissions[m].fruitType > 0 then
						local fruitTypeIndex = g_fruitTypeManager:getFillTypeIndexByFruitTypeIndex(freeMissions[m].fruitType);
						if fruitTypeIndex ~= nil then setNumber = fruitTypeIndex;end;
					--elseif freeMissions[m].typ == "lime" or string.find(freeMissions[m].typ, "lime") then 
					--	setNumber = FillType.LIME; --virtual
					elseif freeMissions[m].typ == "fertilize" then
						setNumber = FillType.FERTILIZER; --virtual
					elseif freeMissions[m].typ == "herbicide" then
						setNumber = FillType.HERBICIDE; 	--virtual					
					--elseif freeMissions[m].typ == "transport" then
					--	setNumber = 500; --virtual fake	
					elseif freeMissions[m].typ == "weed" then
						setNumber = 501; --virtual fake						
					elseif freeMissions[m].typ == "treetransport" then
						setNumber = 502; --virtual fake	
					elseif freeMissions[m].typ == "deadwood" then
						setNumber = 503; --virtual fake	
					elseif freeMissions[m].typ == "destructiblerock" then
						setNumber = 504; --virtual fake	
					elseif freeMissions[m].typ == "stonepick" then
						setNumber = 505; --virtual fake	
					elseif freeMissions[m].typ == "tedder" then
						setNumber = 506; --virtual fake	
					elseif freeMissions[m].typ == "hoe" then
						setNumber = 507; --virtual fake						
					elseif freeMissions[m].typ == "mow" then
						setNumber = 508; --virtual fake	
					elseif freeMissions[m].typ == "bale" then
						setNumber = 509; --virtual fake
					elseif freeMissions[m].typ == "balewrap" then
						setNumber = 510; --virtual fake		
					elseif freeMissions[m].typ == "lime" then
						setNumber = 511; --virtual fake	
					elseif freeMissions[m].typ == "mowbale" then
						setNumber = 512; --virtual fake
					elseif freeMissions[m].typ == "roller" then
						setNumber = 513; --virtual fake
					elseif freeMissions[m].typ == "supplytransport" then
						setNumber = 514; --virtual fake
					elseif freeMissions[m].typ == "kommunal" or string.find(freeMissions[m].typ, "kommunal") then 
						setNumber = 515; --virtual Fake --FillType.GRASS_WINDROW;
					elseif freeMissions[m].typ == "irrigation" or string.find(freeMissions[m].typ, "irrigation") then 
						setNumber = 516; --virtual Fake --FillType.WATER;
					elseif freeMissions[m].typ == "transport" then
						setNumber = 517; --virtual Fake
					elseif freeMissions[m].typ == "additionalcontracts" then
						setNumber = 518; --virtual Fake	
					else
						setNumber = 519; --virtual Fake	
					end;					
					freeMissions[m].sortByNumber = setNumber;
				elseif values.view.sortBy[1] == 5 then --field number
					if freeMissions[m].field ~= nil then
						freeMissions[m].sortByNumber = freeMissions[m].field.id;
					else
						freeMissions[m].sortByNumber = 10000; --virtual fake
					end;
				elseif values.view.sortBy[1] == 6 then --field hectar
					if freeMissions[m].field ~= nil then
						freeMissions[m].sortByNumber = freeMissions[m].field.hectar;
					else
						freeMissions[m].sortByNumber = 0;
					end;	
				elseif values.view.sortBy[1] == 7 then --time limit
					if freeMissions[m].hasTimeLimit then
						freeMissions[m].sortByNumber = freeMissions[m].minutes;
					else
						freeMissions[m].sortByNumber = 10000000000000; --virtual fake
					end;
				end;
			end;
			if values.view.sortBy[1] == 2 or values.view.sortBy[1] == 4 or values.view.sortBy[1] == 6 or values.view.sortBy[1] == 7 then table.sort(freeMissions, sortByNumber);end;
			if values.view.sortBy[1] == 3 then table.sort(freeMissions, sortByString);end;
			if values.view.sortBy[1] == 5 then table.sort(freeMissions, sortByNumberNegative);end;
		end;		
	end;
	
	function setOpenMissionDetails(viewDetails)
		if not openMissionDetails and (viewDetails ~= nil and viewDetails) then openMissionDetails = true;end;
	end;	
	if #Missions_Display.missions.farmId > 0 and (values.view.missions[1] == 1 or values.view.missions[1] == 2) then
		for m=1, #Missions_Display.missions.farmId do
			mission = Missions_Display.missions.farmId[m];
			if not g_currentMission.missionDynamicInfo.isMultiplayer then
				setOpenMissionDetails(mission.viewDetails);
				farmIdMissions[#farmIdMissions+1] = mission;
			elseif valuesGlobal.viewMissionsFarm[1] == 1 and mission.farmId == playerFarmId then --only player farm
				setOpenMissionDetails(mission.viewDetails);
				farmIdMissions[#farmIdMissions+1] = mission;
			elseif valuesGlobal.viewMissionsFarm[1] == 2 then --player farm + contractor farm
				setOpenMissionDetails(mission.viewDetails);
				if mission.farmId == playerFarmId then
					farmIdMissions[#farmIdMissions+1] = mission; --player farm
				else
					otherFarmIdMissions[#otherFarmIdMissions+1] = mission; --contractor farm
				end;
			elseif valuesGlobal.viewMissionsFarm[1] == 3 and mission.farmId ~= playerFarmId then	--only contractor farm
				setOpenMissionDetails(mission.viewDetails);
				farmIdMissions[#farmIdMissions+1] = mission;
			end;
		end;
	end;
	if #Missions_Display.missions.free > 0 and (values.view.missions[1] == 1 or values.view.missions[1] == 3) then
		for m=1, #Missions_Display.missions.free do
			mission = Missions_Display.missions.free[m];
			if Missions_Display.values.missionsTypes[mission.typId] == nil or Missions_Display.values.missionsTypes[mission.typId].view then
				setOpenMissionDetails(mission.viewDetails);
				freeMissions[#freeMissions+1] = mission;
			end;
			--if values.viewMissionsTyp == 0 then --view all types
			--	setOpenMissionDetails(mission.viewDetails);
			--	freeMissions[#freeMissions+1] = mission;
			--elseif Missions_Display.values.missionsTypes[values.viewMissionsTyp].typId == mission.typId then
			--	setOpenMissionDetails(mission.viewDetails);
			--	freeMissions[#freeMissions+1] = mission;
			--end;
		end;
	end;
	sortBy();
	if #farmIdMissions > 0 then
		table.foreach(farmIdMissions, function(k, v) table.insert(viewMissions, v) end);		
	end;
	if #otherFarmIdMissions > 0 then
		table.foreach(otherFarmIdMissions, function(k, v) table.insert(viewMissions, v) end);		
	end;
	if #freeMissions > 0 then
		table.foreach(freeMissions, function(k, v) table.insert(viewMissions, v) end);		
	end;
	Missions_DisplaySetGet.viewMissionsBox = viewMissions;
	return openMissionDetails;
end;

function Missions_DisplaySetGet.setMissionsUpdateByTimer()
	if g_currentMission.missionDynamicInfo.isMultiplayer and g_currentMission.hlHudSystem.ownData ~= nil and g_currentMission.hlHudSystem.ownData.mpOff then return;end;
	if Missions_Display.loadError or g_currentMission.hlHudSystem.ownData.hiddenMods["MissionsDisplay"].isHidden then return;end;
	Missions_DisplaySetGet:setMissions();
end;

function Missions_DisplaySetGet:getPercentAndNotice(missionsTable)
	local percent = 0;
	local notice = {finish=0, failed=0};	
	local total = 0;
	local missionen = missionsTable or Missions_Display.missions.farmId;
	if missionen ~= nil and #missionen > 0 then		
		for m=1, #missionen do
			if not missionen[m].failed and not missionen[m].finish then
				percent = percent + missionen[m].percent;
				total = total + 1
			elseif missionen[m].finish then
				notice.finish = notice.finish + 1;
			elseif missionen[m].failed then
				notice.failed = notice.failed + 1;
			end;
		end;
		if percent > 0 and total > 0 then percent = percent/total;end;		
	end;
	return percent, notice;
end;

function Missions_DisplaySetGet:getMissions(sort, firstStart)	
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();		
	local missions = {};	
	for index, mission in ipairs(g_missionManager.missions) do
		if mission.mdMod_viewDetails == nil then mission.mdMod_viewDetails = false;end;
		if mission.mdMod_newMissionsTimer == nil then 
			if Missions_Display.values.startTime+5000 < g_time then 
				mission.mdMod_newMissionsTimer = g_time;
			else
				mission.mdMod_newMissionsTimer = 0;
			end;			
		end;	
		--set title language for not g_i18n founds--
		if Missions_Display.values.missionsTypes[mission.type.typeId] ~= nil and string.find(Missions_Display.values.missionsTypes[mission.type.typeId].jobTypName, "Type...") then Missions_Display.values.missionsTypes[mission.type.typeId].jobTypName = mission.title;end;
		--set title language for not g_i18n founds--
		--local missionInfo = mission:getData();
		missions[index] = {};
		missions[index].viewDetails = mission.mdMod_viewDetails;
		missions[index].setNewMarker = mission.mdMod_newMissionsTimer+Missions_Display.values.markerNewMission > g_time;
		missions[index].typId = mission.type.typeId;
		missions[index].id = mission.id;
		missions[index].uniqueId = mission.uniqueId;
		missions[index].status = mission.status;
		missions[index].isRunning = mission.isInMissionMap or (mission.activeMissionId ~= nil);
		missions[index].farmId = mission.farmId;		
		missions[index].percent = math.floor((Utils.getNoNil(mission.completion, 0)*100) + 0.5);
		missions[index].finish = mission.finishState == 2;
		missions[index].failed = mission.status == 4 and not missions[index].finish;
		missions[index].typ = "unknown";
		missions[index].typGroup = mission.typGroup;
		missions[index].jobTyp = mission.title;
		if string.find(mission.type.classObject.className:lower(), "missions") then missions[index].typ = string.gsub(mission.type.classObject.className:lower(), "missions", ""):lower();else missions[index].typ = string.gsub(mission.type.classObject.className:lower(), "mission", ""):lower();end; --mod ?
		if mission.jobTypName ~= nil and mission.jobTypName:len() > 0 then
			missions[index].jobTyp = mission.jobTypName;
		elseif mission.getJobTypName ~= nil then
			local jobTypName = mission:getJobTypName();
			if jobTypName ~= nil and jobTypName:len() > 0 then missions[index].jobTyp = jobTypName;end;
		end;
		if mission.getClassTypOverlay ~= nil then missions[index].getClassTypOverlay = function(args)return mission:getClassTypOverlay(args);end;end;
		if mission.getFillTypeIndexOverlay ~= nil then missions[index].getFillTypeIndexOverlay = function(args)return mission:getFillTypeIndexOverlay(args);end;end;
		missions[index].fillType = mission.fillTypeIndex;
		missions[index].fruitType = mission.fruitTypeIndex;
		missions[index].baleType = mission.baleTypeIndex;
		missions[index].isRoundBales = mission.needRoundbaler;
		missions[index].windrowType = mission.windrowFillTypeIndex
		missions[index].transport = {};
		missions[index].dataByMod = nil;
		if mission.data ~= nil then missions[index].dataByMod = mission.data;end;
		if mission.field ~= nil and mission.field.getName ~= nil then
			missions[index].field = {};	
			missions[index].field.id = tonumber(mission.field:getName());
			missions[index].field.hectar = mission.field.areaHa;
			missions[index].field.dimmension = mission.field.angel;
			function getMaxCutLiters()
				local expectedLiters = nil;
				if mission.getMaxCutLiters ~= nil and mission.mdMod_viewDetails and not Missions_Display.otherMods.realisticWeather then --Mod RealisticWeather overwritten function with bad formel :-(
					if mission.type.name == "harvestMission" or mission.type.name == "mowbaleMission" then
						expectedLiters = mission:getMaxCutLiters();
						if expectedLiters ~= nil and expectedLiters > 0 then expectedLiters = expectedLiters * AbstractMission.SUCCESS_FACTOR;return expectedLiters;end;
					end;
				end;
				return expectedLiters;
			end;
			if mission.expectedLiters ~= nil then
				missions[index].field.expectedLiters = mission.expectedLiters * AbstractMission.SUCCESS_FACTOR;
				if missions[index].field.expectedLiters == 0 and not missions[index].isRunning then missions[index].field.expectedLiters = getMaxCutLiters();end;
			elseif mission.type.name == "harvestMission" or mission.type.name == "mowbaleMission" and not missions[index].isRunning then
				missions[index].field.expectedLiters = getMaxCutLiters();				
			end;
			missions[index].field.depositedLiters = Utils.getNoNil(mission.depositedLiters, 0);
		else			
			missions[index].farmlandId = mission.farmlandId;
			if missions[index].farmlandId == nil and (missions[index].typ == "transport" or string.find(missions[index].typ, "transport") or string.find(missions[index].typ, "contracts")) then missions[index].farmlandId = 0;end;
			missions[index].transport.numObjects = Utils.getNoNil(mission.numObjects, 0);
			if mission.numObjects == nil and mission.getNumObjects ~= nil then
				missions[index].transport.numObjects = Utils.getNoNil(mission:getNumObjects(), 0);
				if mission.data ~= nil and mission.data.ownTable ~= nil then
					missions[index].transport.objectTypString = Utils.getNoNil(mission.data.ownTable.objectTypString, g_i18n:getText("category_misc"));
				end;				
			end;		
			missions[index].transport.pickupTrigger = mission.pickup;
			missions[index].transport.dropoffTrigger = mission.dropoff;
			if mission.dropoff ~= nil then missions[index].transport.dropoffTriggerName = mission:getTriggerTitle(mission.dropoff, false);end;
			if mission.dropoff == nil and mission.getActiveTriggers ~= nil then
				missions[index].transport.pickupTrigger, missions[index].transport.dropoffTrigger, missions[index].transport.dropoffTriggerName = mission:getActiveTriggers();
			end;
			
			missions[index].transport.supplyLiters = mission.expectedLiters;
			missions[index].transport.deliveredLiters = Utils.getNoNil(mission.depositedLiters, 0);
			--missions[index].transport.supplyTimeLimit = missionInfo.timeLimit;
			
			missions[index].transport.numTrees = mission.numTrees;
			missions[index].transport.numDeliveredTrees = mission.numDeliveredTrees;
			missions[index].transport.numDeletedTrees = mission.numDeletedTrees;			
			
			if mission.rocks ~= nil then
				missions[index].numRocks = Utils.getNoNil(#mission.rocks, nil);
			end;
			missions[index].numRocksDestroyed = mission.numRocksDestroyed;
			missions[index].wronglyDestroyedRocksPenalty = mission.wronglyDestroyedRocksPenalty;
			
			missions[index].numDeadTrees = mission.numDeadTrees;
			missions[index].numCutDownTrees = mission.numCutDownTrees;
			missions[index].wronglyCutDownTreesReward = mission.wronglyCutDownTreesReward;
		end;
		missions[index].hasTimeLimitMod = Missions_Display.otherMods.missionsTimes or Missions_Display.otherMods.missionsExpanded;
		missions[index].minutes = 0; --ui_pendingMissionTimeLeftTitle :: Verbleibende Zeit; --ui_ingameMissionTimeLimit :: Zeitlimit; ui_pendingMissionTimeLeft :: noch %d Min.
		missions[index].hasTimeLimit = mission.endDate ~= nil and mission.endDate.endDayTime ~= nil;
		if missions[index].hasTimeLimit then			
			missions[index].minutes = mission:getMinutesLeft();			
			if missions[index].hasTimeLimitMod and not mission.isRunning and mission.mdMod_viewDetails then
				local isModReady = true;
				if g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"] ~= nil then 
					if not g_currentMission.missionDynamicInfo.isMultiplayer or (g_currentMission.missionDynamicInfo.isMultiplayer and g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"].isMpReady()) then
						missions[index].runningMinutes = g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"].getRunningMinutes(mission, mission.endDate.endDay, mission.endDate.endDayTime);
					else
						isModReady = false;
					end;
				elseif g_currentMission.hlUtils.globalFunction["FS25_MissionsExpanded"] ~= nil then
					if not g_currentMission.missionDynamicInfo.isMultiplayer or (g_currentMission.missionDynamicInfo.isMultiplayer and g_currentMission.hlUtils.globalFunction["FS25_MissionsExpanded"].isMpReady()) then
						missions[index].runningMinutes = g_currentMission.hlUtils.globalFunction["FS25_MissionsExpanded"].getRunningMinutes(mission, mission.endDate.endDay, mission.endDate.endDayTime);
					else
						isModReady = false;
					end;				
				else
					isModReady = false;
				end;
				missions[index].hasTimeLimitMod = isModReady;
			end;			
		end;
		if mission.sellPoint ~= nil then			
			missions[index].sellPointId = Utils.getNoNil(mission.sellPoint.rootNode, 0);
			missions[index].sellPointName = mission.sellPoint:getName();
		end;
		if mission.sellingStation ~= nil then
			missions[index].sellingStationId = Utils.getNoNil(mission.sellingStation.rootNode, 0);
			missions[index].sellingStationName = mission.sellingStation:getName();
		end;
		--distance--
		if mission.mdMod_distance == nil then
			mission.mdMod_distance = -1;
			local foundFieldOrFarmland = {0,1};
			local foundSellPointOrSellingStation = {0,0};
			if missions[index].field ~= nil and missions[index].field.id ~= nil then
				foundFieldOrFarmland[1] = missions[index].field.id;				
			elseif missions[index].farmlandId ~= nil then
				foundFieldOrFarmland[1] = missions[index].farmlandId;
				foundFieldOrFarmland[2] = 2;
			end;
			if foundFieldOrFarmland[1] > 0 then
				if missions[index].sellPointId ~= nil and missions[index].sellPointId > 0 then					
					foundSellPointOrSellingStation[1] = missions[index].sellPointId;				
				end;
				if missions[index].sellingStationId ~= nil and missions[index].sellingStationId > 0 then
					foundSellPointOrSellingStation[2] = missions[index].sellingStationId;
				end;
				if foundSellPointOrSellingStation[1] > 0 or foundSellPointOrSellingStation[2] > 0 then
					mission.mdMod_distance = Missions_DisplaySetGet:getDistance(foundFieldOrFarmland, foundSellPointOrSellingStation);
				end;
			end;		
		end;
		missions[index].distance = mission.mdMod_distance;
		--distance--
		if mission.vehicles ~= nil then
			missions[index].leasingVehicles = Utils.getNoNil(mission.spawnedVehicles, false);
		else
			missions[index].leasingVehicles = false;
		end;
		missions[index].leasingVehicleName = {};
		missions[index].canLeasingVehicles = mission.vehiclesToLoad ~= nil;
		if mission.vehiclesToLoad ~= nil then
			missions[index].leasingVehicleCost = mission:getVehicleCosts() or 0;			
			for i, v in ipairs(mission.vehiclesToLoad) do
				local storeItem = g_storeManager:getItemByXMLFilename(v.filename)
				if storeItem ~= nil then
					local isLoad = g_currentMission.hlUtils.loadVehicleOverlay(nil, storeItem);					
					if isLoad ~= nil then missions[index].leasingVehicleName[#missions[index].leasingVehicleName+1] = storeItem.name;end;
				end;				
			end;			
		end;
		missions[index].reward = mission:getReward(); 
		missions[index].totalReward = 0; 
		if missions[index].failed then missions[index].totalReward = Missions_DisplaySetGet:getTotalReward(mission)end;
		missions[index].sortByString = "";
		missions[index].sortByNumber = 0;
		missions[index].sortByBoolean = false;		
	end;	
	--reset total--
	for missionId, missionsType in ipairs(Missions_Display.values.missionsTypes) do
		missionsType.total = 0;
	end;
	--reset total--
	if sort ~= nil and sort then
		function comp(w1,w2)		
			if w1.typ < w2.typ then
				return true;
			end;				
		end;		
		table.sort(missions, comp);		
	end;	
	return missions;
end;

function Missions_DisplaySetGet:getTotalReward(mission)
	local r = mission:getActualReward();
	local v = mission:getActualVehicleCosts();
	local s = mission:getActualStealingCosts();
	local rb = mission:getReimbursement();
	return r - v - s + rb;
end

function Missions_DisplaySetGet:getDistance(object, target)
	local objectPos = {};
	local targetPos = {x=nil,y=nil,z=nil};
	if object[2] == 1 then
		local field = g_fieldManager:getFieldById(object[1]);
		if field ~= nil then objectPos.x, objectPos.y, objectPos.z = field.posX, 0, field.posZ;end;
	else
		local farmland = g_farmlandManager:getFarmlandById(object[1]);
		if farmland ~= nil then objectPos.x, objectPos.y, objectPos.z = farmland.xWorldPos, 0, farmland.zWorldPos;end; 
	end;
	if target[1] > 0 then targetPos.x, targetPos.y, targetPos.z = getWorldTranslation(target[1]);end;
	if (targetPos.x == nil or targetPos.x == 0) and target[2] > 0 then targetPos.x, targetPos.y, targetPos.z = getWorldTranslation(target[2]);end;
	return g_currentMission.hlUtils.getObjectDistance(objectPos, targetPos);
end;

function Missions_DisplaySetGet:getContractorFarm(playerFarmId, missionFarmId)
	if not g_currentMission.missionDynamicInfo.isMultiplayer then return false;end;	
	if Missions_Display.values.viewMissionsFarm[1] == 1 then return false;end;
	local missionFarm = g_farmManager:getFarmById(playerFarmId);
	if missionFarm ~= nil then
		return missionFarm:getIsContractingFor(missionFarmId); 
	end;
	return false;
end;

function Missions_DisplaySetGet:setMissions(missionsTable, farmId, firstStart)
	local playerFarmId = Utils.getNoNil(farmId, g_currentMission.hlUtils.getPlayerFarmId())
	local missions = Missions_DisplaySetGet:getMissions(nil, firstStart);
	local missionen = missionsTable or Missions_Display.missions;
	if missions ~= nil and playerFarmId ~= 0 then		
		local isFarmId = {};		
		local isNotFarmId = {};
		local isFree = {};
		for index=1, #missions do
			if missions[index].farmId ~= nil and (missions[index].farmId == playerFarmId or Missions_DisplaySetGet:getContractorFarm(playerFarmId, missions[index].farmId)) then
				isFarmId[#isFarmId+1] = missions[index];
				if Missions_Display.values.missionsTypes[missions[index].typId] ~= nil then Missions_Display.values.missionsTypes[missions[index].typId].total = Missions_Display.values.missionsTypes[missions[index].typId].total+1;end; --total
			elseif missions[index].farmId ~= nil then
				isNotFarmId[#isNotFarmId+1] = missions[index];
			else
				isFree[#isFree+1] = missions[index];
				if Missions_Display.values.missionsTypes[missions[index].typId] ~= nil then Missions_Display.values.missionsTypes[missions[index].typId].total = Missions_Display.values.missionsTypes[missions[index].typId].total+1;end; --total
			end;			
		end;
		missionen.all = missions; --maphotspot or global data
		missionen.farmId = isFarmId;		
		missionen.otherFarmId = isNotFarmId;
		missionen.free = isFree;		
	else
		missionen.all = {}; --maphotspot or global data
		missionen.farmId = {};		
		missionen.otherFarmId = {};
		missionen.free = {};
	end;
	return missionen;
end;

function Missions_DisplaySetGet:setViewMissionDetails(missionId)
	local state = false;
	for index, mission in ipairs(g_missionManager.missions) do
		if mission.id == missionId and mission.mdMod_viewDetails ~= nil then 
			mission.mdMod_viewDetails = not mission.mdMod_viewDetails;
			state = mission.mdMod_viewDetails;
			break;
		end;
	end;
	Missions_DisplaySetGet:setMissions();	
end;

function Missions_DisplaySetGet:setCloseAllMissionsDetails()
	local deadwood = true;
	local rocks = true;
	local trees = true;
	for index, mission in ipairs(g_missionManager.missions) do
		if mission.mdMod_viewDetails ~= nil then 
			mission.mdMod_viewDetails = false;			
		end;		
	end;	
	Missions_DisplaySetGet:setMissions();	
end;

function Missions_DisplaySetGet:getMissionById(missionId)
	local mission = nil;
	for index, mission in ipairs(g_missionManager.missions) do
		if mission.id == missionId then 
			return mission;
		end;
	end;
	return mission;	
end;

function Missions_DisplaySetGet:showInGameMenuFrame(frame, missionId, global, change, forceMouse)	
	if frame == nil or missionId == nil or g_gui.frames[frame] == nil or change > 1 then return;end;
	local change = change or 0;
	function setForceMouse()		
		g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff			
	end;
	---im mp vorher abfragen ob player eine farmid hat oder
	--......FS22_MissionsDisplay/scripte_missionsdisplay/Missions_DisplaySetGet.lua:455: attempt to index local 'sectionContracts' (a nil value)
	if frame == "ingameMenuContracts"	then
		local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
		local isMissionByPlayerFarmId = false;
		if global ~= nil and global then
			if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
			local show = g_gui:showGui("InGameMenu");				
			local missionPageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageContracts);
			local missionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);
			show.parent.pageSelector:setState(missionPageIndex, true);				
		else
			if missionId > 0 then
				if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
				local activeMission = false;
				local mission = Missions_DisplaySetGet:getMissionById(missionId);
				if mission ~= nil then 
					activeMission = mission.finishState == 2 or mission.status == 4 or mission.isInMissionMap or (mission.activeMissionId ~= nil);						
				end;
				if activeMission and mission.farmId == playerFarmId then isMissionByPlayerFarmId = true;end;
				local show = g_gui:showGui("InGameMenu");
				local missionPageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageContracts);
				local missionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);					
				local subMissionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);
				show.parent.pageSelector:setState(missionPageIndex, true);				
				local section = 1;
				if activeMission then section = 2;end;					
				show.parent.subCategorySelector:setState(section, true);							
				local sectionContracts = show.parent.pageContracts.sectionContracts[section];					
				if sectionContracts ~= nil and #sectionContracts > 0 then --groups/group
					for s=1, #sectionContracts do --groups
						if sectionContracts[s] ~= nil and sectionContracts[s].contracts ~= nil and #sectionContracts[s].contracts > 0 then
							for sg=1, #sectionContracts[s].contracts do --group
								if sectionContracts[s].contracts[sg] ~= nil and sectionContracts[s].contracts[sg].mission ~= nil then
									if sectionContracts[s].contracts[sg].mission.id == missionId then
										show.parent.pageContracts.contractsList:setSelectedItem(s, sg);
										return;
									end;
								end;
							end;
						end;
					end;
				end;
				Missions_DisplaySetGet:showInGameMenuFrame(frame, missionId, true, change+1, forceMouse)		
			elseif change == 0 then
				Missions_DisplaySetGet:showInGameMenuFrame(frame, missionId, true, change+1, forceMouse)
			end;
		end;
	end;	
end;

function Missions_DisplaySetGet:setMapHotspot(missionId, byObject)
	if Missions_Display.missions ~= nil and Missions_Display.missions.all ~= nil and #Missions_Display.missions.all > 0 then
		local mission = nil;
		for index, missions in ipairs(g_missionManager.missions) do
			if missions.id == missionId then mission = missions;break;end;
		end;
		if mission ~= nil then
			local stationHotspot = {};
			function getSellPointOrSellingStation()				
				if mission.sellPoint ~= nil and mission.sellPoint.rootNode ~= nil then
					local x, _, z = getWorldTranslation(mission.sellPoint.rootNode);
					if x ~= nil and x ~= 0 then
						stationHotspot = {x=x, z=z, color="orangeRed"};
					end;
				elseif mission.sellingStation ~= nil and mission.sellingStation.rootNode ~= nil then
					local x, _, z = getWorldTranslation(mission.sellingStation.rootNode);
					if x ~= nil and x ~= 0 then
						stationHotspot = {x=x, z=z, color="orangeRed"};
					end;
				end;
			end;
			function getSellingStation()
				if mission.sellingStationMapHotspot ~= nil and mission.sellingStationMapHotspot.worldX ~= nil and mission.sellingStationMapHotspot.worldZ ~= nil then
					stationHotspot = {x=mission.sellingStationMapHotspot.worldX, z=mission.sellingStationMapHotspot.worldZ, color="orangeRed"};
				end;
			end;
			if byObject == nil then
				if mission.dropoff ~= nil or mission.pickup ~= nil then
					local objects = {positionen={}};				
					if mission.pickup ~= nil then
						local trigger = nil;
						if g_missionManager.transportTriggers ~= nil then trigger = g_missionManager.transportTriggers[mission.pickup];end;
						if trigger ~= nil and trigger.triggerId ~= nil then						
							local x, _, z = getWorldTranslation(trigger.triggerId);
							if x ~= nil and x ~= 0 then
								objects.positionen[#objects.positionen+1] = {x=x, z=z};
							end;						
						end;
					end;
					if mission.dropoff ~= nil then
						local trigger = nil;
						if g_missionManager.transportTriggers ~= nil then trigger = g_missionManager.transportTriggers[mission.dropoff];end;
						if trigger ~= nil and trigger.triggerId ~= nil then							
							local x, _, z = getWorldTranslation(trigger.triggerId);
							if x ~= nil and x ~= 0 then
								objects.positionen[#objects.positionen+1] = {x=x, z=z, color="orangeRed"};
							end;
						end;
					end;
					getSellingStation();
					if stationHotspot.x == nil then getSellPointOrSellingStation();end;
					if stationHotspot.x ~= nil then
						objects.positionen[#objects.positionen+1] = stationHotspot;
					end;
					if #objects.positionen > 0 then g_currentMission.hlHudSystem.setMapHotspot(objects);end;
				elseif mission.setMapHotspotForMD ~= nil then
					mission:setMapHotspotForMD(missionId, true);
				elseif mission.typ ~= nil and mission.typ.getTriggerHotspot ~= nil then
					local objects = {positionen={}};
					local trigger = mission.typ:getTriggerHotspot(true);					
					if trigger ~= nil and trigger.triggerId ~= nil then						
						local x, _, z = getWorldTranslation(trigger.triggerId);
						if x ~= nil and x ~= 0 then
							objects.positionen[#objects.positionen+1] = {x=x, z=z};
						end;						
					end;						
					trigger = mission.typ:getTriggerHotspot(false);					
					if trigger ~= nil and trigger.triggerId ~= nil then						
						local x, _, z = getWorldTranslation(trigger.triggerId);
						if x ~= nil and x ~= 0 then
							objects.positionen[#objects.positionen+1] = {x=x, z=z, color="orangeRed"};
						end;						
					end;						
					if #objects.positionen > 0 then g_currentMission.hlHudSystem.setMapHotspot(objects);end;
				elseif mission.field ~= nil and mission.field.getName ~= nil then
					local field = g_fieldManager:getFieldById(tonumber(mission.field:getName()));
					if field ~= nil then					
						local objects = {positionen={}};
						local x, z = field:getCenterOfFieldWorldPosition();
						if x ~= nil and x ~= 0 then
							objects.positionen[#objects.positionen+1] = {x=x, z=z};
						end;
						getSellPointOrSellingStation()	
						if stationHotspot.x == nil then getSellingStation();end;
						if stationHotspot.x ~= nil then
							objects.positionen[#objects.positionen+1] = stationHotspot;
						end;						
						if #objects.positionen > 0 then g_currentMission.hlHudSystem.setMapHotspot(objects);end;													
					end;								
				elseif mission.mapHotspot ~= nil and mission.mapHotspot.worldX ~= nil and mission.mapHotspot.worldZ ~= nil then
					local objects = {positionen={}};
					objects.positionen[#objects.positionen+1] = {x=mission.mapHotspot.worldX, z=mission.mapHotspot.worldZ};
					getSellingStation()	
					if stationHotspot.x == nil then getSellPointOrSellingStation();end;
					if stationHotspot.x ~= nil then
						objects.positionen[#objects.positionen+1] = stationHotspot;
					end;
					g_currentMission.hlHudSystem.setMapHotspot(objects);									
				elseif mission.spot ~= nil and mission.spot.x ~= nil and mission.spot.z ~= nil then --dlc
					local objects = {positionen={}};
					objects.positionen[#objects.positionen+1] = {x=mission.spot.x, z=mission.spot.z};
					getSellingStation();	
					if stationHotspot.x == nil then getSellPointOrSellingStation();end;
					if stationHotspot.x ~= nil then
						objects.positionen[#objects.positionen+1] = stationHotspot;					
					end;
					g_currentMission.hlHudSystem.setMapHotspot(objects);
				elseif mission.sellPoint ~= nil and mission.sellPoint.rootNode ~= nil then
					local objects = {positionen={}};				
					local x, _, z = getWorldTranslation(mission.sellPoint.rootNode);
					if x ~= nil and x ~= 0 then
						objects.positionen[#objects.positionen+1] = {x=x, z=z, color="orangeRed"};
					end;					
					if #objects.positionen > 0 then g_currentMission.hlHudSystem.setMapHotspot(objects);end;
				elseif mission.sellingStation ~= nil and mission.sellingStation.rootNode ~= nil then
					local objects = {positionen={}};				
					local x, _, z = getWorldTranslation(mission.sellingStation.rootNode);
					if x ~= nil and x ~= 0 then
						objects.positionen[#objects.positionen+1] = {x=x, z=z, color="orangeRed"};
					end;					
					if #objects.positionen > 0 then g_currentMission.hlHudSystem.setMapHotspot(objects);end;
				end;
			elseif type(byObject) == "table" then
				local objectData = byObject;
				
			end;			
		end;
	end;
end;

function Missions_DisplaySetGet:generateBounds(box)
	if box ~= nil and box.ownTable.bounds ~= nil then
		box.ownTable.bounds[1] = 1;
		box.ownTable.bounds[2] = box.ownTable.maxIconWidth or 1;
		box.ownTable.bounds[3] = box.ownTable.bounds[2];
	end;
end;

function Missions_DisplaySetGet:resetBounds(box)
	if box ~= nil and box.ownTable.bounds ~= nil then		
		box.ownTable.bounds = {-1,0,0,box.ownTable.typeIcons or 1};
	end;
end;

function Missions_DisplaySetGet:setBounds(box, left, right)
	if box ~= nil and box.ownTable.bounds ~= nil then		
		local bounds = box.ownTable.bounds;
		if bounds[4] <= 0 or bounds[3] >= bounds[4] or bounds[1] == 0 then return;end;
		if left ~= nil and left then
			if bounds[1]-1 <= 0 then return;end;
			bounds[1] = bounds[1]-1;
			bounds[2] = bounds[2]-1;
		elseif right ~= nil and right then		
			if bounds[2]+1 > bounds[4] then return;end;
			bounds[1] = bounds[1]+1;
			bounds[2] = bounds[2]+1;
		end;
	end;
end;

function Missions_DisplaySetGet:notDrawProgressBars()
	if Missions_Display.otherMods.extendedMissionInfo or Missions_Display.values.viewProgressBars[1] == 1 or g_currentMission.hlHudSystem.ownData.hiddenMods["MissionsDisplay"].isHidden then return false;end;
	local box = g_currentMission.hlHudSystem.hlBox:getData("Missions_Display_Box"); --search Box
	local pda = g_currentMission.hlHudSystem.hlPda:getData("Missions_Display_Pda"); --search Pda
	if box == nil and pda == nil then return false;end;
	--if box ~= nil and box.show then --! optional later is show box or pda set hidden !
	return true;
end;

function Missions_DisplaySetGet:visibleProgressBars()
	if self ~= nil and self.progressBars ~= nil and Missions_DisplaySetGet:notDrawProgressBars() then
		local contractText = g_i18n:getText("contract_title");
		for _, progressBar in ipairs(self.progressBars) do
			if progressBar.isVisible then
				if progressBar.title ~= nil and progressBar.title:len() > 0 and progressBar.title == contractText then progressBar.isVisible = false;end;
			end;
		end;
	end;
end;

function Missions_DisplaySetGet:showCompletionNotification()	
    if Missions_Display.values.viewProgressBars[1] == 1 then
		local text = string.format(g_i18n:getText("contract_field_completionNotification"), self.field:getId(), self.completion * 100);
		g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, text);
	end;
end;

function Missions_DisplaySetGet:enhancedVehicleDrawHUD()
	if Missions_DisplaySetGet:notDrawProgressBars() then _G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle_HUD.numberProgessBars = 0;end;
end;

function Missions_DisplaySetGet:replaceFunctions()
	if Missions_Display:getDetiServer() then return;end;
	SideNotification.draw = Utils.prependedFunction(SideNotification.draw, Missions_DisplaySetGet.visibleProgressBars);
	AbstractFieldMission.showCompletionNotification = Utils.overwrittenFunction(AbstractFieldMission.showCompletionNotification, Missions_DisplaySetGet.showCompletionNotification);
	if Missions_Display.otherMods.enhancedVehicle then		
		if _G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle.ui_hud ~= nil and _G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle.ui_hud.drawHUD ~= nil then 
			_G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle.ui_hud.drawHUD = Utils.prependedFunction(_G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle.ui_hud.drawHUD, Missions_DisplaySetGet.enhancedVehicleDrawHUD);
		end;
	end;
end;

function Missions_DisplaySetGet:setGlobalFunctions()
	g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"] = {
		getMissions = function(args)return Missions_DisplaySetGet:getMissions(args);end;
		getPercentAndNotice = function(args)return Missions_DisplaySetGet:getPercentAndNotice(args);end;
		viewProgressBars = function()return not Missions_DisplaySetGet:notDrawProgressBars();end;
		getModDir = function()return Missions_Display.modDir;end;
	};	
end;
