Missions_Display = {};
Missions_Display.modDir = g_currentModDirectory;
Missions_Display.modName = g_currentModName;

Missions_Display.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "Missions Display",
	notes = "Zeigt die Aktuellen Missionen und/oder vorhandene Missionen an (mit integrierten HL Hud System)",
	author = "(by HappyLooser)",
	version = "v1.0.0.2",
	build = 28,
	xmlVersion = 1,
	languageVersion = 1,
	datum = "20.02.2024", 
	update = "10.08.2025",	
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt"	
};

function Missions_Display:loadMap(mapName)		
	print("---loading ".. tostring(Missions_Display.metadata.title).. " ".. tostring(Missions_Display.metadata.version).. "(#".. tostring(Missions_Display.metadata.build).. ") ".. tostring(Missions_Display.metadata.author).. "---")
	if not Missions_Display:getDetiServer() then
		Missions_Display:loadValues();
	end;
end;

function Missions_Display:loadValues() --for All in Mod Extra Load
	if not Missions_Display:getDetiServer() then
		Missions_Display.hlDebugMode = false;	--for Modder Testing	
		Missions_Display.testString = {};		
		generateFolders();
		Missions_Display.otherMods = {missionsExpanded=false,missionsTimes=false,extendedGameInfoDisplay=false,realisticWeather=false,enhancedVehicle=false,extendedMissionInfo=false}; --mod Support
		Missions_Display:loadSource(1);		
		Missions_Display.loadError = false; --optional for !
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, Missions_Display.onStartMission);		
	end;
end;

function Missions_Display:onStartMission()
	if Missions_Display:getDetiServer() then return;end;	
	g_currentMission.hlUtils.modLoad("FS25_MissionsDisplay");
	Missions_DisplaySetGet:setGlobalFunctions();
	Missions_Display.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();	
	if g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil then --check is HL Hud System ready !
		print("#Info: ".. tostring(Missions_Display.metadata.title).. " generate Hud --> for HL Hud System (".. tostring(g_currentMission.hlHudSystem.metadata.version).. ")")
		Missions_Display.missions = {farmId={},otherFarmId={},free={}};		
		Missions_Display:searchOtherMods();			
		Missions_Display.values = {startTime=g_time,markerNewMission=15000,missionsUpdateTimer=1, viewMissionsFarm={1,1,3}, missionsTypes=Missions_DisplaySetGet:getMissionsTypes(),viewProgressBars={1,1,2},warningIsTimeLimit={60,30}}; --global for Hud and Box		
		Missions_DisplaySetGet:replaceFunctions();
		Missions_Display:loadSource(2);
		if Missions_Display_XmlHud:loadHud("Missions_Display_Hud") then		
			Missions_Display:loadSource(3);	
		else
			Missions_Display.loadError = true; --optional for !			
			print("#WARNING: ".. tostring(Missions_Display.metadata.title).. " CAN NOT GENERATE Hud ! Check/Search: ? Mod cause with integrated HL Hud System ? ")
		end;		
	else
		Missions_Display.loadError = true; --optional for !		
		g_currentMission.hlUtils.modUnLoad("FS25_MissionsDisplay");
		print("#WARNING: ".. tostring(Missions_Display.metadata.title).. " CAN NOT GENERATE Hud/Pda/Box ! MISSING --> HL Hud System ! Check/Search: ? Corrupt Mod with integrated HL Hud System ? ")
	end;	
end;

function Missions_Display:delete()
	
end;

function Missions_Display:deleteMap()
			
end;

function Missions_Display:mouseEvent(posX, posY, isDown, isUp, button)
	
end;	

function Missions_Display:keyEvent(unicode, sym, modifier, isDown)
	
end;

function Missions_Display:update(dt)	
	if Missions_Display:getDetiServer() then return;end;
	if Missions_Display.lastPlayerFarmId ~= nil and Missions_Display.lastPlayerFarmId ~= g_currentMission.hlUtils.getPlayerFarmId() then Missions_Display.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();Missions_DisplaySetGet:refreshPlayerFarmId();end;	
end;

function Missions_Display:draw()
	if Missions_Display:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
			
	if #Missions_Display.testString > 0 then
		setTextBold(true);		
		for a=1, #Missions_Display.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(Missions_Display.testString[a]));
		end;
	end;
	
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;
addModEventListener(Missions_Display);

function Missions_Display:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function Missions_Display:searchOtherMods()
	Missions_Display.otherMods.missionsExpanded = g_modIsLoaded["FS25_MissionsExpanded"] and _G["FS25_MissionsExpanded"] ~= nil and FS25_MissionsExpanded.MissionsExpanded.missionsTimes ~= nil;
	Missions_Display.otherMods.missionsTimes = g_modIsLoaded["FS25_MissionsTimes"] and _G["FS25_MissionsTimes"] ~= nil;
	Missions_Display.otherMods.extendedGameInfoDisplay = g_modIsLoaded["FS25_ExtendedGameInfoDisplay"] and _G["FS25_ExtendedGameInfoDisplay"] ~= nil and FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY ~= nil;
	Missions_Display.otherMods.realisticWeather = g_modIsLoaded["FS25_RealisticWeather"] and _G["FS25_RealisticWeather"] ~= nil;
	Missions_Display.otherMods.enhancedVehicle = g_modIsLoaded["FS25_EnhancedVehicle"] and _G["FS25_EnhancedVehicle"] ~= nil;
	Missions_Display.otherMods.extendedMissionInfo = g_modIsLoaded["FS25_extendedMissionInfo"] and _G["FS25_extendedMissionInfo"] ~= nil;
end;

function Missions_Display:loadSource(int)
	if int == 1 then
		source(Missions_Display.modDir.."scripte_missionsdisplay/Missions_DisplaySetGet.lua");		
	elseif int == 2 then
		source(Missions_Display.modDir.."scripte_missionsdisplay/mouseKeyEvents/Missions_Display_MouseKeyEventsHud.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/draw/Missions_Display_DrawHud.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/xml/Missions_Display_XmlHud.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/mouseKeyEvents/Missions_Display_MouseKeyEventsBox.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/draw/Missions_Display_DrawBox.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/xml/Missions_Display_XmlBox.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/mouseKeyEvents/Missions_Display_MouseKeyEventsPda.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/draw/Missions_Display_DrawPda.lua");
		source(Missions_Display.modDir.."scripte_missionsdisplay/xml/Missions_Display_XmlPda.lua");
	elseif int == 3 then
	
	end;
end;

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_MissionsDisplay/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_MissionsDisplay/languages/");			
end;