-- Hide NPCs
-- @author GMNGjoy
-- @copyright 11/06/2025
-- @contact https://github.com/GMNGjoy/FS25_HideNpcs
-- @license CC BY-NC-SA 4.0 w/ Conversions Restricted
-- @license https://creativecommons.org/licenses/by-nc-sa/4.0/

MOD_NAME = g_currentModName or "unknown"
HideNPCs = {}

---Initializes Hide NPCs!
function HideNPCs:init()

    -- Check to make sure that it's not a new savegame
    if not (g_currentMission.missionInfo.isNewSPCareer and g_currentMission.missionInfo.startWithGuidedTour) then

        -- Append to the NPC.setSpot basegame function
        NPC.setSpot = Utils.appendedFunction(NPC.setSpot, HideNPCs.setSpot)
    end

    Logging.info(MOD_NAME..': INITIALIZED.')
end

---Run this after the NPC.setSpot function completes.
function HideNPCs:setSpot()
    local npcName = self.name
    Logging.info(MOD_NAME..": HIDE %s", npcName)

    -- Move the NPC below the map
    self.y = self.y - 10

    -- Hide the NPC's mapHotspot
    if self.mapHotspot then
        self.mapHotspot.isVisible = false
    end
end

---Initialize HideNPCs when the map has finished loading
BaseMission.loadMapFinished = Utils.prependedFunction(BaseMission.loadMapFinished, function(...)
    HideNPCs:init()
end)
