------------------------------------------------------------
-- Runtime injector for FastDischarge specialization
-- Pattern copied from regRealSpeedLimit.lua
------------------------------------------------------------

-- Load the specialization file manually
source(Utils.getFilename("lua/FastDischarge.lua", g_currentModDirectory))

local function injectFastDischarge(typeManager)
    for typeName, typeDef in pairs(typeManager:getTypes()) do
        if typeDef ~= nil and typeDef.specializations ~= nil then

            local hasDischargeable = false

            for _, spec in ipairs(typeDef.specializations) do
                if spec == Dischargeable then
                    hasDischargeable = true
                    break
                end
            end

            -- Only attach to true discharge vehicles
            if hasDischargeable then
                if typeDef.specializationsByName["fastDischarge"] == nil then
                    table.insert(typeDef.specializations, FastDischarge)
                    table.insert(typeDef.specializationNames, "fastDischarge")
                    typeDef.specializationsByName["fastDischarge"] = FastDischarge
                end
            end
        end
    end
end

-- Hook into vehicle type validation
TypeManager.validateTypes = Utils.appendedFunction(
    TypeManager.validateTypes,
    injectFastDischarge
)
