-- Copyright (C) Bobster82
-- Copyright (C) Sablerock
-- Ask !! before you steal

AutoRepairUI = {}
local AutoRepairUI_mt = Class(AutoRepairUI, ScreenElement);

function AutoRepairUI.new()
	-- print("function AutoRepairUI.new()")
	local self = DialogElement.new(target, custom_mt or AutoRepairUI_mt)
    return self
end

function AutoRepairUI:onGuiSetupFinished()
	-- print("function AutoRepairUI:onGuiSetupFinished()")
    -- ✅ never remove following line
	-- The base implementation (DialogElement.onGuiSetupFinished) handles standard setup like registering focusable elements,
	-- 		tooltips, navigation with gamepad/keyboard, etc.	
	-- ✅ keep parent behavior
    AutoRepairUI:superClass().onGuiSetupFinished(self)
	local textInputElement = self.textInputTime
	 if textInputElement ~= nil and textInputElement.oldSetCaptureInput == nil then
		local oldSetCaptureInput = textInputElement.setCaptureInput

		textInputElement.setCaptureInput = function(element, isCapturing)
			oldSetCaptureInput(element, isCapturing)
			-- print("function(element, isCapturing) oldSetCaptureInput(element, isCapturing)")

			if element.isCapturingInput then
				-- When entering input mode: clear field and errors/icons
				self.errorMessage:setVisible(false)
				self.iconWarning:setVisible(false)		
				self.iconError:setVisible(false)		
				element:setText("")
			else
				-- When leaving input mode: validate the value
				self:validateTimeInput()
			end
		end

		textInputElement.oldSetCaptureInput = oldSetCaptureInput
	end
end

local function setPercByValue(element, value)
    -- value can be number or string; we normalize to the map’s keys
    local key = tostring(math.floor(tonumber(value) or 0))
    local idx = PercIndex[key] or 1   -- fallback if not found
    element:setState(idx)
end

function AutoRepairUI:onOpen()
	-- print("function AutoRepairUI.onOpen()")

    AutoRepairUI:superClass().onOpen(self)

	-- Title
    local title = "AutoRepairs"
    -- local title = AutoRepair.name .." by " .. AutoRepair.author .." v".. AutoRepair.version
	
    -- ✅ make a backup of main table to use in reset button
	ARbackup = deepcopy(AutoRepair)
	
	-- self.guiTitle:setText(title)
	self.guiTitle:setText(title)
	-- Global or per farm (only in MP)
	self.global_selection:setDisabled(not AutoRepair.mp.isActive)
	self.global_selection:setTexts({g_i18n:getText("AR_gui_useGlobal_global"), g_i18n:getText("AR_gui_useGlobal_farm")});

	self.farmId = 1;
	self.useByFarmValue:setDisabled(not AutoRepair.mp.isActive)
	self.useByFarmValue:setTexts({"1", "2", "3", "4", "5", "6", "7", "8"});

	-- Set the values
    PercTexts = {"1","5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70", "75", "80", "85", "90", "95", "99"}
	PercIndex = {}
	for i, v in ipairs(PercTexts) do
		PercIndex[v] = i
	end
	
    self.damagePerc:setTexts(PercTexts)
    self.wearPerc:setTexts(PercTexts)
    self.cleanPerc:setTexts(PercTexts)
	
	self:updateValues();
	if AutoRepair.mp.isActive then
		FocusManager:setFocus(self.global_selection) 
	else
		FocusManager:setFocus(self.textInputTime) 
	end
end

-- utility function: deep copy a table
function deepcopy(orig) 
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for k, v in pairs(orig) do
            copy[deepcopy(k)] = deepcopy(v)
        end
    else
        copy = orig
    end
    return copy
end

function AutoRepairUI:updateValues()
	self.global_selection:setState((AutoRepair.mp.useGlobal) and 1 or 2);
	self.farmId = self.useByFarmValue:getState();

	self.textInputTime:setText(tostring(AutoRepair.timeToUpdate / 1000));
	
	if (self.global_selection:getState() == 1) then
		-- ✅ global is selected
	
		self.useByFarmValue:setDisabled(true);
		self.autoRepairYesNo:setState((AutoRepair.doRepair) and 1 or 2);
        setPercByValue(self.damagePerc, AutoRepair.dmgThreshold)
		
		self.autoRepaintYesNo:setState((AutoRepair.doRepaint) and 1 or 2);
        setPercByValue(self.wearPerc, AutoRepair.wearThreshold)
		
		self.autoCleanYesNo:setState((AutoRepair.doWash) and 1 or 2);
        setPercByValue(self.cleanPerc, AutoRepair.dirtThreshold)
	else
		-- ✅ by farmid is selected
		self.useByFarmValue:setDisabled(false);
		self.useByFarmValue:setState(self.farmId);
		
		self.autoRepairYesNo:setState((AutoRepair.mp.farms[self.farmId].doRepair) and 1 or 2);
        setPercByValue(self.damagePerc, AutoRepair.mp.farms[self.farmId].dmgThreshold)
		
		self.autoRepaintYesNo:setState((AutoRepair.mp.farms[self.farmId].doRepaint) and 1 or 2);
        setPercByValue(self.wearPerc, AutoRepair.mp.farms[self.farmId].wearThreshold)
		
		self.autoCleanYesNo:setState((AutoRepair.mp.farms[self.farmId].doWash) and 1 or 2);
        setPercByValue(self.cleanPerc, AutoRepair.mp.farms[self.farmId].dirtThreshold)
	end;
end;

function AutoRepairUI:getIndex(value)
	testval = tostring(math.floor(value))
	return PercIndex[testvalue]  
end

function AutoRepairUI:validateTimeInput()
	-- print("function AutoRepairUI:validateTimeInput()")
    local val = tonumber(self.textInputTime.text)
	
    if val == nil or val < 180 or val > 600 then
        val = AutoRepair.timeToUpdate / 1000   -- reset to original value
		self.textInputTime:setText(tostring(val))
		
        self.errorMessage:setVisible(true)
		self.iconWarning:setVisible(true)
        self.errorMessage:setText(g_i18n:getText("AR_error_invalidTime"))
    else
        -- Hide error message if valid
        self.errorMessage:setVisible(false)
		self.iconWarning:setVisible(false)		
		self.iconError:setVisible(false)		
    end
    AutoRepair.timeToUpdate = val * 1000  -- update to new value
	
end

-- called when pressing ENTER inside the input
function AutoRepairUI:onSetTimeEnterPressed()
	-- print("function AutoRepairUI:onSetTimeEnterPressed()")
    -- self:validateTimeInput()
	self.doEnterPress = false	
end
-- called when pressing ENTER inside the input
function AutoRepairUI:InputTimeTextChanged()
	-- print("function AutoRepairUI:InputTimeTextChanged()")
	self.errorMessage:setVisible(false)
	self.errorIcon:setVisible(false)		
	-- self.doEnterPress = true
end

-- called when pressing ESC or clicking away from input
function AutoRepairUI:onTimeInputEscPressed()
    -- self:validateTimeInput()
	-- self.doEnterPress = false
end

-- optional: also when dialog closes
function AutoRepairUI:onClose()

    AutoRepairUI:superClass().onClose(self)
end

function AutoRepairUI:onClick_globalValueChanged()
	AutoRepair.mp.useGlobal = self.global_selection:getState() == 1;
	
    -- ✅ when player switches between global/By Farm , always start with farm 1
	self.useByFarmValue:setState(1);
    -- ✅ now refrresh GUI with new selection, any changes are discarded
	self:updateValues();
end;

function AutoRepairUI:onClick_FarmValueChanged()

    -- ✅ commit screen changes to autoRepair table when changing farm number. assumed player wants to keep values
	self:onClick_updateAll()
    -- ✅ commit screen changes to backup when changing farm number. assumed player wants to keep values
	ARbackup = deepcopy(AutoRepair)
    -- ✅ now refresh screen values with selected farm number.
	self:updateValues();
	
end;

function AutoRepairUI:onClick_updateAll()
	local doRepair  = (self.autoRepairYesNo:getState() == 1)
	local doRepaint = (self.autoRepaintYesNo:getState() == 1)
	local doWash    = (self.autoCleanYesNo:getState() == 1)	

	if (AutoRepair.mp.useGlobal) then
        AutoRepair.doRepair  = doRepair
        AutoRepair.doRepaint = doRepaint
        AutoRepair.doWash    = doWash
	else
        AutoRepair.mp.farms[self.farmId].doRepair  = doRepair
        AutoRepair.mp.farms[self.farmId].doRepaint = doRepaint
        AutoRepair.mp.farms[self.farmId].doWash    = doWash
	end;
    -- ✅ Damage threshold
    local dmgPercIndex = self.damagePerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.dmgThreshold = tonumber(self.damagePerc.texts[dmgPercIndex]) or AutoRepair.dmgThreshold
    else
        AutoRepair.mp.farms[self.farmId].dmgThreshold = tonumber(self.damagePerc.texts[dmgPercIndex]) or AutoRepair.mp.farms[self.farmId].dmgThreshold
    end

    -- ✅ Wear threshold
    local wearPercIndex = self.wearPerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.wearThreshold = tonumber(self.wearPerc.texts[wearPercIndex]) or AutoRepair.wearThreshold
    else
        AutoRepair.mp.farms[self.farmId].wearThreshold = tonumber(self.wearPerc.texts[wearPercIndex]) or AutoRepair.mp.farms[self.farmId].wearThreshold
    end

    -- ✅ Dirt threshold
    local cleanPercIndex = self.cleanPerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.dirtThreshold = tonumber(self.cleanPerc.texts[cleanPercIndex]) or AutoRepair.dirtThreshold
    else
        AutoRepair.mp.farms[self.farmId].dirtThreshold = tonumber(self.cleanPerc.texts[cleanPercIndex]) or AutoRepair.mp.farms[self.farmId].dirtThreshold
    end
	
end;

function AutoRepairUI:onClickOk()
    -- print("function AutoRepairUI:onClickOk()")

    -- ✅ Validate & set time input
    local val = tonumber(self.textInputTime:getText())
    if val == nil or val < 180 or val > 600 then
        val = 180
    end
	
    AutoRepair.timeToUpdate = val * 1000

    -- ✅ Update mode
    AutoRepair.mp.useGlobal = (self.global_selection:getState() == 1)
    self.farmId = self.useByFarmValue:getState()

    -- ✅ Repair / repaint / wash
	local doRepair  = (self.autoRepairYesNo:getState() == 1)
	local doRepaint = (self.autoRepaintYesNo:getState() == 1)
	local doWash    = (self.autoCleanYesNo:getState() == 1)	
	
	if AutoRepair.mp.useGlobal then
        AutoRepair.doRepair  = doRepair
        AutoRepair.doRepaint = doRepaint
        AutoRepair.doWash    = doWash
    else
        AutoRepair.mp.farms[self.farmId].doRepair  = doRepair
        AutoRepair.mp.farms[self.farmId].doRepaint = doRepaint
        AutoRepair.mp.farms[self.farmId].doWash    = doWash
    end


    -- ✅ Damage threshold
    local dmgPercIndex = self.damagePerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.dmgThreshold = tonumber(self.damagePerc.texts[dmgPercIndex]) or AutoRepair.dmgThreshold
    else
        AutoRepair.mp.farms[self.farmId].dmgThreshold = tonumber(self.damagePerc.texts[dmgPercIndex]) or AutoRepair.mp.farms[self.farmId].dmgThreshold
    end

    -- ✅ Wear threshold
    local wearPercIndex = self.wearPerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.wearThreshold = tonumber(self.wearPerc.texts[wearPercIndex]) or AutoRepair.wearThreshold
    else
        AutoRepair.mp.farms[self.farmId].wearThreshold = tonumber(self.wearPerc.texts[wearPercIndex]) or AutoRepair.mp.farms[self.farmId].wearThreshold
    end

    -- ✅ Dirt threshold
    local cleanPercIndex = self.cleanPerc:getState()
    if AutoRepair.mp.useGlobal then
        AutoRepair.dirtThreshold = tonumber(self.cleanPerc.texts[cleanPercIndex]) or AutoRepair.dirtThreshold
    else
        AutoRepair.mp.farms[self.farmId].dirtThreshold = tonumber(self.cleanPerc.texts[cleanPercIndex]) or AutoRepair.mp.farms[self.farmId].dirtThreshold
    end

    -- ✅ Multiplayer sync
    if AutoRepair.mp.isActive then
        -- Global event (farmId = 0)
        ArSettingsEvent.sendEvent(
            0,
            AutoRepair.timeToUpdate,
            AutoRepair.mp.useGlobal,
            AutoRepair.doRepair,
            AutoRepair.doRepaint,
            AutoRepair.doWash,
            AutoRepair.dmgThreshold,
            AutoRepair.wearThreshold,
            AutoRepair.dirtThreshold
        )

        -- Per-farm events
        for farmId, f in ipairs(AutoRepair.mp.farms) do
            ArSettingsEvent.sendEvent(
                farmId,
                AutoRepair.timeToUpdate,
                AutoRepair.mp.useGlobal,
                f.doRepair,
                f.doRepaint,
                f.doWash,
                f.dmgThreshold,
                f.wearThreshold,
                f.dirtThreshold
            )
        end
    end
	
    -- ✅ Close
    g_gui:closeDialogByName(AutoRepair.guiName)
end

function AutoRepairUI:onClickReset()

	self.errorMessage:setVisible(false)
	self.iconWarning:setVisible(false)
	self.iconError:setVisible(false)		

    -- Always reset the time field
	AutoRepair.timeToUpdate = ARbackup.timeToUpdate 
	
    -- ✅ reset specific values AutoRepair table to backup values
	if AutoRepair.mp.useGlobal then
        AutoRepair.doRepair  = ARbackup.doRepair
        AutoRepair.doRepaint = ARbackup.doRepaint
        AutoRepair.doWash    = ARbackup.doWash
        AutoRepair.dmgThreshold = ARbackup.dmgThreshold
        AutoRepair.wearThreshold = ARbackup.wearThreshold
        AutoRepair.dirtThreshold = ARbackup.dirtThreshold
    else
        AutoRepair.mp.farms[self.farmId].doRepair  = ARbackup.mp.farms[self.farmId].doRepair 
        AutoRepair.mp.farms[self.farmId].doRepaint = ARbackup.mp.farms[self.farmId].doRepaint
        AutoRepair.mp.farms[self.farmId].doWash    = ARbackup.mp.farms[self.farmId].doWash   
        AutoRepair.mp.farms[self.farmId].dmgThreshold = ARbackup.mp.farms[self.farmId].dmgThreshold
        AutoRepair.mp.farms[self.farmId].wearThreshold = ARbackup.mp.farms[self.farmId].wearThreshold
        AutoRepair.mp.farms[self.farmId].dirtThreshold = ARbackup.mp.farms[self.farmId].dirtThreshold
    end
	
    -- ✅ now refresh screen values with reset values above
	self:updateValues();

end

function AutoRepairUI:onClickCancel()
	-- print("function AutoRepairUI:onClickCancel()")
	
    -- ✅ restore all values from backup of main table
    -- ✅ irrespective what values were changed on screen
	AutoRepair = deepcopy(ARbackup)
	
	if g_gui ~= nil then
        g_gui:closeDialogByName(AutoRepair.guiName)
    end	
end
