-- AutoRepair
-- Copyright (C) Bobster82
-- Copyright (C) Sablerock
-- Ask !! before you steal

modDir = g_currentModDirectory;

source(Utils.getFilename("Gui/AutoRepairUI.lua", modDir));
source(Utils.getFilename("Events/ArSyncEvent.lua", modDir));
source(Utils.getFilename("Events/ArSettingsEvent.lua", modDir));


-- Main table
AutoRepair = {};
AutoRepair.name = "AutoRepairs";
AutoRepair.guiName = "AutoRepairUI";

-- Settings SinglePlayer (or global)
AutoRepair.timeToUpdate = 180000; 	-- we check every 180000 msec (180 sec) (default) if we need to repair/repaint/clean a vehicle and or tool. (Global)
AutoRepair.dmgThreshold = 5; 		-- 5% damage (default)
AutoRepair.wearThreshold = 5; 		-- 5% damage to paint (default)
AutoRepair.dirtThreshold = 5;	 	-- 5% dirty (default)
AutoRepair.doRepair = true;
AutoRepair.doRepaint = false;
AutoRepair.doWash = false;

-- Settings MultiPlayer
AutoRepair.mp = {};
AutoRepair.mp.isActive = false;
AutoRepair.mp.farms = {};
for i = 1, 8, 1 do table.insert(AutoRepair.mp.farms, i, {farmId = i}); end; -- max farms is 8

-- ✅ load defaults for all farms. For new savegames
for farmId, _ in ipairs(AutoRepair.mp.farms) do

	AutoRepair.mp.farms[farmId].doRepair  		= true 
	AutoRepair.mp.farms[farmId].doRepaint 		= false
	AutoRepair.mp.farms[farmId].doWash    		= false   
	AutoRepair.mp.farms[farmId].dmgThreshold 	= 5
	AutoRepair.mp.farms[farmId].wearThreshold 	= 5
	AutoRepair.mp.farms[farmId].dirtThreshold 	= 5

end	

AutoRepair.mp.useGlobal = true; 	-- use same settings for all farms?
AutoRepair.timer = 0;
AutoRepair.firstRun = true;
AutoRepair.isServer = false;
AutoRepair.isInitialized = false

local filename = modDir .. "Gui/gui.xml"
g_overlayManager:addTextureConfigFile(filename, "AutoRepair")

addModEventListener(AutoRepair);


-- FS loadMap
function AutoRepair:loadMap()
	PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, AutoRepair.registerActionEvents);
	
	AutoRepair:init();
	
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, AutoRepair.saveSavegame);
	AutoRepair.loadStoredXML();
	
	AutoRepair.isInitialized = true
	
	self.mp.isActive = g_currentMission.missionDynamicInfo.isMultiplayer;
	self.isServer = g_currentMission:getIsServer();
	self.requestSync = not self.isServer and self.mp.isActive  -- flag for update	
	
-- ******testing only*******************************************
	-- self.mp.isActive = true
	-- self.timeToUpdate = 20000 -- testing only	
-- *************************************************************		
	
	print(string.format("** %s, version: %s, by: %s **", AutoRepair.name, AutoRepair.version, AutoRepair.author));
end;

function AutoRepair:registerActionEvents()

    local triggerUp, triggerDown, triggerAlways, startActive, callbackState, disableConflictingBindings = false, true, false, true, nil, true
	local success, actionEventId, otherEvents = g_inputBinding:registerActionEvent(InputAction.AR_openMenu, AutoRepair, AutoRepair.openSettingsMenu, triggerUp, triggerDown, triggerAlways, startActive, callbackState, disableConflictingBindings)
		
    if success then
		-- print("AutoRepair: registerActionEvent success = " .. tostring(success))
        AutoRepair.actionEventId = actionEventId
        g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH)
    -- else
        -- print("Failed to register action key for AutoRepair ,success="..tostring(success).." ,actionId=", actionEventId)
    end    

	g_inputBinding:setActionEventActive(actionEventId, true)
	g_inputBinding:setActionEventTextVisibility(actionEventId, true)
	
end


-- FS update
function AutoRepair:update(dt)

	if self.requestSync then
        self.requestSync = false  -- only once
        ArSyncEvent.sendEvent()
        print("AutoRepairs: requested sync from server")
    end
	
	-- If not server no need to go further
	if (not self.isServer) then 
		return;
	end;

	-- only start looking for vehicles after everything loaded
	if not AutoRepair.isInitialized then
		return;
	end;

	if (self.timer > self.timeToUpdate) then
		if (self.mp.useGlobal) then 
			self:spUpdate();
		else 
			self:mpUpdate(); 
		end;
		self.timer = 0;
	end;
	self.timer = self.timer + dt;
end;

function AutoRepair:spUpdate()
	for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
		AutoRepair:doSPMaint(vehicle)
	end;
end;

function AutoRepair:mpUpdate()
	-- print("function AutoRepair:mpUpdate()")
	for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
		AutoRepair:doMPMaint(vehicle)
	end;
end;

function AutoRepair:doMPMaint(vehicle)
	-- print("function AutoRepair:doMPMaint()")

    -- ✅ is there a vehicle present?
	if vehicle == nil then
		return
	end;
    -- ✅ do you own this vehicle?
	local farmId = vehicle:getOwnerFarmId();
	if farmId == 0	then
		return
	end;
    -- ✅ these are strange vehicles
	if farmId > 8	then
		return
	end;
	
	-- ✅ Filter out non-machines (bags/pallets/etc.)
	if vehicle.getFullName == nil and vehicle.getAttachedImplements == nil then
		return
	end;
	
    -- ✅ is this a mission vehicle?
	local missionsVehicle = vehicle.propertyState >= 4 or (vehicle.propertyState >= 2 and vehicle.activeMissionId ~= nil and vehicle.activeMissionId > 0);
	if missionsVehicle then
		return
	end;

	-- Repair
	if (self.mp.farms[farmId].doRepair and vehicle.getDamageAmount) then
		if (vehicle:getDamageAmount() > self.mp.farms[farmId].dmgThreshold /100) then
			if (vehicle.repairVehicle) then 
				vehicle:repairVehicle(); 	
			end;
		end;
	end;
	
	-- Repaint
	if (self.mp.farms[farmId].doRepaint and vehicle.getWearTotalAmount) then
		if (vehicle:getWearTotalAmount() > self.mp.farms[farmId].wearThreshold /100) then
			if (vehicle.repaintVehicle) then 
				vehicle:repaintVehicle(); 
			end;
		end;
	end;
	
	-- Wash
	if (self.mp.farms[farmId].doWash and vehicle.getDirtAmount) then
		if (vehicle:getDirtAmount() > self.mp.farms[farmId].dirtThreshold /100) then
			for _, node in pairs(vehicle.spec_washable.washableNodes) do
				vehicle:setNodeDirtAmount(node, 0);
			end;
		end;
	end;
	
end;

function AutoRepair:doSPMaint(vehicle)
	-- print("function AutoRepair:doSPMaint()")
    -- ✅ is there a vehicle present?
	if vehicle == nil then
		return
	end;
    -- ✅ do you own this vehicle?
	local farmId = vehicle:getOwnerFarmId();
	if farmId == 0	then
		return
	end;
    -- ✅ is this a mission vehicle?
	local missionsVehicle = vehicle.propertyState >= 4 or (vehicle.propertyState >= 2 and vehicle.activeMissionId ~= nil and vehicle.activeMissionId > 0);
	if missionsVehicle then
		return
	end;
	
	-- ✅ Filter out non-machines (bags/pallets/etc.)
	if vehicle.getFullName == nil and vehicle.getAttachedImplements == nil then
		return
	end;
	
    -- ✅ is the damage > than threshold set by player?
	if (self.doRepair and vehicle.getDamageAmount) then
		if (vehicle:getDamageAmount() > self.dmgThreshold /100) then
			if (vehicle.repairVehicle) then 
				vehicle:repairVehicle(); 	
			end;
		end;
	end;
	-- Repaint
	if (self.doRepaint and vehicle.getWearTotalAmount) then
		if (vehicle:getWearTotalAmount() > self.wearThreshold /100) then
			if (vehicle.repaintVehicle) then 
				-- print("vehicle wear repaired")
				vehicle:repaintVehicle();
			end;
		end;
	end;
	-- Wash
	if (self.doWash and vehicle.getDirtAmount) then
		if (vehicle:getDirtAmount() > self.dirtThreshold /100) then
			-- print("vehicle dirt removed")
			for _, node in pairs(vehicle.spec_washable.washableNodes) do
				vehicle:setNodeDirtAmount(node, 0);
			end;
		end;
	end;
	
end;

function AutoRepair:init()
    local modDesc = loadXMLFile("modDesc", modDir .. "modDesc.xml");
    AutoRepair.name = getXMLString(modDesc, "modDesc.title.en");
    AutoRepair.version = getXMLString(modDesc, "modDesc.version");
    AutoRepair.author = getXMLString(modDesc, "modDesc.author");

    g_gui:loadProfiles(modDir.."Gui/guiProfiles.xml");
    MainUI = AutoRepairUI.new();
    g_gui:loadGui(modDir.."Gui/AutoRepairUI.xml", AutoRepair.guiName , MainUI);
	
end;

function AutoRepair:openSettingsMenu()
	-- Only admin in MP can change settings
	
	if (not g_currentMission.isMasterUser) then
		YesNoDialog.show(
				nil,                    -- no callback
				nil,                    -- no arguments for callback
				g_i18n:getText("AR_warning_noAdmin"),
				nil,
				"OK",
				nil                     -- no "No" text or button
			)		
		return;
	end;

    if not g_gui:getIsGuiVisible() then
		-- show dialog, not base GUI
        g_gui:showDialog(AutoRepair.guiName);	
    end;
	
end;

-- ### SAVE

function AutoRepair.saveSavegame()
	-- Only the server needs to save in MP game
    if (not g_currentMission:getIsServer()) then return end
	
	local xmlFilePath = AutoRepair.getXMLPath();
	print("[AR] saving settings to: " .. tostring(xmlFilePath))	
	
	local xmlFile = createXMLFile("AutoRepair", xmlFilePath, "AutoRepair");
	
	setXMLString(xmlFile, "AutoRepair.author", AutoRepair.author);
	setXMLString(xmlFile, "AutoRepair.version", AutoRepair.version);

	setXMLBool(xmlFile, "AutoRepair.doRepair", AutoRepair.doRepair);
	setXMLBool(xmlFile, "AutoRepair.doRepaint", AutoRepair.doRepaint);
	setXMLBool(xmlFile, "AutoRepair.doWash", AutoRepair.doWash);

	setXMLInt(xmlFile, "AutoRepair.timeToUpdate", AutoRepair.timeToUpdate);
	setXMLInt(xmlFile, "AutoRepair.dmgThreshold", AutoRepair.dmgThreshold);
	setXMLInt(xmlFile, "AutoRepair.wearThreshold", AutoRepair.wearThreshold);
	setXMLInt(xmlFile, "AutoRepair.dirtThreshold", AutoRepair.dirtThreshold);

	if (AutoRepair.mp.isActive) then
		setXMLBool(xmlFile, "AutoRepair.useGlobal", AutoRepair.mp.useGlobal);
		for farmId, _ in ipairs(AutoRepair.mp.farms) do
			local key = "AutoRepair.mp.farms.farm" .. tostring(farmId);

			setXMLBool(xmlFile, key..".doRepair", AutoRepair.mp.farms[farmId].doRepair);
			setXMLBool(xmlFile, key..".doRepaint", AutoRepair.mp.farms[farmId].doRepaint);
			setXMLBool(xmlFile, key..".doWash", AutoRepair.mp.farms[farmId].doWash);
	
			setXMLInt(xmlFile, key..".dmgThreshold", AutoRepair.mp.farms[farmId].dmgThreshold);
			setXMLInt(xmlFile, key..".wearThreshold", AutoRepair.mp.farms[farmId].wearThreshold);
			setXMLInt(xmlFile, key..".dirtThreshold", AutoRepair.mp.farms[farmId].dirtThreshold);
		end;
	end;

	saveXMLFile(xmlFile);
	delete(xmlFile)   -- 🔑 must delete handle!		
	print ("[AR] settings saved to xml file");
end;

function AutoRepair.loadStoredXML()
    if (g_server == nil) then return; end;

	local xmlFilePath = AutoRepair.getXMLPath();
		
	if fileExists(xmlFilePath) then
		local xmlFile = loadXMLFile(AutoRepair.name, xmlFilePath);
		AutoRepair.readFromXML(xmlFile);
        delete(xmlFile);
	end;
end;

function AutoRepair.readFromXML(xmlFile)
	if (xmlFile == nil) then return; end;

	-- SP (or global) load settings
	AutoRepair.doRepair = 		Utils.getNoNil(getXMLBool(xmlFile, "AutoRepair.doRepair"), AutoRepair.doRepair);
	AutoRepair.doRepaint = 		Utils.getNoNil(getXMLBool(xmlFile, "AutoRepair.doRepaint"), AutoRepair.doRepaint);
	AutoRepair.doWash = 		Utils.getNoNil(getXMLBool(xmlFile, "AutoRepair.doWash"), AutoRepair.doWash);
	AutoRepair.timeToUpdate = 	Utils.getNoNil(getXMLInt(xmlFile, "AutoRepair.timeToUpdate"), AutoRepair.timeToUpdate);
	AutoRepair.dmgThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, "AutoRepair.dmgThreshold"), AutoRepair.dmgThreshold);
	AutoRepair.wearThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, "AutoRepair.wearThreshold"), AutoRepair.wearThreshold);
	AutoRepair.dirtThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, "AutoRepair.dirtThreshold"), AutoRepair.dirtThreshold);
	AutoRepair.mp.useGlobal = 	Utils.getNoNil(getXMLBool(xmlFile, "AutoRepair.useGlobal"), AutoRepair.mp.useGlobal);

	-- MP load settings (if nothing saved, use the saved SP settings or default)
	for farmId, farm in ipairs(AutoRepair.mp.farms) do
		local key = "AutoRepair.mp.farms.farm" .. tostring(farmId);

		farm.doRepair = 		Utils.getNoNil(getXMLBool(xmlFile, key..".doRepair"), AutoRepair.doRepair);
		farm.doRepaint = 		Utils.getNoNil(getXMLBool(xmlFile, key..".doRepaint"), AutoRepair.doRepaint);
		farm.doWash = 			Utils.getNoNil(getXMLBool(xmlFile, key..".doWash"), AutoRepair.doWash);

		farm.dmgThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, key..".dmgThreshold"), AutoRepair.dmgThreshold);
		farm.wearThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, key..".wearThreshold"), AutoRepair.wearThreshold);
		farm.dirtThreshold = 	Utils.getNoNil(getXMLInt(xmlFile, key..".dirtThreshold"), AutoRepair.dirtThreshold);
	end;

	print ("[AR] settings loaded from xml file");
end;

-- Returns the xml file path stored in savegame directory. Creates new if not exists
function AutoRepair.getXMLPath()

	local path = g_currentMission.missionInfo.savegameDirectory;
	
	if path ~= nil then
		return path .. "/AutoRepair_config.xml";
	else
		return getUserProfileAppPath() .. "savegame" .. g_currentMission.missionInfo.savegameIndex .. "/AutoRepair_config.xml";
	end;
end;


