ChaffChangeSettingsEvent = {};
ChaffChangeSettingsEvent_mt = Class(ChaffChangeSettingsEvent, Event);
InitEventClass(ChaffChangeSettingsEvent, "ChaffChangeSettingsEvent");

ChaffChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
ChaffChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function ChaffChangeSettingsEvent.emptyNew()
    local self = Event.new(ChaffChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function ChaffChangeSettingsEvent.new(settingsId, settingsState)
    local self = ChaffChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function ChaffChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, ChaffChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, ChaffChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function ChaffChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, ChaffChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, ChaffChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function ChaffChangeSettingsEvent:run(connection)	
	if self.settingsId == "chaffMission_minMax" then
		g_additionalContractTypes:getTyp("chaffMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

