-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles
myself, the author, to unlimited free and unrestricted use,
access, and distribution of any works related to the unauthorized
user and/or distributor.

--]]

THTramlines = {}
local THTramlines_mt = Class(THTramlines)
THTramlines.CLASS_NAME = "THTramlines"
local function initScript()
    local self = THTramlines.new()
    if self ~= nil then
        _G.g_thTramlines = self
    end
end
function THTramlines.new(customMt)
    customMt = customMt or THTramlines_mt
    local self = setmetatable({}, customMt)
    if self ~= nil then
        self.areTramlinesDisabled = false
        self.hasUserTramlines = false
        self.bypassDefaultTramlines = false
        g_thEventManager:addEventListener(self)
        return self
    end
end
function THTramlines.onPostInit(self)
    local pfData = g_thPFConfig.precisionFarming
    if pfData.isFound then
        local pfModEnv = pfData.mod.environment
        local PrecisionFarming = pfModEnv.PrecisionFarming
        THUtils.setFunctionHook(PrecisionFarming, "initialize", false, false, self, THTramlines.inj_initPrecisionFarming)
        local TramlineMap = pfModEnv.TramlineMap
        THUtils.setFunctionHook(TramlineMap, "loadTramlineFruitTypesFromXML", false, false, self, THTramlines.inj_loadTramlineFruitTypesFromXML)
        local ExtendedSowingMachine = pfModEnv.ExtendedSowingMachine
        THUtils.setFunctionHook(ExtendedSowingMachine, "onLoad", false, false, self, THTramlines.inj_onLoadExtendedSowingMachine)
    end
end
function THTramlines.onLoadMapFinished(self, mission)
    if THUtils.getIsDebugEnabled() then
        local pfData = g_thPFConfig.precisionFarming
        if pfData.isFound then
            THUtils.displayMsg("THTramlines configuration:")
            THUtils.printTable(self)
        end
    end
end
function THTramlines.loadFromMapXML(self, xmlFile, xmlKey, customEnv, baseDirectory)
    local tramlinesKey = "map.precisionFarming.npcTramlines"
    self.areTramlinesDisabled = xmlFile:getBool(xmlKey .. "#disableTramlines", false)
    self.bypassDefaultTramlines = false
    self.hasUserTramlines = false
    if xmlFile:hasProperty(tramlinesKey) then
        local fruitTypeNames = xmlFile:getString(tramlinesKey .. "#fruitTypes")
        if fruitTypeNames ~= nil and fruitTypeNames ~= "" then
            self.bypassDefaultTramlines = xmlFile:getBool(xmlKey .. "overrideTramlines", false)
            self.hasUserTramlines = true
        end
    end
    return true
end
function THTramlines.inj_initPrecisionFarming(self, superFunc, parent, ...)
    local pfData = g_thPFConfig.precisionFarming
    if pfData.isFound then
        THUtils.pcall(function()
            if parent.tramlineMap ~= nil and self.areTramlinesDisabled then
                if parent.valueMaps ~= nil then
                    local valueMapIndex = 1
                    while true do
                        local valueMapData = parent.valueMaps[valueMapIndex]
                        if valueMapData == nil then
                            break
                        end
                        if valueMapData.name == "tramlineMap" then
                            table.remove(parent.valueMaps, valueMapIndex)
                        else
                            valueMapData.valueMapIndex = valueMapIndex
                            valueMapIndex = valueMapIndex + 1
                        end
                    end
                end
                parent.tramlineMap:delete()
                parent.tramlineMap = nil
                THUtils.displayMsg("Tramlines have been disabled globally...")
            end
        end)
    end
    return superFunc(parent, ...)
end
function THTramlines.inj_loadTramlineFruitTypesFromXML(self, superFunc, parent, xmlFile, xmlKey, ...)
    THUtils.pcall(function()
        local pfData = g_thPFConfig.precisionFarming
        local wrappedXML = THUtils.wrapXMLFile(xmlFile)
        if pfData.isFound and wrappedXML ~= nil then
            if xmlKey == "precisionFarming.tramlineMap.npcFields#fruitTypes"
                and (self.bypassDefaultTramlines or self.areTramlinesDisabled)
                and wrappedXML:hasProperty(xmlKey)
            then
                wrappedXML:removeProperty(xmlKey)
                THUtils.displayMsg("Bypassing default tramline definitions...")
            end
        end
    end)
    return superFunc(parent, xmlFile, xmlKey, ...)
end
function THTramlines.inj_onLoadExtendedSowingMachine(self, superFunc, parent, ...)
    local pfData = g_thPFConfig.precisionFarming
    local function appendFunc(...)
        if pfData.isFound then
            THUtils.pcall(function()
                local ExtendedSowingMachine = pfData.mod.environment.ExtendedSowingMachine
                local extendedSowingSpec = parent[ExtendedSowingMachine.SPEC_TABLE_NAME]
                if extendedSowingSpec ~= nil then
                    if extendedSowingSpec.tramlineMap == nil then
                        extendedSowingSpec.tramlineMap = {
                            getTramlineWidthAtWorldPos = function(...) end
                        }
                        g_messageCenter:unsubscribe(MessageType.PRECISION_FARMING_TRAMLINES_CHANGED, parent)
                    end
                end
            end)
        end
        return ...
    end
    return appendFunc(superFunc(parent, ...))
end
THUtils.pcall(initScript)